/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.bdm.common.helper.FieldSelectHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.service.AwsFpyService;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.FileUploadUtils;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.RandomString;
import kd.imc.bdm.common.util.RequestUtils;
import kd.imc.bdm.common.util.UUID;
import org.apache.commons.io.FilenameUtils;

public class DownLoadCenterHelper {
    private static final Log LOG = LogFactory.getLog(DownLoadCenterHelper.class);
    private static final BigDecimal DOWNLOAD_EXCEL_LIMIT = new BigDecimal(999999999);
    private static final BigDecimal DOWNLOAD_FILE_LIMIT = new BigDecimal(999999999);
    public static final String DOWNLOAD_TYPE_XLSX = ".xlsx";
    public static final String DOWNLOAD_TYPE_ZIP = ".zip";
    public static final String KEY_FILE_URL = "fileUrl";
    public static final String KEY_ISSUE_SOURCE = "issueSource";
    public static final String KEY_FILE_TYPE = "fileType";
    public static final String KEY_FILE_ORDER_NO = "fileOrderNo";
    public static final String KEY_FILE_INVOICE_NO = "fileInvoiceNo";

    public static void uploadFileByUrls(DynamicObject obj, List<Map<String, String>> ofdUrls) {
        ThreadPools.executeOnce((String)"downloadFileThread", () -> {
            File zipFile = null;
            try {
                zipFile = DownLoadCenterHelper.createZipFile(obj.getString("filename"), ofdUrls);
                if (zipFile == null) {
                    obj.set("handlestate", (Object)"3");
                } else {
                    FileInputStream in = new FileInputStream(zipFile);
                    DownLoadCenterHelper.uploadFile(obj, obj.getString("filename"), in);
                }
                SaveServiceHelper.update((DynamicObject)obj);
                if (zipFile == null || !zipFile.exists() || zipFile.delete()) return;
            }
            catch (Exception e) {
                try {
                    LOG.error("\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff01", (Throwable)e);
                    if (zipFile == null || !zipFile.exists() || zipFile.delete()) return;
                }
                catch (Throwable throwable) {
                    if (zipFile == null || !zipFile.exists() || zipFile.delete()) throw throwable;
                    LOG.error(String.format("\u4e34\u65f6\u538b\u7f29\u5305%s\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff01", zipFile.getAbsolutePath()));
                    throw throwable;
                }
                LOG.error(String.format("\u4e34\u65f6\u538b\u7f29\u5305%s\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff01", zipFile.getAbsolutePath()));
                return;
            }
            LOG.error(String.format("\u4e34\u65f6\u538b\u7f29\u5305%s\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff01", zipFile.getAbsolutePath()));
            return;
        });
    }

    public static void uploadFile(DynamicObject obj, String fileName, InputStream in) {
        try {
            obj.set("handlestate", (Object)"3");
            String result = FileUploadUtils.upload("/imc/downloadcenter/" + fileName, fileName, in);
            in.close();
            if (null != result) {
                obj.set("handlestate", (Object)"2");
                obj.set("fileurl", (Object)result);
            }
            SaveServiceHelper.update((DynamicObject)obj);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public static File createZipFile(String fileName, List<Map<String, String>> ofdUrls) {
        String zipDirStr = File.separator + "tmp";
        File zipDir = new File(zipDirStr);
        if (!zipDir.exists() || !zipDir.isDirectory()) {
            zipDir.mkdirs();
        }
        File zipFile = new File(zipDirStr + File.separator, FilenameUtils.getName((String)fileName));
        try {
            if (DownLoadCenterHelper.zipOfdFiles(ofdUrls, zipFile)) {
                return zipFile;
            }
        }
        catch (Exception e) {
            LOG.error("\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff01" + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static String getPdfRenameRule(String orderNo, String names, String separator, String fileType) {
        if (StringUtils.isBlank((CharSequence)names) || StringUtils.isBlank((CharSequence)separator)) {
            return orderNo;
        }
        ArrayList<String> selectFieldSet = new ArrayList<String>(FieldSelectHelper.getInvoiceFieldMap().keySet());
        selectFieldSet.add("id");
        DynamicObject invoice = QueryServiceHelper.queryOne((String)"sim_vatinvoice", (String)String.join((CharSequence)",", selectFieldSet), (QFilter[])new QFilter("orderno", "=", (Object)orderNo).toArray());
        LOG.info("\u53d1\u7968\u4e0b\u8f7d\u547d\u540d\u5b57\u6bb5\uff1a" + names + "   \u5206\u9694\u7b26\uff1a" + separator);
        String[] split = names.split(",", 0);
        ArrayList<String> nameList = new ArrayList<String>(split.length);
        for (String key : split) {
            Object val = invoice.get(key);
            if (val instanceof BigDecimal) {
                nameList.add(((BigDecimal)val).setScale(2, 4).toPlainString());
                continue;
            }
            if (val instanceof Date) {
                nameList.add(DateUtils.format((Date)val));
                continue;
            }
            nameList.add(val.toString());
        }
        return String.join((CharSequence)separator, nameList) + '.' + fileType;
    }

    public static String warpDownloadFileName(Map<String, String> fileMap) {
        String fileName;
        String orderNo = fileMap.get(KEY_FILE_ORDER_NO);
        String fileType = fileMap.get(KEY_FILE_TYPE);
        DynamicObject fileDynamic = QueryServiceHelper.queryOne((String)"bdm_pdf_download_rename", (String)"id,nowinvoicepdfname,invoicepdfseparator", (QFilter[])new QFilter("org", "=", (Object)Long.parseLong(fileMap.get("orgid"))).toArray());
        if (fileDynamic != null) {
            fileName = DownLoadCenterHelper.getPdfRenameRule(orderNo, fileDynamic.getString("nowinvoicepdfname"), fileDynamic.getString("invoicepdfseparator"), fileType);
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("warpDownloadFileName %s %s", orderNo, fileName));
            }
        } else {
            String invoiceType = fileMap.get("invoicetype");
            fileName = InvoiceUtils.isAllEInvoice(invoiceType) ? String.format("dzfp_%s_%s_%s_%s.%s", fileMap.get(KEY_FILE_INVOICE_NO), fileMap.get("buyername"), fileMap.get("invoiceamount"), fileMap.get("issuetime"), fileType) : String.format("%s.%s", orderNo, fileType);
        }
        return fileName;
    }

    public static InputStream getDownloadPdfInputStream(Map<String, String> ofdMap) {
        String fileUrl = ofdMap.get(KEY_FILE_URL);
        if (InvoiceUtils.isAllEInvoice(ofdMap.get("invoicetype"))) {
            LOG.info("downloadUrl:" + fileUrl);
            if (StringUtils.isNotEmpty((CharSequence)fileUrl) && !fileUrl.startsWith("http")) {
                return DownLoadCenterHelper.getLocalInputStream(fileUrl);
            }
            return DownLoadCenterHelper.getInputStream(fileUrl);
        }
        String uuid = UUID.next();
        JSONArray jsonArray = DownLoadCenterHelper.getOrderNoJson(ofdMap.get(KEY_FILE_ORDER_NO));
        return DownLoadCenterHelper.getFileFromIsmc(uuid, jsonArray);
    }

    public static InputStream getFileFromIsmc(String uuid, JSONArray jsonArray) {
        MsgResponse msgResponse = RequestUtils.doRequest(uuid, "SimDownloadPdf", jsonArray);
        if (ErrorType.SUCCESS.getCode().equalsIgnoreCase(msgResponse.getErrorCode())) {
            String respData = msgResponse.getRespData();
            if ("3".equals(respData)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25\uff1a \u7eb8\u8d28\u53d1\u7968\u4e0d\u5b58\u5728PDF\u6587\u4ef6\uff0c\u4f9d\u636e\u7a0e\u5c40\u89c4\u5b9a\uff0c\u53ea\u6709\u7535\u5b50\u53d1\u7968\u624d\u6709PDF\u677f\u5f0f\u6587\u4ef6", (String)"DownLoadCenterHelper_7", (String)"imc-bdm-common", (Object[])new Object[0]));
            }
            byte[] decodeOfdBytes = Base64.getDecoder().decode(respData);
            return new ByteArrayInputStream(decodeOfdBytes);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u53d1\u7968\u6587\u4ef6\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", (String)"DownLoadCenterHelper_8", (String)"imc-bdm-common", (Object[])new Object[0]));
    }

    public static InputStream getInputStream(String urlStr) {
        try {
            urlStr = AwsFpyService.replaceUrl(urlStr);
            URL url = new URL(urlStr);
            HttpURLConnection conn = DownLoadCenterHelper.getConnection(url, null);
            conn.setConnectTimeout(60000);
            conn.setReadTimeout(860000);
            Map<String, String> requestHeader = ImcConfigUtil.getValue("request_header_config");
            if (!CollectionUtils.isEmpty(requestHeader)) {
                Set<Map.Entry<String, String>> entries = requestHeader.entrySet();
                for (Map.Entry<String, String> entry : entries) {
                    if (!urlStr.contains(entry.getKey())) continue;
                    JSONObject json = JSONObject.parseObject((String)entry.getValue());
                    json.forEach((k, v) -> conn.setRequestProperty((String)k, (String)v));
                }
            }
            return conn.getInputStream();
        }
        catch (Exception e) {
            LOG.error(String.format("getInputStream%s", e.getMessage()), (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u53d1\u7968\u6587\u4ef6\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", (String)"DownLoadCenterHelper_8", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
    }

    public static InputStream getLocalInputStream(String urlStr) {
        try {
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            return fileService.getInputStream(urlStr);
        }
        catch (Exception e) {
            LOG.error(String.format("getLocalInputStream%s", e.getMessage()), (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u8f7d\u672c\u5730\u6587\u4ef6\u51fa\u9519\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", (String)"DownLoadCenterHelper_9", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
    }

    private static HttpURLConnection getConnection(URL url, String method) throws IOException {
        HttpURLConnection conn;
        if ("https".equals(url.getProtocol())) {
            SSLContext ctx;
            try {
                ctx = SSLContext.getInstance("TLSv1.2");
                ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            HttpsURLConnection connHttps = (HttpsURLConnection)DownLoadCenterHelper.getConnection(url);
            connHttps.setSSLSocketFactory(ctx.getSocketFactory());
            connHttps.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return !"sim_bill_relation".equalsIgnoreCase(hostname);
                }
            });
            conn = connHttps;
        } else {
            conn = (HttpURLConnection)DownLoadCenterHelper.getConnection(url);
        }
        if (!StringUtils.isEmpty((CharSequence)method)) {
            conn.setRequestMethod(method);
            conn.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            conn.setRequestProperty("Connection", "Keep-Alive");
        }
        conn.setDoInput(true);
        conn.setDoOutput(true);
        return conn;
    }

    private static URLConnection getConnection(URL url) throws IOException {
        String[] values;
        String proxyConfig = HttpUtil.getProxy(url.getHost(), url.getPort());
        Proxy proxy = null;
        if (StringUtils.isNotEmpty((CharSequence)proxyConfig) && (values = proxyConfig.trim().split(":")).length >= 2) {
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(values[0], Integer.parseInt(values[1])));
        }
        if (proxy != null) {
            return url.openConnection(proxy);
        }
        return url.openConnection();
    }

    public static void checkExportItemsLimit(QFilter qFilter) {
        String value = ImcConfigUtil.getValue("exprotItemsLimit", "exprotItemsLimit");
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        int limit = Integer.parseInt(value);
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"id,items.id", (QFilter[])qFilter.toArray());
        if (array.length > 0) {
            int totalItemSize = 0;
            for (DynamicObject invoice : array) {
                totalItemSize += invoice.getDynamicObjectCollection("items").size();
            }
            if (totalItemSize > limit) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u5bfc\u51fa\u8d85\u51fa\u660e\u7ec6\u9650\u5236\uff1a%s\u6761", (String)"DownLoadCenterHelper_10", (String)"imc-bdm-common", (Object[])new Object[0]), limit));
            }
        }
    }

    public static void checkDownloadSize(DynamicObject[] objects) {
        String value = ImcConfigUtil.getValue("paperPdfDownloadLimit", "paperPdfDownloadLimit");
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        int limit = Integer.parseInt(value);
        if (objects.length > limit) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d85\u8fc7\u7eb8\u8d28\u53d1\u7968\u6587\u4ef6\u7684\u4e0b\u8f7d\u9650\u5236:%s\u6761\uff0c\u8bf7\u5206\u6279\u4e0b\u8f7d", (String)"DownLoadCenterHelper_11", (String)"imc-bdm-common", (Object[])new Object[0]), limit));
        }
    }

    public static JSONArray getOrderNoJson(String orderNo) {
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("orderno", (Object)orderNo);
        jsonArray.add((Object)jsonObject);
        return jsonArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zipOfdFiles(List<Map<String, String>> fileUrls, File zipFile) {
        boolean flag = true;
        InputStream inputStream = null;
        try (CheckedOutputStream cos = new CheckedOutputStream(new FileOutputStream(zipFile), new CRC32());
             ZipOutputStream zos = new ZipOutputStream(cos);){
            for (Map<String, String> fileMap : fileUrls) {
                inputStream = DownLoadCenterHelper.getDownloadPdfInputStream(fileMap);
                if (inputStream == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801%s\u672a\u83b7\u53d6\u5230\u6587\u4ef6\u6d41\uff0c\u4e0b\u8f7d\u5931\u8d25", (String)"DownLoadCenterHelper_12", (String)"imc-bdm-common", (Object[])new Object[0]), fileMap.get(KEY_FILE_INVOICE_NO)));
                }
                String fileName = DownLoadCenterHelper.warpDownloadFileName(fileMap);
                DownLoadCenterHelper.putNextEntry(zos, inputStream, fileName);
                inputStream.close();
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            flag = false;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    LOG.error("\u4e0b\u8f7d\u5173\u95ed\u6d41\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return flag;
    }

    public static void putNextEntry(ZipOutputStream zos, InputStream in, String fileName) throws IOException {
        int count;
        BufferedInputStream bis = new BufferedInputStream(in);
        int bufferLen = 1024;
        byte[] data = new byte[bufferLen];
        ZipEntry entry = new ZipEntry(fileName);
        zos.putNextEntry(entry);
        while ((count = bis.read(data, 0, bufferLen)) != -1) {
            zos.write(data, 0, count);
        }
        bis.close();
        zos.closeEntry();
    }

    public static String generateFileName(String pageName, String fileType) {
        return DateUtils.format(new Date(), "yyyyMMddHHmmss") + pageName + RandomString.getRandom(6) + fileType;
    }

    public static DynamicObject saveDownLoadCenter(IFormView view, String fileName, int size, Date applyTime) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bdm_download_center");
        obj.set("filename", (Object)fileName);
        obj.set("number", (Object)size);
        obj.set("applicant", (Object)RequestContext.get().getUserId());
        obj.set("org", (Object)RequestContext.get().getOrgId());
        obj.set("applytime", (Object)applyTime);
        obj.set("appid", (Object)"sim");
        obj.set("file_type", (Object)(fileName.endsWith(DOWNLOAD_TYPE_XLSX) ? "1" : "2"));
        obj.set("handlestate", (Object)"1");
        obj.set("delstate", (Object)"1");
        obj.set("source", (Object)view.getFormShowParameter().getCaption());
        ImcSaveServiceHelper.save(obj);
        return obj;
    }

    public static void showConfirmView(IFormView view) {
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(4);
        btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"DownLoadCenterHelper_14", (String)"imc-bdm-common", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7acb\u5373\u524d\u5f80", (String)"DownLoadCenterHelper_15", (String)"imc-bdm-common", (Object[])new Object[0]));
        view.showConfirm(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u6b63\u5728\u5904\u7406\uff0c\u7531\u4e8e\u6587\u4ef6\u8f83\u5927\uff0c\u5904\u7406\u9700\u8981\u4e00\u5b9a\u65f6\u95f4\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599/\u4e0b\u8f7d\u4e2d\u5fc3\u4e2d\u67e5\u770b\u3002", (String)"DownLoadCenterHelper_16", (String)"imc-bdm-common", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("bdm_download_center"), btnNameMaps);
    }

    public static void addDownloadItem(int size, String fileType) {
        String today = DateUtils.format(new Date());
        QFilter q = new QFilter("createdate", "=", (Object)today);
        q.and("creater", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        q.and("filetype", "=", (Object)fileType);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bdm_download_item", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_download_item"), (QFilter[])new QFilter[]{q});
        if (null == dynamicObject) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bdm_download_item");
            dynamicObject.set("downloadnumber", (Object)size);
            dynamicObject.set("createdate", (Object)today);
            dynamicObject.set("creater", (Object)Long.valueOf(RequestContext.get().getUserId()));
            dynamicObject.set("filetype", (Object)fileType);
        } else {
            dynamicObject.set("downloadnumber", (Object)dynamicObject.getBigDecimal("downloadnumber").add(new BigDecimal(size)));
        }
        ImcSaveServiceHelper.save(dynamicObject);
    }

    public static void checkLimitDownload(int size, String fileType) {
        QFilter qfilter = new QFilter("creater", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        qfilter.and("filetype", "=", (Object)fileType);
        qfilter.and("createdate", "=", (Object)DateUtils.format(new Date()));
        DynamicObjectCollection dc = QueryServiceHelper.query((String)"bdm_download_item", (String)"downloadnumber", (QFilter[])new QFilter[]{qfilter});
        BigDecimal downloadedNum = dc.stream().map(o -> o.getBigDecimal("downloadnumber")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sum = downloadedNum.add(new BigDecimal(size));
        if (sum.compareTo("excel".equals(fileType) ? DOWNLOAD_EXCEL_LIMIT : DOWNLOAD_FILE_LIMIT) > 0) {
            String s = fileType.equals("excel") ? String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25;\u5f53\u524d\u6bcf\u65e5\u53d1\u7968\u660e\u7ec6\u4e0b\u8f7d\u6700\u5927\u9650\u5236\u6570\u91cf\u4e3a%1$s\u6761,\u5f53\u524d\u60a8\u5df2\u4e0b\u8f7d%2$s\u6761,\u6700\u591a\u8fd8\u53ef\u4e0b\u8f7d%3$s\u6761", (String)"DownLoadCenterHelper_22", (String)"imc-bdm-common", (Object[])new Object[0]), DOWNLOAD_EXCEL_LIMIT, downloadedNum.longValue(), DOWNLOAD_EXCEL_LIMIT.subtract(downloadedNum).longValue()) : String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25;\u5f53\u524d\u6bcf\u65e5\u53d1\u7968OFD\u6587\u4ef6\u6700\u5927\u9650\u5236\u6570\u91cf\u4e3a%1$s\u6761,\u5f53\u524d\u60a8\u5df2\u4e0b\u8f7d%2$s\u6761,\u6700\u591a\u8fd8\u53ef\u4e0b\u8f7d%3$s\u6761", (String)"DownLoadCenterHelper_23", (String)"imc-bdm-common", (Object[])new Object[0]), DOWNLOAD_FILE_LIMIT, downloadedNum.longValue(), DOWNLOAD_FILE_LIMIT.subtract(downloadedNum).longValue());
            throw new KDBizException(s);
        }
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] cert, String oauthType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] cert, String oauthType) throws CertificateException {
        }
    }
}

