/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.constant.InvTitleVo;
import kd.imc.bdm.common.constant.MultiLangEnumBridge;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.CodeGenerateUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;

public class InvTitleSettingHelper {
    private static final Log LOGGER = LogFactory.getLog(InvTitleSettingHelper.class);
    public static final String FORM_ID = "bdm_inv_title_setting";
    public static final String INV_TITLE_SETTING_CACHE_KEY = "INV_TITLE_SETTING_";

    public static DynamicObject getInvTitleSetting(Long orgId) {
        if (null == orgId || orgId.intValue() == 0) {
            return null;
        }
        String cacheStr = CacheHelper.get(INV_TITLE_SETTING_CACHE_KEY + orgId);
        if (StringUtils.isNotBlank((CharSequence)cacheStr)) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)FORM_ID);
            return DynamicObjectUtil.json2DynamicObject(obj, JSON.parseObject((String)cacheStr));
        }
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        String selFields = PropertieUtil.getAllPropertiesSplitByComma(FORM_ID, true);
        DynamicObject invTitleSettingObj = QueryServiceHelper.queryOne((String)FORM_ID, (String)selFields, (QFilter[])filter.toArray());
        if (null == invTitleSettingObj) {
            return null;
        }
        CacheHelper.put(INV_TITLE_SETTING_CACHE_KEY + orgId, DynamicObjectUtil.dynamicObject2Json(invTitleSettingObj).toJSONString());
        return invTitleSettingObj;
    }

    public static void selAndSaveInvTitle(InvTitleVo invTitleVo) {
        if (null == invTitleVo) {
            return;
        }
        DynamicObject invTitleObj = BusinessDataServiceHelper.newDynamicObject((String)"bdm_invice_title_strate");
        invTitleObj.set("number", (Object)CodeGenerateUtil.getRandomTitleCode(invTitleVo.getOrgId()));
        invTitleObj.set("name", (Object)(null == invTitleVo.getBuyerName() ? " " : invTitleVo.getBuyerName()));
        invTitleObj.set("taxno", (Object)(null == invTitleVo.getBuyerTaxNo() ? " " : invTitleVo.getBuyerTaxNo()));
        invTitleObj.set("buyertype", (Object)(null == invTitleVo.getBuyerType() ? "1" : invTitleVo.getBuyerType()));
        invTitleObj.set("status", (Object)"C");
        invTitleObj.set("enable", (Object)"1");
        invTitleObj.set("idcode", (Object)(null == invTitleVo.getIdCode() ? " " : invTitleVo.getIdCode()));
        invTitleObj.set("companycode", (Object)(null == invTitleVo.getCompanyCode() ? " " : invTitleVo.getCompanyCode()));
        long orgId = null == invTitleVo.getOrgId() ? Long.valueOf(RequestContext.get().getOrgId()) : invTitleVo.getOrgId();
        DynamicObject org = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
        org.set("id", (Object)orgId);
        invTitleObj.set("org", (Object)org);
        invTitleObj.set("createorg", (Object)org);
        invTitleObj.set("useorg", (Object)org);
        invTitleObj.set("createtime", (Object)new Date());
        invTitleObj.set("modifytime", (Object)new Date());
        invTitleObj.set("epinfo", null == invTitleVo.getEpInfo() ? Integer.valueOf(0) : invTitleVo.getEpInfo());
        invTitleObj.set("openingbank", (Object)(null == invTitleVo.getOpenBank() ? " " : invTitleVo.getOpenBank()));
        invTitleObj.set("addr", (Object)(null == invTitleVo.getAddr() ? " " : invTitleVo.getAddr()));
        invTitleObj.set("ctrlstrategy", (Object)"7");
        invTitleObj.set("creator", (Object)RequestContext.get().getUserId());
        DynamicObject items = invTitleObj.getDynamicObjectCollection("items").addNew();
        items.set("seq", (Object)0);
        items.set("itemopeningbank", (Object)(null == invTitleVo.getOpenBank() ? " " : invTitleVo.getOpenBank()));
        items.set("itemaddr", (Object)(null == invTitleVo.getAddr() ? " " : invTitleVo.getAddr()));
        items.set("itemcontacts", (Object)(null == invTitleVo.getContact() ? " " : invTitleVo.getContact()));
        items.set("itemmobilephone", (Object)(null == invTitleVo.getMobile() ? " " : invTitleVo.getMobile()));
        items.set("itememail", (Object)(null == invTitleVo.getEmai() ? " " : invTitleVo.getEmai()));
        items.set("isdefault", (Object)"1");
        items.set("priority", (Object)"1");
        OperationServiceHelper.executeOperate((String)"save", (String)"bdm_invice_title_strate", (DynamicObject[])new DynamicObject[]{invTitleObj}, (OperateOption)OperateOption.create());
    }

    public static void dealInvTitleBySetting(DynamicObject invObj) {
        try {
            long orgId;
            DynamicObject setObj;
            if (null == invObj) {
                return;
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("\u81ea\u52a8\u8865\u5f55\u53d1\u7968\u62ac\u5934\u4f20\u5165\u7684\u53d1\u7968\u4fe1\u606f\u662f\uff1a%s", SerializationUtils.toJsonString((Object)invObj)));
            }
            if (null == (setObj = InvTitleSettingHelper.getInvTitleSetting(orgId = DynamicObjectUtil.getDynamicObjectLongValue(invObj.get("orgid"))))) {
                return;
            }
            boolean singleInv = setObj.getBoolean("single_invoice");
            boolean batchInv = setObj.getBoolean("batch_invoice");
            boolean apiInv = setObj.getBoolean("api_invoice");
            boolean splitMergeInv = setObj.getBoolean("split_merge_invoice");
            boolean scanInv = setObj.getBoolean("scan_invoice");
            String invDataSource = invObj.getString("buyertype");
            if (singleInv && "0".equals(invDataSource)) {
                InvTitleSettingHelper.selAndSaveInvTitle(InvTitleSettingHelper.buildInv2InvTitle(invObj, orgId));
            }
            if (batchInv && "1".equals(invDataSource)) {
                InvTitleSettingHelper.selAndSaveInvTitle(InvTitleSettingHelper.buildInv2InvTitle(invObj, orgId));
            }
            if (apiInv && "3".equals(invDataSource)) {
                InvTitleSettingHelper.selAndSaveInvTitle(InvTitleSettingHelper.buildInv2InvTitle(invObj, orgId));
            }
            if (splitMergeInv && "4".equals(invDataSource)) {
                InvTitleSettingHelper.selAndSaveInvTitle(InvTitleSettingHelper.buildInv2InvTitle(invObj, orgId));
            }
            if (scanInv && StringUtils.isNotBlank((CharSequence)invObj.getString("wxid"))) {
                InvTitleSettingHelper.selAndSaveInvTitle(InvTitleSettingHelper.buildInv2InvTitle(invObj, orgId));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u81ea\u52a8\u8865\u5f55\u53d1\u7968\u62ac\u5934\u5931\u8d25", (Throwable)e);
        }
    }

    public static InvTitleVo buildInv2InvTitle(DynamicObject invObj, long orgId) {
        if (null == invObj) {
            return null;
        }
        String taxNo = invObj.getString("buyertaxno");
        InvTitleVo titleVo = new InvTitleVo();
        titleVo.setBuyerName(invObj.getString("buyername"));
        titleVo.setBuyerTaxNo(taxNo);
        titleVo.setOpenBank(invObj.getString("buyerbank"));
        titleVo.setAddr(invObj.getString("buyeraddr"));
        titleVo.setMobile(invObj.getString("buyerphone"));
        titleVo.setEmai(invObj.getString("buyeremail"));
        titleVo.setOrgId(orgId);
        String buyerProperty = invObj.getString("buyerproperty");
        String buyerType = "1";
        if ("1".equals(buyerProperty)) {
            buyerType = "2";
        } else if ("2".equals(buyerProperty)) {
            buyerType = "3";
        }
        titleVo.setBuyerType(buyerType);
        return titleVo;
    }

    public static enum InvTitleMappingEnum {
        TIT_MAPP_BILL_PUSH("tit_mapp_bill_push", new MultiLangEnumBridge("\u539f\u59cb\u5355\u636e\u63a5\u53e3", "InvTitleSettingHelper_0", "imc-bdm-common")),
        TIT_MAPP_BILL_IMPORT("tit_mapp_bill_import", new MultiLangEnumBridge("\u539f\u59cb\u5355\u636e\u5bfc\u5165", "InvTitleSettingHelper_1", "imc-bdm-common")),
        TIT_MAPP_INV_API("tit_mapp_inv_api", new MultiLangEnumBridge("API\u5f00\u7968", "InvTitleSettingHelper_2", "imc-bdm-common")),
        TIT_MAPP_INV_BATCH("tit_mapp_inv_batch", new MultiLangEnumBridge("\u6279\u91cf\u5f00\u7968", "InvTitleSettingHelper_3", "imc-bdm-common"));

        private String code;
        private MultiLangEnumBridge bridge;

        private InvTitleMappingEnum(String code, MultiLangEnumBridge bridge) {
            this.code = code;
            this.bridge = bridge;
        }

        public String getCode() {
            return this.code;
        }

        public String getDes() {
            return this.bridge.loadKDString();
        }
    }
}

