/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.InvoiceFileUrlInfo;
import kd.imc.bdm.common.util.InvoiceUtils;

public class InvoiceFileUrlInfoHelper {
    private static final Log LOGGER = LogFactory.getLog(InvoiceFileUrlInfoHelper.class);

    public static InvoiceFileUrlInfo getFileUrlInfo(String orderNo) {
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "fileurl", "snapshoturl", "xmlfileurl", "pdffileurl", "issuesource"), (QFilter[])new QFilter("orderno", "=", (Object)orderNo).toArray());
        if (array.length == 0) {
            throw new MsgException(String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7\uff1a%s\u5bf9\u5e94\u7684\u53d1\u7968\u6ca1\u6709\u627e\u5230", (String)"InvoiceFileUrlInfoHelper_0", (String)"imc-bdm-common", (Object[])new Object[0]), orderNo));
        }
        if (StringUtils.isNotBlank((CharSequence)array[0].getString("fileurl"))) {
            InvoiceFileUrlInfo info = new InvoiceFileUrlInfo();
            info.setFileUrl(array[0].getString("fileurl"));
            info.setSnapshotUrl(array[0].getString("snapshoturl"));
            info.setPdfUrl(array[0].getString("pdffileurl"));
            info.setXmlUrl(array[0].getString("xmlfileurl"));
            LOGGER.info(String.format("S3\u6587\u4ef6\u5730\u5740\uff1a%s", JSONObject.toJSONString((Object)info)));
            return info;
        }
        if (InvoiceFileUrlInfoHelper.isLeQiFileExist(array[0])) {
            InvoiceFileUrlInfo info = new InvoiceFileUrlInfo();
            String attachmentUrl = System.getProperty("attachmentServer.url");
            info.setFileUrl(attachmentUrl + array[0].getString("pdffileurl"));
            String snapShotUrl = array[0].getString("snapshoturl");
            if (StringUtils.isNotBlank((CharSequence)snapShotUrl)) {
                info.setSnapshotUrl(attachmentUrl + snapShotUrl);
            }
            info.setPdfUrl(info.getFileUrl());
            info.setXmlUrl(array[0].getString("xmlfileurl"));
            LOGGER.info(String.format("S3\u6587\u4ef6\u5730\u5740\uff1a%s", JSONObject.toJSONString((Object)info)));
            return info;
        }
        throw new MsgException(ErrorType.INVOICE_FILE_NOT_FOUND);
    }

    public static boolean isLeQiFileExist(DynamicObject invoice) {
        return InvoiceUtils.isFromLeqi(invoice) && StringUtils.isNotBlank((CharSequence)invoice.getString("pdffileurl"));
    }
}

