/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.imc.bdm.common.constant.InvoiceStatus;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.UnitTestHelper;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.util.InvoiceQueryUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;

public class RedConfirmHelper {
    public static QFilter getNormalUsefulFilter() {
        QFilter filter = new QFilter("uploadstatus", "=", (Object)"1");
        filter = filter.and("issuestatus", "=", (Object)"2");
        return filter;
    }

    public static QFilter getApplicantFilter() {
        return new QFilter("applicant", "=", (Object)"2");
    }

    public static QFilter getBillUsedFilter() {
        return new QFilter("source", "!=", (Object)"5");
    }

    public static String matchBillRedReason(Object redReason) {
        String billRedReason = null;
        if ("01".equals(redReason)) {
            billRedReason = "2";
        } else if ("03".equals(redReason)) {
            billRedReason = "3";
        } else if ("04".equals(redReason)) {
            billRedReason = "4";
        } else if ("02".equals(redReason)) {
            billRedReason = "1";
        }
        return billRedReason;
    }

    public static void dealRedConfirmBillItem(JSONObject invoiceJson) {
        String invoiceType = invoiceJson.getString("invoicetype");
        Object issueType = invoiceJson.get((Object)"issuetype");
        Object isElePaper = invoiceJson.get((Object)"iselepaper");
        if (!IssueType.RED_INVOICE.getTypeCode().equals(issueType) || !InvoiceUtils.isAllEInvoice(invoiceType) && !AllEleAuthHelper.isElePaper(isElePaper)) {
            return;
        }
        String redConfirmBillNo = (String)invoiceJson.get((Object)"infocode");
        String orgId = invoiceJson.getString("orgid");
        Long orgPk = Long.parseLong(orgId);
        QFilter filter = UnitTestHelper.isUnitTest() ? new QFilter("number", "=", (Object)redConfirmBillNo).and("org", "=", (Object)orgPk) : RedConfirmHelper.getFilter(redConfirmBillNo, orgPk);
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_red_confirm_bill", true), (QFilter[])filter.toArray());
        if (array.length == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u67e5\u627e\u5230\u5bf9\u5e94\u7684\u7ea2\u5b57\u786e\u8ba4\u5355,billNo:%1$s,OrgPk:%2$s", (String)"RedConfirmHelper_7", (String)"imc-bdm-common", (Object[])new Object[0]), redConfirmBillNo, orgPk));
        }
        DynamicObject redConfirmBill = array[0];
        DynamicObjectCollection redConfirmItems = redConfirmBill.getDynamicObjectCollection("items");
        invoiceJson.put("govuuid", redConfirmBill.get("govuuid"));
        invoiceJson.put("orderno", redConfirmBill.get("orderno"));
        invoiceJson.put("specialtype", redConfirmBill.get("specialtype"));
        JSONArray newItems = new JSONArray();
        invoiceJson.put("items", (Object)newItems);
        int i = 0;
        String hsbz = redConfirmBill.getString("hsbz");
        for (DynamicObject redConfirmItem : redConfirmItems) {
            i = RedConfirmHelper.dealItem(newItems, i, hsbz, redConfirmItem);
        }
    }

    public static int dealItem(JSONArray newItems, int i, String hsbz, DynamicObject redConfirmItem) {
        DynamicObject taxClassCode;
        JSONObject newItem = new JSONObject();
        newItems.add((Object)newItem);
        String goodsCode = RedConfirmHelper.getStrValue(redConfirmItem.get("goodscode"));
        if (StringUtils.isNotBlank((CharSequence)goodsCode) && (taxClassCode = TaxClassCodeCheckHelper.geTaxCode(goodsCode)) != null) {
            newItem.put("simplegoodsname", (Object)taxClassCode.getString("simplename"));
        }
        newItem.put("num", (Object)RedConfirmHelper.getStrValue(redConfirmItem.get("num")));
        newItem.put("goodsname", (Object)RedConfirmHelper.getStrValue(redConfirmItem.get("goodsname")));
        newItem.put("itemremainredamount", null);
        newItem.put("startdate", null);
        newItem.put("unitprice", (Object)RedConfirmHelper.getStrValue(redConfirmItem.get("unitprice")));
        newItem.put("tableName", (Object)"items");
        newItem.put("discountamount", null);
        newItem.put("itemremainredtax", null);
        newItem.put("id", (Object)String.valueOf(DBServiceHelper.genGlobalLongId()));
        newItem.put("spbm", null);
        newItem.put("seq", (Object)RedConfirmHelper.getStrValue(i));
        newItem.put("taxunitprice", (Object)RedConfirmHelper.getStrValue(redConfirmItem.get("taxunitprice")));
        newItem.put("taxpremark", null);
        newItem.put("taxrate", (Object)RedConfirmHelper.getStrValue(redConfirmItem.get("taxrate")));
        newItem.put("amount", (Object)RedConfirmHelper.getStrValue(redConfirmItem.get("amount")));
        newItem.put("goodscode", (Object)goodsCode);
        newItem.put("zzstsgl", null);
        newItem.put("rowtype", (Object)RedConfirmHelper.getStrValue(redConfirmItem.get("rowtype")));
        newItem.put("specification", (Object)RedConfirmHelper.getStrValue(redConfirmItem.get("specification")));
        newItem.put("zerotaxmark", null);
        newItem.put("vehplate", null);
        newItem.put("tax", (Object)RedConfirmHelper.getStrValue(redConfirmItem.get("tax")));
        newItem.put("writeoffqty", null);
        newItem.put("discountrate", null);
        newItem.put("zxbm", null);
        newItem.put("unit", (Object)RedConfirmHelper.getStrValue(redConfirmItem.get("unit")));
        newItem.put("enddate", null);
        newItem.put("taxflag", (Object)hsbz);
        newItem.put("taxamount", (Object)RedConfirmHelper.getStrValue(redConfirmItem.get("taxamount")));
        newItem.put("billsourceid", redConfirmItem.get("billsourceid"));
        newItem.put("originseq", redConfirmItem.get("originseq"));
        newItem.put("originalinvoiceitemid", (Object)RedConfirmHelper.getStrValue(redConfirmItem.get("originalinvoiceitemid")));
        return ++i;
    }

    private static String getStrValue(Object value) {
        if (null == value) {
            return null;
        }
        return String.valueOf(value);
    }

    public static QFilter getFilter(String redConfirmBillNo, Long orgId) {
        QFilter baseFilter = ImcBaseDataHelper.getRedConfirmFilter(orgId);
        return new QFilter("number", "=", (Object)redConfirmBillNo).and(baseFilter);
    }

    public static DynamicObject loadConfirmBill(String redConfirmBillNo, Long orgId) {
        QFilter filter = RedConfirmHelper.getFilter(redConfirmBillNo, orgId);
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_red_confirm_bill", true), (QFilter[])filter.toArray());
        if (array.length == 0) {
            return null;
        }
        return array[0];
    }

    public static boolean isRedConfirmBill(DynamicObject bill) {
        String billProperty = bill.getString("billproperties");
        String invoiceType = bill.getString("invoicetype");
        String isElePaper = bill.getString("iselepaper");
        return "-1".equals(billProperty) && (InvoiceUtils.isAllEInvoice(invoiceType) || AllEleAuthHelper.isElePaper(isElePaper));
    }

    public static void replaceItems(DynamicObject confirmBill, DynamicObject invoice) {
        DynamicObjectCollection items = invoice.getDynamicObjectCollection("items");
        items.clear();
        DynamicObjectCollection confirmItems = confirmBill.getDynamicObjectCollection("items");
        int i = 0;
        String hsbz = confirmBill.getString("hsbz");
        invoice.set("govuuid", confirmBill.get("govuuid"));
        invoice.set("orderno", confirmBill.get("orderno"));
        invoice.set("specialtype", confirmBill.get("specialtype"));
        for (DynamicObject confirmItem : confirmItems) {
            DynamicObject taxClassCode;
            DynamicObject newItem = items.addNew();
            String goodsCode = RedConfirmHelper.getStrValue(confirmItem.get("goodscode"));
            if (StringUtils.isNotBlank((CharSequence)goodsCode) && (taxClassCode = TaxClassCodeCheckHelper.geTaxCode(goodsCode)) != null) {
                newItem.set("simplegoodsname", (Object)taxClassCode.getString("simplename"));
            }
            newItem.set("num", confirmItem.get("num"));
            newItem.set("goodsname", confirmItem.get("goodsname"));
            newItem.set("itemremainredamount", null);
            newItem.set("startdate", null);
            newItem.set("unitprice", confirmItem.get("unitprice"));
            newItem.set("discountamount", null);
            newItem.set("itemremainredtax", null);
            newItem.set("id", (Object)DBServiceHelper.genGlobalLongId());
            newItem.set("spbm", null);
            newItem.set("seq", (Object)RedConfirmHelper.getStrValue(i));
            newItem.set("taxunitprice", confirmItem.get("taxunitprice"));
            newItem.set("taxpremark", null);
            newItem.set("taxrate", confirmItem.get("taxrate"));
            newItem.set("amount", confirmItem.get("amount"));
            newItem.set("goodscode", (Object)goodsCode);
            newItem.set("zzstsgl", null);
            newItem.set("rowtype", confirmItem.get("rowtype"));
            newItem.set("specification", confirmItem.get("specification"));
            newItem.set("zerotaxmark", null);
            newItem.set("vehplate", null);
            newItem.set("tax", confirmItem.get("tax"));
            newItem.set("writeoffqty", null);
            newItem.set("discountrate", null);
            newItem.set("zxbm", null);
            newItem.set("unit", confirmItem.get("unit"));
            newItem.set("enddate", null);
            newItem.set("taxflag", (Object)hsbz);
            newItem.set("taxamount", confirmItem.get("taxamount"));
            newItem.set("billsourceid", confirmItem.get("billsourceid"));
            newItem.set("originseq", confirmItem.get("originseq"));
            newItem.set("originalinvoiceitemid", confirmItem.get("originalinvoiceitemid"));
            ++i;
        }
    }

    public static void checkInvoiceExistConfirmBillNo(String confirmBillNo) {
        QFilter filter = new QFilter("infocode", "=", (Object)confirmBillNo).and("invoicetype", "in", (Object)new String[]{"08xdp", "10xdp"});
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"invoicecode,invoiceno,billno", (QFilter[])filter.toArray());
        if (array.length == 0) {
            return;
        }
        String invoiceNo = array[0].getString("invoiceno");
        if (StringUtils.isBlank((CharSequence)invoiceNo)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u7ea2\u5b57\u786e\u8ba4\u5355\u6807\u53f7\u4e3a%s\u7684\u5f85\u5f00\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"RedConfirmHelper_1", (String)"imc-bdm-common", (Object[])new Object[0]), confirmBillNo));
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u7ea2\u5b57\u786e\u8ba4\u5355\u6807\u53f7\u4e3a%s\u7684\u53d1\u7968\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"RedConfirmHelper_2", (String)"imc-bdm-common", (Object[])new Object[0]), confirmBillNo));
    }

    public static void checkRedConfirmBillNoUsed(DynamicObject oriBill) {
        String redConfirmBillNo = oriBill.getString("infocode");
        if (StringUtils.isNotEmpty((CharSequence)redConfirmBillNo)) {
            DynamicObject org = oriBill.getDynamicObject("orgid");
            QFilter filter = RedConfirmHelper.getFilter(redConfirmBillNo, org.getLong("id"));
            DynamicObject[] array = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_red_confirm_bill", true), (QFilter[])filter.toArray());
            if (array.length == 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7ea2\u5b57\u786e\u8ba4\u5355\u5355\u636e\u7f16\u53f7\u4e3a\uff1a%s\u7684\u7ea2\u5b57\u786e\u8ba4\u5355", (String)"RedConfirmHelper_3", (String)"imc-bdm-common", (Object[])new Object[0]), redConfirmBillNo));
            }
            String billNo = oriBill.getString("billno");
            String source = array[0].getString("source");
            if ("5".equals(source)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e:%1$s\u7684\u7ea2\u5b57\u786e\u8ba4\u5355:%2$s\u5df2\u7ecf\u88ab\u5360\u7528\uff0c\u8bf7\u68c0\u67e5\u786e\u8ba4", (String)"RedConfirmHelper_8", (String)"imc-bdm-common", (Object[])new Object[0]), billNo, redConfirmBillNo));
            }
            String issueStatus = array[0].getString("issuestatus");
            if (!"2".equals(issueStatus)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e:%1$s\u7684\u7ea2\u5b57\u786e\u8ba4\u5355:%2$s\u975e\u672a\u5f00\u7968\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5\u786e\u8ba4", (String)"RedConfirmHelper_9", (String)"imc-bdm-common", (Object[])new Object[0]), billNo, redConfirmBillNo));
            }
        } else {
            String blueInvoiceCode = org.apache.commons.lang.StringUtils.trimToEmpty((String)oriBill.getString("blueinvoicecode"));
            String blueInvoiceNo = org.apache.commons.lang.StringUtils.trimToEmpty((String)oriBill.getString("blueinvoiceno"));
            QFilter qFilter = InvoiceQueryUtil.getInvoiceByCodeAndNo(blueInvoiceCode, blueInvoiceNo);
            DynamicObject invoiceObj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice", false), (QFilter[])qFilter.toArray());
            if (invoiceObj == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53d1\u7968\u53f7\u7801\u4e3a\uff1a%s\u7684\u539f\u84dd\u7968\u4fe1\u606f", (String)"RedConfirmHelper_10", (String)"imc-bdm-common", (Object[])new Object[0]), blueInvoiceNo));
            }
            if (!InvoiceStatus.isNormalInvIncludePartRed(invoiceObj.getString("invoicestatus"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u4e3a\uff1a%s\u7684\u539f\u84dd\u7968\u4fe1\u606f\u975e\u6b63\u5e38\u6216\u90e8\u5206\u7ea2\u51b2\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"RedConfirmHelper_11", (String)"imc-bdm-common", (Object[])new Object[0]), blueInvoiceNo));
            }
        }
    }

    public static void checkOriginalBillRedConfirmInfo(DynamicObject bill) {
        String redConfirmBillNo = bill.getString("infocode");
        String blueInvoiceNo = bill.getString("blueinvoiceno");
        String redReason = bill.getString("redreason");
        Date blueIssueTime = bill.getDate("originalissuetime");
        String blueInvoiceType = bill.getString("blueinvoicetype");
        if (StringUtils.isEmpty((CharSequence)redConfirmBillNo) && StringUtils.isNotEmpty((CharSequence)redReason)) {
            if (StringUtils.isBlank((CharSequence)blueInvoiceNo) || null == blueIssueTime || StringUtils.isBlank((CharSequence)blueInvoiceType)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s,\u5f85\u51b2\u84dd\u7968\u53f7\u7801\u3001\u5f85\u51b2\u84dd\u7968\u5f00\u7968\u65e5\u671f\u3001\u5f85\u51b2\u53d1\u7968\u79cd\u7c7b\u3001\u7ea2\u51b2\u539f\u56e0\u5fc5\u586b", (String)"RedConfirmHelper_12", (String)"imc-bdm-common", (Object[])new Object[0]), bill.getString("billno")));
            }
            return;
        }
        if (StringUtils.isBlank((CharSequence)redConfirmBillNo) || StringUtils.isBlank((CharSequence)blueInvoiceNo) || StringUtils.isBlank((CharSequence)redReason) || null == blueIssueTime || StringUtils.isBlank((CharSequence)blueInvoiceType)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s,\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7\u3001\u5f85\u51b2\u84dd\u7968\u53f7\u7801\u3001\u5f85\u51b2\u84dd\u7968\u5f00\u7968\u65e5\u671f\u3001\u5f85\u51b2\u53d1\u7968\u79cd\u7c7b\u3001\u7ea2\u51b2\u539f\u56e0\u5fc5\u586b", (String)"RedConfirmHelper_6", (String)"imc-bdm-common", (Object[])new Object[0]), bill.getString("billno")));
        }
    }

    public static void replaceWaitInvFromBillBuyerReceiveInvInfo(DynamicObject confirmBill, DynamicObject invoice) {
        String buyerPhone = confirmBill.getString("buyerphone");
        String buyerEmail = confirmBill.getString("buyeremail");
        if (StringUtils.isBlank((CharSequence)invoice.getString("buyerphone")) && StringUtils.isBlank((CharSequence)invoice.getString("buyeremail"))) {
            invoice.set("buyerphone", (Object)buyerPhone);
            invoice.set("buyeremail", (Object)buyerEmail);
        }
    }
}

