/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ReducedHelper {
    public static String REDUCED_PRIVILEGE_TYPE = "\u7b80\u6613\u5f81\u6536";
    public static String REDUCED_PRIVILEGE_TYPE_SPECIAL = "\u7b80\u6613\u5f81\u6536\u51cf\u6309";
    public static final Log LOGGER = LogFactory.getLog(ReducedHelper.class);
    public static final String REDUCED_TAXRATE = "0.015";
    public static final String REDUCED_TAXRATE_POLICYCONSTANT = "\u63095%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%\u8ba1\u5f81";

    public static BigDecimal calcTaxWithoutTax(Object policyConstants, BigDecimal amount) {
        String policyStr = String.valueOf(policyConstants);
        if (policyStr.split("%").length != 3) {
            throw new KDBizException(ResManager.loadKDString((String)"\u51cf\u6309\u8ba1\u5f81\u7684\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u6709\u8bef", (String)"ReducedHelper_20", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        String[] array1 = policyStr.split("\u6309");
        String[] first = array1[1].split("%");
        String old = first[0];
        String[] last = array1[2].split("%");
        String used = last[0];
        BigDecimal oriTaxRate = new BigDecimal(old).divide(new BigDecimal("100"));
        BigDecimal usedTaxRate = new BigDecimal(used).divide(new BigDecimal("100"));
        BigDecimal decimalValue = BigDecimal.ONE.subtract(usedTaxRate).add(oriTaxRate);
        return usedTaxRate.multiply(amount).divide(decimalValue, 2, RoundingMode.HALF_UP);
    }

    public static BigDecimal calcTaxWithTax(Object policyConstants, BigDecimal taxAmount) {
        String policyStr = String.valueOf(policyConstants);
        if (policyStr.split("%").length != 3) {
            throw new KDBizException(ResManager.loadKDString((String)"\u51cf\u6309\u8ba1\u5f81\u7684\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u6709\u8bef", (String)"ReducedHelper_20", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        String[] array1 = policyStr.split("\u6309");
        String[] first = array1[1].split("%");
        String old = first[0];
        String[] last = array1[2].split("%");
        String used = last[0];
        BigDecimal oriTaxRate = new BigDecimal(old).divide(new BigDecimal("100"));
        BigDecimal usedTaxRate = new BigDecimal(used).divide(new BigDecimal("100"));
        BigDecimal decimalValue = BigDecimal.ONE.add(oriTaxRate);
        return usedTaxRate.multiply(taxAmount).divide(decimalValue, 2, RoundingMode.HALF_UP);
    }

    public static BigDecimal getReducedTaxRate(Object policyConstants) {
        if (!String.valueOf(policyConstants).contains(REDUCED_PRIVILEGE_TYPE_SPECIAL)) {
            return BigDecimal.ZERO;
        }
        String policyStr = String.valueOf(policyConstants);
        String[] array1 = policyStr.split(ResManager.loadKDString((String)"\u6309", (String)"ReducedHelper_21", (String)"imc-bdm-common", (Object[])new Object[0]));
        String[] last = array1[2].split("%");
        String used = last[0];
        return new BigDecimal(used).divide(new BigDecimal("100"));
    }

    public static boolean isReduced(Object taxationStyle) {
        return "1".equals(taxationStyle);
    }

    public static boolean isSpecialCalc(Object policyConstants) {
        return String.valueOf(policyConstants).contains(ResManager.loadKDString((String)"\u7b80\u6613\u5f81\u6536\u51cf\u6309", (String)"ReducedHelper_19", (String)"imc-bdm-common", (Object[])new Object[0]));
    }

    public static boolean isPrivilegeTypeNotReduced(Object privilegeType) {
        return !String.valueOf(privilegeType).contains(REDUCED_PRIVILEGE_TYPE);
    }

    public static boolean isTaxRateCodeisReduced(DynamicObject taxRateObj) {
        String zzstsglStr = taxRateObj.getString("vatspecialmanagement");
        return String.valueOf(zzstsglStr).contains(REDUCED_PRIVILEGE_TYPE);
    }
}

