/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper.callback;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.EquipmentType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.OpenApiCallbackInterfaceCodeEnum;
import kd.imc.bdm.common.constant.table.OriginalBillConstant;
import kd.imc.bdm.common.dto.BillTravelerItemVo;
import kd.imc.bdm.common.dto.CallbackLogVo;
import kd.imc.bdm.common.dto.allelespecial.BillVehicheVesselShipVo;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.EasBusinessHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.RelationHelper;
import kd.imc.bdm.common.helper.callback.SendCallBackHelper;
import kd.imc.bdm.common.message.util.IsmcToken;
import kd.imc.bdm.common.openapi.BizControlVo;
import kd.imc.bdm.common.openapi.CallbackResponseVo;
import kd.imc.bdm.common.openapi.InvoiceDetailVo;
import kd.imc.bdm.common.openapi.InvoiceVo;
import kd.imc.bdm.common.util.AesUtil;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;

public class ApiCallBackHelper {
    private static final Log LOGGER = LogFactory.getLog(ApiCallBackHelper.class);

    public static CallbackResponseVo sendCallBack(String callbackUrl, DynamicObject businessSystem, CallbackLogVo callbackLog, InvoiceVo invoiceVo, DynamicObject invoiceDynamicObject, BizControlVo bizControlVo) {
        DynamicObject invalidBill;
        String billNo;
        DynamicObject[] billInvRelations;
        DynamicObject[] dynamicObjectArray = billInvRelations = "merge".equals(ImcConfigUtil.getValue(CacheKeyEnum.SIM_INVOICE_CALLBACK_CONFIG)) ? ApiCallBackHelper.getMergeOriBillRelation(invoiceDynamicObject) : ApiCallBackHelper.getOriBillRelation(invoiceDynamicObject);
        if ("10".equals(invoiceDynamicObject.getString("contraststatus"))) {
            billInvRelations = ApiCallBackHelper.getMatchBillRelation(invoiceDynamicObject);
        }
        String string = billNo = billInvRelations == null || billInvRelations.length == 0 ? "" : Stream.of(billInvRelations).map(relation -> relation.getString("sbillno")).distinct().collect(Collectors.joining(","));
        if (StringUtils.isNotBlank((CharSequence)billNo)) {
            invoiceVo.setBillNo(billNo);
        }
        if (StringUtils.isBlank((CharSequence)invoiceVo.getBillNo())) {
            invoiceVo.setBillNo(invoiceVo.getBatch());
        }
        if ((invalidBill = ApiCallBackHelper.getInvalidBill(invoiceDynamicObject)) != null) {
            invoiceVo.setOriginalBillNo(invoiceVo.getBillNo());
            invoiceVo.setBillNo(invalidBill.getString("billno"));
        }
        String data = JSON.toJSONString((Object)invoiceVo);
        if (InvoiceUtils.isRed(invoiceDynamicObject.getString("issuetype")) && invoiceDynamicObject.getString("systemsource").startsWith("3std1")) {
            ArrayList<InvoiceVo> invoiceVoList = new ArrayList<InvoiceVo>();
            QFilter invoiceFilter = InvoiceUtils.getInvoiceFilter(invoiceDynamicObject.getString("originalinvoicecode"), invoiceDynamicObject.getString("originalinvoiceno"));
            DynamicObject blueInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice"), (QFilter[])invoiceFilter.toArray());
            invoiceVo.setBillNo(ApiCallBackHelper.getOriBillNoByBillInvRelation(blueInvoice));
            invoiceVoList.add(invoiceVo);
            data = JSONObject.toJSONString(invoiceVoList);
            callbackLog.setBusinessType("INVOICE.OPEN");
        }
        return ApiCallBackHelper.sendCallBackRequest(callbackUrl, businessSystem, callbackLog, data, bizControlVo);
    }

    private static DynamicObject[] getMatchBillRelation(DynamicObject invoiceDynamicObject) {
        Long pk = RelationHelper.getRedTBillId(invoiceDynamicObject);
        QFilter filter = new QFilter("tbillid", "=", (Object)pk);
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"sim_match_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_match_inv_relation", true), (QFilter[])filter.toArray());
        if (relations.length == 0) {
            return new DynamicObject[0];
        }
        HashSet<Long> matchBillItemPks = new HashSet<Long>();
        for (DynamicObject relation : relations) {
            matchBillItemPks.add(relation.getLong("sdetailid"));
        }
        filter = new QFilter("tdetailid", "in", (Object)matchBillItemPks.toArray(new Object[0]));
        return BusinessDataServiceHelper.load((String)"sim_matchbill_relation", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_matchbill_relation", true), (QFilter[])filter.toArray());
    }

    private static DynamicObject getInvalidBill(DynamicObject invoice) {
        QFilter qFilter = new QFilter("orgid", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue(invoice.get("orgid"))).and("invoicecode", "=", (Object)invoice.getString("invoicecode")).and("invoiceno", "=", (Object)invoice.getString("invoiceno")).and("billsourcetype", "=", (Object)"C");
        return BusinessDataServiceHelper.loadSingle((String)"sim_original_bill", (String)"billno", (QFilter[])qFilter.toArray());
    }

    public static String getOriBillNoByBillInvRelation(DynamicObject invoiceDynamicObject) {
        DynamicObject[] billInvRelations = ApiCallBackHelper.getOriBillRelation(invoiceDynamicObject);
        return billInvRelations == null || billInvRelations.length == 0 ? "" : Stream.of(billInvRelations).map(relation -> relation.getString("sbillno")).distinct().collect(Collectors.joining(","));
    }

    public static DynamicObject[] getMergeOriBillRelation(DynamicObject invoiceDynamicObject) {
        QFilter qFilter = new QFilter("tbillno", "=", (Object)invoiceDynamicObject.getString("billno"));
        return BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)String.join((CharSequence)",", "sbillid", "sbillno"), (QFilter[])qFilter.toArray());
    }

    public static DynamicObject[] getOriBillRelation(DynamicObject invoiceDynamicObject) {
        QFilter qFilter = new QFilter("tbillid", "=", (Object)invoiceDynamicObject.getLong("id"));
        DynamicObject[] billInvRelations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)String.join((CharSequence)",", "sbillid", "sbillno"), (QFilter[])qFilter.toArray());
        if (billInvRelations.length == 0 && IssueType.RED_INVOICE.getTypeCode().equals(invoiceDynamicObject.getString("issuetype"))) {
            billInvRelations = ApiCallBackHelper.getRedInvoiceRelation(invoiceDynamicObject);
        }
        return billInvRelations;
    }

    private static DynamicObject[] getRedInvoiceRelation(DynamicObject invoice) {
        QFilter qFilter;
        String originalInvoiceCode = invoice.getString("originalinvoicecode");
        String originalInvoiceNo = invoice.getString("originalinvoiceno");
        if (InvoiceUtils.isSpecialInvoice(invoice.getString("invoicetype"))) {
            String infoSource;
            DynamicObject redInfo;
            String invoiceStatus = invoice.getString("invoicestatus");
            qFilter = "6".equals(invoiceStatus) ? new QFilter("tbillno", "=", (Object)invoice.getString("billno")) : ((redInfo = BusinessDataServiceHelper.loadSingle((String)"sim_red_info", (String)"infosource", (QFilter[])new QFilter("infocode", "=", (Object)invoice.getString("infocode")).and("org", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue(invoice.get("orgid"))).toArray())) == null ? new QFilter("tbillno", "=", (Object)invoice.getString("billno")) : (!"5".equals(infoSource = redInfo.getString("infosource")) && !"6".equals(infoSource) ? ApiCallBackHelper.getOriginalInvoiceRelation(originalInvoiceCode, originalInvoiceNo) : new QFilter("tbillid", "=", redInfo.getPkValue()).and("isdelete", "!=", (Object)"Y")));
        } else if (InvoiceUtils.isAllEInvoice(invoice.getString("invoicetype"))) {
            DynamicObject redConfirm = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)"source", (QFilter[])new QFilter("number", "=", (Object)invoice.getString("infocode")).toArray());
            if (redConfirm == null) {
                return new DynamicObject[0];
            }
            String infoSource = redConfirm.getString("source");
            qFilter = !"5".equals(infoSource) ? ApiCallBackHelper.getOriginalInvoiceRelation(originalInvoiceCode, originalInvoiceNo) : new QFilter("tbillid", "=", redConfirm.getPkValue()).and("isdelete", "!=", (Object)"Y");
        } else {
            qFilter = ApiCallBackHelper.getOriginalInvoiceRelation(originalInvoiceCode, originalInvoiceNo);
        }
        return BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)String.join((CharSequence)",", "sbillid", "sbillno"), (QFilter[])qFilter.toArray());
    }

    private static QFilter getOriginalInvoiceRelation(String invoiceCode, String invoiceNo) {
        if (StringUtils.isNotBlank((CharSequence)invoiceNo)) {
            DynamicObject blueInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"", (QFilter[])new QFilter("invoicecode", "=", (Object)invoiceCode).and("invoiceno", "=", (Object)invoiceNo).toArray());
            if (blueInvoice == null) {
                return new QFilter("id", "=", (Object)0);
            }
            return new QFilter("tbillid", "=", blueInvoice.getPkValue());
        }
        return new QFilter("id", "=", (Object)0);
    }

    private static Map<String, Object> createCallBackReqDataMap(DynamicObject accessConfigObject, String interfaceCode, String data) throws Exception {
        HashMap<String, Object> requestDataMap = new HashMap<String, Object>(4);
        requestDataMap.put("interfaceCode", interfaceCode);
        requestDataMap.put("returnCode", "0");
        requestDataMap.put("returnMsg", "success");
        requestDataMap.put("data", AesUtil.getData(accessConfigObject, 0, data));
        return requestDataMap;
    }

    public static CallbackResponseVo sendCallBackRequest(String callbackUrl, DynamicObject businessSystem, CallbackLogVo callbackLog, String data, BizControlVo bizControlVo) {
        callbackLog.setCallbackContent(data);
        callbackLog.setRetryTimes(callbackLog.getRetryTimes() + 1);
        CallbackResponseVo responseVo = new CallbackResponseVo();
        try {
            Map<String, Object> requestDataMap = ApiCallBackHelper.createCallBackReqDataMap(businessSystem, callbackLog.getBusinessType(), data);
            if (bizControlVo != null) {
                requestDataMap.put("bizControl", bizControlVo);
            }
            DynamicObject easCallBackConfig = BusinessDataServiceHelper.loadSingle((String)"invsm_callback_config", (String)PropertieUtil.getAllPropertiesSplitByComma("invsm_callback_config"), (QFilter[])new QFilter("business_system_code", "=", (Object)callbackLog.getBusinessSystemCode()).toArray());
            data = ApiCallBackHelper.getPostResult(easCallBackConfig, callbackLog.getBusinessSystemCode(), callbackUrl, requestDataMap, data);
            ApiCallBackHelper.setResponse(responseVo, easCallBackConfig, data);
            responseVo.setData(JSON.toJSONString((Object)callbackLog));
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u53d1\u7968\u56de\u8c03\u4e1a\u52a1\u7cfb\u7edf\u8fd4\u56de\u7684\u5f02\u5e38\u62a5\u6587\u662f\uff1a%s", data), (Throwable)e);
            responseVo.setCode(ApiErrCodeEnum.ERROR.getCode());
            responseVo.setMessage(e.getMessage());
        }
        return responseVo;
    }

    public static void setResponse(CallbackResponseVo responseVo, DynamicObject easCallBackConfig, String data) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            responseVo.setCode(ApiErrCodeEnum.ERROR.getCode());
            responseVo.setMessage(ResManager.loadKDString((String)"\u8bf7\u6c42\u4e1a\u52a1\u7cfb\u7edf\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a", (String)"ApiCallBackHelper_9", (String)"imc-bdm-common", (Object[])new Object[0]));
        } else {
            try {
                JSONObject json = JSON.parseObject((String)data);
                if (json.containsKey((Object)"success")) {
                    responseVo.setCode(Boolean.TRUE.equals(json.get((Object)"success")) ? "0" : "9999");
                    responseVo.setMessage(json.getString("message"));
                } else if (easCallBackConfig != null) {
                    EasBusinessHelper.handleEasResponse(json);
                    responseVo.setCode(json.getString("errorCode"));
                    responseVo.setMessage(json.getString("message"));
                } else {
                    responseVo = (CallbackResponseVo)JSON.parseObject((String)data, CallbackResponseVo.class);
                }
                responseVo.setMessage(String.format(ResManager.loadKDString((String)"\u5bf9\u63a5\u65b9\u8fd4\u56de\u62a5\u6587: %s", (String)"ApiCallBackHelper_10", (String)"imc-bdm-common", (Object[])new Object[0]), data));
            }
            catch (Exception e) {
                LOGGER.error(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u56de\u8c03\u4e1a\u52a1\u7cfb\u7edf\u8fd4\u56de\u7684\u5f02\u5e38\u62a5\u6587\u662f\uff1a%s", (String)"ApiCallBackHelper_11", (String)"imc-bdm-common", (Object[])new Object[0]), data), (Throwable)e);
                responseVo.setCode(ApiErrCodeEnum.ERROR.getCode());
                responseVo.setMessage(String.format(ResManager.loadKDString((String)"\u5bf9\u63a5\u65b9\u8fd4\u56de\u62a5\u6587\u4e0d\u4e00\u81f4\uff1a%s", (String)"ApiCallBackHelper_12", (String)"imc-bdm-common", (Object[])new Object[0]), data));
            }
        }
    }

    public static String getPostResult(DynamicObject easCallBackConfig, String businessSystemCode, String callbackUrl, Map<String, Object> requestDataMap, String data) throws IOException {
        if (!callbackUrl.startsWith("https:") && !callbackUrl.startsWith("http:")) {
            String[] configs = callbackUrl.split(",");
            Object result = DispatchServiceHelper.invokeService((String)configs[0], (String)configs[1], (String)configs[2], (String)configs[3], (Object[])new Object[]{requestDataMap});
            if (result instanceof String) {
                return (String)result;
            }
            return SerializationUtils.toJsonString((Object)result);
        }
        if (easCallBackConfig != null) {
            CallbackHelperUtil.checkInvsmCallBackConfig(easCallBackConfig);
            return CallbackHelperUtil.postEas(easCallBackConfig, EasBusinessHelper.getEasRequestData(data, (String)requestDataMap.get("interfaceCode")), easCallBackConfig.getString("business_system_code"));
        }
        if ("XKQJ".equals(businessSystemCode)) {
            return ApiCallBackHelper.postXK(requestDataMap);
        }
        Map<String, String> requestHeader = ApiCallBackHelper.setRequestHeader(callbackUrl);
        int callBackTimeOut = SendCallBackHelper.getCallBackTimeOut();
        LOGGER.info("\u53d1\u7968\u56de\u8c03\u8bf7\u6c42url_" + callbackUrl);
        LOGGER.info("\u53d1\u7968\u56de\u8c03\u8bf7\u6c42\u5b8c\u6574\u62a5\u6587_" + JSONUtils.toString(requestDataMap));
        data = HttpUtil.doPostJson(callbackUrl, requestHeader, JSON.toJSONString(requestDataMap), callBackTimeOut, callBackTimeOut);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("\u53d1\u7968\u56de\u8c03\u8fd4\u56de_" + data);
        }
        return data;
    }

    private static String postXK(Map<String, Object> requestDataMap) {
        try {
            Map<String, String> fpyCallbackConfig = ImcConfigUtil.getValue("fpyiv_conifg");
            String accesstoken = ApiCallBackHelper.getFpyToken(fpyCallbackConfig);
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("accesstoken", accesstoken);
            header.put("access_token", accesstoken);
            String xAcgwIdentity = fpyCallbackConfig.get("fpyiv_conifg_xAcgwIdentity");
            if (StringUtils.isBlank((CharSequence)xAcgwIdentity)) {
                LOGGER.info("\u672a\u914d\u7f6ex-acgw-identity\uff0c\u53bb\u7b2c\u4e09\u65b9\u5e94\u7528\u53bb\u67e5\u8be2");
                DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)"third_app").getProperties();
                if (properties.containsKey((Object)"identity")) {
                    LOGGER.info("third_app\u5305\u542bidentity\u53c2\u6570");
                    String appId = fpyCallbackConfig.get("fpyiv_conifg_appId");
                    DynamicObject thirdApp = QueryServiceHelper.queryOne((String)"third_app", (String)"identity", (QFilter[])new QFilter("number", "=", (Object)appId).toArray());
                    if (thirdApp != null) {
                        LOGGER.info("\u5df2\u67e5\u8be2\u5230\u7b2c\u4e09\u65b9\u5e94\u7528\uff0c\u53d6\u7b2c\u4e09\u65b9\u5e94\u7528\u4e2d\u7684x-acgw-identity\u503c : " + thirdApp.getString("identity"));
                        xAcgwIdentity = thirdApp.getString("identity");
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)xAcgwIdentity)) {
                header.put("x-acgw-identity", xAcgwIdentity);
            }
            String apiUrl = fpyCallbackConfig.get("fpyiv_conifg_baseUrl") + "/kapi/v2/fpy/fpy_iv/fpyiv/imccallback/doBusiness";
            LOGGER.info("\u8bf7\u6c42XK api request url:\n" + apiUrl);
            int callBackTimeOut = SendCallBackHelper.getCallBackTimeOut();
            String returnDataStr = HttpUtil.doPostJson(apiUrl, header, JSONObject.toJSONString(requestDataMap), callBackTimeOut, callBackTimeOut);
            LOGGER.info("\u8bf7\u6c42XK api response:" + returnDataStr);
            return returnDataStr;
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42XK sendApi data Exception ", (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u56de\u8c03\u661f\u7a7a\u65d7\u8230\u7248\u7cfb\u7edf\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s", (String)"ApiCallBackHelper_8", (String)"imc-bdm-common", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private static String getFpyToken(Map<String, String> fpyCallbackConfig) {
        String token = CacheHelper.get("imc_fpy_callback_token");
        if (StringUtils.isNotBlank((CharSequence)token)) {
            return token;
        }
        String configPrefix = "fpyiv_conifg_";
        String url = fpyCallbackConfig.get(configPrefix + "baseUrl");
        String accountId = fpyCallbackConfig.get(configPrefix + "accountId");
        String appId = fpyCallbackConfig.get(configPrefix + "appId");
        String appSecret = fpyCallbackConfig.get(configPrefix + "appSecret");
        String user = fpyCallbackConfig.get(configPrefix + "user");
        String userType = fpyCallbackConfig.get(configPrefix + "userType");
        String fpyToken = IsmcToken.login(url, "", appId, appSecret, accountId, user, userType);
        CacheHelper.put("imc_fpy_callback_token", fpyToken, 3600);
        return fpyToken;
    }

    public static Map<String, String> setRequestHeader(String callbackUrl) {
        HashMap paramMap = Maps.newHashMap();
        String[] split = callbackUrl.split("\\?");
        if (split.length > 1) {
            String[] params;
            String paramsStr = split[1];
            for (String param : params = paramsStr.split("&")) {
                String[] split1 = param.split("=");
                if (split1.length <= 1 || !"userPassword".equals(split1[0])) continue;
                String userPassword = split1[1];
                paramMap.put("Authorization", "Basic " + Base64.encodeBase64String((byte[])userPassword.getBytes(StandardCharsets.UTF_8)));
            }
        }
        return paramMap;
    }

    public static InvoiceVo invoiceDynamicConvert2InvoiceVo(DynamicObject invoice, String businessType) {
        String specialType;
        InvoiceVo invoiceVo = DynamicObjectUtil.dynamicObject2Bean(InvoiceVo.class, invoice);
        DynamicObjectCollection items = invoice.getDynamicObjectCollection("items");
        if (CollectionUtils.isNotEmpty((Collection)items)) {
            ArrayList<InvoiceDetailVo> invoiceDetailList = new ArrayList<InvoiceDetailVo>(items.size());
            int inx = 1;
            for (DynamicObject item : items) {
                InvoiceDetailVo invoiceDetail = DynamicObjectUtil.dynamicObject2Bean(InvoiceDetailVo.class, item);
                invoiceDetail.setDetailRowNo(inx);
                invoiceDetailList.add(invoiceDetail);
                ++inx;
            }
            invoiceVo.setInvoiceDetail(invoiceDetailList);
        }
        invoiceVo.setOriginalBillNo(ApiCallBackHelper.getNormalOriginalBillNo(invoice));
        invoiceVo.setOriginalInvoiceStatus(ApiCallBackHelper.setOriginalInvoiceStatusByBusinessType(businessType));
        String invoiceType = invoice.getString("invoicetype");
        invoiceVo.setFileType(InvoiceUtils.isAllEInvoice(invoiceType) || EquipmentType.isOFDEquipment(invoice.getString("issuesource")) ? "1" : "0");
        if (!InvoiceUtils.isAllEInvoice(invoiceType) && !EquipmentType.isOFDEquipment(invoice.getString("issuesource")) && StringUtils.isNotBlank((CharSequence)invoiceVo.getInvoiceFileUrl())) {
            invoiceVo.setInvoicePdfFileUrl(invoiceVo.getInvoiceFileUrl());
        }
        if (InvoiceUtils.isAllEInvoice(invoiceType)) {
            ApiCallBackHelper.setRedConfirmInfo(invoice, invoiceVo);
        }
        if ("E09".equals(specialType = invoiceVo.getSpecialType())) {
            DynamicObjectCollection travelerCollection = invoice.getDynamicObjectCollection("travelers");
            if (CollectionUtils.isNotEmpty((Collection)travelerCollection)) {
                ArrayList<BillTravelerItemVo> billTravelerItemList = new ArrayList<BillTravelerItemVo>(travelerCollection.size());
                for (DynamicObject travlerObject : travelerCollection) {
                    BillTravelerItemVo billTravelerItemVo = DynamicObjectUtil.dynamicObject2Bean(BillTravelerItemVo.class, travlerObject);
                    ApiCallBackHelper.formatTravelDateMethod(billTravelerItemVo);
                    billTravelerItemList.add(billTravelerItemVo);
                }
                invoiceVo.setTravelerList(billTravelerItemList);
                invoiceVo.setVehicheVesselShipVoList(null);
                if (OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode().equals(businessType)) {
                    invoiceVo.setSpecialType("E09");
                } else if (OpenApiCallbackInterfaceCodeEnum.ALLE_INVOICE_OPEN.getCode().equals(businessType)) {
                    invoiceVo.setSpecialType("09");
                }
            }
        } else if ("E07".equals(specialType)) {
            DynamicObjectCollection vehicheVesselShipCollection = invoice.getDynamicObjectCollection("vehichevesselships");
            if (CollectionUtils.isNotEmpty((Collection)vehicheVesselShipCollection)) {
                ArrayList<BillVehicheVesselShipVo> vehicheVesselShipVoList = new ArrayList<BillVehicheVesselShipVo>(vehicheVesselShipCollection.size());
                for (DynamicObject vehicheVesselShipObject : vehicheVesselShipCollection) {
                    BillVehicheVesselShipVo billVehicheVesselShipVo = DynamicObjectUtil.dynamicObject2Bean(BillVehicheVesselShipVo.class, vehicheVesselShipObject);
                    billVehicheVesselShipVo.setVehicleLateAmount(billVehicheVesselShipVo.getVehicleLateAmount().setScale(2, RoundingMode.HALF_UP));
                    billVehicheVesselShipVo.setVehicleVesselAmount(billVehicheVesselShipVo.getVehicleVesselAmount().setScale(2, RoundingMode.HALF_UP));
                    billVehicheVesselShipVo.setVehicleTotalAmount(billVehicheVesselShipVo.getVehicleTotalAmount().setScale(2, RoundingMode.HALF_UP));
                    vehicheVesselShipVoList.add(billVehicheVesselShipVo);
                }
                invoiceVo.setVehicheVesselShipVoList(vehicheVesselShipVoList);
                invoiceVo.setTravelerList(null);
                if (OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode().equals(businessType)) {
                    invoiceVo.setSpecialType("E07");
                } else if (OpenApiCallbackInterfaceCodeEnum.ALLE_INVOICE_OPEN.getCode().equals(businessType)) {
                    invoiceVo.setSpecialType("07");
                }
            }
        } else {
            invoiceVo.setTravelerList(null);
            invoiceVo.setVehicheVesselShipVoList(null);
        }
        return invoiceVo;
    }

    private static void formatTravelDateMethod(BillTravelerItemVo billTravelerItemVo) {
        String travelDate = billTravelerItemVo.getTravelDate();
        Date travel_date = DateUtils.stringToDate(travelDate);
        travelDate = DateUtils.format(travel_date);
        billTravelerItemVo.setTravelDate(travelDate);
    }

    private static void setRedConfirmInfo(DynamicObject invoice, InvoiceVo invoiceVo) {
        String redBillNo = invoice.getString("infocode");
        Object orgIdObj = invoice.get("orgid");
        try {
            if (StringUtils.isNotEmpty((CharSequence)redBillNo)) {
                invoiceVo.setRedInfoBillNo(redBillNo);
                QFilter baseDataFilter = ImcBaseDataHelper.getRedConfirmFilter(orgIdObj);
                baseDataFilter.and("number", "=", (Object)redBillNo);
                DynamicObject redConfirmBill = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "govuuid", "uploaddate", "confirmstatus"), (QFilter[])baseDataFilter.toArray());
                if (redConfirmBill != null) {
                    invoiceVo.setGovRedConfirmBillUuid(redConfirmBill.getString("govuuid"));
                    invoiceVo.setRedConfirmBillStatus(redConfirmBill.getString("confirmstatus"));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8bbe\u7f6e\u7ea2\u5b57\u786e\u8ba4\u5355\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38", (Object)e.getMessage(), (Object)e);
        }
    }

    public static String setOriginalInvoiceStatusByBusinessType(String businessType) {
        String originalInvoiceStatus = "";
        if (OpenApiCallbackInterfaceCodeEnum.INVOICE_RED.getCode().equals(businessType)) {
            originalInvoiceStatus = "3";
        } else if (OpenApiCallbackInterfaceCodeEnum.INVOICE_CANCEL.getCode().equals(businessType)) {
            originalInvoiceStatus = "6";
        }
        return originalInvoiceStatus;
    }

    public static String getNormalOriginalBillNo(DynamicObject invoice) {
        DynamicObject[] relations = ApiCallBackHelper.getOriBillRelation(invoice);
        List billIds = Arrays.stream(relations).map(relation -> relation.getLong("sbillid")).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(billIds)) {
            return "";
        }
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"billsourcetype", (QFilter[])new QFilter("id", "in", billIds).toArray());
        if (Arrays.stream(bills).noneMatch(bill -> OriginalBillConstant.isSpecialSourcType(bill.getString("billsourcetype")))) {
            return "";
        }
        return ApiCallBackHelper.getNormalBillNo(bills);
    }

    private static String getNormalBillNo(DynamicObject[] bills) {
        QFilter qFilter = new QFilter("tbillid", "in", (Object)Arrays.stream(bills).map(DataEntityBase::getPkValue).toArray()).and("relationtype", "=", (Object)"0");
        DynamicObject[] billRelations = BusinessDataServiceHelper.load((String)"sim_bill_relation", (String)"sbillid", (QFilter[])qFilter.toArray());
        List billIds = Arrays.stream(billRelations).map(relation -> relation.getLong("sbillid")).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(billIds)) {
            return "";
        }
        DynamicObject[] oriBills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)String.join((CharSequence)",", "billsourcetype", "billno"), (QFilter[])new QFilter("id", "in", billIds).toArray());
        if (Arrays.stream(oriBills).anyMatch(oriBill -> "A".equals(oriBill.getString("billsourcetype")))) {
            return Arrays.stream(oriBills).map(oriBill -> oriBill.getString("billno")).collect(Collectors.joining(","));
        }
        return ApiCallBackHelper.getNormalBillNo(oriBills);
    }
}

