/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper.callback;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.ParamConfigConstant;
import kd.imc.bdm.common.dto.CallBackProcessVo;
import kd.imc.bdm.common.dto.CallbackLogVo;
import kd.imc.bdm.common.enums.CallBackLogTypeEnum;
import kd.imc.bdm.common.helper.ConfigCacheHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.IssuePolicyHelper;
import kd.imc.bdm.common.helper.RelationHelper;
import kd.imc.bdm.common.helper.SystemParameterHelper;
import kd.imc.bdm.common.helper.callback.ApiCallBackHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.openapi.BizControlVo;
import kd.imc.bdm.common.openapi.CallbackResponseVo;
import kd.imc.bdm.common.openapi.InvoiceVo;
import kd.imc.bdm.common.openapi.helper.AllEApiHelper;
import kd.imc.bdm.common.util.AesUtil;
import kd.imc.bdm.common.util.Base64Util;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.MqPublishUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import org.apache.commons.lang3.StringUtils;

public class SendCallBackHelper {
    private static final Log LOGGER = LogFactory.getLog(SendCallBackHelper.class);

    private static final String getSTR_ALL_SUCCESS() {
        return ResManager.loadKDString((String)"\u5355\u636e\u5168\u90e8\u5f00\u7968\u6210\u529f", (String)"SendCallBackHelper_9", (String)"imc-bdm-common", (Object[])new Object[0]);
    }

    public static int getCallBackTimeOut() {
        int timeout = ConfigCacheHelper.getIntegerValueByParamConfig("sim_callback_request_timeout");
        return timeout == 0 ? 60000 : timeout;
    }

    public static void normalExecuteErrorCallBack(String errorMsg, DynamicObject invoiceDynamicObject, String businessType, String systemSource, String callbackUrl) {
        String data;
        Serializable invoiceVo;
        boolean alleCallback;
        String billNo;
        DynamicObject callbackDynamic = BusinessDataServiceHelper.newDynamicObject((String)"invsm_callback_log");
        callbackDynamic.set("create_time", (Object)new Date());
        if ("4".equals(invoiceDynamicObject.getString("buyertype")) || "11".equals(invoiceDynamicObject.getString("buyertype"))) {
            billNo = ApiCallBackHelper.getOriBillNoByBillInvRelation(invoiceDynamicObject);
            callbackDynamic.set("callbacktype", (Object)CallBackLogTypeEnum.billError.getValue());
            if (billNo.contains(",")) {
                billNo = invoiceDynamicObject.getString("billno");
            }
        } else {
            billNo = invoiceDynamicObject.getString("billno");
            callbackDynamic.set("callbacktype", (Object)CallBackLogTypeEnum.invoiceError.getValue());
        }
        callbackDynamic.set("business_fid", invoiceDynamicObject.get("id"));
        callbackDynamic.set("callback_message", (Object)errorMsg);
        callbackDynamic.set("business_type", (Object)businessType);
        callbackDynamic.set("business_system_code", (Object)systemSource);
        callbackDynamic.set("callbackbillno", (Object)billNo);
        callbackDynamic.set("retry_times", (Object)0);
        callbackDynamic.set("callback_url", (Object)callbackUrl);
        callbackDynamic.set("invoicetype", (Object)invoiceDynamicObject.getString("invoicetype"));
        callbackDynamic.set("issuetype", (Object)invoiceDynamicObject.getString("issuetype"));
        callbackDynamic.set("org", invoiceDynamicObject.get("orgid"));
        boolean bl = alleCallback = !SystemParameterHelper.getInvsmParameterBoolean(DynamicObjectUtil.getDynamicObjectLongValue(invoiceDynamicObject.get("orgid")), "alle_callback_type");
        if (alleCallback && ("ALLE.INVOICE.OPEN".equals(invoiceDynamicObject.getString("datahash")) || "ALLE.INVOICE.RED".equals(invoiceDynamicObject.getString("datahash")))) {
            invoiceVo = new AllEApiHelper().transferAllEInvoiceVO(invoiceDynamicObject);
            data = JSON.toJSONString((Object)invoiceVo);
        } else {
            invoiceVo = ApiCallBackHelper.invoiceDynamicConvert2InvoiceVo(invoiceDynamicObject, businessType);
            invoiceVo.setBillNo(billNo);
            data = JSON.toJSONString((Object)invoiceVo);
        }
        DynamicObject save = (DynamicObject)ImcSaveServiceHelper.save(callbackDynamic);
        BizControlVo bizControlVo = IssuePolicyHelper.getBizControlVo(invoiceDynamicObject);
        SendCallBackHelper.sendCallBackHttpRequest(errorMsg, save, data, bizControlVo);
    }

    public static void sendCallBackHttpRequest(String errorMsg, DynamicObject callBackLogDynamicObject, String dataJson, BizControlVo bizControlVo) {
        SendCallBackHelper.sendCallBackHttpRequest(errorMsg, callBackLogDynamicObject, dataJson, true, bizControlVo);
    }

    public static CallbackResponseVo sendCallBackHttpRequest(String errorMsg, DynamicObject callBackLogDynamicObject, String dataJson, boolean isSave, BizControlVo bizControlVo) {
        block12: {
            HashMap<String, Object> requestDataMap = new HashMap<String, Object>(4);
            requestDataMap.put("interfaceCode", callBackLogDynamicObject.getString("business_type"));
            callBackLogDynamicObject.set("callback_content", (Object)RequestContext.get().getTraceId());
            try {
                if (StringUtils.isBlank((CharSequence)errorMsg)) {
                    requestDataMap.put("returnCode", "0");
                    requestDataMap.put("returnMsg", "success");
                    callBackLogDynamicObject.set("callback_message", (Object)SendCallBackHelper.getSTR_ALL_SUCCESS());
                } else {
                    if (errorMsg.contains(ErrorType.RPA_CONFIRM_STATUS_ERROR.getName())) {
                        requestDataMap.put("returnCode", ErrorType.RPA_CONFIRM_STATUS_ERROR.getCode());
                    } else {
                        requestDataMap.put("returnCode", "9999");
                    }
                    requestDataMap.put("billNo", callBackLogDynamicObject.getString("callbackbillno"));
                    requestDataMap.put("returnMsg", errorMsg);
                }
                if (bizControlVo != null) {
                    requestDataMap.put("bizControl", bizControlVo);
                }
                callBackLogDynamicObject.set("callback_content_tag", (Object)dataJson);
                LOGGER.info("sendCallBackHttpRequest request dataJson " + dataJson);
                if ("XKQJ".equals(callBackLogDynamicObject.getString("business_system_code"))) {
                    requestDataMap.put("data", Base64Util.encode(dataJson, "UTF-8"));
                } else {
                    requestDataMap.put("data", AesUtil.getData(CallbackHelperUtil.getBusinessSystemByCode(callBackLogDynamicObject.getString("business_system_code")), 0, dataJson));
                }
                String callBackUrl = callBackLogDynamicObject.getString("callback_url");
                callBackLogDynamicObject.set("update_time", (Object)new Date());
                callBackLogDynamicObject.set("callback_status", (Object)"2");
                LOGGER.info("sendCallBackHttpRequest request url " + callBackUrl);
                LOGGER.info("sendCallBackHttpRequest request requestDataMap " + JSON.toJSONString(requestDataMap));
                DynamicObject easCallBackConfig = BusinessDataServiceHelper.loadSingle((String)"invsm_callback_config", (String)PropertieUtil.getAllPropertiesSplitByComma("invsm_callback_config"), (QFilter[])new QFilter("business_system_code", "=", (Object)callBackLogDynamicObject.getString("business_system_code")).toArray());
                String result = ApiCallBackHelper.getPostResult(easCallBackConfig, callBackLogDynamicObject.getString("business_system_code"), callBackUrl, requestDataMap, dataJson);
                LOGGER.info("sendCallBackHttpRequest response " + result);
                if (!isSave) {
                    CallbackResponseVo responseVo = new CallbackResponseVo();
                    ApiCallBackHelper.setResponse(responseVo, null, result);
                    return responseVo;
                }
                JSONObject json = JSON.parseObject((String)result);
                if (Boolean.TRUE.equals(json.getBoolean("success") != false || "0".equals(json.getString("errorCode")))) {
                    callBackLogDynamicObject.set("callback_status", (Object)"0");
                    callBackLogDynamicObject.set("callback_result", (Object)"0");
                } else {
                    String message = String.format(ResManager.loadKDString((String)"\u56de\u8c03\u65b9\u8fd4\u56de\u5931\u8d25:%s", (String)"SendCallBackHelper_10", (String)"imc-bdm-common", (Object[])new Object[0]), result);
                    callBackLogDynamicObject.set("callback_message", (Object)(message.length() > 80 ? message.substring(0, 80) : message));
                }
            }
            catch (Exception e) {
                LOGGER.info("sendCallBackHttpRequest response error" + e.getMessage());
                if (isSave) break block12;
                return CallbackResponseVo.valueOfError(ErrorType.FAIL.getCode(), e.getMessage());
            }
        }
        ImcSaveServiceHelper.update((DynamicObject)callBackLogDynamicObject);
        return null;
    }

    public static void invoiceAllEndCallback(DynamicObject invObj, String businessType, String callbackUrl, String errorMsg) {
        try {
            DynamicObject[] relationObjs = RelationHelper.getRelationByInvoice(invObj);
            if (relationObjs.length != 0) {
                SendCallBackHelper.createBillCallbackLog(invObj, businessType, callbackUrl, errorMsg, relationObjs);
                return;
            }
            if (!IssueType.RED_INVOICE.getTypeCode().equals(invObj.getString("issuetype"))) {
                SendCallBackHelper.createNormalCallbackLog(errorMsg, invObj, businessType, callbackUrl);
            } else if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
                SendCallBackHelper.normalExecuteErrorCallBack(errorMsg, invObj, businessType, invObj.getString("systemsource"), callbackUrl);
            } else {
                CallbackHelperUtil.pushCallBackLogToMQ(new CallBackProcessVo(invObj, invObj.getString("systemsource"), businessType, callbackUrl));
            }
        }
        catch (MsgException e) {
            LOGGER.info(String.format("invoiceAllEndCallback %s", e.getErrorMsg()));
        }
        catch (Exception e) {
            LOGGER.error("invoiceAllEndCallback Exception ", (Throwable)e);
        }
    }

    private static void createNormalCallbackLog(String errorMsg, DynamicObject invObj, String businessType, String callbackUrl) {
        if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
            SendCallBackHelper.normalExecuteErrorCallBack(errorMsg, invObj, businessType, invObj.getString("systemsource"), callbackUrl);
            return;
        }
        CallbackHelperUtil.pushCallBackLogToMQ(new CallBackProcessVo(invObj, invObj.getString("systemsource"), businessType, callbackUrl));
    }

    private static void createBillCallbackLog(DynamicObject invObj, String businessType, String callbackUrl, String errorMsg, DynamicObject[] relationObjs) {
        DynamicObject callbackLogDynamic = SendCallBackHelper.addBillCallBackLog(invObj, businessType, callbackUrl, errorMsg, relationObjs[0]);
        CallbackLogVo callbackLogVo = DynamicObjectUtil.dynamicObject2Bean(CallbackLogVo.class, callbackLogDynamic);
        MqPublishUtils.publish("imc", "imc.sim.api_queue", JSON.toJSONString((Object)callbackLogVo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicObject addBillCallBackLog(DynamicObject invObj, String businessType, String callbackUrl, String errorMsg, DynamicObject relationObj) {
        String billNo = relationObj.getString("sbillno");
        DLock lock = DLock.create((String)(billNo + "createCallbackLog" + CallBackLogTypeEnum.allCallback.getValue()));
        DynamicObject callbackLogDynamic = null;
        try {
            String invoiceNo;
            lock.lock();
            QFilter qFilter = new QFilter("callbackbillno", "=", relationObj.get("sbillno")).and("callback_url", "=", (Object)callbackUrl).and("business_type", "=", (Object)businessType);
            callbackLogDynamic = BusinessDataServiceHelper.loadSingle((String)"invsm_callback_log", (String)PropertieUtil.getAllPropertiesSplitByComma("invsm_callback_log"), (QFilter[])qFilter.toArray());
            if (callbackLogDynamic == null) {
                callbackLogDynamic = BusinessDataServiceHelper.newDynamicObject((String)"invsm_callback_log");
                callbackLogDynamic.set("create_time", (Object)new Date());
                callbackLogDynamic.set("business_type", (Object)businessType);
                callbackLogDynamic.set("business_system_code", (Object)invObj.getString("systemsource"));
                callbackLogDynamic.set("callbackbillno", relationObj.get("sbillno"));
                callbackLogDynamic.set("callback_url", (Object)callbackUrl);
                callbackLogDynamic.set("invoicetype", (Object)invObj.getString("invoicetype"));
                callbackLogDynamic.set("issuetype", (Object)invObj.getString("issuetype"));
                callbackLogDynamic.set("org", invObj.get("orgid"));
                callbackLogDynamic.set("callback_status", (Object)"2");
                callbackLogDynamic.set("callback_result", (Object)"");
            } else {
                callbackLogDynamic.set("callback_status", (Object)"2");
                callbackLogDynamic.set("callback_result", (Object)"");
            }
            callbackLogDynamic.set("retry_times", (Object)0);
            callbackLogDynamic.set("callbacktype", (Object)CallBackLogTypeEnum.allCallback.getValue());
            callbackLogDynamic.set("business_fid", relationObj.get("sbillid"));
            String invoiceCode = invObj.getString("invoicecode");
            if (StringUtils.isNotBlank((CharSequence)invoiceCode)) {
                callbackLogDynamic.set("invoicecode", (Object)invObj.getString("invoicecode"));
            }
            if (StringUtils.isNotBlank((CharSequence)(invoiceNo = invObj.getString("invoiceno")))) {
                callbackLogDynamic.set("invoiceno", (Object)invObj.getString("invoiceno"));
            }
            callbackLogDynamic.set("callback_message", (Object)errorMsg);
            ImcSaveServiceHelper.save(callbackLogDynamic);
        }
        finally {
            lock.unlock();
        }
        return callbackLogDynamic;
    }

    public static void handlerErrorCallBackTask(DynamicObject callBackLogDynamicObject) {
        int retryTimes = callBackLogDynamicObject.getInt("retry_times");
        if (retryTimes < 3) {
            try {
                QFilter qFilter = new QFilter("id", "=", callBackLogDynamicObject.get("business_fid"));
                DynamicObject invoiceDynamicObject = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice", true), (QFilter[])qFilter.toArray());
                if (invoiceDynamicObject != null) {
                    InvoiceVo invoiceVo = ApiCallBackHelper.invoiceDynamicConvert2InvoiceVo(invoiceDynamicObject, callBackLogDynamicObject.getString("business_type"));
                    invoiceVo.setBillNo(callBackLogDynamicObject.getString("callbackbillno"));
                    Map<String, String> botpErrorCallBackConfig = ImcConfigUtil.getValue("botp_bill_need_error_callback");
                    String systemSource = callBackLogDynamicObject.getString("business_system_code");
                    String businessType = callBackLogDynamicObject.getString("business_type");
                    if (ParamConfigConstant.ErrorCallBack.YES.equals(botpErrorCallBackConfig.get(systemSource))) {
                        CallbackHelperUtil.sendCallBackMsgBOTP(invoiceDynamicObject, systemSource, businessType, false);
                    } else {
                        boolean alleCallback = !SystemParameterHelper.getInvsmParameterBoolean(DynamicObjectUtil.getDynamicObjectLongValue(invoiceDynamicObject.get("orgid")), "alle_callback_type");
                        String data = alleCallback && ("ALLE.INVOICE.OPEN".equals(invoiceDynamicObject.getString("datahash")) || "ALLE.INVOICE.RED".equals(invoiceDynamicObject.getString("datahash"))) ? JSON.toJSONString((Object)new AllEApiHelper().transferAllEInvoiceVO(invoiceDynamicObject)) : JSON.toJSONString((Object)invoiceVo);
                        BizControlVo bizControlVo = IssuePolicyHelper.getBizControlVo(invoiceDynamicObject);
                        SendCallBackHelper.sendCallBackHttpRequest(callBackLogDynamicObject.getString("callback_message"), callBackLogDynamicObject, data, bizControlVo);
                    }
                    callBackLogDynamicObject.set("retry_times", (Object)(retryTimes + 1));
                    ImcSaveServiceHelper.update((DynamicObject)callBackLogDynamicObject);
                }
            }
            catch (Exception e) {
                LOGGER.error("handlerErrorCallBackTask", (Throwable)e);
            }
        }
    }
}

