/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper.invoice;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.util.InvoiceUtils;

public class RemarkTemplateHelper {
    public static final String RED_INVOICE_REMARK_TEMPLATE = "\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u4ee3\u7801:%1$s\u53f7\u7801:%2$s ";
    public static final String DEDUCTION_RED_INVOICE_REMARK_TEMPLATE = "\u5dee\u989d\u5f81\u7a0e\uff1a%1$s\u3002\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u4ee3\u7801:%2$s\u53f7\u7801:%3$s ";
    public static final String DEDUCTION_INVOICE_REMARK_TEMPLATE = "\u5dee\u989d\u5f81\u7a0e\uff1a%s\u3002";
    public static final String ALL_DEDUCTION_INVOICE_REMARK_TEMPLATE = "\u6263\u9664\u989d\uff1a%s\u3002";
    public static final String RED_INFO_REMARK_TEMPLATE = "\u5f00\u5177\u7ea2\u5b57\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u4fe1\u606f\u8868\u7f16\u53f7";
    public static final String BLUE = "0";
    public static final String RED = "1";
    public static final String RED_ALL_ELE_REMARK_TEMPLATE = "\u88ab\u7ea2\u51b2\u84dd\u5b57\u6570\u7535\u7968\u53f7\u7801\uff1a%1$s  \u7ea2\u5b57\u53d1\u7968\u4fe1\u606f\u786e\u8ba4\u5355\u7f16\u53f7\uff1a%2$s";

    public static String getRedInvoiceWithDeductionRemarkTemplate(BigDecimal deduction, String blueInvoiceCode, String blueInvoiceNo) {
        return String.format(DEDUCTION_RED_INVOICE_REMARK_TEMPLATE, deduction, blueInvoiceCode, blueInvoiceNo);
    }

    public static String getRedInvoiceRemarkTemplate(String blueInvoiceCode, String blueInvoiceNo) {
        return String.format(RED_INVOICE_REMARK_TEMPLATE, blueInvoiceCode, blueInvoiceNo);
    }

    public static String generateRemark(DynamicObject obj) {
        if ("sim_red_info".equals(obj.getDataEntityType().getName())) {
            return "";
        }
        if (StringUtils.isNotBlank((CharSequence)obj.getString("infocode"))) {
            String isElePaper = obj.getString("iselepaper");
            boolean elePaper = AllEleAuthHelper.isElePaper(isElePaper);
            if (InvoiceUtils.isAllEInvoice(obj.getString("invoicetype")) || elePaper) {
                return "";
            }
            return RemarkTemplateHelper.generateRedInfoRemark(obj);
        }
        return RemarkTemplateHelper.generateRemark(obj.getString("remark"), obj.getString("issuetype"), obj.getInt("taxedtype"), obj.getBigDecimal("totalamount"), obj.getBigDecimal("deduction"), obj.getString("originalinvoicecode"), obj.getString("originalinvoiceno"));
    }

    public static String generateRemark(String invoiceRemark, String issueType, int taxedType, BigDecimal totalAmount, BigDecimal deduction, String originalInvoiceCode, String originalInvoiceNo) {
        StringBuilder sb = RemarkTemplateHelper.getRedRemarkTemplate(issueType, taxedType, totalAmount, deduction, originalInvoiceCode, originalInvoiceNo);
        if (sb.length() != 0) {
            sb.append(System.lineSeparator());
        }
        sb.append(invoiceRemark);
        return sb.toString();
    }

    public static StringBuilder getRedRemarkTemplate(String issueType, int taxedType, BigDecimal totalAmount, BigDecimal deduction, String originalInvoiceCode, String originalInvoiceNo) {
        boolean isDeduction;
        StringBuilder sb = new StringBuilder();
        boolean isRed = IssueType.RED_INVOICE.getTypeCode().equals(issueType) || totalAmount.compareTo(BigDecimal.ZERO) < 0;
        boolean bl = isDeduction = 2 == taxedType || deduction.compareTo(BigDecimal.ZERO) > 0;
        if (isRed) {
            if (StringUtils.isNotBlank((CharSequence)originalInvoiceCode) && StringUtils.isNotBlank((CharSequence)originalInvoiceNo)) {
                if (isDeduction) {
                    sb.append(String.format(DEDUCTION_RED_INVOICE_REMARK_TEMPLATE, deduction, originalInvoiceCode, originalInvoiceNo));
                } else {
                    sb.append(String.format(RED_INVOICE_REMARK_TEMPLATE, originalInvoiceCode, originalInvoiceNo));
                }
            }
        } else if (isDeduction) {
            sb.append(String.format(DEDUCTION_INVOICE_REMARK_TEMPLATE, deduction.setScale(2, 4)));
        }
        return sb;
    }

    public static String generateRedInfoRemark(DynamicObject dynamicRedInfo) {
        String remark = RED_INFO_REMARK_TEMPLATE;
        String originalInvoiceCode = dynamicRedInfo.getString("originalinvoicecode");
        String originalInvoiceNumber = dynamicRedInfo.getString("originalinvoiceno");
        String infoCode = dynamicRedInfo.getString("infocode");
        if (StringUtils.isNotBlank((CharSequence)infoCode)) {
            remark = remark + infoCode + "\u3002";
        }
        if (StringUtils.isNotBlank((CharSequence)originalInvoiceCode)) {
            remark = remark + "\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u4ee3\u7801" + originalInvoiceCode;
        }
        if (StringUtils.isNotBlank((CharSequence)originalInvoiceNumber)) {
            remark = remark + "\u53f7\u7801" + originalInvoiceNumber + " ";
        }
        return remark;
    }

    public static String generateRedAllEleRemark(String redConfirmBillNo, String invoiceNo) {
        return String.format(RED_ALL_ELE_REMARK_TEMPLATE, invoiceNo, redConfirmBillNo);
    }
}

