/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.invoicecallback.impl;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.OpenApiCallbackInterfaceCodeEnum;
import kd.imc.bdm.common.dto.CallbackLogVo;
import kd.imc.bdm.common.helper.IssuePolicyHelper;
import kd.imc.bdm.common.helper.SystemParameterHelper;
import kd.imc.bdm.common.helper.callback.ApiCallBackHelper;
import kd.imc.bdm.common.invoicecallback.AbstractInvoiceCallBackServiceImpl;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.openapi.BizControlVo;
import kd.imc.bdm.common.openapi.CallbackResponseVo;
import kd.imc.bdm.common.openapi.InvoiceVo;
import kd.imc.bdm.common.openapi.alle.AllEInvoiceRequestDTO;
import kd.imc.bdm.common.openapi.helper.AllEApiHelper;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;

public class InvoiceCallBackServiceImpl
extends AbstractInvoiceCallBackServiceImpl {
    @Override
    public boolean support(CallbackLogVo callbackLogVo) {
        String businessSystemCode = callbackLogVo.getBusinessSystemCode();
        return "XKQJ".equals(businessSystemCode) || CallbackHelperUtil.getBusinessSystemByCode(businessSystemCode) != null;
    }

    @Override
    public CallbackResponseVo callBack(CallbackLogVo callbackLog, DynamicObject invoiceDynamic) {
        boolean alleCallback;
        boolean isIssue;
        boolean bl = isIssue = OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode().equals(callbackLog.getBusinessType()) || OpenApiCallbackInterfaceCodeEnum.INVOICE_RED.getCode().equals(callbackLog.getBusinessType()) || OpenApiCallbackInterfaceCodeEnum.ALLE_INVOICE_OPEN.getCode().equals(callbackLog.getBusinessType());
        if (isIssue && InvoiceUtils.isAllEInvoice(invoiceDynamic.getString("invoicetype")) && !InvoiceCallBackServiceImpl.checkFileExists(invoiceDynamic.getDate("issuetime"), invoiceDynamic.getString("invoiceno"))) {
            return null;
        }
        LOGGER.info(String.format("invoiceNoEnterCallBack:invoiceNo[%s],orderNo:[%s]", invoiceDynamic.getString("invoiceno"), invoiceDynamic.getString("orderno")));
        DynamicObject businessSystem = this.checkCallBackForBusinessSystem(callbackLog);
        DynamicObject invoiceDynamicObject = DynamicObjectUtil.copyDynamicObject(invoiceDynamic);
        invoiceDynamicObject.set("orgid", invoiceDynamic.get("orgid"));
        boolean bl2 = alleCallback = !SystemParameterHelper.getInvsmParameterBoolean(DynamicObjectUtil.getDynamicObjectLongValue(invoiceDynamic.get("orgid")), "alle_callback_type");
        if (alleCallback && this.isAlleInterface(invoiceDynamicObject) && InvoiceUtils.isAllEInvoice(invoiceDynamic.getString("invoicetype"))) {
            return this.callbackAlle(invoiceDynamic, invoiceDynamicObject, callbackLog, businessSystem);
        }
        InvoiceVo invoiceVo = ApiCallBackHelper.invoiceDynamicConvert2InvoiceVo(invoiceDynamicObject, callbackLog.getBusinessType());
        BizControlVo bizControlVo = IssuePolicyHelper.getBizControlVo(invoiceDynamic);
        return ApiCallBackHelper.sendCallBack(callbackLog.getCallbackUrl(), businessSystem, callbackLog, invoiceVo, invoiceDynamicObject, bizControlVo);
    }

    private boolean isAlleInterface(DynamicObject invoice) {
        return "ALLE.INVOICE.OPEN".equals(invoice.getString("datahash")) || "ALLE.INVOICE.RED".equals(invoice.getString("datahash"));
    }

    private CallbackResponseVo callbackAlle(DynamicObject invoiceDynamic, DynamicObject invoiceDynamicObject, CallbackLogVo callbackLog, DynamicObject businessSystem) {
        AllEInvoiceRequestDTO invoiceVo = new AllEApiHelper().transferAllEInvoiceVO(invoiceDynamicObject);
        BizControlVo bizControlVo = IssuePolicyHelper.getBizControlVo(invoiceDynamic);
        return ApiCallBackHelper.sendCallBackRequest(callbackLog.getCallbackUrl(), businessSystem, callbackLog, JSON.toJSONString((Object)invoiceVo), bizControlVo);
    }

    public DynamicObject checkCallBackForBusinessSystem(CallbackLogVo callbackLog) {
        DynamicObject businessSystem = null;
        if ("XKQJ".equals(callbackLog.getBusinessSystemCode())) {
            businessSystem = BusinessDataServiceHelper.newDynamicObject((String)"invsm_app_access_config");
            businessSystem.set("encryption_type", (Object)"1");
            businessSystem.set("code", (Object)"XKQJ");
            return businessSystem;
        }
        String callbackUrl = callbackLog.getCallbackUrl();
        if (!CallbackHelperUtil.isFromArIssueBill(callbackLog.getBusinessSystemCode())) {
            businessSystem = CallbackHelperUtil.getBusinessSystemByCode(callbackLog.getBusinessSystemCode());
            if (null == businessSystem) {
                throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), ResManager.loadKDString((String)"\u65e0\u6b64\u4e1a\u52a1\u7cfb\u7edf\uff0c\u7ed3\u675f\u4efb\u52a1", (String)"InvoiceCallBackServiceImpl_0", (String)"imc-bdm-common", (Object[])new Object[0]));
            }
            CallbackResponseVo responseVo = CallbackHelperUtil.checkBusinessSystemValid(businessSystem);
            if (!ApiErrCodeEnum.OK.getCode().equals(responseVo.getCode())) {
                throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), responseVo.getMessage());
            }
            if (StringUtils.isBlank((CharSequence)callbackUrl)) {
                callbackUrl = businessSystem.getString("callback_url");
            }
            if (StringUtils.isBlank((CharSequence)callbackUrl)) {
                callbackUrl = businessSystem.getString("callback_url_two");
            }
            if (StringUtils.isBlank((CharSequence)callbackUrl)) {
                callbackUrl = businessSystem.getString("callback_url_thr");
            }
            if (StringUtils.isEmpty((CharSequence)callbackUrl)) {
                throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u4e1a\u52a1\u7cfb\u7edf\u56de\u8c03\u5730\u5740", (String)"InvoiceCallBackServiceImpl_1", (String)"imc-bdm-common", (Object[])new Object[0]));
            }
        }
        callbackLog.setCallbackUrl(callbackUrl);
        return businessSystem;
    }

    public static boolean checkFileExists(Date issueTime, String invoiceNo) {
        String fileExistsSetting = ImcConfigUtil.getValue("invoicefile_config", "file");
        if (StringUtils.isBlank((CharSequence)fileExistsSetting)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u6587\u4ef6\u751f\u6210\u540e\u56de\u8c03\uff0c\u76f4\u63a5\u56de\u8c03", (String)"InvoiceCallBackServiceImpl_2", (String)"imc-bdm-common", (Object[])new Object[0]));
            }
            return true;
        }
        String[] fileTypes = fileExistsSetting.split(",");
        QFilter qFilter = new QFilter("issuetime", ">=", (Object)DateUtils.addDay(issueTime, -1)).and("issuetime", "<=", (Object)DateUtils.addDay(issueTime, 1)).and("invoiceno", "=", (Object)invoiceNo).and("filetype", "in", (Object)fileTypes);
        DynamicObject[] files = BusinessDataServiceHelper.load((String)"sim_vatinvoice_file", (String)String.join((CharSequence)",", "callbacktype", "localfilestatus", "remotefilestatus", "issuechannel"), (QFilter[])qFilter.toArray());
        if (files == null || files.length == 0) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("\u6839\u636e\u53d1\u7968\u53f7\u7801\u67e5\u8be2\u51fa\u6587\u4ef6\u4e3a\u7a7a\uff0c\u53d1\u7968\u53f7\u7801\u4e3a[%s]\uff0c\u76f4\u63a5\u56de\u8c03", invoiceNo));
            }
            return true;
        }
        if ("virtual".equals(files[0].getString("issuechannel"))) {
            try {
                String sleepTime = ImcConfigUtil.getValue("virtual_callback", "sleep_time");
                if (StringUtils.isNotBlank((CharSequence)sleepTime)) {
                    Thread.sleep(Integer.parseInt(sleepTime) * 1000);
                }
            }
            catch (Exception sleepTime) {
                // empty catch block
            }
        }
        boolean isRemote = "remote".equals(files[0].getString("callbacktype"));
        boolean isFileAllCreate = Stream.of(files).allMatch(file -> "1".equals(file.getString(isRemote ? "remotefilestatus" : "localfilestatus")));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("\u6839\u636e\u53d1\u7968\u53f7\u7801\u67e5\u8be2\u6587\u4ef6\u662f\u5426\u751f\u6210\uff0c\u53d1\u7968\u53f7\u7801\u4e3a[%s]\uff0c\u751f\u6210\u72b6\u6001\u4e3a[%s]", invoiceNo, String.valueOf(isFileAllCreate)));
        }
        return isFileAllCreate;
    }
}

