/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.invoicecallback.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.imc.bdm.common.constant.FiBotpReplayEnum;
import kd.imc.bdm.common.dto.CallbackLogVo;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.invoicecallback.AbstractInvoiceCallBackServiceImpl;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.openapi.CallbackResponseVo;
import kd.imc.bdm.common.util.InvoiceUtils;

public class ProjectCloudCallBackServiceImpl
extends AbstractInvoiceCallBackServiceImpl {
    private static final Log LOGGER = LogFactory.getLog(ProjectCloudCallBackServiceImpl.class);

    @Override
    public boolean support(CallbackLogVo callbackLogVo) {
        String businessSystemCode = callbackLogVo.getBusinessSystemCode();
        return BotpHelper.isFromXMY(businessSystemCode);
    }

    @Override
    public CallbackResponseVo callBack(CallbackLogVo callbackLogVo, DynamicObject invoice) {
        try {
            JSONObject param = new JSONObject();
            Object invoiceCode = invoice.get("invoicecode");
            Object invoiceNo = invoice.get("invoiceno");
            LOGGER.info("ProjectCloudCallBackServiceImpl:" + invoiceCode + invoiceNo);
            String sellerTaxNo = invoice.getString("salertaxno");
            DynamicObject[] invoices = InvoiceUtils.getInvoice(sellerTaxNo, invoice.get("invoicecode"), invoice.get("invoiceno"));
            if (null == invoices || invoices.length <= 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u672a\u627e\u5230", (String)"ProjectCloudCallBackServiceImpl_0", (String)"imc-bdm-common", (Object[])new Object[0]));
            }
            invoice = invoices[0];
            String systemSource = invoice.getString("systemsource");
            this.setBillInfo(invoice, param);
            String invoiceStr = SerializationUtils.toJsonString((Object)invoice);
            param.put("invoiceData", (Object)JSONObject.parseObject((String)invoiceStr));
            LOGGER.info("ProjectCloudCallBackResult:" + param.toJSONString());
            JSONObject responseJson = systemSource.contains("PMGT_BILL") ? (JSONObject)DispatchServiceHelper.invokeBizService((String)"pmgt", (String)"pmct", (String)"ContractService", (String)"updateContractInvoiceInfo", (Object[])new Object[]{param}) : (JSONObject)DispatchServiceHelper.invokeBizService((String)"repc", (String)"renpcon", (String)"IRenpInvoiceService", (String)"updateContractInvoiceInfo", (Object[])new Object[]{param});
            if (ErrorType.SUCCESS.getCode().equals(responseJson.get((Object)"errorcode"))) {
                return CallbackResponseVo.valueOfSuccess(ErrorType.SUCCESS.getName(), FiBotpReplayEnum.Success.getStatus());
            }
            return CallbackResponseVo.valueOfError(String.valueOf(FiBotpReplayEnum.fail.getCode()), responseJson.getString("errormsg"));
        }
        catch (Exception e) {
            LOGGER.error("callBackProjectCloudOrEstateCloudError:" + e.getMessage(), (Throwable)e);
            return CallbackResponseVo.valueOfError(String.valueOf(FiBotpReplayEnum.fail.getCode()), e.getMessage());
        }
        catch (Throwable t) {
            LOGGER.error("\u56de\u5199\u5e94\u6536\u4e1a\u52a1\u5904\u7406\u5931\u8d25:" + t.getMessage(), t);
            throw t;
        }
    }

    private void setBillInfo(DynamicObject invoice, JSONObject param) {
        DynamicObject[] oriBills;
        JSONArray jsonArray = new JSONArray();
        param.put("BillInfos", (Object)jsonArray);
        for (DynamicObject oriBill : oriBills = InvoiceUtils.queryInvoiceRelateOriBill(invoice, true)) {
            JSONObject bill = new JSONObject();
            bill.put("billno", (Object)oriBill.getString("billno"));
            bill.put("systemsource", (Object)oriBill.getString("systemsource"));
            bill.put("contractno", (Object)oriBill.getString("contractno"));
            jsonArray.add((Object)bill);
        }
    }
}

