/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.model.InvoiceURLDataSource;
import org.apache.commons.io.FilenameUtils;

public class InvoiceFileDataSource
implements DataSource {
    private static final Log LOGGER = LogFactory.getLog(InvoiceURLDataSource.class);
    private String path;
    private String fileName;

    public InvoiceFileDataSource(String path, String fileName) {
        this.path = path;
        this.fileName = fileName;
        LOGGER.info("\u53d1\u7968\u90ae\u4ef6url:{},fileName:{}", (Object)path, (Object)fileName);
    }

    public InputStream getInputStream() throws IOException {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        return fileService.getInputStream(this.path);
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    public String getContentType() {
        String fileType = FilenameUtils.getExtension((String)this.fileName);
        if ("pdf".equalsIgnoreCase(fileType)) {
            return "application/pdf";
        }
        if ("xml".equalsIgnoreCase(fileType)) {
            return "application/xml";
        }
        if ("jpg".equalsIgnoreCase(fileType)) {
            return "image/jpeg";
        }
        return "application/octet-stream";
    }

    public String getName() {
        return this.fileName;
    }
}

