/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import javax.activation.DataSource;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.util.HttpUtil;

public class InvoiceURLDataSource
implements DataSource {
    private static final Log LOGGER = LogFactory.getLog(InvoiceURLDataSource.class);
    private Proxy proxy = null;
    private URL url = null;
    private URLConnection uRLConnection = null;

    public InvoiceURLDataSource(URL url) {
        String[] values;
        this.url = url;
        String proxyConfig = HttpUtil.getProxy(url.getHost(), url.getPort());
        if (StringUtils.isNotEmpty((CharSequence)proxyConfig) && (values = proxyConfig.trim().split(":")).length >= 2) {
            this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(values[0], Integer.parseInt(values[1])));
        }
        LOGGER.info("\u53d1\u7968\u90ae\u4ef6url:{},proxy:{}", (Object)url, (Object)proxyConfig);
    }

    public OutputStream getOutputStream() throws IOException {
        URLConnection conn = this.getURLConnection();
        if (conn != null) {
            conn.setDoOutput(true);
            return conn.getOutputStream();
        }
        return null;
    }

    public InputStream getInputStream() throws IOException {
        return this.url.openStream();
    }

    public String getContentType() {
        String type = null;
        URLConnection conn = this.getURLConnection();
        if (conn != null) {
            type = conn.getContentType();
        }
        if (type == null) {
            type = "application/octet-stream";
        }
        return type;
    }

    public String getName() {
        return this.url.getFile();
    }

    private URLConnection getURLConnection() {
        if (this.uRLConnection != null) {
            return this.uRLConnection;
        }
        try {
            this.uRLConnection = this.proxy != null ? this.url.openConnection(this.proxy) : this.url.openConnection();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.uRLConnection;
    }
}

