/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.moduleservice;

import java.io.Serializable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.imc.bdm.common.message.constant.ErrorType;

public class ResultResponse
implements Serializable {
    private String resultCode;
    private String resultMsg;
    private Object resultData;

    public String getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public String getResultMsg() {
        return this.resultMsg;
    }

    public void setResultMsg(String resultMsg) {
        this.resultMsg = resultMsg;
    }

    public Object getResultData() {
        return this.resultData;
    }

    public void setResultData(Object resultData) {
        this.resultData = resultData;
    }

    public ResultResponse() {
    }

    public ResultResponse(ErrorType errorType) {
        this.resultCode = errorType.getCode();
        this.resultMsg = errorType.getName();
    }

    public ResultResponse(ErrorType errorType, Object rData) {
        this.resultCode = errorType.getCode();
        this.resultMsg = errorType.getName();
        this.resultData = rData;
    }

    public static ResultResponse valueOfSuccess() {
        return new ResultResponse(ErrorType.SUCCESS);
    }

    public static ResultResponse valueOfSuccess(Object data) {
        return new ResultResponse(ErrorType.SUCCESS, data);
    }

    public static ResultResponse valueOfError(String resultCode, String resultMsg) {
        ResultResponse response = new ResultResponse();
        response.setResultMsg(resultMsg);
        response.setResultCode(resultCode);
        return response;
    }

    public static ResultResponse valueOfError(String resultMsg) {
        return ResultResponse.valueOfError(ErrorType.FAIL.getCode(), resultMsg);
    }

    public static ApiResult valueOfApiResultSuccess(Object data) {
        ApiResult result = new ApiResult();
        result.setErrorCode(ErrorType.SUCCESS.getCode());
        result.setMessage(ResManager.loadKDString((String)"\u6210\u529f", (String)"ResultResponse_0", (String)"imc-bdm-common", (Object[])new Object[0]));
        result.setData(data);
        result.setSuccess(true);
        return result;
    }
}

