/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.plugin;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.helper.ExcelHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.FileField;
import kd.imc.bdm.common.util.FileUploadUtils;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.RegexUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public abstract class AbstractImportPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final Log LOGGER = LogFactory.getLog(AbstractImportPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btn_download_template", "btn_reset_file", "btn_upload", "btn_cancel"});
        Image label = (Image)this.getControl("btn_file_upload");
        label.addUploadListener((UploadListener)this);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "btn_download_template": {
                this.downloadTemplate();
                break;
            }
            case "btn_reset_file": {
                this.resetFile();
                break;
            }
            case "btn_upload": {
                this.excelUpload();
                break;
            }
            case "btn_cancel": {
                this.resetFile();
                break;
            }
        }
    }

    protected void excelUpload() {
        String filepath = (String)this.getModel().getValue("filepath");
        if (StringUtils.isBlank((CharSequence)filepath)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c", (String)"AbstractImportPlugin_0", (String)"imc-bdm-common", (Object[])new Object[0]));
            return;
        }
        FileService service = FileServiceFactory.getAttachmentFileService();
        try (InputStream inputStream = service.getInputStream(filepath);
             Workbook workbook = WorkbookFactory.create((InputStream)inputStream);){
            this.uploadFile(filepath, inputStream, workbook);
        }
        catch (Exception e) {
            LOGGER.error("excelUploadError:" + e.getMessage(), (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    protected abstract void uploadFile(String var1, InputStream var2, Workbook var3) throws Exception;

    protected void resetFile() {
        String filePath = (String)this.getView().getModel().getValue("filepath");
        FileUploadUtils.delete(filePath);
        this.getView().getModel().setValue("filename", (Object)"");
        this.getView().getModel().setValue("filepath", (Object)"");
        this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"uploadpanel"});
    }

    protected abstract void downloadTemplate();

    public void upload(UploadEvent evt) {
        ExcelHelper.setUploadView(evt, this.getView(), this.getModel());
    }

    protected void fillInMapValue(Map<String, Object> map, String key, Object defaultValue) {
        if (this.checkMapValueNull(map, key)) {
            map.put(key, defaultValue);
        }
    }

    protected void checkNull(Map<String, String> errMap, Map<String, Object> redInfo, FileField field) {
        if (field != null && this.checkMapValueNull(redInfo, field.getFieldCode())) {
            ExcelHelper.setErrorMessage((Row)redInfo.get("row"), field, String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u80fd\u4e3a\u7a7a", (String)"AbstractImportPlugin_1", (String)"imc-bdm-common", (Object[])new Object[0]), field.getFieldName()), errMap);
        }
    }

    protected boolean checkMapValueNull(Map<String, Object> map, String key) {
        return map == null || map.get(key) == null || StringUtils.isBlank((CharSequence)map.get(key).toString());
    }

    protected void checkAmountRule(String amountStr, String msg) {
        try {
            Double.parseDouble(amountStr);
        }
        catch (Exception e) {
            throw new MsgException(msg);
        }
    }

    protected void checkAmountLength(BigDecimal amount, String msg, int num) {
        if (amount == null) {
            throw new MsgException(msg);
        }
        String inputValueStr = amount.stripTrailingZeros().toPlainString();
        if ((inputValueStr = inputValueStr.replace(".", "")).length() > num) {
            throw new MsgException(msg);
        }
    }

    protected boolean checkMapValueLength(Map<String, Object> map, String key, int length) {
        if (map == null) {
            return false;
        }
        String value = (String)map.get(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        return GBKUtils.getGBKLength(value) > length;
    }

    protected boolean checkMapValueStrLength(Map<String, Object> map, String key, int length) {
        if (map == null) {
            return false;
        }
        String value = (String)map.get(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        return value.length() > length;
    }

    public void checkTaxNo(Map<String, String> errMap, Map<String, Object> redInfo, FileField field) {
        this.checkTaxNo(errMap, redInfo, field, false);
    }

    public void checkTaxNo(Map<String, String> errMap, Map<String, Object> redInfo, FileField field, boolean isBuyer) {
        if (this.checkMapValueNull(redInfo, field.getFieldCode())) {
            ExcelHelper.setErrorMessage((Row)redInfo.get("row"), field, String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u80fd\u4e3a\u7a7a", (String)"AbstractImportPlugin_1", (String)"imc-bdm-common", (Object[])new Object[0]), field.getFieldName()), errMap);
            return;
        }
        Object taxNo = redInfo.get(field.getFieldCode());
        if (!RegexUtil.isNsrsbh(taxNo.toString(), isBuyer)) {
            ExcelHelper.setErrorMessage((Row)redInfo.get("row"), field, String.format(ResManager.loadKDString((String)"%s\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"AbstractImportPlugin_2", (String)"imc-bdm-common", (Object[])new Object[0]), field.getFieldName()), errMap);
        }
    }
}

