/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgRequest;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.message.send.MessageSendService;
import kd.imc.bdm.common.util.UUID;

public class CAService {
    private static final String MSGTYPE_CA_CREATE = "CaCreate";
    private static final String MSGTYPE_CA_UPDATE = "CaUpdate";
    private static final Log LOGGER = LogFactory.getLog(CAService.class);

    public static MsgResponse caApply(String enterpriseName, String taxNo, String publicPersonName) {
        try {
            QFilter filter;
            DynamicObject[] array;
            if (!CAService.isAuth(taxNo)) {
                MsgResponse response = new MsgResponse();
                response.setErrorCode(ErrorType.FAIL.getCode());
                response.setErrorMsg(ResManager.loadKDString((String)"\u5b58\u5728\u6388\u6743\u7684\u8bbe\u5907\u624d\u53ef\u4ee5\u7533\u8bf7CA", (String)"CAService_8", (String)"imc-bdm-common", (Object[])new Object[0]));
            }
            MsgRequest request = CAService.getMsgRequest(enterpriseName, taxNo, publicPersonName);
            MsgResponse response = MessageSendService.send(request);
            if (ErrorType.SUCCESS.getCode().equals(response.getErrorCode()) && null != (array = BusinessDataServiceHelper.load((String)"bdm_enterprise_baseinfo", (String)"castatus,castarttime,caendtime", (QFilter[])(filter = new QFilter("number", "=", (Object)taxNo)).toArray())) && array.length > 0) {
                array[0].set("castatus", (Object)"1");
                Date now = new Date();
                array[0].set("castarttime", (Object)now);
                Calendar instance = Calendar.getInstance();
                instance.add(1, 2);
                array[0].set("caendtime", (Object)instance.getTime());
                SaveServiceHelper.update((DynamicObject)array[0]);
            }
            return response;
        }
        catch (Exception e) {
            LOGGER.error("\u7533\u8bf7\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u8bf7CA\u5931\u8d25", (String)"CAService_2", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
    }

    public static MsgResponse caUpdate(String taxNo) {
        try {
            QFilter filter;
            DynamicObject[] array;
            MsgRequest request = new MsgRequest();
            request.setMsgType(MSGTYPE_CA_UPDATE);
            request.setMsgId(UUID.next());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("taxNo", taxNo);
            request.setReqData(params);
            MsgResponse response = MessageSendService.send(request);
            if (ErrorType.SUCCESS.getCode().equals(response.getErrorCode()) && null != (array = BusinessDataServiceHelper.load((String)"bdm_enterprise_baseinfo", (String)"castatus,castarttime,caendtime", (QFilter[])(filter = new QFilter("number", "=", (Object)taxNo)).toArray())) && array.length > 0) {
                array[0].set("castatus", (Object)"1");
                Date now = new Date();
                array[0].set("castarttime", (Object)now);
                Calendar instance = Calendar.getInstance();
                instance.add(1, 2);
                array[0].set("caendtime", (Object)instance.getTime());
                SaveServiceHelper.update((DynamicObject)array[0]);
            }
            return response;
        }
        catch (Exception e) {
            LOGGER.error(ResManager.loadKDString((String)"\u66f4\u65b0CA\u5931\u8d25\uff1a", (String)"CAService_3", (String)"imc-bdm-common", (Object[])new Object[0]) + e.getMessage(), (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u66f4\u65b0CA\u5931\u8d25", (String)"CAService_4", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
    }

    private static MsgRequest getMsgRequest(String enterpriseName, String taxNo, String publicPersonName) {
        MsgRequest request = new MsgRequest();
        request.setMsgType(MSGTYPE_CA_CREATE);
        request.setMsgId(UUID.next());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("eName", enterpriseName);
        params.put("taxNo", taxNo);
        params.put("legalPersonName", publicPersonName);
        request.setReqData(params);
        return request;
    }

    public static boolean isAuth(String taxNo) {
        DynamicObject[] arrays = BusinessDataServiceHelper.load((String)"bdm_tax_equipment", (String)"equipmenttype,authstatus", (QFilter[])new QFilter("epinfo.number", "=", (Object)taxNo).toArray());
        if (null == arrays || arrays.length == 0) {
            return false;
        }
        boolean isAuth = false;
        for (DynamicObject object : arrays) {
            String authstatus = object.getString("authstatus");
            if (!"1".equals(authstatus)) continue;
            isAuth = true;
        }
        return isAuth;
    }

    public static void checkEnterpriseCaEnable(String taxNo) {
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"bdm_enterprise_baseinfo", (String)"castatus,caendtime", (QFilter[])new QFilter("number", "=", (Object)taxNo).toArray());
        if (null == array || array.length == 0) {
            throw new MsgException(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u7a0e\u53f7:%s\uff0c\u5bf9\u5e94\u7684\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f", (String)"CAService_5", (String)"imc-bdm-common", (Object[])new Object[0]), taxNo));
        }
        if (!"1".equals(array[0].getString("castatus"))) {
            throw new MsgException(ResManager.loadKDString((String)"\u5f00\u7968\u5931\u8d25\uff0c\u8be5\u4f01\u4e1a\u8fd8\u672a\u7533\u8bf7CA\u8bc1\u4e66\uff0c\u65e0\u6cd5\u5f00\u5177\u7535\u5b50\u53d1\u7968\u3002\u8bf7\u524d\u5f80 \u53d1\u7968\u4e91-\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406 \u7533\u8bf7\u8be5\u4f01\u4e1a\u7684CA\u8bc1\u4e66\u3002", (String)"CAService_6", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        if (array[0].getDate("caendtime") != null && array[0].getDate("caendtime").before(new Date())) {
            throw new MsgException(ResManager.loadKDString((String)"\u5f00\u7968\u5931\u8d25\uff0c\u8be5\u4f01\u4e1a\u7684CA\u8bc1\u4e66\u5df2\u8fc7\u6709\u6548\u671f\uff0c\u8bf7\u5148\u7eed\u671f\u8be5\u4f01\u4e1a\u7684CA\u8bc1\u4e66", (String)"CAService_7", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
    }

    public static void batchApplyCA(List<DynamicObject> epInfoArr) {
        DynamicObject[] epInfoDatas;
        ArrayList successList = Lists.newArrayListWithCapacity((int)epInfoArr.size());
        Object[] pks = epInfoArr.stream().map(DataEntityBase::getPkValue).toArray();
        for (DynamicObject epInfo : epInfoDatas = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdm_enterprise_baseinfo"))) {
            if ("1".equals(epInfo.getString("castatus")) || !CAService.caApply(epInfo)) continue;
            Date now = new Date();
            epInfo.set("castarttime", (Object)now);
            Calendar instance = Calendar.getInstance();
            instance.add(1, 2);
            epInfo.set("caendtime", (Object)instance.getTime());
            epInfo.set("castatus", (Object)"1");
            successList.add(epInfo);
        }
        if (!CollectionUtils.isEmpty((Collection)successList)) {
            SaveServiceHelper.update((DynamicObject[])successList.toArray(new DynamicObject[0]));
        }
    }

    private static boolean caApply(DynamicObject org) {
        try {
            MsgRequest request = CAService.getMsgRequest(org.getString("name"), org.getString("number"), org.getString("publicperson"));
            LOGGER.info(String.format("CAService caApply response:%s", request));
            MsgResponse response = MessageSendService.send(request);
            return ErrorType.SUCCESS.getCode().equals(response.getErrorCode());
        }
        catch (Exception e) {
            LOGGER.error("\u7533\u8bf7\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

