/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.resource.ResManager;
import org.apache.commons.lang3.StringUtils;

public class BigDecimalUtil {
    public static final BigDecimal ZERO = new BigDecimal(0);
    public static final BigDecimal POINT_ZERO_ONE = new BigDecimal("0.01");

    public static BigDecimal abs(BigDecimal val) {
        if (val == null) {
            val = new BigDecimal(0);
        }
        return val.abs();
    }

    public static BigDecimal multiply(BigDecimal val1, BigDecimal val2) {
        if (null == val1 || null == val2) {
            throw new NullPointerException(ResManager.loadKDString((String)"\u8fdb\u884c\u8ba1\u7b97\u7684\u91d1\u989d\u4e0d\u80fd\u4e3anull!", (String)"BigDecimalUtil_0", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        return val1.multiply(val2);
    }

    public static boolean compare(BigDecimal val1, BigDecimal val2, BigDecimal val3) {
        if (val1 == null) {
            val1 = BigDecimal.ZERO;
        }
        if (val2 == null) {
            val2 = BigDecimal.ZERO;
        }
        if (val3 == null) {
            val3 = BigDecimal.ZERO;
        }
        return BigDecimalUtil.subtract(val1, val2).abs().compareTo(val3) > 0;
    }

    public static BigDecimal subtract(BigDecimal val1, BigDecimal val2) {
        int scale = BigDecimalUtil.getScale(val1, val2);
        return val1.subtract(val2).setScale(scale, 4);
    }

    public static BigDecimal add(BigDecimal val1, BigDecimal val2) {
        int scale = BigDecimalUtil.getScale(val1, val2);
        return val1.add(val2).setScale(scale, 4);
    }

    private static int getScale(BigDecimal val1, BigDecimal val2) {
        if (null == val1 || null == val2) {
            throw new NullPointerException(ResManager.loadKDString((String)"\u8fdb\u884c\u8ba1\u7b97\u7684\u91d1\u989d\u4e0d\u80fd\u4e3anull!", (String)"BigDecimalUtil_0", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        return val1.scale() >= val2.scale() ? val1.scale() : val2.scale();
    }

    public static boolean compareZero(BigDecimal val) {
        if (null == val) {
            return true;
        }
        return val.compareTo(ZERO) == 0;
    }

    public static boolean greaterZero(BigDecimal val) {
        if (null == val) {
            return false;
        }
        return val.compareTo(ZERO) > 0;
    }

    public static boolean lessZero(BigDecimal val) {
        if (null == val) {
            return false;
        }
        return val.compareTo(ZERO) < 0;
    }

    public static String transToPoint(String val) {
        return BigDecimalUtil.transToPoint(val, 2);
    }

    public static String transToPoint(String val, int scale) {
        if (!BigDecimalUtil.isNumber(val)) {
            return "";
        }
        return new BigDecimal(val).setScale(scale, 4).toPlainString();
    }

    public static boolean isNumber(String number) {
        try {
            BigDecimal val = new BigDecimal(number);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static BigDecimal getJsonBigDecimalVal(Object obj) {
        BigDecimal val = BigDecimal.ZERO;
        if (obj == null) {
            return val;
        }
        try {
            val = new BigDecimal(obj.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    public static String getBigDecimalStr(String big) {
        if (StringUtils.isBlank((CharSequence)big) || !BigDecimalUtil.isNumber(big)) {
            return "";
        }
        BigDecimal cp = new BigDecimal(big);
        if (cp.compareTo(BigDecimal.ZERO) == 0) {
            return "";
        }
        return big;
    }

    public static BigDecimal transDecimal(Object val) {
        if (null == val || "".equals(val)) {
            return BigDecimal.ZERO;
        }
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        try {
            return new BigDecimal(String.valueOf(val));
        }
        catch (NumberFormatException e) {
            return BigDecimal.ZERO;
        }
    }

    public static BigDecimal formatNumOrUnitPrice(BigDecimal number, int i) {
        int intPart = (number = number.stripTrailingZeros()).precision() - number.scale();
        return intPart > i ? number : number.setScale(i - 1 - intPart, RoundingMode.HALF_UP);
    }
}

