/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.table.InvsmQrCallbackLogConstant;
import kd.imc.bdm.common.dto.InvsmQrCallbackLogVo;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.model.MsgRequest;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.message.send.SendMsg2Imac;
import kd.imc.bdm.common.openapi.CallbackResponseVo;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.SendMsg2Erp;

public class CallbackMcloudUtil {
    private static final Log LOGGER = LogFactory.getLog(CallbackMcloudUtil.class);

    public static void dealInvoice2Mcloud(DynamicObject invObj) {
        if (null == invObj) {
            return;
        }
        MsgResponse response = null;
        try {
            MsgRequest request = new MsgRequest();
            request.setIdentifytype("imacSciiFromImc");
            request.setMsgType("imcInvoiceCallIn");
            String sellerTaxNo = null == invObj.get("salertaxno") ? "" : invObj.getString("salertaxno");
            String jqbh = null == invObj.get("jqbh") ? "" : invObj.getString("jqbh");
            Map<String, Object> map = DynamicObjectUtil.dynamicObjectToMap(invObj);
            map.put("invreciveaddrphne", CallbackMcloudUtil.getInvAddr(sellerTaxNo, jqbh));
            map.put("billno", invObj.get("batchbelong"));
            request.setReqData(map);
            LOGGER.info(String.format("\u63a8\u9001\u53d1\u7968\u5230\u79fb\u52a8\u4e91 request: %s", request.toString()));
            response = SendMsg2Imac.send(request, "/kapi/app/imasm/imacWebService".concat("?access_token="));
            LOGGER.info("\u63a8\u9001\u53d1\u7968\u5230\u79fb\u52a8\u4e91 response\uff1a%s", (Object)response);
            if ("0000".equals(response.getErrorCode())) {
                try {
                    DeleteServiceHelper.delete((String)"invsm_qr_callback_log", (QFilter[])new QFilter("vat_invoice_ids", "=", (Object)invObj.getPkValue().toString()).toArray());
                }
                catch (Exception ignore) {
                    CallbackMcloudUtil.updateMcallbackLog(invObj, response);
                }
                return;
            }
            CallbackMcloudUtil.updateMcallbackLog(invObj, response);
        }
        catch (Exception e) {
            LOGGER.error(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u540c\u6b65\u626b\u7801\u5f00\u7968\u6570\u636e\u7ed9\u79fb\u52a8\u4e91\u53d1\u751f\u5f02\u5e38\uff1a%1$s;\u540c\u6b65\u79fb\u52a8\u4e91\u5931\u8d25\u53d1\u7968ID\u662f\uff1a%2$s", (String)"CallbackMcloudUtil_0", (String)"imc-bdm-common", (Object[])new Object[0]), e, invObj.getString("id")));
            String callbackCode = null == response ? ErrorType.FAIL.getCode() : response.getErrorCode();
            String callbackMsg = null == response ? String.format(ResManager.loadKDString((String)"\u53d1\u7968\u5f00\u5177\u8bf7\u6c42\u79fb\u52a8\u4e91\u5f02\u5e38\uff1a%s", (String)"CallbackMcloudUtil_1", (String)"imc-bdm-common", (Object[])new Object[0]), e.getMessage()) : response.getErrorMsg();
            InvsmQrCallbackLogVo mvo = new InvsmQrCallbackLogVo();
            mvo.setVatInvoiceIds(invObj.getString("id"));
            mvo.setCallbackCode(callbackCode);
            mvo.setCallbackMsg(callbackMsg);
            mvo.setBusType(InvsmQrCallbackLogConstant.BusTypeEnum.M_CLOUDE.getValue());
            CallbackMcloudUtil.recordMcallbackLog(mvo);
        }
    }

    private static void updateMcallbackLog(DynamicObject invObj, MsgResponse response) {
        InvsmQrCallbackLogVo mLog = new InvsmQrCallbackLogVo();
        mLog.setVatInvoiceIds(invObj.getString("id"));
        mLog.setCallbackCode(response.getErrorCode());
        mLog.setCallbackMsg(response.getErrorMsg());
        mLog.setBusType(InvsmQrCallbackLogConstant.BusTypeEnum.M_CLOUDE.getValue());
        CallbackMcloudUtil.recordMcallbackLog(mLog);
    }

    public static void dealInfo2ThirdSys(String systemCode, String noticeData, String methodCode, Long logId) {
        CallbackResponseVo rVo;
        if (StringUtils.isBlank((CharSequence)systemCode) || StringUtils.isBlank((CharSequence)noticeData)) {
            return;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("\u901a\u77e5ERP\u7cfb\u7edf\u662f\uff1a%s;methodCode\u662f\uff1a%s;\u901a\u77e5\u5185\u5bb9\u662f\uff1a%s", systemCode, methodCode, noticeData));
        }
        if (null != (rVo = SendMsg2Erp.send(systemCode, methodCode, noticeData)) && "0".equals(rVo.getCode())) {
            if (null != logId) {
                DeleteServiceHelper.delete((String)"invsm_qr_callback_log", (QFilter[])new QFilter("id", "=", (Object)logId).toArray());
                return;
            }
            return;
        }
        String msg = null == rVo ? "" : rVo.getMessage();
        String code = null == rVo ? "" : rVo.getCode();
        InvsmQrCallbackLogVo mlvo = new InvsmQrCallbackLogVo();
        mlvo.setId(logId);
        mlvo.setBusType(InvsmQrCallbackLogConstant.BusTypeEnum.ERP.getValue());
        mlvo.setCallbackMsg(msg);
        mlvo.setCallbackCode(code);
        mlvo.setCallbackMurl(systemCode);
        mlvo.setNoticeData(noticeData);
        mlvo.setMethodCode(methodCode);
        CallbackMcloudUtil.recordMcallbackLog(mlvo);
    }

    public static void recordMcallbackLog(InvsmQrCallbackLogVo mvo) {
        if (null == mvo) {
            return;
        }
        QFilter filter = new QFilter("vat_invoice_ids", "=", (Object)mvo.getVatInvoiceIds());
        DynamicObject logObj = BusinessDataServiceHelper.loadSingle((String)"invsm_qr_callback_log", (String)PropertieUtil.getAllPropertiesSplitByComma("invsm_qr_callback_log"), (QFilter[])filter.toArray());
        if (null == logObj) {
            logObj = BusinessDataServiceHelper.newDynamicObject((String)"invsm_qr_callback_log");
            DynamicObjectUtil.bean2DynamicObject(mvo, logObj);
            logObj.set("createdate", (Object)new Date());
            logObj.set("retry_times", (Object)1);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logObj});
            return;
        }
        int retryTimes = logObj.getInt("retry_times");
        DynamicObjectUtil.bean2DynamicObject(mvo, logObj);
        logObj.set("modifydate", (Object)new Date());
        logObj.set("retry_times", (Object)(retryTimes + 1));
        SaveServiceHelper.update((DynamicObject)logObj);
    }

    public static String getInvAddr(String sellerTaxNo, String deviceNo) {
        if (StringUtils.isBlank((CharSequence)sellerTaxNo) || StringUtils.isBlank((CharSequence)deviceNo)) {
            return "";
        }
        QFilter filter = new QFilter("eqinfono", "=", (Object)deviceNo).and("eqinfotaxno", "=", (Object)sellerTaxNo);
        DynamicObject invAddrAndPhoneObj = BusinessDataServiceHelper.loadSingle((String)"bdm_scaninvoice_setting", (String)"address,phone", (QFilter[])filter.toArray());
        if (null == invAddrAndPhoneObj) {
            return "";
        }
        String addrStr = null == invAddrAndPhoneObj.get("address") ? "" : invAddrAndPhoneObj.getString("address");
        String phoneStr = null == invAddrAndPhoneObj.get("phone") ? "" : invAddrAndPhoneObj.getString("phone");
        return addrStr + ">>" + phoneStr;
    }
}

