/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import kd.bos.util.StringUtils;
import kd.imc.bdm.common.untrans.BdmConstellationUntrans;

public class ConvertUpMoneyUtils {
    private static final String[] NUMBERS = BdmConstellationUntrans.ConvertUpMoneyUtils_0;
    private static final String[] IUNIT = BdmConstellationUntrans.ConvertUpMoneyUtils_1;
    private static final String[] DUNIT = BdmConstellationUntrans.ConvertUpMoneyUtils_2;

    public static String toChinese(String str) {
        String decimalStr;
        String integerStr;
        if (StringUtils.isBlank((String)str) || !str.matches("(-)?[\\d]*(.)?[\\d]*")) {
            return str;
        }
        if ("0".equals(str) || "0.00".equals(str) || "0.0".equals(str)) {
            return "\u96f6\u5706";
        }
        boolean flag = false;
        if (str.startsWith("-")) {
            flag = true;
            str = str.replaceAll("-", "");
        }
        if ((str = str.replaceAll(",", "")).indexOf(46) != -1) {
            integerStr = str.substring(0, str.indexOf(46));
            decimalStr = str.substring(str.indexOf(46) + 1);
        } else if (str.startsWith(".")) {
            integerStr = "";
            decimalStr = str.substring(1);
        } else {
            integerStr = str;
            decimalStr = "";
        }
        if (integerStr.length() > IUNIT.length) {
            return str;
        }
        int[] integers = ConvertUpMoneyUtils.toIntArray(integerStr);
        if (integers.length > 1 && integers[0] == 0) {
            if (flag) {
                str = "-" + str;
            }
            return str;
        }
        boolean isWan = ConvertUpMoneyUtils.isWan5(integerStr);
        int[] decimals = ConvertUpMoneyUtils.toIntArray(decimalStr);
        String result = ConvertUpMoneyUtils.getChineseInteger(integers, isWan) + ConvertUpMoneyUtils.getChineseDecimal(decimals);
        if (flag) {
            return "\uff08\u8d1f\u6570\uff09" + result;
        }
        return result;
    }

    private static int[] toIntArray(String number) {
        int[] array = new int[number.length()];
        for (int i = 0; i < number.length(); ++i) {
            array[i] = Integer.parseInt(number.substring(i, i + 1));
        }
        return array;
    }

    public static String getChineseInteger(int[] integers, boolean isWan) {
        StringBuilder chineseInteger = new StringBuilder();
        int length = integers.length;
        if (length == 1 && integers[0] == 0) {
            return "";
        }
        for (int i = 0; i < length; ++i) {
            String unit = "";
            if (integers[i] == 0) {
                if (length - i == 13) {
                    unit = "\u4e07";
                } else if (length - i == 9) {
                    unit = "\u4ebf";
                } else if (length - i == 5 && isWan) {
                    unit = "\u4e07";
                } else if (length - i == 1) {
                    unit = "\u5706";
                }
                if (length - i > 1 && integers[i + 1] != 0) {
                    unit = unit + "\u96f6";
                }
            }
            chineseInteger.append(integers[i] == 0 ? unit : NUMBERS[integers[i]] + IUNIT[length - i - 1]);
        }
        return chineseInteger.toString();
    }

    private static String getChineseDecimal(int[] decimals) {
        StringBuilder chineseDecimal = new StringBuilder();
        for (int i = 0; i < decimals.length && i != 3; ++i) {
            chineseDecimal.append(decimals[i] == 0 ? "" : NUMBERS[decimals[i]] + DUNIT[i]);
        }
        return chineseDecimal.toString();
    }

    private static boolean isWan5(String integerStr) {
        int length = integerStr.length();
        if (length > 4) {
            String subInteger = length > 8 ? integerStr.substring(length - 8, length - 4) : integerStr.substring(0, length - 4);
            return Integer.parseInt(subInteger) > 0;
        }
        return false;
    }
}

