/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import java.util.ArrayList;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.PermissionEnum;
import kd.imc.bdm.common.util.DynamicObjectUtil;

public class InputPermissionUtils {
    public static boolean checkAuth(String taxNo) {
        QFilter taxFilter = new QFilter("epinfo.number", "=", (Object)taxNo);
        QFilter stateFilter = new QFilter("authstate", "=", (Object)"1");
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"bdm_invoice_permission", (String)"id", (QFilter[])new QFilter[]{stateFilter, taxFilter});
        return !CollectionUtils.isEmpty((Collection)collect);
    }

    public static void saveInputPermissionByEp(Object[] epIds) {
        QFilter idFilter = new QFilter("id", "in", (Object)epIds);
        DynamicObjectCollection epList = QueryServiceHelper.query((String)"bdm_enterprise_baseinfo", (String)"id,org_id", (QFilter[])new QFilter[]{idFilter});
        if (epList != null) {
            for (DynamicObject ep : epList) {
                InputPermissionUtils.save(DynamicObjectUtil.getDynamicObjectLongValue(ep.get("org_id")), ep.getLong("id"), PermissionEnum.COLLECT_INVOICE_SERVICE.getPermissionNo());
            }
        }
    }

    public static void savePermission(Long orgId, String[] permissions, String authState) {
        QFilter idFilter = new QFilter("id", "=", (Object)orgId);
        DynamicObject epObj = QueryServiceHelper.queryOne((String)"bdm_org", (String)"epinfo", (QFilter[])new QFilter[]{idFilter});
        Long epId = DynamicObjectUtil.getDynamicObjectLongValue(epObj.get("epinfo"));
        if (epId > 0L) {
            for (String permission : permissions) {
                InputPermissionUtils.save(orgId, epId, permission, authState);
            }
        }
    }

    public static void savePermission(Long orgId) {
        InputPermissionUtils.savePermission(orgId, new String[]{PermissionEnum.ISSUE_INVOICE_SERVICE.getPermissionNo(), PermissionEnum.COLLECT_INVOICE_SERVICE.getPermissionNo()}, "0");
    }

    public static DynamicObject save(Long orgId, Object epId, String serverGroup, String authState) {
        QFilter taxFilter = new QFilter("epinfo.id", "=", epId);
        QFilter groupFilter = new QFilter("servergroup", "=", (Object)serverGroup);
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"bdm_invoice_permission", (String)"id,orginfo.id as org_id,authstate", (QFilter[])new QFilter[]{taxFilter, groupFilter});
        if (CollectionUtils.isEmpty((Collection)collect)) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bdm_invoice_permission");
            obj.set("orginfo", (Object)orgId);
            obj.set("epinfo", epId);
            obj.set("authstate", (Object)authState);
            obj.set("servergroup", (Object)serverGroup);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            return obj;
        }
        ArrayList<Object> pkList = new ArrayList<Object>(8);
        for (DynamicObject obj : collect) {
            if ("1".equals(obj.getString("authstate"))) continue;
            pkList.add(obj.get("id"));
        }
        if (!pkList.isEmpty()) {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle(pkList.get(0), (String)"bdm_invoice_permission");
            obj.set("orginfo", (Object)orgId);
            if (authState.equals("1")) {
                obj.set("authstate", (Object)"1");
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            return obj;
        }
        return null;
    }

    public static DynamicObject save(Long orgId, Object epId, String serverGroup) {
        return InputPermissionUtils.save(orgId, epId, serverGroup, "0");
    }
}

