/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import java.security.SecureRandom;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.RandomSingleton;

public class RandomString {
    private static final char[] symbols;

    private RandomString() {
    }

    public static String nextString(int length, boolean onlyNum, boolean noStartWithZero) {
        if (length < 1) {
            throw new IllegalArgumentException("length < 1: " + length);
        }
        SecureRandom random = RandomSingleton.getInstance();
        char[] buf = new char[length];
        int l = symbols.length;
        if (onlyNum) {
            l = 10;
        }
        int index = random.nextInt(l);
        if (noStartWithZero) {
            index = random.nextInt(l - 1) + 1;
        }
        buf[0] = symbols[index];
        for (int idx = 1; idx < buf.length; ++idx) {
            buf[idx] = symbols[random.nextInt(l)];
        }
        return new String(buf);
    }

    public static String getRandom(int length) {
        int[] a = new int[length];
        SecureRandom random = RandomSingleton.getInstance();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            a[i] = random.nextInt(10);
            sb.append(a[i]);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        int i;
        int length = BigDecimalUtil.transDecimal(RandomString.nextString(1, true, true)).intValue();
        int[] array = new int[length];
        for (i = 0; i < length; ++i) {
            array[i] = i;
        }
        for (i = 0; i < 1000; ++i) {
            int random = BigDecimalUtil.transDecimal(RandomString.nextString(4, true, true)).intValue();
            int idx = random % array.length;
            System.out.println(length + "  " + random + "  " + idx + "  " + array[idx]);
        }
    }

    static {
        int idx;
        symbols = new char[36];
        for (idx = 0; idx < 10; ++idx) {
            RandomString.symbols[idx] = (char)(48 + idx);
        }
        for (idx = 10; idx < 36; ++idx) {
            RandomString.symbols[idx] = (char)(97 + idx - 10);
        }
    }
}

