/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.DBServiceHelper;
import kd.imc.bdm.common.util.RandomString;

public class UUID {
    private static final Pattern ORDERNO_REG = Pattern.compile("[0-9a-zA-Z]*");

    public static String next() {
        return UUID.randomUUID();
    }

    public static synchronized String randomUUID() {
        StringBuilder sb = new StringBuilder();
        String id = DBServiceHelper.genStringId();
        Matcher m = ORDERNO_REG.matcher(id);
        while (m.find()) {
            sb.append(m.group());
        }
        if (sb.length() < 20) {
            sb.append(RandomString.nextString(20 - sb.length(), false, false).toUpperCase());
        }
        return sb.substring(0, 20);
    }

    public static String getBatchNumber() {
        String batchNumber;
        String lockKey = "batchNumberlock";
        try (DLock lock = DLock.create((String)lockKey);){
            if (!lock.tryLock(150000L)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u7f16\u53f7", (String)"UUID_0", (String)"imc-bdm-common", (Object[])new Object[0]));
            }
            batchNumber = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
        }
        return batchNumber;
    }
}

