/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.alleinvoice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.dto.allele.AllEleActiveProcessDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;

public class AllEinvoiceAccountListPlugin
extends AbstractListPlugin {
    private static final Log LOGGER = LogFactory.getLog(AllEinvoiceAccountListPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"importcode", "update"});
    }

    public void setFilter(SetFilterEvent e) {
        Set taxNoSet = OrgHelper.getUserHasPermTaxNo();
        LOGGER.info(String.format("userHasPermTaxNo:%s", JSONObject.toJSON((Object)taxNoSet)));
        QFilter filter = new QFilter("taxno", "in", (Object)taxNoSet);
        e.getCustomQFilters().add(filter);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "importcode": {
                ViewUtil.openDialog((AbstractFormPlugin)this, null, (String)"import_active_code", (String)"import_active_code");
                break;
            }
            case "update": {
                LOGGER.info("updateimportcode");
                if (!AllEleAuthHelper.isTenantAuthed() && !AllEleAuthHelper.isListExistAuthInfo()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5bfc\u5165\u6fc0\u6d3b\u7801", (String)"AllEinvoiceAccountListPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                AllEleActiveProcessDTO dto = AllEleAuthHelper.saveAuthAndEpInfo(null);
                Integer totalQueryNum = dto.getTotalQueryNum();
                Integer success = dto.getSuccessNum();
                int error = totalQueryNum - success;
                String totalDescription = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u66f4\u65b0\u53ef\u5bfc\u5165%1$s\u6761\u6570\u636e\uff0c\u672c\u6b21\u5bfc\u5165\u6210\u529f%2$s\u6761\uff0c\u672a\u5bfc\u5165%3$s\u6761\u3002", (String)"AllEinvoiceAccountListPlugin_11", (String)"imc-bdm-formplugin", (Object[])new Object[0]), totalQueryNum, success, error);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("activeSuccess", (IFormPlugin)this);
                String description = AllEleAuthHelper.getDescription();
                this.getView().showConfirm(totalDescription, description, MessageBoxOptions.OK, ConfirmTypes.Default, confirmCallBacks);
                break;
            }
            case "upgrade": {
                Set needShowEpIdSet = AllEleAuthHelper.needShowEpIdSet();
                QFilter filter = new QFilter("id", "in", (Object)needShowEpIdSet.toArray(new Object[0]));
                String tipMsg2 = ResManager.loadKDString((String)"\u4f01\u4e1a\u5217\u8868", (String)"AllEinvoiceAccountList_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)filter, (String)"bdm_enterprise_bas_layout", (String)"chooseEpInfo", (boolean)true, (boolean)true, null, null, (String)tipMsg2);
                break;
            }
            case "assign_lower_level": {
                Object[] primaryKeyValues = ((IListView)this.getView()).getSelectedRows().getPrimaryKeyValues();
                if (primaryKeyValues.length <= 0) break;
                if (primaryKeyValues.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5217\u8868\u53ea\u80fd\u52fe\u9009\u4e00\u4e2a\u8bbe\u5907\u8fdb\u884c\u5206\u914d\u7ec4\u7ec7", (String)"AllEinvoiceAccountListPlugin_6", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject eInvoiceObj = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValues[0], (String)"bdm_einvoice_account");
                DynamicObject epInfoDO = eInvoiceObj.getDynamicObject("epinfo");
                DynamicObject org = epInfoDO.getDynamicObject("org");
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f01\u4e1a\u7a0e\u53f7\u672a\u5173\u8054\u7ec4\u7ec7", (String)"AllEinvoiceAccountListPlugin_7", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                customParams.put("equipmentid", eInvoiceObj.getPkValue());
                customParams.put("orgId", org.getPkValue());
                ViewUtil.openDialog((AbstractFormPlugin)this, customParams, (String)"bdm_issue_auth_org", (String)"bdm_issue_auth_org");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection collection;
        Object[] pks;
        this.getView().invokeOperation("refresh");
        Object returnData = closedCallBackEvent.getReturnData();
        String actionId = closedCallBackEvent.getActionId();
        if ("chooseEpInfo".equalsIgnoreCase(actionId) && null != returnData && (pks = (collection = (ListSelectedRowCollection)returnData).getPrimaryKeyValues()).length > 0) {
            this.getPageCache().put("eppks", JSONObject.toJSONString((Object)pks));
            ViewUtil.openDialog((AbstractFormPlugin)this, null, (String)"bdm_auth_email", (String)"bdm_auth_email");
        }
        if ("bdm_auth_email".equals(actionId) && StringUtils.isNotBlank((Object)returnData)) {
            try {
                String eppks = this.getPageCache().get("eppks");
                JSONArray jsonArray = JSONObject.parseArray((String)eppks);
                Object[] pkArray = jsonArray.toArray();
                DynamicObject[] epInfos = BusinessDataServiceHelper.load((String)"bdm_enterprise_baseinfo", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_enterprise_baseinfo", (boolean)true), (QFilter[])new QFilter("id", "in", (Object)pkArray).toArray());
                ArrayList<String> taxNoList = new ArrayList<String>();
                for (DynamicObject epInfo : epInfos) {
                    taxNoList.add(epInfo.getString("number"));
                }
                String email = (String)returnData;
                try {
                    this.sendActiveEmail(email, taxNoList);
                }
                catch (KDBizException e) {
                    String message = e.getMessage();
                    String lowerErrorMsg = String.valueOf(message).toLowerCase();
                    if (lowerErrorMsg.contains("read") && lowerErrorMsg.contains("out")) {
                        AllEleAuthHelper.markEnterpriseIsAllSendEmail(taxNoList);
                    }
                    throw e;
                }
                AllEleAuthHelper.markEnterpriseIsAllSendEmail(taxNoList);
                String start = String.format(ResManager.loadKDString((String)"\u5df2\u63a8\u9001\u6fc0\u6d3b\u6570\u7535\u5f00\u7968\u90ae\u4ef6\u81f3\u90ae\u7bb1\uff1a%s\u3002", (String)"AllEinvoiceAccountListPlugin_8", (String)"imc-bdm-formplugin", (Object[])new Object[0]), email);
                String tip = String.format(ResManager.loadKDString((String)"%1$s%2$s\u8bf7\u5c06\u90ae\u4ef6\u4e2d\u7684\u6fc0\u6d3b\u7801\u5bfc\u5165\u672c\u9875\u9762\u3002", (String)"AllEinvoiceAccountListPlugin_13", (String)"imc-bdm-formplugin", (Object[])new Object[0]), start, System.lineSeparator());
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("tip", tip);
                ViewUtil.openDialog((AbstractFormPlugin)this, params, (String)"bdm_tips", null);
            }
            catch (Exception e) {
                LOGGER.error("bdm_auth_email" + e.getMessage(), (Throwable)e);
                this.getView().showErrorNotification(e.getMessage());
            }
        }
        super.closedCallBack(closedCallBackEvent);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("activeSuccess".equals(callBackId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void sendActiveEmail(String activeEmail, List<String> taxNoList) {
        MsgResponse response = AllEleAuthHelper.sendAuthEmail((String)activeEmail, taxNoList);
        if (!ErrorType.SUCCESS.getCode().equals(response.getErrorCode())) {
            String errorMsg = response.getErrorMsg();
            if (StringUtils.isBlank((CharSequence)errorMsg)) {
                errorMsg = ResManager.loadKDString((String)"\u53d1\u9001\u6fc0\u6d3b\u90ae\u4ef6\u5931\u8d25", (String)"AllEinvoiceAccountListPlugin_10", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
            }
            throw new KDBizException(errorMsg);
        }
    }
}

