/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.alleinvoice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.constant.allele.AllEleLonType;
import kd.imc.bdm.common.dto.allele.AllEleLoginRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleLoginResponseDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.dto.allele.AllEleTaxPlatformResponseDTO;
import kd.imc.bdm.common.dto.allele.TenantAuthDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;

public class EInvoiceAccountPlugin
extends AbstractFormPlugin {
    public void afterBindData(EventObject e) {
        this.refreshLoginAndAuthStatus();
    }

    private void refreshLoginAndAuthStatus() {
        IDataModel model = this.getModel();
        DynamicObjectCollection items = model.getEntryEntity("entryentity");
        String taxNo = (String)model.getValue("taxno");
        AllEleLoginRequestDTO eleIssue = new AllEleLoginRequestDTO();
        eleIssue.setRequest_path(AllEleInterfaceTypeEnum.LOGIN_CHECK.getRequestPath());
        if (null == items) {
            return;
        }
        for (int i = 0; i < items.size(); ++i) {
            DynamicObject item = (DynamicObject)items.get(i);
            if (!"1".equals(item.getString("isenable")) || "4".equals(item.getString("accounttype"))) {
                this.hideOperates(i, "login", "auth");
                continue;
            }
            boolean isOnlyReceive = "2".equals(item.getString("accounttype"));
            String account = item.getString("account");
            eleIssue.setAccount(account);
            if (isOnlyReceive) {
                eleIssue.setCheckAuth(Boolean.FALSE);
            } else {
                eleIssue.setCheckAuth(Boolean.TRUE);
            }
            AllEleResponseDTO reponse = AllEleServiceHelper.eleLogin((String)taxNo, (AllEleLoginRequestDTO)eleIssue);
            if (reponse.getSuccess().booleanValue()) {
                AllEleLoginResponseDTO data = (AllEleLoginResponseDTO)reponse.getData();
                if (data.getNeedAuth().booleanValue()) {
                    model.setValue("authstatus", (Object)"0", i);
                } else {
                    model.setValue("authstatus", (Object)"1", i);
                }
                if (data.getEtaxAccountType() == null || data.getEtaxAccountType() == -1) {
                    model.setValue("loginstatus", (Object)"0", i);
                    model.setValue("authstatus", (Object)"", i);
                } else {
                    this.hideOperates(i, "login");
                    model.setValue("loginstatus", (Object)"1", i);
                }
            }
            if (StringUtils.isBlank((CharSequence)item.getString("logintype"))) {
                model.setValue("logintype", (Object)"1", i);
            }
            if (!isOnlyReceive) continue;
            this.hideOperates(i, "auth");
            model.setValue("authstatus", (Object)"", i);
        }
        this.getModel().setDataChanged(false);
    }

    private void hideOperates(int index, String ... operates) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        ArrayList<String> opeIds = new ArrayList<String>(Arrays.asList(operates));
        entryGrid.hideOperateItems("operationcolumnap", index, opeIds);
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"advcontoolbarap", "tbmain"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "enabled": {
                this.setEnable(Boolean.TRUE);
                break;
            }
            case "disabled": {
                this.setEnable(Boolean.FALSE);
                break;
            }
            case "save": {
                this.setDefault();
            }
        }
    }

    private void setDefault() {
        DynamicObjectCollection items = this.getModel().getEntryEntity("entryentity");
        int issueDefaultNum = 0;
        int inputDefaultNum = 0;
        for (DynamicObject item : items) {
            String defaultBusiness = item.getString("defaultbusiness");
            if (!"1".equals(item.get("isdefault"))) continue;
            String isEnable = item.getString("isenable");
            if (!"1".equals(isEnable)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9ed8\u8ba4\u8d26\u53f7:%s\u5fc5\u987b\u542f\u7528", (String)"EInvoiceAccountPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]), item.getString("account")));
            }
            if (AllEleAuthHelper.isOutputBusiness((String)defaultBusiness)) {
                ++issueDefaultNum;
            }
            if (!AllEleAuthHelper.isInputBusiness((String)defaultBusiness)) continue;
            ++inputDefaultNum;
        }
        if (items.size() > 0) {
            if (issueDefaultNum > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9ed8\u8ba4\u4e1a\u52a1\u5305\u542b\u5f00\u7968\u7ba1\u7406\u7684\u9ed8\u8ba4\u8d26\u53f7\u53ea\u80fd\u67091\u4e2a", (String)"EInvoiceAccountPlugin_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            if (inputDefaultNum > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9ed8\u8ba4\u4e1a\u52a1\u5305\u542b\u6536\u7968\u7ba1\u7406\u7684\u9ed8\u8ba4\u8d26\u53f7\u53ea\u80fd\u67091\u4e2a", (String)"EInvoiceAccountPlugin_5", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
        }
        DynamicObject entity = this.getModel().getDataEntity();
        for (DynamicObject item : items) {
            if (!"1".equals(item.get("isdefault")) || !StringUtils.isNotBlank((CharSequence)item.getString("defaultbusiness")) || !StringUtils.isNotBlank((CharSequence)item.getString("accounttype"))) continue;
            String defaultBusiness = item.getString("defaultbusiness");
            String account = item.getString("account");
            TenantAuthDTO tenantInfo = new TenantAuthDTO();
            String companyOuNo = entity.getString("companyouno");
            tenantInfo.setClientId(entity.getString("clientid"));
            tenantInfo.setClientSecret(entity.getString("clientsecret"));
            tenantInfo.setEncKey(entity.getString("encryptkey"));
            tenantInfo.setTenantNo(entity.getString("tenantno"));
            AllEleAuthHelper.setDefault((TenantAuthDTO)tenantInfo, (String)account, (String)companyOuNo, (String)defaultBusiness);
        }
        this.getView().invokeOperation("save");
        this.getView().invokeOperation("refresh");
    }

    private void setEnable(Boolean enalbe) {
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = grid.getSelectRows();
        DynamicObject entity = this.getModel().getDataEntity();
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"bdm_einvoice_account", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_einvoice_account", (boolean)true), (QFilter[])new QFilter("id", "=", entity.getPkValue()).toArray());
        if (array.length > 0) {
            DynamicObjectCollection items = array[0].getDynamicObjectCollection("entryentity");
            for (int selectRow : selectRows) {
                String isDefault = ((DynamicObject)items.get(selectRow)).getString("isdefault");
                if ("1".equals(isDefault) && !enalbe.booleanValue()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u9ed8\u8ba4\u8d26\u53f7\u4e0d\u80fd\u88ab\u7981\u7528", (String)"EInvoiceAccountPlugin_6", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                }
                ((DynamicObject)items.get(selectRow)).set("isenable", (Object)(enalbe != false ? "1" : "0"));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{array[0]});
        }
        this.getView().invokeOperation("refresh");
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (afterDoOperationEventArgs.getOperationResult() == null || !afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = grid.getSelectRows();
        switch (operateKey) {
            case "login": 
            case "auth": {
                this.loginOrAuth(selectRows[0], operateKey);
                break;
            }
            case "refreshstatus": {
                this.refreshLoginAndAuthStatus();
            }
        }
    }

    private void loginOrAuth(int selectRow, String operateKey) {
        IDataModel model = this.getModel();
        String taxNo = (String)model.getValue("taxno");
        AllEleLoginRequestDTO eleIssue = new AllEleLoginRequestDTO();
        eleIssue.setRequest_path(AllEleInterfaceTypeEnum.LOGIN_CHECK.getRequestPath());
        boolean isAuth = "auth".equals(operateKey);
        if (isAuth) {
            eleIssue.setCheckAuth(Boolean.TRUE);
        } else {
            eleIssue.setCheckAuth(Boolean.FALSE);
        }
        String account = (String)model.getValue("account", selectRow);
        eleIssue.setOperationType("2".equals(model.getValue("accounttype", selectRow)) ? "2" : "1");
        eleIssue.setAccount(account);
        AllEleResponseDTO loginInfo = AllEleServiceHelper.eleLogin((String)taxNo, (AllEleLoginRequestDTO)eleIssue);
        if (!loginInfo.getSuccess().booleanValue()) {
            String description = loginInfo.getDescription();
            this.getView().showErrorNotification(org.apache.commons.lang.StringUtils.isBlank((String)description) ? ResManager.loadKDString((String)"\u767b\u5f55\u5931\u8d25", (String)"EInvoiceAccountPlugin_7", (String)"imc-bdm-formplugin", (Object[])new Object[0]) : description);
            return;
        }
        AllEleLoginResponseDTO data = (AllEleLoginResponseDTO)loginInfo.getData();
        if (isAuth || !AllEleLonType.AUTO_LOGIN.equals(data.getLoginType()) && data.getEtaxAccountType() == -1) {
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            map.put("taxNo", taxNo);
            map.put("account", account);
            map.put("longLinkName", ((AllEleLoginResponseDTO)loginInfo.getData()).getLongLinkName());
            map.put("loginWebUrls", ((AllEleLoginResponseDTO)loginInfo.getData()).getLoginWebUrl());
            map.put("loginType", model.getValue("logintype", selectRow));
            map.put("checkAuth", isAuth ? "1" : "0");
            ViewUtil.openDialog((AbstractFormPlugin)this, map, (String)"bdm_tax_login", (String)"bdm_tax_login");
            return;
        }
        model.setValue("loginstatus", (Object)"1", selectRow);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("bdm_tax_login".equals(closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() != null) {
            AllEleTaxPlatformResponseDTO response = (AllEleTaxPlatformResponseDTO)closedCallBackEvent.getReturnData();
            boolean checkAuth = "1".equals(response.getCustomParams().get("checkAuth"));
            EntryGrid grid = (EntryGrid)this.getControl("entryentity");
            int selectRow = grid.getSelectRows()[0];
            IDataModel model = this.getModel();
            model.setValue("loginstatus", (Object)"1", selectRow);
            if (checkAuth) {
                model.setValue("authstatus", (Object)"1", selectRow);
            }
            this.hideOperates(selectRow, "login");
        }
    }
}

