/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.custommail;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResultImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.table.MailSettingConstant;
import kd.imc.bdm.common.helper.HiddenButtonHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;

public class MailSettingListPlugin
extends AbstractListPlugin {
    private static Log LOGGER = LogFactory.getLog(MailSettingListPlugin.class);
    private static final String BDM_MAIL_SETTING_ADD = "bdm_mail_setting_add";
    private static final String MAIL_SETTING_ADD_CALL_BACK = "mailSettingAddCallBack";

    public void setFilter(SetFilterEvent e) {
        LOGGER.info("\u67e5\u8be2\u6761\u4ef6\u9650\u5236...");
        long currentUserId = Long.parseLong(RequestContext.get().getUserId());
        HasPermOrgResultImpl userHasPermEpInfo = OrgHelper.getUserHasPermEpInfo();
        if (!userHasPermEpInfo.hasAllOrgPerm()) {
            ArrayList containIdArray = new ArrayList(8);
            QFilter filter = new QFilter("creater", "=", (Object)currentUserId).and(QFilter.isNull((String)"items.id"));
            DynamicObjectCollection createMailColl = QueryServiceHelper.query((String)"bdm_mail", (String)"id", (QFilter[])filter.toArray());
            if (!createMailColl.isEmpty()) {
                createMailColl.stream().forEach(createMail -> containIdArray.add(createMail.getLong("id")));
            }
            List epInfos = userHasPermEpInfo.getHasPermOrgs();
            QFilter finalFilter = new QFilter("items.epinfo", "in", (Object)epInfos).or("id", "in", containIdArray).or("number", "=", (Object)"YZYXSZ01_s");
            e.getCustomQFilters().add(finalFilter);
        } else {
            QFilter filter = new QFilter("creater", "!=", (Object)currentUserId).and(QFilter.isNull((String)"items.id"));
            DynamicObjectCollection createMailColl = QueryServiceHelper.query((String)"bdm_mail", (String)"id", (QFilter[])filter.toArray());
            if (!createMailColl.isEmpty()) {
                List notContainIdArray = createMailColl.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
                QFilter notFinalFilter = new QFilter("id", "not in", notContainIdArray).or("number", "=", (Object)"YZYXSZ01_s");
                e.getCustomQFilters().add(notFinalFilter);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        HiddenButtonHelper.hideClose((AbstractFormPlugin)this, (String[])new String[]{"baritemap1"});
    }

    public void itemClick(ItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "btn_add": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.ITEM_NEW);
                this.addMail(null);
                break;
            }
            case "showallocatedenterprise": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.SHOW\uff3fALLOCATED\uff3fENTERPRISE);
                this.showAllocatedEnterprise();
                break;
            }
            case "btn_disable": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.ITEM_DISABLE);
                this.disable();
                break;
            }
            case "btn_enable": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.ITEM_ENABLE);
                this.enable();
                break;
            }
        }
    }

    private void enable() {
        QFilter qFilter;
        ListSelectedRowCollection rows = this.getSelectedRows();
        if (rows.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u90ae\u7bb1\u8bbe\u7f6e", (String)"MailSettingListPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] ids = rows.getPrimaryKeyValues();
        String fields = String.join((CharSequence)",", "id", "items", "items.epinfo", "status");
        DynamicObject[] disableMailColl = BusinessDataServiceHelper.load((String)"bdm_mail", (String)fields, (QFilter[])(qFilter = new QFilter("id", "in", (Object)ids).and(new QFilter("status", "=", (Object)MailSettingConstant.Status.DISABLE.getValue()))).toArray());
        if (disableMailColl.length == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u52fe\u9009\u7684\u90ae\u7bb1\u8bbe\u7f6e\u5df2\u542f\u7528", (String)"MailSettingListPlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> disableIds = new ArrayList<Long>(8);
        ArrayList disableEpIds = new ArrayList(8);
        for (DynamicObject disableMail : disableMailColl) {
            disableIds.add(disableMail.getLong("id"));
            DynamicObjectCollection itemColl = disableMail.getDynamicObjectCollection("items");
            if (itemColl.isEmpty()) continue;
            disableEpIds.addAll(itemColl.stream().filter(o -> o != null).map(o -> o.getDynamicObject("epinfo").getLong("id")).collect(Collectors.toList()));
        }
        QFilter existFilter = new QFilter("id", "not in", disableIds).and("items.epinfo", "in", disableEpIds);
        DynamicObject[] existColl = BusinessDataServiceHelper.load((String)"bdm_mail", (String)"id, items, items.epinfo", (QFilter[])existFilter.toArray());
        StringBuilder showMsgBuilder = new StringBuilder();
        if (existColl.length != 0) {
            HashSet epIdSet = new HashSet(8);
            Arrays.stream(existColl).forEach(existObj -> {
                DynamicObjectCollection itemObjColl = existObj.getDynamicObjectCollection("items");
                if (itemObjColl == null || itemObjColl.isEmpty()) {
                    return;
                }
                itemObjColl.forEach(epObj -> {
                    DynamicObject companyObj = epObj.getDynamicObject("epinfo");
                    if (companyObj == null) {
                        return;
                    }
                    if (epIdSet.contains(companyObj.getLong("id"))) {
                        return;
                    }
                    showMsgBuilder.append(String.format("\u3010%s+%s\u3011\n", companyObj.getString("name"), companyObj.getString("number")));
                    epIdSet.add(companyObj.getLong("id"));
                });
            });
            if (showMsgBuilder.length() != 0) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u542f\u7528\u5931\u8d25\uff0c%1$s %2$s\u5df2\u5b58\u5728\u90ae\u7bb1\u914d\u7f6e\uff0c\u4e0d\u53ef\u91cd\u590d\u8bbe\u7f6e", (String)"MailSettingListPlugin_17", (String)"imc-bdm-formplugin", (Object[])new Object[0]), "\n", showMsgBuilder.toString()));
                return;
            }
        }
        for (DynamicObject dynamicObject : disableMailColl) {
            dynamicObject.set("status", (Object)MailSettingConstant.Status.ENABLE.getValue());
        }
        SaveServiceHelper.update((DynamicObject[])disableMailColl);
        this.getView().invokeOperation("refresh");
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f", (String)"MailSettingListPlugin_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
    }

    private void disable() {
        ListSelectedRowCollection rows = this.getSelectedRows();
        if (rows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u90ae\u7bb1\u8bbe\u7f6e", (String)"MailSettingListPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        Object[] ids = rows.getPrimaryKeyValues();
        DynamicObject[] dynamicObjects = this.getEnableDynamicObjects(ids);
        if (0 == dynamicObjects.length) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u542f\u7528\u7684\u90ae\u7bb1\u8bbe\u7f6e", (String)"MailSettingListPlugin_5", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        for (DynamicObject entity : dynamicObjects) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)entity.getString("number"), (CharSequence)"YZYXSZ01_s")) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s\u4e3a\u7cfb\u7edf\u9884\u8bbe\u65b9\u6848\uff0c\u4e0d\u53ef\u7981\u7528", (String)"MailSettingListPlugin_6", (String)"imc-bdm-formplugin", (Object[])new Object[0]), "YZYXSZ01_s"), Integer.valueOf(2000));
            return;
        }
        QFilter otherEnableMailFilter = new QFilter("id", "not in", (Object)ids).and(new QFilter("status", "=", (Object)MailSettingConstant.Status.ENABLE.getValue()));
        DynamicObjectCollection otherMailSettings = QueryServiceHelper.query((String)"bdm_mail", (String)"id", (QFilter[])otherEnableMailFilter.toArray());
        if (0 == otherMailSettings.size()) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("btn_disablemailSetting");
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"MailSettingListPlugin_7", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"MailSettingListPlugin_8", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u6709\u90ae\u7bb1\u65b9\u6848\u7981\u7528\u540e\uff0c\u65e0\u8bba\u662f\u5426\u586b\u5199\u6536\u7968\u90ae\u7bb1\uff0c\u7535\u5b50\u53d1\u7968\u5c06\u4e0d\u4f1a\u901a\u8fc7\u90ae\u4ef6\u63a8\u9001\uff0c\u662f\u5426\u786e\u8ba4\u7981\u7528\uff1f", (String)"MailSettingListPlugin_9", (String)"imc-bdm-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        } else {
            Object[] enableIds = Arrays.stream(dynamicObjects).map(DataEntityBase::getPkValue).toArray();
            this.updateMailSetting(enableIds, MailSettingConstant.Status.DISABLE.getValue());
        }
    }

    private DynamicObject[] getEnableDynamicObjects(Object[] ids) {
        String fields = PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_mail", (boolean)false);
        QFilter qFilter = new QFilter("id", "in", (Object)ids).and(new QFilter("status", "=", (Object)MailSettingConstant.Status.ENABLE.getValue()));
        return BusinessDataServiceHelper.load((String)"bdm_mail", (String)fields, (QFilter[])qFilter.toArray());
    }

    private void showAllocatedEnterprise() {
        ListSelectedRowCollection rows = this.getSelectedRows();
        if (rows.isEmpty()) {
            return;
        }
        if (rows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u67e5\u770b", (String)"MailSettingListPlugin_10", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        Object[] ids = rows.getPrimaryKeyValues();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)ids[0], (String)"bdm_mail");
        DynamicObjectCollection items = dynamicObject.getDynamicObjectCollection("items");
        if (items.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd8\u672a\u5206\u914d\u4f01\u4e1a", (String)"MailSettingListPlugin_11", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        Object[] convert = this.getEpInfos(items);
        ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)new QFilter("id", "in", (Object)convert), (String)"bdm_allocated_enterprise", (String)"showallocatedenterprise", (boolean)false);
    }

    private Object[] getEpInfos(DynamicObjectCollection items) {
        ArrayList<Object> pkList = new ArrayList<Object>();
        HasPermOrgResultImpl userHasPermEpInfo = OrgHelper.getUserHasPermEpInfo();
        List pkIds = new ArrayList(8);
        boolean allOrgPerm = true;
        if (!userHasPermEpInfo.hasAllOrgPerm()) {
            pkIds = userHasPermEpInfo.getHasPermOrgs();
            allOrgPerm = false;
        }
        for (DynamicObject item : items) {
            DynamicObject epInfo = item.getDynamicObject("epinfo");
            if (null == epInfo) continue;
            if (allOrgPerm) {
                pkList.add(epInfo.getPkValue());
                continue;
            }
            if (!pkIds.contains(epInfo.getPkValue())) continue;
            pkList.add(epInfo.getPkValue());
        }
        return pkList.toArray(new Object[0]);
    }

    private void addMail(Object id) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        customParams.put("id", id);
        String tipMsg1 = ResManager.loadKDString((String)"\u90ae\u7bb1\u8bbe\u7f6e", (String)"MailSettingListPlugin_18", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        String tipMsg2 = ResManager.loadKDString((String)"\u65b0\u589e", (String)"MailSettingListPlugin_19", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        String tipMsg3 = ResManager.loadKDString((String)"\u4fee\u6539", (String)"MailSettingListPlugin_20", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        ViewUtil.openMainNewTabPage((AbstractFormPlugin)this, (String)(this.getView().getPageId() + BDM_MAIL_SETTING_ADD + (null == id ? "" : id)), customParams, (String)BDM_MAIL_SETTING_ADD, (String)MAIL_SETTING_ADD_CALL_BACK, (String)(tipMsg1 + (null == id ? tipMsg2 : tipMsg3)));
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        this.addMail(currentSelectedRowInfo.getPrimaryKeyValue());
        args.setCancel(true);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData;
        if (MAIL_SETTING_ADD_CALL_BACK.equals(event.getActionId()) && (returnData = event.getReturnData()) != null) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"MailSettingListPlugin_15", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
            this.getView().invokeOperation("refresh");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("btn_disablemailSetting".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            ListSelectedRowCollection rows = this.getSelectedRows();
            Object[] ids = rows.getPrimaryKeyValues();
            this.updateMailSetting(ids, MailSettingConstant.Status.DISABLE.getValue());
        }
    }

    private void updateMailSetting(Object[] ids, String maiSettingStatus) {
        DynamicObject[] dynamicObjects;
        for (DynamicObject dynamicObject : dynamicObjects = this.getEnableDynamicObjects(ids)) {
            dynamicObject.set("status", (Object)maiSettingStatus);
        }
        SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        this.getView().invokeOperation("refresh");
        this.getView().showMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"MailSettingListPlugin_16", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
    }
}

