/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.enterpriseinfo;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeUploadEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.table.EnterPriseBaseInfoConstant;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.service.OpenInvoiceService;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.InputPermissionUtils;
import kd.imc.bdm.common.util.MetadataUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.bdm.formplugin.org.control.OrgEditControl;

public class EnterpriseInfoBindPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final String customControlKey = "epnamequery";
    private static final Log LOGGER = LogFactory.getLog(EnterpriseInfoBindPlugin.class);
    private static final String INPUT_NAME = "input_name";
    private static final String KEY_EP_QUALIFICATION = "epqualification";
    private static final String KEY_TOBACCO_DATE = "tobaccodate";
    private static final String KEY_TOBACCO_START_DATE = "tobaccostartdate";
    private static final String KEY_TOBACCO_END_DATE = "tobaccoenddate";

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"epname"});
        this.initCustomControl();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object parentName = customParams.get("parentName");
        Object number = customParams.get("number");
        Object name = customParams.get("name");
        Object orgId = customParams.get("orgId");
        IDataModel model = this.getModel();
        model.setValue("orgcode", number);
        model.setValue("orgname", name);
        model.setValue("parentorg", parentName);
        model.setValue("orgid", orgId);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_TOBACCO_DATE});
        this.visibleDelete();
        OrgEditControl.updateOrgNameAndNumber(this, orgId);
    }

    private void visibleDelete() {
        Object fileName = this.getModel().getValue("filename");
        if (StringUtils.isBlank((Object)fileName)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"deletefile"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"deletefile"});
        }
    }

    public void beforeUpload(BeforeUploadEvent evt) {
        List attachInfos = evt.getAttachInfos();
        int size = attachInfos.size();
        if (size > 0) {
            IDataModel model = this.getModel();
            Map map = (Map)attachInfos.get(0);
            this.setFileName(model, map);
        }
    }

    public void setFileName(IDataModel model, Map<String, Object> map) {
        Object fileSize = map.get("size");
        String fileName = String.valueOf(map.get("name"));
        if (fileName.length() > 100) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u540d\u957f\u5ea6\u8fc7\u957f", (String)"EnterpriseInfoBindPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(fileSize)).divide(new BigDecimal("1024"), 2, RoundingMode.HALF_UP);
        model.setValue("filename", (Object)(fileName + bigDecimal + "kb"));
        this.visibleDelete();
    }

    public void afterUpload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            String url = (String)urls[0];
            IDataModel model = this.getModel();
            model.setValue("filepath", (Object)url);
        }
    }

    private void initCustomControl() {
        HashMap<String, String> showDataMap = new HashMap<String, String>(4);
        showDataMap.put("showSearchIcon", "none");
        showDataMap.put("inputStyle", "border: none; border-bottom: 1px solid #999;padding-bottom: 5px;");
        ViewUtil.bindDataToHtml((AbstractFormPlugin)this, showDataMap, (String)customControlKey);
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String args = e.getEventArgs();
        switch (eventName) {
            case "queryTitle": {
                this.getModel().setValue("enterprisename", (Object)args);
                this.getView().addClientCallBack(customControlKey);
                this.getPageCache().put(INPUT_NAME, args);
                return;
            }
            case "updateBuyerTaxNo": {
                this.confirmEnterprise(args);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap1", "toolbarap", "advtoolbar", "deletefile"});
        this.addClickListeners(new String[]{"upload", "deletefile"});
        Button upload = (Button)this.getControl("upload");
        upload.addUploadListener((UploadListener)this);
    }

    public void click(EventObject evt) {
        IDataModel model;
        String filePath;
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("deletefile".equals(key) && StringUtils.isNotBlank((CharSequence)(filePath = (String)(model = this.getModel()).getValue("filepath")))) {
            FileServiceFactory.getAttachmentFileService().delete(filePath);
            model.setValue("filename", null);
            this.visibleDelete();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("btn_save".equals(key)) {
            DynamicObjectCollection collect = this.getModel().getEntryEntity("usednameentry");
            for (int i = 0; i < collect.size(); ++i) {
                DynamicObject obj = (DynamicObject)collect.get(i);
                if (!StringUtils.isEmpty((CharSequence)obj.getString("used_name"))) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u66fe\u7528\u540d\u7b2c%1$s\u884c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"EnterpriseInfoBindPlugin_16", (String)"imc-bdm-formplugin", (Object[])new Object[0]), i + 1), Integer.valueOf(3000));
                return;
            }
            String taxNo = this.getSafeTaxNo(this.getModel());
            String enterpriseRole = (String)this.getView().getModel().getValue("enterpriserole");
            String issueChannel = (String)this.getModel().getValue("issuechannel");
            try (TXHandle tx = TX.required();){
                try {
                    this.saveEnterpriseInfo();
                    this.getView().close();
                }
                catch (KDBizException e) {
                    tx.markRollback();
                    LOGGER.error("\u4fdd\u5b58\u7ec4\u7ec7\u8bbe\u5907\u5217\u8868\u4fe1\u606f\u548c\u5b58\u50a8\u8bbe\u5907\u4fe1\u606f\u5931\u8d25\uff0c\u89e6\u53d1\u4e8b\u52a1\u56de\u6eda", (Throwable)e);
                    this.getView().showErrorNotification(e.getMessage());
                }
                catch (Throwable e) {
                    tx.markRollback();
                    LOGGER.error("\u4fdd\u5b58\u7ec4\u7ec7\u8bbe\u5907\u5217\u8868\u4fe1\u606f\u548c\u5b58\u50a8\u8bbe\u5907\u4fe1\u606f\u5931\u8d25\uff0c\u89e6\u53d1\u4e8b\u52a1\u56de\u6eda", e);
                    throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"EnterpriseInfoBindPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                }
            }
            if (EnterPriseBaseInfoConstant.LQPT_CHANNEL.contains((Object)issueChannel)) {
                OrgEditControl.initLqptInfo(taxNo, enterpriseRole);
            }
        }
    }

    private void saveEpQualification(DynamicObject orgDynamicObject) {
        Object epQualification = this.getModel().getValue(KEY_EP_QUALIFICATION);
        Object tobaccoStartDate = this.getModel().getValue(KEY_TOBACCO_START_DATE);
        Object tobaccoEndDate = this.getModel().getValue(KEY_TOBACCO_END_DATE);
        if ("".equals(epQualification)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f01\u4e1a\u8d44\u8d28", (String)"EnterpriseInfoBindPlugin_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject epBaseInfo = orgDynamicObject.getDynamicObject("epinfo");
        DynamicObject epInfo = TaxUtils.getEpInfoByOrg((DynamicObject)orgDynamicObject);
        if (epInfo == null) {
            epInfo = BusinessDataServiceHelper.newDynamicObject((String)"bdm_enterprise_info");
            epInfo.set("epinfo", epBaseInfo.getPkValue());
        }
        if (!TaxUtils.isTobaccoMark((String)((String)epQualification))) {
            epInfo.set("tobaccoexpirestarttime", null);
            epInfo.set("tobaccoexpireendtime", null);
        } else {
            if (tobaccoStartDate == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5377\u70df\u4f01\u4e1a\u542f\u7528\u65f6\u95f4", (String)"EnterpriseInfoBindPlugin_5", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            epInfo.set("tobaccoexpirestarttime", tobaccoStartDate);
            epInfo.set("tobaccoexpireendtime", tobaccoEndDate);
        }
        epInfo.set("tobaccomark", epQualification);
        ImcSaveServiceHelper.save((DynamicObject)epInfo);
    }

    private void saveEnterpriseInfo() {
        String publicPerson;
        IDataModel model = this.getModel();
        String enterpriseName = this.getSafeEnterpriseName(model);
        String taxNo = this.getSafeTaxNo(model);
        Object safeAddrTel = this.getSafeAddrTel(model);
        Object safeBankAccount = this.getSafeBankAccount(model);
        Object authtype = this.getModel().getValue("authtype");
        DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)model.getValue("orgid"), (String)"bdm_org");
        this.fillIsvField(org, "bdm_org");
        DynamicObject eObject = BusinessDataServiceHelper.newDynamicObject((String)"bdm_enterprise_baseinfo");
        this.fillIsvField(eObject, "bdm_enterprise_baseinfo");
        eObject.set("name", (Object)enterpriseName);
        eObject.set("number", (Object)taxNo);
        eObject.set("org", (Object)org);
        Date now = new Date();
        eObject.set("createtime", (Object)now);
        eObject.set("modifytime", (Object)now);
        eObject.set("invoiceaddr", safeAddrTel);
        eObject.set("openuserbank", safeBankAccount);
        eObject.set("authtype", authtype);
        eObject.set("isvoucher", this.getModel().getValue("isvoucher"));
        eObject.set("taxusername", this.getModel().getValue("taxusername"));
        eObject.set("taxpassword", this.getModel().getValue("taxpassword"));
        DynamicObjectCollection usednameentry = eObject.getDynamicObjectCollection("usednameentry");
        DynamicObjectCollection collect = this.getModel().getEntryEntity("usednameentry");
        for (int i = 0; i < collect.size(); ++i) {
            DynamicObject obj = (DynamicObject)collect.get(i);
            DynamicObject usedNameObject = usednameentry.addNew();
            usedNameObject.set("used_name", (Object)obj.getString("used_name"));
            usedNameObject.set("used_name_date", obj.get("used_name_date"));
        }
        Object businessLicenseUrl = model.getValue("filepath");
        if (null != businessLicenseUrl) {
            eObject.set("businesslicenseurl", businessLicenseUrl);
        }
        if (!StringUtils.isEmpty((CharSequence)(publicPerson = (String)model.getValue("publicperson")))) {
            if (publicPerson.length() > 10) {
                throw new KDBizException(ResManager.loadKDString((String)"CA\u7b7e\u7ae0\u6cd5\u4eba\u540d\u79f0\u8d85\u957f", (String)"EnterpriseInfoBindPlugin_6", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            eObject.set("publicperson", (Object)publicPerson);
        }
        String issueChannel = (String)this.getModel().getValue("issuechannel");
        eObject.set("issuechannel", (Object)issueChannel);
        OrgEditControl.checkAllEleIssueChannle(this, eObject);
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{eObject});
        this.getModel().setValue("epid", ((DynamicObject)save[0]).getPkValue());
        org.set("epinfo", save[0]);
        org.set("enterprisemainorg", (Object)"1");
        this.saveEpQualification(org);
        SaveServiceHelper.update((DynamicObject)org);
        this.saveAddrAndAccount(taxNo, safeAddrTel, safeBankAccount);
        InputPermissionUtils.savePermission((Long)org.getLong("id"));
    }

    private void fillIsvField(DynamicObject orgDynamicObject, String entityKey) {
        List fieldList = MetadataUtil.getIsvEntityItems((String)entityKey);
        for (String field : fieldList) {
            try {
                Control control = this.getView().getControl(field);
                if (control == null) continue;
                orgDynamicObject.set(field, this.getModel().getValue(field));
            }
            catch (Exception e) {
                LOGGER.info("\u6269\u5c55\u5b57\u6bb5\u8bbe\u7f6e\u9519\u8bef{},{}", (Object)entityKey, (Object)field);
            }
        }
    }

    private Object getSafeBankAccount(IDataModel model) {
        Object bankaccount = model.getValue("bankaccount");
        if (StringUtils.isBlank((Object)bankaccount)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u6237\u884c\u53ca\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"EnterpriseInfoBindPlugin_7", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        Integer gbkLength = GBKUtils.getGBKLength((String)bankaccount.toString());
        if (gbkLength > 100) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u6237\u884c\u53ca\u8d26\u53f7\u957f\u5ea6\u8fc7\u957f", (String)"EnterpriseInfoBindPlugin_8", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        return bankaccount;
    }

    private Object getSafeAddrTel(IDataModel model) {
        Object addrtel = model.getValue("addrtel");
        if (StringUtils.isBlank((Object)addrtel)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5730\u5740\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a", (String)"EnterpriseInfoBindPlugin_9", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        Integer gbkLength = GBKUtils.getGBKLength((String)addrtel.toString());
        if (gbkLength > 100) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5730\u5740\u7535\u8bdd\u957f\u5ea6\u8fc7\u957f", (String)"EnterpriseInfoBindPlugin_10", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        return addrtel;
    }

    private String getSafeTaxNo(IDataModel model) {
        String taxNo = (String)model.getValue("taxno");
        this.check(taxNo);
        return taxNo.toUpperCase();
    }

    private String getSafeEnterpriseName(IDataModel model) {
        String enterpriseName = (String)model.getValue("enterprisename");
        if (StringUtils.isBlank((CharSequence)enterpriseName)) {
            enterpriseName = this.getPageCache().get(INPUT_NAME);
        }
        if (StringUtils.isBlank((CharSequence)enterpriseName)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5165\u4f01\u4e1a\u540d\u79f0", (String)"EnterpriseInfoBindPlugin_11", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        if (enterpriseName.length() > 50) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f01\u4e1a\u540d\u79f0\u957f\u5ea6\u8fc7\u957f", (String)"EnterpriseInfoBindPlugin_12", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        return enterpriseName;
    }

    private void saveAddrAndAccount(String taxNo, Object addrtel, Object bankaccount) {
        DynamicObject[] invoiceSettings = BusinessDataServiceHelper.load((String)"sim_invoice_setting", (String)"ischeck", (QFilter[])new QFilter("taxno", "=", (Object)taxNo).toArray());
        if (invoiceSettings.length != 0) {
            for (DynamicObject invoiceSetting : invoiceSettings) {
                invoiceSetting.set("ischeck", (Object)"0");
            }
            SaveServiceHelper.save((DynamicObject[])invoiceSettings);
        }
        if (StringUtils.isNotBlank((Object)addrtel) || StringUtils.isNotBlank((Object)bankaccount)) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"sim_invoice_setting");
            obj.set("invoiceaddr", addrtel);
            obj.set("openuserbank", bankaccount);
            obj.set("taxno", (Object)taxNo);
            obj.set("ischeck", (Object)"1");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        }
    }

    private void check(String taxNo) {
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5165\u4f01\u4e1a\u7a0e\u53f7", (String)"EnterpriseInfoBindPlugin_13", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        int length = taxNo.length();
        if (length != 15 && length != 16 && length != 17 && length != 18 && length != 20) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u53f7\u957f\u5ea6\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"EnterpriseInfoBindPlugin_14", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        QFilter filter = new QFilter("epinfo.number", "=", (Object)taxNo);
        DynamicObject[] ids = BusinessDataServiceHelper.load((String)"bdm_org", (String)"id", (QFilter[])filter.toArray());
        if (null != ids && ids.length > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u7a0e\u53f7\u5df2\u88ab\u5176\u4ed6\u4f01\u4e1a\u7ed1\u5b9a\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"EnterpriseInfoBindPlugin_15", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
    }

    public void confirmEnterprise(String args) {
        JSONObject jsonObject = JSONObject.parseObject((String)args);
        this.getView().getModel().setValue("taxno", jsonObject.get((Object)"tax"));
        this.getView().getModel().setValue("enterprisename", jsonObject.get((Object)"name"));
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if (customControlKey.equals(e.getName())) {
            String enterprisename = (String)this.getModel().getValue("enterprisename");
            this.queryBuyerTitle(enterprisename, customControlKey);
        }
    }

    public void queryBuyerTitle(String ars, String key) {
        HashMap<String, Object> showDataMap = new HashMap<String, Object>(4);
        showDataMap.put("eventkey", "queryTitle");
        this.getPageCache().put("cacheBuyerName", ars);
        OpenInvoiceService openInvoiceService = new OpenInvoiceService();
        List companyInfos = openInvoiceService.queryCompany(ars);
        showDataMap.put("companyInfos", companyInfos);
        ViewUtil.bindDataToHtml((AbstractFormPlugin)this, showDataMap, (String)key);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        this.getModel().setValue("nextpagedata", (Object)SerializationUtils.toJsonString((Object)returnData));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (KEY_EP_QUALIFICATION.equals(e.getProperty().getName())) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            if ("1".equals(newValue) || "2".equals(newValue)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_TOBACCO_DATE});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_TOBACCO_DATE});
            }
        }
    }
}

