/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.equipment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResultImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.TaxUtils;

public class EquipmentListFilterListPlugin
extends AbstractListPlugin {
    private static final String epInfoCache = "epInfoCache";

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        HasPermOrgResultImpl result;
        super.filterContainerBeforeF7Select(args);
        if (args.getFieldName().startsWith("epinfo") && !(result = OrgHelper.getUserHasPermEpInfo()).hasAllOrgPerm()) {
            args.addCustomQFilter(OrgHelper.getIdFilter((Collection)result.getHasPermOrgs()));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            if (!commonFilterColumn.getFieldName().startsWith("epinfo")) continue;
            this.setEpInfoFilter(commonFilterColumn);
        }
    }

    private void setEpInfoFilter(FilterColumn commonFilterColumn) {
        CommonBaseDataFilterColumn epInfoFilter = (CommonBaseDataFilterColumn)commonFilterColumn;
        String orgListCacheString = this.getPageCache().get(epInfoCache);
        if ("hasAllOrgPerm".equals(orgListCacheString)) {
            this.selectEpInfo(epInfoFilter);
            return;
        }
        ArrayList<ComboItem> comboItems = epInfoFilter.getComboItems();
        if (StringUtils.isNotBlank((CharSequence)orgListCacheString)) {
            comboItems = SerializationUtils.fromJsonStringToList((String)orgListCacheString, ComboItem.class);
            epInfoFilter.setComboItems((List)comboItems);
        } else {
            HasPermOrgResultImpl userHasPermEpInfo = OrgHelper.getUserHasPermEpInfo();
            if (userHasPermEpInfo.hasAllOrgPerm()) {
                this.getPageCache().put(epInfoCache, "hasAllOrgPerm");
            } else {
                DynamicObject[] epInfos;
                comboItems = new ArrayList<ComboItem>(comboItems.size());
                for (DynamicObject epInfo : epInfos = BusinessDataServiceHelper.load((String)"bdm_enterprise_baseinfo", (String)String.join((CharSequence)",", "name", "id"), (QFilter[])OrgHelper.getIdFilter((Collection)userHasPermEpInfo.getHasPermOrgs()).toArray())) {
                    ComboItem item = new ComboItem();
                    item.setCaption(new LocaleString(epInfo.getString("name")));
                    item.setValue(String.valueOf(epInfo.getPkValue()));
                    comboItems.add(item);
                }
                epInfoFilter.setComboItems(comboItems);
                this.getPageCache().put(epInfoCache, SerializationUtils.toJsonString(comboItems));
            }
        }
        this.selectEpInfo(epInfoFilter);
    }

    private void selectEpInfo(CommonBaseDataFilterColumn epInfoFilter) {
        block3: {
            List comboItems = epInfoFilter.getComboItems();
            try {
                DynamicObject org;
                long epInfo;
                String epInfoIdStr = this.getPageCache().get(String.valueOf(RequestContext.get().getOrgId()));
                if (StringUtils.isBlank((CharSequence)epInfoIdStr) && (epInfo = DynamicObjectUtil.getDynamicObjectLongValue((Object)(org = TaxUtils.getOrgDynamicObject((Long)RequestContext.get().getOrgId())).get("epinfo"))) != 0L) {
                    epInfoIdStr = String.valueOf(epInfo);
                    this.getPageCache().put(String.valueOf(RequestContext.get().getOrgId()), epInfoIdStr);
                }
                epInfoFilter.setDefaultValue(epInfoIdStr);
            }
            catch (Exception e) {
                if (CollectionUtils.isEmpty((Collection)comboItems)) break block3;
                epInfoFilter.setDefaultValue(((ComboItem)comboItems.get(0)).getValue());
            }
        }
    }
}

