/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.goodsinfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;

public class UpdateGoodsInfoTaxClassCodePugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        String updatetype = (String)this.getView().getFormShowParameter().getCustomParam("updatetype");
        if (StringUtils.isNotBlank((CharSequence)updatetype)) {
            this.getModel().setValue("updatetype", (Object)updatetype);
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        this.addClickListeners(new String[]{"btncancel"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if ("btnok".equals(source.getKey())) {
            String updateType = (String)this.getModel().getValue("updatetype");
            if ("splitRule".equals(updateType)) {
                this.updateSplitRule();
            } else if ("mergerule".equalsIgnoreCase(updateType)) {
                this.updateMergeRule();
            } else if ("goodsinfo".equals(updateType)) {
                this.updateGoodsInfo();
            } else {
                this.updateTaxCode();
            }
        }
    }

    private void updateMergeRule() {
        DynamicObject[] mergeRules = this.updateMergeRules();
        if (mergeRules == null) {
            return;
        }
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6210\u529f%s\u6761\u6570\u636e\u66f4\u65b0", (String)"UpdateGoodsInfoTaxClassCodePugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]), mergeRules.length), Integer.valueOf(2000));
    }

    public DynamicObject[] updateMergeRules() {
        this.updateDefaultMergeRule();
        QFilter qFilter = new QFilter("ctrlstrategy", "=", (Object)Character.valueOf(' ')).or("ctrlstrategy", "=", null);
        DynamicObject[] mergeRules = BusinessDataServiceHelper.load((String)"bdm_merge_rule_strategy", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_merge_rule_strategy", (boolean)true), (QFilter[])qFilter.toArray());
        if (mergeRules.length == 0) {
            return null;
        }
        for (DynamicObject mergeRule : mergeRules) {
            mergeRule.set("ctrlstrategy", (Object)"7");
            mergeRule.set("name", (Object)mergeRule.getString("name"));
            mergeRule.set("status", (Object)BillStatusEnum.AUDIT_SUCCESS.getCode());
            DynamicObject org = mergeRule.getDynamicObject("org");
            if (null != org) {
                String orgNumber = org.getString("number") + "_";
                mergeRule.set("number", (Object)(orgNumber + mergeRule.getString("number").replace(orgNumber, "")));
                mergeRule.set("createorg", (Object)org);
            }
            BaseDataServiceHelper.baseDataCtrlChangeHandler((DynamicObject)mergeRule);
        }
        SaveServiceHelper.save((DynamicObject[])mergeRules);
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"invsm_param_configuration");
        this.updateSuccess(object, "merge_rule");
        return mergeRules;
    }

    public void updateDefaultMergeRule() {
        DynamicObject mergeRule = BusinessDataServiceHelper.loadSingleFromCache((String)"bdm_merge_rule_strategy", (String)"", (QFilter[])new QFilter("id", "=", (Object)1610822718469790720L).toArray());
        if (mergeRule != null) {
            mergeRule = BusinessDataServiceHelper.loadSingle((Object)mergeRule.getPkValue(), (String)"bdm_merge_rule_strategy");
            long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
            if (DynamicObjectUtil.getDynamicObjectLongValue((Object)mergeRule.get("createorg")) != rootOrgId) {
                mergeRule.set("createorg", (Object)rootOrgId);
                mergeRule.set("useorg", (Object)rootOrgId);
                mergeRule.set("org", (Object)rootOrgId);
                mergeRule.set("ctrlstrategy", (Object)"5");
                BaseDataServiceHelper.baseDataCtrlChangeHandler((DynamicObject)mergeRule);
                ImcSaveServiceHelper.save((DynamicObject)mergeRule);
            }
        }
    }

    private void updateSplitRule() {
        DynamicObject[] dynamicObjects = this.updateSplitRuleFromPlugin();
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6210\u529f%s\u6761\u6570\u636e\u66f4\u65b0", (String)"UpdateGoodsInfoTaxClassCodePugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]), dynamicObjects.length), Integer.valueOf(2000));
    }

    public DynamicObject[] updateSplitRuleFromPlugin() {
        DynamicObject[] splitRules;
        QFilter qFilter = new QFilter("ctrlstrategy", "=", (Object)Character.valueOf(' '));
        for (DynamicObject splitRule : splitRules = BusinessDataServiceHelper.load((String)"bdm_inv_split_rule_strate", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_inv_split_rule_strate", (boolean)true), (QFilter[])qFilter.toArray())) {
            splitRule.set("ctrlstrategy", (Object)"7");
            splitRule.set("name", (Object)splitRule.getString("name"));
            splitRule.set("status", (Object)BillStatusEnum.AUDIT_SUCCESS.getCode());
            DynamicObject org = splitRule.getDynamicObject("org");
            if (null != org) {
                String orgNumber = org.getString("number") + "_";
                splitRule.set("number", (Object)(orgNumber + splitRule.getString("number").replace(orgNumber, "")));
                splitRule.set("createorg", (Object)org);
            }
            BaseDataServiceHelper.baseDataCtrlChangeHandler((DynamicObject)splitRule);
        }
        SaveServiceHelper.save((DynamicObject[])splitRules);
        this.updateDefaultSplitRule();
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"invsm_param_configuration");
        this.updateSuccess(object, "split_rule");
        return splitRules;
    }

    public void updateDefaultSplitRule() {
        DynamicObject splitRule = BusinessDataServiceHelper.loadSingleFromCache((String)"bdm_inv_split_rule_strate", (String)"", (QFilter[])new QFilter("id", "=", (Object)1L).toArray());
        if (splitRule != null) {
            splitRule = BusinessDataServiceHelper.loadSingle((Object)splitRule.getPkValue(), (String)"bdm_inv_split_rule_strate");
            long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
            if (DynamicObjectUtil.getDynamicObjectLongValue((Object)splitRule.get("createorg")) != rootOrgId) {
                splitRule.set("createorg", (Object)rootOrgId);
                splitRule.set("useorg", (Object)rootOrgId);
                splitRule.set("org", (Object)rootOrgId);
                splitRule.set("ctrlstrategy", (Object)"5");
                BaseDataServiceHelper.baseDataCtrlChangeHandler((DynamicObject)splitRule);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{splitRule});
            }
        }
    }

    private void updateSuccess(DynamicObject object, String bdmGoodsInfo) {
        object.set("config_type", (Object)bdmGoodsInfo);
        object.set("config_key", (Object)"update");
        object.set("config_value", (Object)"1");
        ImcSaveServiceHelper.save((DynamicObject)object);
    }

    private void updateTaxCode() {
        DynamicObjectCollection goodsInfos = QueryServiceHelper.query((String)"bdm_goods_info", (String)"id,taxcode", (QFilter[])new QFilter[0]);
        int i = 0;
        for (DynamicObject goodsInfo : goodsInfos) {
            QFilter qFilter = new QFilter("id", "=", (Object)goodsInfo.getLong("taxcode"));
            DynamicObject taxRateCode = BusinessDataServiceHelper.loadSingle((String)"bdm_taxrate_code", (String)"id", (QFilter[])qFilter.toArray());
            if (null == taxRateCode) continue;
            String taxCode = goodsInfo.getString("taxcode").substring(1);
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bdm_goods_info");
            dynamicObject.set("id", goodsInfo.get("id"));
            dynamicObject.set("taxcode", (Object)Long.parseLong(taxCode));
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
            ++i;
        }
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6761\u6570\u636e\u66f4\u65b0\u6210\u529f", (String)"UpdateGoodsInfoTaxClassCodePugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]), i), Integer.valueOf(2000));
    }

    private void updateGoodsInfo() {
        String ctrlstrategy = (String)this.getModel().getValue("ctrlstrategy");
        String sql = "SELECT count(1) as count from t_bdm_goods_info where fshare != '2'";
        int count = 0;
        try (DataSet ds = DB.queryDataSet((String)"getGoodsInfoCount", (DBRoute)new DBRoute("taxc"), (String)sql);){
            if (ds != null) {
                count = ds.next().getLong("count").intValue();
            }
        }
        int pageSize = 5000;
        HashMap<Long, List> children = new HashMap<Long, List>(100);
        int totalPage = (count + pageSize - 1) / pageSize;
        for (int pageIndex = 0; pageIndex < totalPage; ++pageIndex) {
            DynamicObject[] goodsInfos = BusinessDataServiceHelper.load((String)"bdm_goods_info", (String)"", (QFilter[])new QFilter("share", "!=", (Object)"2").toArray(), (String)"id", (int)0, (int)pageSize);
            for (DynamicObject goodsInfo : goodsInfos = BusinessDataServiceHelper.load((Object[])Stream.of(goodsInfos).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdm_goods_info"))) {
                String[] orgIdArr;
                OrmLocaleValue name = (OrmLocaleValue)goodsInfo.get("name");
                if (name != null && StringUtils.isBlank((CharSequence)name.getLocaleValue())) {
                    goodsInfo.set("name", (Object)name.toString());
                }
                if ("private".equals(ctrlstrategy) || "all".equals(ctrlstrategy)) {
                    goodsInfo.set("share", (Object)"2");
                    goodsInfo.set("ctrlstrategy", (Object)("private".equals(ctrlstrategy) ? "7" : "5"));
                    BaseDataServiceHelper.baseDataCtrlChangeHandler((DynamicObject)goodsInfo);
                    continue;
                }
                long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)goodsInfo.get("org"));
                String share = goodsInfo.getString("share");
                String shareOrgs = goodsInfo.getString("shareorgstext_tag");
                if ("0".equals(share) && StringUtils.isBlank((CharSequence)shareOrgs)) {
                    goodsInfo.set("share", (Object)"2");
                    goodsInfo.set("ctrlstrategy", (Object)"7");
                    BaseDataServiceHelper.baseDataCtrlChangeHandler((DynamicObject)goodsInfo);
                    continue;
                }
                ArrayList<Long> dataIds = new ArrayList<Long>();
                dataIds.add(Long.parseLong(goodsInfo.getPkValue().toString()));
                if (StringUtils.isBlank((CharSequence)shareOrgs)) {
                    List childrenOrgIds = (List)children.get(orgId);
                    if (childrenOrgIds == null) {
                        childrenOrgIds = OrgHelper.getChildrenOrgIds((long)orgId, (boolean)false);
                        children.put(orgId, childrenOrgIds);
                    }
                    if (!CollectionUtils.isEmpty((Collection)childrenOrgIds)) {
                        goodsInfo.set("ctrlstrategy", (Object)"2");
                        BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject)goodsInfo, (Long)orgId);
                        BaseDataServiceHelper.batchAssignWithDetail((String)"bdm_goods_info", (Long)orgId, dataIds, (List)childrenOrgIds);
                    }
                    goodsInfo.set("share", (Object)"2");
                    continue;
                }
                HashSet<Long> orgIds = new HashSet<Long>();
                for (String orgIdStr : orgIdArr = shareOrgs.split(",")) {
                    if (!StringUtils.isNotBlank((CharSequence)orgIdStr)) continue;
                    orgIds.add(Long.parseLong(orgIdStr));
                }
                if (orgIds.size() > 0) {
                    goodsInfo.set("ctrlstrategy", (Object)"2");
                    BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject)goodsInfo, (Long)orgId);
                    BaseDataServiceHelper.batchAssignWithDetail((String)"bdm_goods_info", (Long)orgId, dataIds, new ArrayList(orgIds));
                }
                goodsInfo.set("share", (Object)"2");
            }
            ImcSaveServiceHelper.save((DynamicObject[])goodsInfos);
        }
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"invsm_param_configuration");
        this.updateSuccess(object, "bdm_goods_info");
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u5f00\u7968\u9879\u6210\u529f", (String)"UpdateGoodsInfoTaxClassCodePugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
    }
}

