/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.goodsinfo;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.table.GoodsInfoConstant;
import kd.imc.bdm.common.util.MaterialInfoUtil;
import kd.imc.bdm.formplugin.goodsinfoctrlstrategy.contorller.GoodsInfoUintController;

public class UpdateUnitRatePlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"btnok"});
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            this.updateRate();
        }
    }

    private void updateRate() {
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("bdmorg");
        DynamicObjectCollection selectMaterials = (DynamicObjectCollection)this.getModel().getValue("material");
        ArrayList selectMaterialsPks = Lists.newArrayList();
        ArrayList selectMaterialsNumberLists = Lists.newArrayList();
        List selectOrgPks = orgs.stream().map(e -> e.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        int row = (Integer)this.getModel().getValue("row");
        for (DynamicObject selectMaterial : selectMaterials) {
            selectMaterialsPks.add(selectMaterial.getDynamicObject("fbasedataid").getPkValue());
            selectMaterialsNumberLists.add(selectMaterial.getDynamicObject("fbasedataid").getString("name"));
        }
        QFilter qFilter = new QFilter("org", "in", selectOrgPks);
        DynamicObject[] goodsInfos = BusinessDataServiceHelper.load((String)"bdm_goods_info", (String)GoodsInfoConstant.SELECT_PROPERTIES, (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty(selectOrgPks)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u8fdb\u884c\u4fee\u6539", (String)"UpdateUnitRatePlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (CollectionUtils.isEmpty((Collection)selectMaterialsPks)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u8fdb\u884c\u4fee\u6539", (String)"UpdateUnitRatePlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (goodsInfos.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u53ef\u4fee\u6539\u4fe1\u606f", (String)"UpdateUnitRatePlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList updateList = Lists.newArrayListWithCapacity((int)goodsInfos.length);
        StringBuilder sb = new StringBuilder();
        HashSet materialSet = Sets.newHashSet();
        int failCount = 0;
        for (DynamicObject goodsInfo : goodsInfos) {
            boolean isUpdate = false;
            DynamicObjectCollection items = goodsInfo.getDynamicObjectCollection("bdm_goods_info_item");
            for (DynamicObject item : items) {
                if (!GoodsInfoConstant.SourceTypeEnum.MATERIAL.getCode().equals(item.getString("sourcetype"))) continue;
                materialSet.add(item.getDynamicObject("material_no").getString("name"));
                Object pkValue = item.getDynamicObject("material_no").getPkValue();
                if (!selectMaterialsPks.contains(pkValue)) continue;
                DynamicObject[] units = MaterialInfoUtil.querySourceUnitByMater((Object)pkValue, null);
                if (units.length < row) {
                    ++failCount;
                    sb.append(String.format(ResManager.loadKDString((String)"[%1$s]\u7ec4\u7ec7\u4e0b\u7684\u7269\u6599:%2$s \u672a\u627e\u5230\u5355\u4f4d\u4fe1\u606f\uff0c\u8bf7\u6838\u5b9e", (String)"UpdateUnitRatePlugin_6", (String)"imc-bdm-formplugin", (Object[])new Object[0]), goodsInfo.getString("org.name"), item.getString("material_no.name"))).append(System.lineSeparator());
                    continue;
                }
                DynamicObject unit = units[row - 1];
                item.set("baseunit", unit.get("measureunitid"));
                String modelNumRate = GoodsInfoUintController.getModelNumRate(unit);
                item.set("modelnum_rate", (Object)modelNumRate);
                isUpdate = true;
            }
            if (!isUpdate) continue;
            updateList.add(goodsInfo);
        }
        for (String number : selectMaterialsNumberLists) {
            if (materialSet.contains(number)) continue;
            sb.append(String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\uff1a%s \u672a\u914d\u7f6e\u5f00\u7968\u9879\uff0c\u8bf7\u6838\u5b9e", (String)"UpdateUnitRatePlugin_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]), number)).append(System.lineSeparator());
            ++failCount;
        }
        if (!CollectionUtils.isEmpty((Collection)updateList)) {
            SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
        this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6210\u529f\u66f4\u65b0%1$s\u6761\u6570\u636e,\u5931\u8d25%2$s\u6761", (String)"UpdateUnitRatePlugin_7", (String)"imc-bdm-formplugin", (Object[])new Object[0]), updateList.size(), failCount), sb.toString(), MessageTypes.Commit);
    }
}

