/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.invoicetitle.strategy;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;

public class InvoiceIssueTitleAdrCtrPlugin
extends AbstractFormPlugin {
    private static final String fields = "taxno,items.itemaddr,items.itemopeningbank,items.itemmobilephone,items.itememail,items.isdefault";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeBindData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object buyerName = customParams.get("name");
        Object orgId = customParams.get("orgId");
        QFilter qFilter = new QFilter("name", "=", buyerName);
        QFilter baseDataFilter = ImcBaseDataHelper.getInvTitleFilter(orgId);
        qFilter.and(baseDataFilter);
        DynamicObject[] fpyTitleColl = BusinessDataServiceHelper.load((String)"bdm_invice_title_strate", (String)fields, (QFilter[])qFilter.toArray());
        if (fpyTitleColl != null && fpyTitleColl.length == 1) {
            DynamicObjectCollection items = fpyTitleColl[0].getDynamicObjectCollection("items");
            for (int i = 0; i < items.size(); ++i) {
                DynamicObject item = (DynamicObject)items.get(i);
                if (i > 0) {
                    this.getModel().createNewEntryRow("entryentity");
                }
                this.getModel().setValue("taxno", fpyTitleColl[0].get("taxno"), i);
                this.getModel().setValue("addr", item.get("itemaddr"), i);
                this.getModel().setValue("openingbank", item.get("itemopeningbank"), i);
                this.getModel().setValue("mobilephone", item.get("itemmobilephone"), i);
                this.getModel().setValue("email", item.get("itememail"), i);
                this.getModel().setValue("isdefault", item.get("isdefault"), i);
            }
        }
        this.getModel().clearNoDataRow();
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
            if (selectRows == null || selectRows.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"InvoiceIssueTitleAdrCtrPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (selectRows.length == 1) {
                HashMap<String, Object> returnData = new HashMap<String, Object>();
                DynamicObject item = (DynamicObject)entity.get(selectRows[0]);
                returnData.put("buyeraddr", item.get("addr"));
                returnData.put("buyerbank", item.get("openingbank"));
                returnData.put("buyerphone", item.get("mobilephone"));
                returnData.put("buyeremail", item.get("email"));
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            }
        }
    }
}

