/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.invoicetypemanage;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.SchemeHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;

public class InvoiceTypeManageFormPlugin
extends AbstractFormPlugin {
    private Set<String> filterList = new HashSet<String>(Arrays.asList("buyername", "buyertaxno", "invoiceamount", "jqbh", "billsource", "orgid.number"));
    private static final String filterAp = "filtergridap";

    public void beforeBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(filterAp);
        filterGrid.setEntityNumber("sim_original_bill");
    }

    public void afterBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(filterAp);
        try {
            String extFilterField = ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.BDM_INVOICE_TYPE_MANAGE_FIELD);
            if (StringUtils.isNotBlank((CharSequence)extFilterField)) {
                this.filterList.addAll(Arrays.asList(extFilterField.split(",")));
            }
        }
        catch (Exception extFilterField) {
            // empty catch block
        }
        List fieldColumns = filterGrid.getFilterColumns();
        Map buyerTaxNoField = null;
        Iterator iterator = fieldColumns.iterator();
        while (iterator.hasNext()) {
            Map fieldColumn2 = (Map)iterator.next();
            String fieldName = (String)fieldColumn2.get("fieldName");
            if (!this.filterList.contains(fieldName)) {
                iterator.remove();
                continue;
            }
            if (!"buyertaxno".equals(fieldName)) continue;
            String tipMsg = ResManager.loadKDString((String)"\u8d2d\u65b9\u7a0e\u53f7", (String)"InvoiceTypeManageFormPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
            fieldColumn2.put("fieldCaption", tipMsg);
            buyerTaxNoField = fieldColumn2;
        }
        if (buyerTaxNoField != null) {
            Map finalBuyerTaxNoField = buyerTaxNoField;
            fieldColumns.stream().filter(fieldColumn -> "jqbh".equals(fieldColumn.get("fieldName"))).findFirst().ifPresent(fieldColumn -> {
                fieldColumn.put("type", "text");
                fieldColumn.put("compareGroupID", finalBuyerTaxNoField.get("compareGroupID"));
                fieldColumn.put("compareTypes", finalBuyerTaxNoField.get("compareTypes"));
                fieldColumn.put("entityId", finalBuyerTaxNoField.get("entityId"));
                fieldColumn.put("fieldType", finalBuyerTaxNoField.get("fieldType"));
                fieldColumn.remove("items");
            });
        }
        filterGrid.setFilterColumns(fieldColumns);
        String filterStr = (String)this.getModel().getValue("filter_tag");
        if (StringUtils.isNotBlank((CharSequence)filterStr)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
            filterGrid.SetValue(filterCondition);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"save", (CharSequence)((FormOperate)args.getSource()).getOperateKey())) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(filterAp);
            String filterStr = SchemeHelper.getFilterStr((FilterGrid)filterGrid);
            this.getModel().setValue("filter_tag", (Object)filterStr);
        }
    }
}

