/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.issuepolicy;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.ViewUtil;

public class BizControlFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"account"});
        this.addItemClickListeners(new String[]{"advcontoolbarap1"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "account": {
                DynamicObject orgDynamicObject = (DynamicObject)this.getModel().getValue("org");
                SaleInfo saleInfoByOrg = TaxUtils.getSaleInfoByOrg((Long)orgDynamicObject.getLong("id"));
                if (saleInfoByOrg == null) {
                    String tipMsg2 = ResManager.loadKDString((String)"\u7ec4\u7ec7\u8fd8\u672a\u914d\u7f6e\u4f01\u4e1a", (String)"BizControlFormPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(tipMsg2);
                    return;
                }
                HashMap<String, String> customParams = new HashMap<String, String>();
                customParams.put("taxNo", saleInfoByOrg.getSaleTaxNo());
                ViewUtil.openDialog((AbstractFormPlugin)this, customParams, (String)"bdm_choose_account_dialog", (String)"chooseAccount");
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "newentry": {
                this.getModel().setValue("channelenable", (Object)false);
            }
        }
    }

    public void createNewData(BizDataEventArgs e) {
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getModel().getValue("org") == null) {
            this.getModel().setValue("useorg", (Object)RequestContext.get().getOrgId());
            this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        switch (e.getProperty().getName()) {
            case "useorg": {
                this.getModel().setValue("useorg", this.getModel().getValue("org"));
                break;
            }
            case "channeltype": {
                this.getModel().setValue("account", null);
                this.getModel().setValue("drawer", null);
                this.getModel().setValue("devno", null);
                break;
            }
            case "channelenable": {
                EntryGrid entryentity1;
                if (!this.getModel().getValue("channelenable").toString().equals("true") || (entryentity1 = (EntryGrid)this.getView().getControl("entrychannel")).getEntryData().getEndIndex() == 0) break;
                this.getModel().setValue("channelenable", (Object)false);
                String tipMsg2 = ResManager.loadKDString((String)"\u5df2\u586b\u5f00\u7968\u901a\u9053\uff0c\u4e0d\u53ef\u9009\u62e9\u2018\u5168\u90e8\u901a\u9053\u53ef\u7528\u2019", (String)"BizControlFormPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tipMsg2);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("chooseAccount".equals(actionId)) {
            HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            EntryGrid entryentity = (EntryGrid)this.getView().getControl("entrychannel");
            int[] selectRows = entryentity.getSelectRows();
            for (Map.Entry entry : returnData.entrySet()) {
                this.getModel().setValue((String)entry.getKey(), entry.getValue(), selectRows[0]);
            }
        }
    }
}

