/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.issuesetting;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.helper.HiddenButtonHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.common.util.ViewUtil;

public class DrawerStrategyListPlugin
extends AbstractListPlugin {
    private String FORM_ID = "bdm_strategy_detail";

    public void afterCreateNewData(EventObject e) {
        HiddenButtonHelper.hideClose((AbstractFormPlugin)this, (String[])new String[]{"exit"});
        DynamicObject[] allStrategys = BusinessDataServiceHelper.load((String)"bdm_drawer_strategy", (String)"item.useorg,orgid", null);
        ArrayList<Object> pks = new ArrayList<Object>();
        for (DynamicObject strategy : allStrategys) {
            DynamicObjectCollection collection = strategy.getDynamicObjectCollection("item");
            if (collection.size() > 0 || strategy.getLong("orgid") == 0L) continue;
            pks.add(strategy.getPkValue());
        }
        DynamicObject[] dealOjbs = BusinessDataServiceHelper.load((String)"bdm_drawer_strategy", (String)"item,item.useorg,orgid,number", (QFilter[])new QFilter("id", "in", pks).toArray());
        ArrayList<DynamicObject> dealList = new ArrayList<DynamicObject>();
        String format = DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
        long num = Long.parseLong(format);
        for (DynamicObject value : dealOjbs) {
            DynamicObjectCollection items = value.getDynamicObjectCollection("item");
            value.set("number", (Object)("No" + num++));
            DynamicObject row = items.addNew();
            row.set("useorg", (Object)value.getLong("orgid"));
            dealList.add(value);
        }
        if (dealList.size() > 0) {
            ImcSaveServiceHelper.save(dealList);
        }
    }

    public void setFilter(SetFilterEvent e) {
        List orgIds = OrgHelper.getChildrenOrgIds((long)RequestContext.get().getOrgId(), (boolean)true);
        e.addCustomQFilter(new QFilter("item.useorg", "in", (Object)orgIds));
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "new": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.ITEM_NEW);
                ViewUtil.openMainNewTabPage((AbstractFormPlugin)this, (String)UUID.randomUUID(), null, (String)this.FORM_ID, (String)this.FORM_ID);
                break;
            }
            case "delete": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.ITEM_DELETE);
                break;
            }
            case "edit": {
                this.edit();
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRow row = billList.getCurrentSelectedRowInfo();
        HashMap<String, Object> obj = new HashMap<String, Object>(1);
        obj.put("id", row.getPrimaryKeyValue());
        ViewUtil.openMainNewTabPage((AbstractFormPlugin)this, null, obj, (String)"bdm_strategy_detail", (String)"bdm_strategy_detail", (String)ResManager.loadKDString((String)"\u7b56\u7565\u8be6\u60c5", (String)"DrawerStrategyListPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
    }

    private void edit() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7f16\u8f91\u7684\u6570\u636e!", (String)"DrawerStrategyListPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        if (rows.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u7f16\u8f91!", (String)"DrawerStrategyListPlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        this.getView().invokeOperation("refresh");
    }
}

