/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.issuesetting;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.SchemeHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.ModelUtil;
import kd.imc.bdm.common.util.ViewUtil;
import org.apache.commons.lang3.StringUtils;

public class InvoiceSettingEditPlugin
extends AbstractFormPlugin {
    public static final String FILTER_GRIDAP = "filtergridap";
    public static final String CACHE_KEY_SAVE_DEFAULT = "cache_key_save_default";
    private static final String SHOP_NO = "shop_no";
    private static final String SHOP_REFERRED = "shop_referred";
    private static final String INVOICE_ADDR = "invoiceaddr";
    private static final String OPEN_USERBANK = "openuserbank";
    private static final String[] DATAS = new String[]{"shop_no", "shop_referred", "invoiceaddr", "openuserbank"};

    public void afterCreateNewData(EventObject e) {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        Object pkValue = this.getView().getFormShowParameter().getCustomParam("id");
        ModelUtil.setModelValueFromMap((Map)map, (AbstractFormPlugin)this);
        this.getModel().setValue(SHOP_NO, (Object)map.getOrDefault(SHOP_NO, ""));
        this.getModel().setValue(SHOP_REFERRED, (Object)map.getOrDefault(SHOP_REFERRED, ""));
        this.getModel().setValue("ischeck", (Object)map.getOrDefault("ischeck", Boolean.FALSE));
        this.getView().setVisible(Boolean.FALSE, new String[]{"priority"});
        this.setFilterGrid(pkValue);
    }

    private void setFilterGrid(Object pkValue) {
        String filterTag;
        DynamicObject invoiceSetting;
        if (pkValue != null && Objects.nonNull(invoiceSetting = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"sim_invoice_setting")) && StringUtils.isNotBlank((CharSequence)(filterTag = invoiceSetting.getString("filter_tag")))) {
            SchemeHelper.setLocal((String)filterTag);
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if ("btnok".equals(source.getKey())) {
            for (String data : DATAS) {
                this.getModel().setValue(data, (Object)this.getModel().getValue(data).toString().trim());
            }
            this.saveInvoiceSetting();
        }
    }

    private void saveInvoiceSetting() {
        DynamicObject obj;
        Object pkValue = this.getView().getFormShowParameter().getCustomParam("id");
        boolean hasDefault = false;
        QFilter qFilter = new QFilter("taxno", "=", this.getView().getFormShowParameter().getCustomParam("taxno"));
        if (pkValue != null) {
            qFilter.and("id", "!=", (Object)Long.valueOf(pkValue.toString()));
            obj = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"sim_invoice_setting");
        } else {
            obj = BusinessDataServiceHelper.newDynamicObject((String)"sim_invoice_setting");
            obj.set("ischeck", (Object)"0");
            obj.set("taxno", this.getView().getFormShowParameter().getCustomParam("taxno"));
        }
        DynamicObjectCollection ids = new DynamicObjectCollection();
        if (Boolean.parseBoolean(this.getModel().getValue("ischeck").toString())) {
            qFilter.and("ischeck", "=", (Object)"1");
            ids = QueryServiceHelper.query((String)"sim_invoice_setting", (String)"id", (QFilter[])qFilter.toArray());
        }
        if (!ids.isEmpty()) {
            hasDefault = true;
        }
        String invoiceAddr = (String)this.getModel().getValue(INVOICE_ADDR);
        String openUseBank = (String)this.getModel().getValue(OPEN_USERBANK);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTER_GRIDAP);
        filterGrid.addClickListener((ClickListener)this);
        String filterStr = SchemeHelper.getFilterStr((FilterGrid)filterGrid);
        String tipMsg1 = ResManager.loadKDString((String)"\u5730\u5740\u7535\u8bdd", (String)"InvoiceSettingFormPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        String tipMsg2 = ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7", (String)"InvoiceSettingFormPlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        GBKUtils.CheckGBKLength((String)invoiceAddr, (String)tipMsg1, (int)100);
        GBKUtils.CheckGBKLength((String)openUseBank, (String)tipMsg2, (int)100);
        obj.set(INVOICE_ADDR, (Object)invoiceAddr);
        obj.set(OPEN_USERBANK, (Object)openUseBank);
        obj.set(SHOP_NO, this.getModel().getValue(SHOP_NO));
        obj.set(SHOP_REFERRED, this.getModel().getValue(SHOP_REFERRED));
        obj.set("filter_tag", (Object)filterStr);
        if (hasDefault) {
            obj.set("ischeck", (Object)"1");
            this.getPageCache().put(CACHE_KEY_SAVE_DEFAULT, DynamicObjectUtil.dynamicObject2Json((DynamicObject)obj).toJSONString());
            this.getPageCache().put("taxno", obj.getString("taxno"));
            ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u9ed8\u8ba4\u8bbe\u7f6e\uff0c\u662f\u5426\u66ff\u6362?", (String)"InvoiceSettingEditPlugin_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]), (String)"sim_save_default");
            return;
        }
        ImcSaveServiceHelper.save((DynamicObject)obj);
        this.getView().returnDataToParent((Object)"refresh");
        this.getView().close();
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        if (callBackId.equals("sim_save_default") && event.getResult() == MessageBoxResult.Yes) {
            DynamicObject[] load;
            String objString = this.getPageCache().get(CACHE_KEY_SAVE_DEFAULT);
            JSONObject jsonObject = JSONObject.parseObject((String)objString);
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"sim_invoice_setting");
            DynamicObjectUtil.json2DynamicObjectContainItems((JSONObject)jsonObject, (DynamicObject)object);
            QFilter addrFilter = new QFilter("taxno", "=", (Object)this.getPageCache().get("taxno"));
            for (DynamicObject obj : load = BusinessDataServiceHelper.load((String)"sim_invoice_setting", (String)"ischeck", (QFilter[])addrFilter.toArray())) {
                obj.set("ischeck", (Object)"0");
            }
            SaveServiceHelper.update((DynamicObject[])load);
            ImcSaveServiceHelper.save((DynamicObject)object);
            this.getPageCache().remove(CACHE_KEY_SAVE_DEFAULT);
            this.getView().returnDataToParent((Object)"refresh");
            this.getView().close();
        }
    }

    public void beforeBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTER_GRIDAP);
        if (Objects.nonNull(filterGrid)) {
            List fieldKeys = SchemeHelper.getFieldKeys();
            SchemeHelper.initializeFilterGrid((FilterGrid)filterGrid, (List)fieldKeys, (String)"sim_original_bill");
        }
    }

    public void afterBindData(EventObject e) {
        this.bindFilterGridData();
    }

    private void bindFilterGridData() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTER_GRIDAP);
        FilterCondition filterCondition = null;
        String s = SchemeHelper.getLocal();
        if (StringUtils.isNotBlank((CharSequence)s)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)s, FilterCondition.class);
        }
        if (filterCondition != null) {
            filterGrid.SetValue(filterCondition);
        }
    }
}

