/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.issuesetting;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResultImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.table.BdmIssueInvSettingConstant;
import kd.imc.bdm.common.helper.FieldSelectHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.helper.cache.MsgAuthSettingCacheHelper;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.ComboEditUtil;
import kd.imc.bdm.common.util.ModelUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.bdm.formplugin.issuesetting.control.HSAmountConfigControl;

public class InvoiceSettingTabPlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(InvoiceSettingTabPlugin.class);
    public static final String IS_COMPLETE = "iscomplete";
    public static final String GOODSINFO_COMPLETION = "GOODSINFO_COMPLETION";

    public void preOpenForm(PreOpenFormEventArgs e) {
        OrgHelper.checkOrgIsImport((PreOpenFormEventArgs)e);
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"inv_item_setting_tool", "invtitlesettingtool", "batch_issue_toolbarap"});
        this.addItemClickListeners(new String[]{"msgauthtool"});
        BasedataEdit edit = (BasedataEdit)this.getView().getControl("epinfo");
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"taxtool", "advcontoolbarap1", "pdfdownloadnametool", "advcontoolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "goodsinforulesave": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.ITEM_SAVE);
                this.invItemConfigSave();
                break;
            }
            case "batchrulesave": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.ITEM_SAVE);
                this.issueInvSettingSave();
                break;
            }
            case "invtitlesettingsave": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.ITEM_SAVE);
                this.invTitleSettingSaveOrUpdate();
                break;
            }
            case "batchrulecancel": 
            case "goodsinforulecancel": 
            case "invtitlesettingcancel": {
                this.flexShowOrHidden(key, false);
                break;
            }
            case "batchruleedit": 
            case "goodsinforuleedit": 
            case "invtitlesettingedit": {
                this.flexShowOrHidden(key, true);
                break;
            }
            case "sendepinfoadd": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.ITEM_NEW);
                this.getModel().createNewEntryRow("sendepinfo");
                break;
            }
            case "sendepinfodel": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.ITEM_DELETE);
                this.deleteEntryRows("sendepinfo");
                break;
            }
            case "msgsave": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.ITEM_SAVE);
                this.msgSendAuthSettingSave();
                break;
            }
            case "settingsave": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.ITEM_SAVE);
                this.checkPhoneAndEmailSave();
                break;
            }
            case "btn_field_set": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.ITEM_SAVE);
                this.setPDFName();
                break;
            }
            case "btn_field_save": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.ITEM_SAVE);
                this.savePDFName();
                break;
            }
            case "splitamountsave": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.ITEM_SAVE);
                HSAmountConfigControl.handleItemClickSplitAmountSave(this, this.getView());
                break;
            }
            case "amountconfigaddrow": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.ITEM_NEW);
                HSAmountConfigControl.addRow(this);
                break;
            }
            case "amountconfigdeleterow": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.ITEM_DELETE);
                HSAmountConfigControl.deleteRow(this);
            }
        }
    }

    private void checkPhoneAndEmailSave() {
        Object checkphone;
        long orgId = RequestContext.get().getOrgId();
        DynamicObject setting = this.loadSetting();
        if (null == setting) {
            setting = BusinessDataServiceHelper.newDynamicObject((String)"bdm_msg_auth_setting");
        }
        if (StringUtils.isBlank((Object)(checkphone = this.getModel().getValue("checkphone")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u63a8\u9001\u8bbe\u7f6e\uff01", (String)"InvoiceSettingTabPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        setting.set("checkphone", checkphone);
        setting.set("orgId", (Object)orgId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{setting});
        MsgAuthSettingCacheHelper.deleteCacheByOry((long)orgId);
        this.getView().invokeOperation("refresh");
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u7535\u7968\u63a8\u9001\u8bbe\u7f6e\u6210\u529f\uff01", (String)"InvoiceSettingTabPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
    }

    private DynamicObject loadSetting() {
        long orgId = RequestContext.get().getOrgId();
        QFilter filter = new QFilter("orgid", "=", (Object)orgId);
        return BusinessDataServiceHelper.loadSingle((String)"bdm_msg_auth_setting", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_msg_auth_setting"), (QFilter[])filter.toArray());
    }

    private void initCheckPhoneAndEmail() {
        DynamicObject setting = this.loadSetting();
        if (Objects.nonNull(setting)) {
            this.getModel().setValue("checkphone", setting.get("checkphone"));
        }
    }

    private void invTitleSettingSaveOrUpdate() {
        DynamicObject obj;
        Object pk = this.getModel().getValue("inv_title_setting_ids");
        if (StringUtils.isBlank((Object)pk)) {
            obj = BusinessDataServiceHelper.newDynamicObject((String)"bdm_inv_title_setting");
        } else {
            QFilter filter = new QFilter("id", "=", (Object)Long.valueOf(String.valueOf(pk)));
            obj = BusinessDataServiceHelper.loadSingle((String)"bdm_inv_title_setting", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_inv_title_setting", (boolean)true), (QFilter[])filter.toArray());
            if (obj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u66f4\u65b0,\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5\u3002", (String)"InvoiceSettingTabPlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                return;
            }
            obj.set("id", pk);
        }
        obj.set("single_invoice", this.getModel().getValue("single_inv"));
        obj.set("batch_invoice", this.getModel().getValue("batch_inv"));
        obj.set("api_invoice", this.getModel().getValue("api_inv"));
        obj.set("split_merge_invoice", this.getModel().getValue("split_merge_inv"));
        obj.set("scan_invoice", this.getModel().getValue("scan_inv"));
        obj.set("org", (Object)RequestContext.get().getOrgId());
        obj.set("tit_mapp_bill_push", this.getModel().getValue("tit_mapp_bill_push"));
        obj.set("tit_mapp_bill_import", this.getModel().getValue("tit_mapp_bill_import"));
        obj.set("forcemapping", this.getModel().getValue("forcemapping"));
        obj.set(IS_COMPLETE, this.getModel().getValue(IS_COMPLETE));
        ImcSaveServiceHelper.save((DynamicObject)obj);
        CacheHelper.remove((String)("INV_TITLE_SETTING_" + RequestContext.get().getOrgId()));
        this.getView().invokeOperation("refresh");
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"InvoiceSettingTabPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
    }

    private void savePDFName() {
        QFilter qfilter = new QFilter("org", "=", (Object)RequestContext.get().getOrgId());
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"bdm_pdf_download_rename", (String)"", (QFilter[])qfilter.toArray());
        if (obj == null) {
            obj = BusinessDataServiceHelper.newDynamicObject((String)"bdm_pdf_download_rename");
            obj.set("creater", (Object)RequestContext.get().getUserId());
            obj.set("createdate", (Object)new Date());
            obj.set("org", (Object)RequestContext.get().getOrgId());
        } else {
            obj = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)"bdm_pdf_download_rename");
            obj.set("modifier", (Object)RequestContext.get().getUserId());
            obj.set("modifydate", (Object)new Date());
        }
        obj.set("nowinvoicepdfname", this.getModel().getValue("nowinvoicepdfname"));
        obj.set("invoicepdfseparator", this.getModel().getValue("invoicepdfseparator"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"PDF\u4e0b\u8f7d\u547d\u540d\u4fdd\u5b58\u6210\u529f", (String)"InvoiceSettingTabPlugin_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        this.getView().invokeOperation("refresh");
    }

    private void setPDFName() {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("filename", this.getModel().getValue("nowinvoicepdfname"));
        map.put("filedMap", JSON.toJSONString((Object)FieldSelectHelper.getInvoiceFieldMap()));
        String tipMsg = ResManager.loadKDString((String)"\u53d1\u7968\u547d\u540d\u5b57\u6bb5\u9009\u62e9", (String)"InvoiceSettingTabPlugin_18", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        ViewUtil.openDialog((AbstractFormPlugin)this, (String)tipMsg, map, (String)"bdm_mail_field_setting", (String)"pdfNameCallBack");
    }

    private void msgSendAuthSettingSave() {
        boolean sendMsgFlag = (Boolean)this.getModel().getValue("msgswitch");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("sendepinfo");
        ArrayList newMsgSettingList = Lists.newArrayListWithCapacity((int)entryEntity.size());
        for (DynamicObject entry : entryEntity) {
            if (null == entry || null == entry.getDynamicObject("epinfo") || !StringUtils.isNotBlank((CharSequence)(entry.getDynamicObject("epinfo").get("number") + ""))) continue;
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bdm_send_epinfo_setting");
            obj.set("epinfo", (Object)entry.getDynamicObject("epinfo"));
            obj.set("filetype", (Object)entry.getString("filetype"));
            newMsgSettingList.add(obj);
        }
        if (sendMsgFlag && newMsgSettingList.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u77ed\u4fe1\u63a8\u9001\u670d\u52a1\u53c2\u6570\u5df2\u5f00\u542f\uff0c\u8bf7\u9009\u62e9\u9700\u8981\u4f7f\u7528\u77ed\u4fe1\u63a8\u9001\u670d\u52a1\u7684\u4f01\u4e1a\u3002", (String)"InvoiceSettingTabPlugin_6", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        try (TXHandle tx = TX.required();){
            try {
                QFilter filter = new QFilter("id", "=", (Object)1);
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"bdm_msg_auth_setting", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_msg_auth_setting"), (QFilter[])filter.toArray());
                if (null == obj) {
                    obj = BusinessDataServiceHelper.newDynamicObject((String)"bdm_msg_auth_setting");
                }
                obj.set("id", (Object)1);
                obj.set("msgswitch", (Object)sendMsgFlag);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                CacheHelper.remove((String)"sendMsgFlag");
                DeleteServiceHelper.delete((String)"bdm_send_epinfo_setting", (QFilter[])this.getUserHasPermEpInfoFilter());
                ImcSaveServiceHelper.save((List)newMsgSettingList);
                CacheHelper.removeAllSetValues((String)"msgAuthEpInfo");
                this.getView().invokeOperation("refresh");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u77ed\u4fe1\u63a8\u9001\u6743\u9650\u63a7\u5236\u6210\u529f\uff01", (String)"InvoiceSettingTabPlugin_7", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            }
            catch (Throwable e) {
                tx.markRollback();
                LOGGER.error("\u77ed\u4fe1\u6743\u9650\u63a7\u5236\u4fdd\u5b58\u5931\u8d25\uff01", e);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25,\u7cfb\u7edf\u5f02\u5e38,\u8bf7\u91cd\u8bd5\uff01", (String)"InvoiceSettingTabPlugin_9", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void issueInvSettingSave() {
        DynamicObject issueInvSetting = BusinessDataServiceHelper.loadSingle((String)"bdm_issue_inv_setting", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_issue_inv_setting"), (QFilter[])new QFilter("org", "=", (Object)RequestContext.get().getOrgId()).toArray());
        if (null == issueInvSetting) {
            issueInvSetting = BusinessDataServiceHelper.newDynamicObject((String)"bdm_issue_inv_setting");
        }
        ModelUtil.getModelValue2DynamicObject((DynamicObject)issueInvSetting, (AbstractFormPlugin)this);
        issueInvSetting.set("org", (Object)RequestContext.get().getOrgId());
        ImcSaveServiceHelper.save((DynamicObject)issueInvSetting);
        this.getView().invokeOperation("refresh");
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"InvoiceSettingTabPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
    }

    private void deleteEntryRows(String iden) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(iden);
        int[] rows = entryGrid.getSelectRows();
        if (rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u6570\u636e\uff01", (String)"InvoiceSettingTabPlugin_10", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        this.getModel().deleteEntryRows(iden, rows);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"batchrule", "goodsinforule", "invtitlesetting"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"batchruleflex", "goodsinforuleflex", "invtitlesettingflex"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"goodsinforulecancel", "goodsinforulesave", "batchrulecancel", "batchrulesave", "invtitlesettingcancel", "invtitlesettingsave"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"goodsinforuleedit", "batchruleedit", "invtitlesettingedit"});
        String taxNo = TaxUtils.getCurrentOrgTaxNo();
        this.getModel().setValue("taxno", (Object)taxNo);
        this.initGoodsInfoSetting();
        this.initBatchInvoiceSetting();
        this.initMsgSendAuthSetting();
        this.initInvTitleSetting();
        this.initPDFRename();
        this.initCheckPhoneAndEmail();
        HSAmountConfigControl.initHSAmountSplit(this);
    }

    private void initPDFRename() {
        QFilter qfilter = new QFilter("org", "=", (Object)RequestContext.get().getOrgId());
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"bdm_pdf_download_rename", (String)"", (QFilter[])qfilter.toArray());
        String invPdfName = "invoicecode,invoiceno";
        String invSeparator = "_";
        if (obj != null) {
            obj = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)"bdm_pdf_download_rename");
            invPdfName = obj.getString("nowinvoicepdfname");
            invSeparator = obj.getString("invoicepdfseparator");
        } else {
            this.initPdfNameSave();
        }
        this.getModel().setValue("nowinvoicepdfname", (Object)invPdfName);
        this.getModel().setValue("invoice_pdf_name", (Object)FieldSelectHelper.getShowFileNameBySelected((String)invPdfName, (String)invSeparator));
        this.getModel().setValue("invoicepdfseparator", (Object)invSeparator);
        this.getModel().setValue("separator", (Object)invSeparator);
    }

    public void initPdfNameSave() {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bdm_pdf_download_rename");
        obj.set("creater", (Object)RequestContext.get().getUserId());
        obj.set("createdate", (Object)new Date());
        obj.set("org", (Object)RequestContext.get().getOrgId());
        obj.set("nowinvoicepdfname", (Object)"invoicecode,invoiceno");
        obj.set("invoicepdfseparator", (Object)"_");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
    }

    private void initMsgSendAuthSetting() {
        DynamicObject[] epinfos;
        QFilter filter = new QFilter("id", "=", (Object)1);
        DynamicObject sendMsgAuthSetObj = QueryServiceHelper.queryOne((String)"bdm_msg_auth_setting", (String)"msgswitch", (QFilter[])filter.toArray());
        if (null != sendMsgAuthSetObj) {
            this.getModel().setValue("msgswitch", (Object)sendMsgAuthSetObj.getBoolean("msgswitch"));
        }
        if (null != (epinfos = BusinessDataServiceHelper.load((String)"bdm_send_epinfo_setting", (String)"epinfo,filetype", (QFilter[])this.getUserHasPermEpInfoFilter())) && epinfos.length > 0) {
            this.getModel().batchCreateNewEntryRow("sendepinfo", epinfos.length);
            for (int i = 0; i < epinfos.length; ++i) {
                this.getModel().setValue("epinfo", (Object)epinfos[i].getDynamicObject("epinfo"), i);
                String fileType = epinfos[i].getString("filetype");
                if (StringUtils.isEmpty((CharSequence)fileType)) {
                    fileType = "0";
                }
                this.getModel().setValue("filetype", (Object)fileType, i);
            }
        }
    }

    private QFilter[] getUserHasPermEpInfoFilter() {
        HasPermOrgResultImpl userHasPermEpInfo = OrgHelper.getUserHasPermEpInfo();
        QFilter qFilter = !userHasPermEpInfo.hasAllOrgPerm() ? OrgHelper.getIdFilter((Collection)userHasPermEpInfo.getHasPermOrgs(), (String)"epinfo") : new QFilter("1", "=", (Object)1);
        return qFilter.toArray();
    }

    private void initInvTitleSetting() {
        String invTitleSetFormId = "bdm_inv_title_setting";
        QFilter filter = new QFilter("org", "=", (Object)RequestContext.get().getOrgId());
        String selFields = PropertieUtil.getAllPropertiesSplitByComma((String)invTitleSetFormId, (boolean)true);
        DynamicObject invTitleSetObj = BusinessDataServiceHelper.loadSingle((String)invTitleSetFormId, (String)selFields, (QFilter[])filter.toArray());
        if (null != invTitleSetObj) {
            this.getModel().setValue("single_inv", invTitleSetObj.get("single_invoice"));
            this.getModel().setValue("batch_inv", invTitleSetObj.get("batch_invoice"));
            this.getModel().setValue("api_inv", invTitleSetObj.get("api_invoice"));
            this.getModel().setValue("split_merge_inv", invTitleSetObj.get("split_merge_invoice"));
            this.getModel().setValue("scan_inv", invTitleSetObj.get("scan_invoice"));
            this.getModel().setValue("tit_mapp_bill_push", invTitleSetObj.get("tit_mapp_bill_push"));
            this.getModel().setValue("tit_mapp_bill_import", invTitleSetObj.get("tit_mapp_bill_import"));
            this.getModel().setValue("forcemapping", invTitleSetObj.get("forcemapping"));
            this.getModel().setValue("inv_title_setting_ids", invTitleSetObj.get("id"));
            this.getModel().setValue(IS_COMPLETE, invTitleSetObj.get(IS_COMPLETE));
        }
        this.setInvTitleLabel();
    }

    private void setInvTitleLabel() {
        Boolean singleInv = (Boolean)this.getModel().getValue("single_inv");
        Boolean batchInv = (Boolean)this.getModel().getValue("batch_inv");
        Boolean apiInv = (Boolean)this.getModel().getValue("api_inv");
        Boolean splitMergeInv = (Boolean)this.getModel().getValue("split_merge_inv");
        Boolean scanInv = (Boolean)this.getModel().getValue("scan_inv");
        Boolean titMappBillPush = (Boolean)this.getModel().getValue("tit_mapp_bill_push");
        Boolean titMappBillImport = (Boolean)this.getModel().getValue("tit_mapp_bill_import");
        if (titMappBillPush.booleanValue() || titMappBillImport.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"forcemapping"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"forcemapping"});
        }
        StringBuilder sb = new StringBuilder();
        if (singleInv.booleanValue()) {
            sb.append(this.getCheckboxDisplayName("single_inv")).append('\uff1b');
        }
        if (batchInv.booleanValue()) {
            sb.append(this.getCheckboxDisplayName("batch_inv")).append('\uff1b');
        }
        if (apiInv.booleanValue()) {
            sb.append(this.getCheckboxDisplayName("api_inv")).append('\uff1b');
        }
        if (splitMergeInv.booleanValue()) {
            sb.append(this.getCheckboxDisplayName("split_merge_inv")).append('\uff1b');
        }
        if (scanInv.booleanValue()) {
            sb.append(this.getCheckboxDisplayName("scan_inv")).append('\uff1b');
        }
        StringBuilder sb1 = new StringBuilder();
        if (titMappBillPush.booleanValue()) {
            sb1.append(this.getCheckboxDisplayName("tit_mapp_bill_push")).append('\uff1b');
        }
        if (titMappBillImport.booleanValue()) {
            sb1.append(this.getCheckboxDisplayName("tit_mapp_bill_import")).append('\uff1b');
        }
        String tipMsg = ResManager.loadKDString((String)"\u65e0", (String)"InvoiceSettingTabPlugin_19", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        Label label = (Label)this.getControl("invtitlelabeli");
        label.setText(sb.length() > 1 ? sb.substring(0, sb.length() - 1) : tipMsg);
        ((Label)this.getControl("invtitlelabeli1")).setText(sb1.length() > 1 ? sb1.substring(0, sb1.length() - 1) : tipMsg);
        String tipMsg2 = ResManager.loadKDString((String)"\u662f", (String)"InvoiceSettingTabPlugin_20", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        String tipMsg3 = ResManager.loadKDString((String)"\u5426", (String)"InvoiceSettingTabPlugin_21", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        Boolean isComplete = (Boolean)this.getModel().getValue(IS_COMPLETE);
        Label isCompleteLabel = (Label)this.getControl("iscompletelabel");
        isCompleteLabel.setText(isComplete != false ? tipMsg2 : tipMsg3);
    }

    private String getCheckboxDisplayName(String key) {
        FieldEdit fieldEdit = (FieldEdit)this.getControl(key);
        return fieldEdit.getProperty().getDisplayName().getLocaleValue();
    }

    private void initGoodsInfoSetting() {
        String selFields = PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_inv_item_setting", (boolean)true);
        DynamicObject invItemSettingObj = QueryServiceHelper.queryOne((String)"bdm_inv_item_setting", (String)selFields, (QFilter[])new QFilter("org", "=", (Object)RequestContext.get().getOrgId()).toArray());
        if (null != invItemSettingObj) {
            ModelUtil.setModelValueFromDynamicObject((DynamicObject)invItemSettingObj, (AbstractFormPlugin)this);
            this.getModel().setValue("inv_item_config_ids", invItemSettingObj.get("id"));
        }
        this.setGoodsMappingLabel();
    }

    private void setGoodsMappingLabel() {
        Boolean originalBillNew = (Boolean)this.getModel().getValue("orginal_bill_new");
        Boolean originalBillImport = (Boolean)this.getModel().getValue("original_bill_import");
        StringBuilder sb = new StringBuilder();
        if (originalBillNew.booleanValue()) {
            sb.append(this.getCheckboxDisplayName("orginal_bill_new")).append(';');
        }
        if (originalBillImport.booleanValue()) {
            sb.append(this.getCheckboxDisplayName("original_bill_import")).append(';');
        }
        String tipMsg = ResManager.loadKDString((String)"\u65e0", (String)"InvoiceSettingTabPlugin_19", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        Label label = (Label)this.getControl("goodsmappinglabel");
        label.setText(sb.length() > 1 ? sb.substring(0, sb.length() - 1) : tipMsg);
        Boolean savefrombill = (Boolean)this.getModel().getValue("savefrombill");
        Label goodsInfoLabel = (Label)this.getControl("goodsinfolabel");
        if (savefrombill.booleanValue()) {
            goodsInfoLabel.setText(this.getCheckboxDisplayName("savefrombill"));
        } else {
            goodsInfoLabel.setText(tipMsg);
        }
        Boolean completion = (Boolean)this.getModel().getValue("completion");
        Label completionLabel = (Label)this.getControl("completionlabel");
        String tipMsg2 = ResManager.loadKDString((String)"\u662f", (String)"InvoiceSettingTabPlugin_20", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        String tipMsg3 = ResManager.loadKDString((String)"\u5426", (String)"InvoiceSettingTabPlugin_21", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        completionLabel.setText(completion != false ? tipMsg2 : tipMsg3);
    }

    private void initBatchInvoiceSetting() {
        DynamicObject issueInvSetting = BusinessDataServiceHelper.loadSingle((String)"bdm_issue_inv_setting", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_issue_inv_setting"), (QFilter[])new QFilter("org", "=", (Object)RequestContext.get().getOrgId()).toArray());
        if (null != issueInvSetting) {
            Object fieldToLongValue = StringUtils.isBlank((Object)issueInvSetting.get("fieldtolong")) ? BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_HINT.getValue() : issueInvSetting.get("fieldtolong");
            issueInvSetting.set("fieldtolong", fieldToLongValue);
            ModelUtil.setModelValueFromDynamicObject((DynamicObject)issueInvSetting, (AbstractFormPlugin)this);
        }
        this.setBatchRuleLabel();
    }

    private void setBatchRuleLabel() {
        Boolean errcontinue = (Boolean)this.getModel().getValue("errcontinue");
        Label errorcontinuelabel = (Label)this.getControl("errorcontinuelabel");
        String tipMsg2 = ResManager.loadKDString((String)"\u662f", (String)"InvoiceSettingTabPlugin_20", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        String tipMsg3 = ResManager.loadKDString((String)"\u5426", (String)"InvoiceSettingTabPlugin_21", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        errorcontinuelabel.setText(errcontinue != false ? tipMsg2 : tipMsg3);
        String issueinvoiceorder = (String)this.getModel().getValue("issueinvoiceorder");
        ComboEdit comboEdit = (ComboEdit)this.getControl("issueinvoiceorder");
        Label issueorderlabel = (Label)this.getControl("issueorderlabel");
        issueorderlabel.setText(ComboEditUtil.getComboNameByValue((ComboEdit)comboEdit, (String)issueinvoiceorder));
        String fieldtolong = (String)this.getModel().getValue("fieldtolong");
        Label fieldtolonglabel = (Label)this.getControl("fieldtolonglabel");
        String tipMsg4 = ResManager.loadKDString((String)"\u8d85\u957f\u63d0\u793a", (String)"InvoiceSettingTabPlugin_22", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        String tipMsg5 = ResManager.loadKDString((String)"\u8d85\u957f\u622a\u53d6", (String)"InvoiceSettingTabPlugin_23", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        fieldtolonglabel.setText("1".equals(fieldtolong) ? tipMsg4 : tipMsg5);
    }

    private void flexShowOrHidden(String key, boolean isShow) {
        String hiddenFlexKey;
        String showFlexKey;
        if (isShow) {
            showFlexKey = key.replace("edit", "");
            hiddenFlexKey = showFlexKey.concat("flex");
            this.getView().setVisible(Boolean.TRUE, new String[]{showFlexKey + "cancel", showFlexKey + "save"});
            this.getView().setVisible(Boolean.FALSE, new String[]{showFlexKey + "edit"});
        } else {
            hiddenFlexKey = key.replace("cancel", "");
            showFlexKey = hiddenFlexKey.concat("flex");
            this.getView().setVisible(Boolean.FALSE, new String[]{hiddenFlexKey + "cancel", hiddenFlexKey + "save"});
            this.getView().setVisible(Boolean.TRUE, new String[]{hiddenFlexKey + "edit"});
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{showFlexKey});
        this.getView().setVisible(Boolean.FALSE, new String[]{hiddenFlexKey});
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        String actionId = event.getActionId();
        if ("sim_invoice_setting_edit".equals(actionId) && event.getReturnData() != null) {
            this.getView().invokeOperation("refresh");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"InvoiceSettingTabPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("pdfNameCallBack".equals(actionId)) {
            if (StringUtils.isBlank((Object)returnData) || returnData.equals("null")) {
                return;
            }
            String showSelect = FieldSelectHelper.getShowFileNameBySelected((String)(returnData + ""), (String)(this.getModel().getValue("separator") + ""));
            this.getModel().setValue("nowinvoicepdfname", returnData);
            this.getModel().setValue("invoice_pdf_name", (Object)showSelect);
        }
        if ("callbackallocationorg".equals(actionId)) {
            HSAmountConfigControl.chooseOrgCloseCallBack(event, this);
        } else if ("callbackhsrulesetting".equals(actionId)) {
            String selectRowIndex = this.getPageCache().get("hs_rule_select_row");
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("hsrowid", Integer.parseInt(selectRowIndex)), (String)"bdm_split_hs_config");
            this.getModel().setValue("taxcalculatetype", obj.get("taxcalculatetype"), Integer.parseInt(selectRowIndex));
            this.getModel().setValue("splitrule", obj.get("splitrule"), Integer.parseInt(selectRowIndex));
            this.getModel().setValue("numberdigit", obj.get("numberdigit"), Integer.parseInt(selectRowIndex));
            this.getModel().setValue("numberdigitrule", obj.get("numberdigitrule"), Integer.parseInt(selectRowIndex));
            this.getModel().setValue("splitpricefixednum", obj.get("splitpricefixednum"), Integer.parseInt(selectRowIndex));
        }
    }

    private void invItemConfigSave() {
        QFilter filter;
        Long id = StringUtils.isBlank((Object)this.getModel().getValue("inv_item_config_ids")) ? Long.valueOf(-999999999L) : Long.valueOf(this.getModel().getValue("inv_item_config_ids").toString());
        String selFields = PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_inv_item_setting", (boolean)true);
        DynamicObject invItemConfigObj = BusinessDataServiceHelper.loadSingle((String)"bdm_inv_item_setting", (String)selFields, (QFilter[])(filter = new QFilter("id", "=", (Object)id)).toArray());
        if (null == invItemConfigObj) {
            invItemConfigObj = BusinessDataServiceHelper.newDynamicObject((String)"bdm_inv_item_setting");
            invItemConfigObj.set("creater", (Object)RequestContext.get().getUserId());
            invItemConfigObj.set("createdate", (Object)new Date());
        } else {
            invItemConfigObj.set("modifier", (Object)RequestContext.get().getUserId());
            invItemConfigObj.set("modifydate", (Object)new Date());
        }
        invItemConfigObj.set("orginal_bill_new", this.getModel().getValue("orginal_bill_new"));
        invItemConfigObj.set("original_bill_import", this.getModel().getValue("original_bill_import"));
        invItemConfigObj.set("org", (Object)RequestContext.get().getOrgId());
        invItemConfigObj.set("completion", this.getModel().getValue("completion"));
        invItemConfigObj.set("completion_policylogo", this.getModel().getValue("completion_policylogo"));
        invItemConfigObj.set("savefrombill", this.getModel().getValue("savefrombill"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invItemConfigObj});
        CacheHelper.remove((String)(GOODSINFO_COMPLETION + RequestContext.get().getOrgId()));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f00\u7968\u9879\u914d\u7f6e\u4fdd\u5b58\u6210\u529f", (String)"InvoiceSettingTabPlugin_16", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        this.getView().invokeOperation("refresh");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("separator".equals(name)) {
            String showSelect = FieldSelectHelper.getShowFileNameBySelected((String)(this.getModel().getValue("nowinvoicepdfname") + ""), (String)(this.getModel().getValue("separator") + ""));
            this.getModel().setValue("invoice_pdf_name", (Object)showSelect);
            this.getModel().setValue("invoicepdfseparator", this.getModel().getValue("separator"));
            return;
        }
        if ("pdfnamebutton".equals(name)) {
            this.getModel().setValue("separator", this.getModel().getValue("invoicepdfseparator"));
        }
        if ("tit_mapp_bill_push".equals(name) || "tit_mapp_bill_import".equals(name)) {
            ChangeData[] changeSet = e.getChangeSet();
            Boolean newValue = (Boolean)changeSet[0].getNewValue();
            Boolean other = "tit_mapp_bill_push".equals(name) ? (Boolean)this.getModel().getValue("tit_mapp_bill_import") : (Boolean)this.getModel().getValue("tit_mapp_bill_push");
            if (newValue.booleanValue() || other.booleanValue()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"forcemapping"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"forcemapping"});
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("epinfo".equals(name)) {
            this.chooseF7Epinfo(beforeF7SelectEvent);
        }
        if ("orgname".equals(name)) {
            DynamicObjectCollection orgs = this.getModel().getEntryEntity("qrentry");
            ArrayList orgList = Lists.newArrayListWithCapacity((int)(orgs == null ? 0 : orgs.size()));
            if (null != orgs && orgs.size() > 0) {
                for (DynamicObject org : orgs) {
                    if (null == org || !StringUtils.isNotBlank((Object)org.get("orgname.number"))) continue;
                    orgList.add(org.getString("orgname.number"));
                }
            }
            QFilter filter = new QFilter("epinfo", ">", (Object)0);
            QFilter originFilter = new QFilter("number", "not in", (Object)orgList.toArray());
            ArrayList<QFilter> list = new ArrayList<QFilter>();
            list.add(filter);
            list.add(originFilter);
            beforeF7SelectEvent.setCustomQFilters(list);
        }
    }

    private void chooseF7Epinfo(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObjectCollection epinfos = this.getModel().getEntryEntity("sendepinfo");
        ArrayList texNoList = Lists.newArrayListWithCapacity((int)epinfos.size());
        for (DynamicObject epinfo : epinfos) {
            if (null == epinfo || null == epinfo.getDynamicObject("epinfo") || !StringUtils.isNotBlank((CharSequence)(epinfo.getDynamicObject("epinfo").get("number") + ""))) continue;
            texNoList.add(epinfo.getDynamicObject("epinfo").get("number") + "");
        }
        QFilter filter = new QFilter("number", "not in", (Object)texNoList);
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(filter);
        HasPermOrgResultImpl userHasPermEpInfo = OrgHelper.getUserHasPermEpInfo();
        if (!userHasPermEpInfo.hasAllOrgPerm()) {
            list.add(new QFilter("id", "in", (Object)userHasPermEpInfo.getHasPermOrgs()));
        }
        beforeF7SelectEvent.setCustomQFilters(list);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key = afterDoOperationEventArgs.getOperateKey();
        if (key.equals("amountconfigorgs")) {
            int selectRow = this.getHSSplitAmountSelectRow();
            this.getPageCache().put("amount_config_select_row", String.valueOf(selectRow));
            HSAmountConfigControl.selectAllocationOrg(this, selectRow);
        } else if (key.equals("hssplitrule")) {
            int selectRow = this.getHSSplitAmountSelectRow();
            this.setHSAmountSplitRule(selectRow);
        }
    }

    private int getHSSplitAmountSelectRow() {
        EntryGrid entry = (EntryGrid)this.getControl("amountconfig");
        int[] selectRows = entry.getSelectRows();
        return selectRows[0];
    }

    private void setHSAmountSplitRule(int selectRow) {
        Long id = (Long)this.getModel().getValue("hsrowid", selectRow);
        if (id == 0L) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5206\u5f55\u8bb0\u5f55\u8fd8\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u5728\u542b\u7a0e\u91d1\u989d\u62c6\u5206\u89c4\u5219\u5de5\u5177\u680f\u70b9\u51fb\u4fdd\u5b58", (String)"InvoiceSettingTabPlugin_17", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Long> customParams = new HashMap<String, Long>();
        customParams.put("id", id);
        this.getPageCache().put("hs_rule_select_row", String.valueOf(selectRow));
        ViewUtil.openMainNewTabPage((AbstractFormPlugin)this, null, customParams, (String)"bdm_split_hs_rule", (String)"callbackhsrulesetting");
    }
}

