/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.org;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeDragEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.util.TreeUtils;
import kd.imc.bdm.formplugin.org.OrgImportPlugin;
import kd.imc.bdm.formplugin.org.OrgTreeController;

public class OrgTreeEditPlugin
extends OrgImportPlugin {
    private static final String LEFT_TREE = "left_tree";
    private static final String RIGHT_TREE = "right_tree";
    public static final String MOVE_RIGHT_TREE = "move_right_tree";
    private static final String BTN_RESET = "btn_reset";
    public static final int MAX_LEVEL = 20;
    public static final String CALL_BACK_ID = "org_tree_save";
    public static final String SOURCE_NODE = "SOURCE_NODE";
    public static final String MOVE_NODE_ID = "move_node_id";
    public static final String NOT_CHANGE = "not_change";

    public static void findChildrenSize(Set<TreeNode> childrenNode, TreeNode treeMode) {
        List children = treeMode.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        for (TreeNode child : children) {
            childrenNode.add(child);
            OrgTreeEditPlugin.findChildrenSize(childrenNode, child);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        OrgTreeController.initTree(this, LEFT_TREE);
        OrgTreeController.initTree(this, RIGHT_TREE);
        TreeNode sourceTreeNode = TreeUtils.getCache((IPageCache)this.getPageCache(), (String)LEFT_TREE);
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)SOURCE_NODE, (Object)sourceTreeNode);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_RESET});
    }

    @Override
    public void treeNodeCheck(TreeNodeCheckEvent event) {
        super.treeNodeCheck(event);
    }

    @Override
    public void treeNodeDragged(TreeNodeDragEvent event) {
        super.treeNodeDragged(event);
    }

    @Override
    public void search(SearchEnterEvent event) {
        super.search(event);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_RESET.equals(key)) {
            PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.BDM_IMPORT_ORG);
            this.reset();
        }
    }

    private void reset() {
        TreeView rightTreeView = (TreeView)this.getView().getControl(RIGHT_TREE);
        rightTreeView.uncheckNode("-1");
        TreeView leftTreeView = (TreeView)this.getView().getControl(LEFT_TREE);
        leftTreeView.uncheckNode("-1");
        TreeNode sourceNode = TreeUtils.getCache((IPageCache)this.getPageCache(), (String)SOURCE_NODE);
        rightTreeView.updateNode(sourceNode);
        leftTreeView.updateNode(sourceNode);
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)RIGHT_TREE, (Object)sourceNode);
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)LEFT_TREE, (Object)sourceNode);
        String idsStr = this.getPageCache().get(MOVE_NODE_ID);
        if (StringUtils.isNotBlank((CharSequence)idsStr)) {
            List moveNodeIds = JSONArray.parseArray((String)idsStr, String.class);
            for (String nodeId : moveNodeIds) {
                TreeUtils.removeCache((IPageCache)this.getPageCache(), (String)MOVE_RIGHT_TREE.concat(nodeId));
            }
        }
    }

    @Override
    public void submitClick() {
        TreeNode rightTreeNode = TreeUtils.getCache((IPageCache)this.getPageCache(), (String)RIGHT_TREE);
        TreeNode sourceTreeNode = TreeUtils.getCache((IPageCache)this.getPageCache(), (String)SOURCE_NODE);
        if (SerializationUtils.toJsonString((Object)sourceTreeNode).equals(SerializationUtils.toJsonString((Object)rightTreeNode))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u67b6\u6784\u6ca1\u6709\u53d8\u66f4", (String)"OrgTreeEditPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            this.getView().returnDataToParent((Object)NOT_CHANGE);
            this.getView().close();
            return;
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CALL_BACK_ID, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"OrgTreeEditPlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"OrgTreeEditPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        this.getView().showConfirm(ResManager.loadKDString((String)"\u8c03\u6574\u540e\uff0c\u5386\u53f2\u53d1\u7968\u6570\u636e\u3001\u5f00\u7968\u9879\u5171\u4eab\u5c06\u6309\u7167\u65b0\u7ec4\u7ec7\u7ed3\u6784\u8fdb\u884c\u67e5\u770b\u3001\u7edf\u8ba1\u3001\u6570\u636e\u4f7f\u7528\uff0c\u662f\u5426\u786e\u8ba4\u8c03\u6574\uff1f", (String)"OrgTreeEditPlugin_7", (String)"imc-bdm-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
    }

    @Override
    public void goClick() {
        TreeView rightTreeView = (TreeView)this.getView().getControl(RIGHT_TREE);
        TreeView leftTreeView = (TreeView)this.getView().getControl(LEFT_TREE);
        List checkedNodeIds = rightTreeView.getTreeState().getCheckedNodeIds();
        if (CollectionUtils.isEmpty((Collection)checkedNodeIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e2d\u4e00\u4e2a\u53f3\u8282\u70b9\u6dfb\u52a0", (String)"OrgTreeEditPlugin_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        List<TreeNode> leftSelectNode = OrgTreeController.getLeftSelectNode(this, (String)checkedNodeIds.get(0));
        if (!CollectionUtils.isEmpty((Collection)checkedNodeIds) && checkedNodeIds.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u4e2d\u4e00\u4e2a\u53f3\u8282\u70b9\u6dfb\u52a0", (String)"OrgTreeEditPlugin_5", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        TreeNode rightRoot = TreeUtils.getCache((IPageCache)this.getPageCache(), (String)RIGHT_TREE);
        TreeNode focusNode = rightRoot.getTreeNode((String)checkedNodeIds.get(0), 20);
        TreeNode leftRoot = TreeUtils.getCache((IPageCache)this.getPageCache(), (String)LEFT_TREE);
        TreeNode leftFocusNode = leftRoot.getTreeNode((String)checkedNodeIds.get(0), 20);
        String idsStr = this.getPageCache().get(MOVE_NODE_ID);
        ArrayList<String> moveNodeIds = StringUtils.isBlank((CharSequence)idsStr) ? new ArrayList<String>(8) : JSONArray.parseArray((String)idsStr, String.class);
        for (TreeNode treeNode : leftSelectNode) {
            if ("gray".equals(treeNode.getColor())) continue;
            if (treeNode.getText().equals(focusNode.getText())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u76f8\u540c\u4f4d\u7f6e\u4e0d\u80fd\u64cd\u4f5c", (String)"OrgTreeEditPlugin_6", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            rightRoot.deleteChildNode(treeNode.getId());
            rightTreeView.deleteNode(treeNode.getId());
            leftRoot.deleteChildNode(treeNode.getId());
            leftTreeView.deleteNode(treeNode.getId());
            moveNodeIds.add(treeNode.getId());
        }
        if (!CollectionUtils.isEmpty(leftSelectNode)) {
            rightTreeView.addNodes(leftSelectNode);
            focusNode.addChildren(leftSelectNode);
            leftTreeView.addNodes(leftSelectNode);
            leftFocusNode.addChildren(leftSelectNode);
            TreeUtils.putCache((IPageCache)this.getPageCache(), (String)RIGHT_TREE, (Object)rightRoot);
            TreeUtils.putCache((IPageCache)this.getPageCache(), (String)LEFT_TREE, (Object)rightRoot);
            this.getPageCache().put(MOVE_NODE_ID, JSONObject.toJSONString(moveNodeIds));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (event.getResult() == MessageBoxResult.Yes) {
            PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.BDM_IMPORT_ORG);
            OrgTreeController.submitClick(this);
        }
    }
}

