/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.remarksetting;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.table.RemarkSettingConstant;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.FieldSelectHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.helper.RemarkHelper;
import kd.imc.bdm.common.helper.SchemeHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.ViewUtil;

public class RemarkSettingPlugin
extends AbstractFormPlugin
implements BeforeFilterF7SelectListener {
    private static ImmutableSet<String> FILTER_EXCLUDE_COMMON_FIELD = new ImmutableSet.Builder().add((Object[])new String[]{"confirmstate", "validstate", "split", "priority", "taxationstyle", "billproperties", "splitormergeflag", "billstatus", "billsource", "splitrule", "mergerule"}).add((Object[])new String[]{"surplusamount", "mainissuedamount", "mainissuedtax", "confirmamount", "taxadjust", "maintaxdeviation", "surplustax", "oldtotalamount"}).add((Object[])new String[]{"terminalno", "biztype", "originbillseq", "mergekey", "oribuyername", "oribuyeraddr", "oribuyerbank", "customname", "exchangerate", "exchangedate", "currency", "auditsuggestion", "goodstype", "botptype"}).add((Object[])new String[]{"materialtypebase", "billtypebase", "taxorg", "auditor", "auditdate", "sim_original_bill_item", "wxid", "redflushblue", "settlementorgbase", "capitalorgbase"}).add((Object[])new String[]{"orgid", "settlementorg", "salesorg", "capitalorg", "salesorgbase"}).build();
    private static ImmutableSet<String> FILTER_EXCLUDE_FIELD = new ImmutableSet.Builder().add((Object[])new String[]{"salername", "salertaxno", "saleraddr", "salerbank", "payee", "reviewer", "drawer"}).add((Object[])new String[]{"purchasername", "purchasercontact", "purchaserphone", "suppliername", "suppliercontact", "supplierphone"}).add((Object[])new String[]{"deduction", "blueinvoicecode", "blueinvoiceno", "infocode", "createdate", "specialtype", "billno", "originalissuetime", "applicant"}).add((Object[])new String[]{"billtaxrate", "invoiceamount", "totalamount", "totaltax", "hsbz"}).build();
    private static ImmutableSet<String> REMARK_BILL_EXCLUDE_FIELD = new ImmutableSet.Builder().add((Object[])new String[]{"confirmstate", "validstate", "split", "priority", "taxationstyle", "billproperties", "splitormergeflag", "billstatus", "billsource", "buyerproperty", "hsbz"}).add((Object[])new String[]{"surplusamount", "mainissuedamount", "mainissuedtax", "confirmamount", "taxadjust", "maintaxdeviation", "surplustax", "oldtotalamount"}).add((Object[])new String[]{"terminalno", "biztype", "originbillseq", "mergekey", "auditsuggestion", "goodstype", "specialtype", "orgid"}).add((Object[])new String[]{"oribuyername", "oribuyeraddr", "oribuyerbank", "customname", "exchangerate", "exchangedate", "currency", "applicant", "invoicetype"}).add((Object[])new String[]{"billhead_lk", "wxid", "auditor", "auditdate", "materialtypebase", "billtypebase", "sim_original_bill_item"}).add((Object[])new String[]{"customnameid", "settlementorg", "salesorg", "capitalorg", "salesorgbase", "settlementorgbase", "capitalorgbase", "redflushblue", "taxorg", "materialtypebase"}).build();
    private static ImmutableSet<String> REMARK_ITEM_EXCLUDE_FIELD = new ImmutableSet.Builder().add((Object[])new String[]{"billsourceid", "sim_original_bill_item_lk", "taxratecodeid", "goodsid"}).add((Object[])new String[]{"deductedpk", "combineamount", "remainvalidamount", "remainvalidtax", "remainvalidnum"}).add((Object[])new String[]{"taxdeviation", "amountdeviation", "numdeviation", "discountamount", "discountrate"}).add((Object[])new String[]{"policylogo", "rowtype", "issuedamount", "issuedtax", "issuedtotaltaxamount", "seq"}).add((Object[])new String[]{"oriunitprice", "oriunit", "origoodsname", "orinum", "orispecification"}).build();
    private static final String FIELD_SELECT_MODAL = "bdm_mail_field_setting";
    private static final String FILE_NAME_CALLBACK = "fileNameCallBack";
    private static final String EDIT = "EDIT";

    public void beforeBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        Set<String> remarkFilterFieldSet = this.getRemarkFilterFieldSet();
        DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)"sim_original_bill").getProperties();
        List fieldKeys = properties.stream().map(IMetadata::getName).filter(name -> !remarkFilterFieldSet.contains(name)).collect(Collectors.toList());
        fieldKeys.add("orgid.name");
        fieldKeys.add("salesorgbase.name");
        fieldKeys.add("capitalorgbase.name");
        fieldKeys.add("settlementorgbase.name");
        fieldKeys.add("capitalorgbase.name");
        fieldKeys.add("customnameid.name");
        fieldKeys.add("operator.name");
        fieldKeys.add("operator.number");
        fieldKeys.add("operator.certificatetype");
        fieldKeys.add("operator.certificatenumber");
        fieldKeys.add("operator.county");
        fieldKeys.add("operator.taxno");
        SchemeHelper.initializeFilterGrid((FilterGrid)filterGrid, fieldKeys, (String)"sim_original_bill");
        SchemeHelper.setLocal((String)((String)this.getModel().getValue("filter_tag")));
    }

    private Set<String> getRemarkFilterFieldSet() {
        HashSet<String> remarkFilterFieldSet = new HashSet<String>();
        try {
            String remarkFilter = ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.BDM_FILTER_CONFIG_REMARK);
            if (StringUtils.isNotBlank((CharSequence)remarkFilter)) {
                String[] split = remarkFilter.split(",");
                remarkFilterFieldSet.addAll(Arrays.asList(split));
            }
        }
        catch (Exception ignore) {
            remarkFilterFieldSet.addAll((Collection<String>)FILTER_EXCLUDE_FIELD);
        }
        remarkFilterFieldSet.addAll((Collection<String>)FILTER_EXCLUDE_COMMON_FIELD);
        return remarkFilterFieldSet;
    }

    public void afterBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        if (OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().getPageCache().put(EDIT, EDIT);
        }
        FilterCondition filterCondition = null;
        String s = SchemeHelper.getLocal();
        if (StringUtils.isNotBlank((CharSequence)s)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)s, FilterCondition.class);
        }
        if (filterCondition != null) {
            filterGrid.SetValue(filterCondition);
        }
        this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
        String nameRule = (String)this.getModel().getValue("namerule");
        if (StringUtils.isBlank((CharSequence)nameRule)) {
            nameRule = String.join((CharSequence)",", "billno", "invoiceamount");
            this.getModel().setValue("namerule", (Object)nameRule);
            this.getModel().setValue("showname", (Object)this.getShowName(nameRule));
        }
        this.getModel().setDataChanged(false);
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap", "advcontoolbarap"});
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "btn_save": {
                this.save();
                break;
            }
            case "btn_field_set": {
                this.openFieldSetPage();
            }
        }
    }

    private void save() {
        if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get(EDIT))) {
            PermissionHelper.checkPermission((String)"bdm", (String)"bdm_remark", (ImcPermItemEnum)ImcPermItemEnum.ITEM_SAVE);
        } else {
            PermissionHelper.checkPermission((String)"bdm", (String)"bdm_remark", (ImcPermItemEnum)ImcPermItemEnum.ITEM_NEW);
        }
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        if (filterCondition == null || CollectionUtils.isEmpty((Collection)filterCondition.getFilterRow())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\"\u542f\u52a8\u6761\u4ef6\"\u3002\u81f3\u5c11\u8bbe\u7f6e\u4e00\u6761\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"RemarkSettingPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        this.getModel().setValue("filter_tag", (Object)SerializationUtils.toJsonString((Object)filterCondition));
        this.getModel().setValue("modifier", (Object)RequestContext.get().getUserId());
        this.getModel().setValue("modifydate", (Object)new Date());
        OperationResult result = this.getView().invokeOperation("save");
        List pkList = result.getSuccessPkIds();
        RemarkHelper.saveSelectRemarkSetting((AbstractFormPlugin)this, (List)pkList);
        this.getView().returnDataToParent((Object)"success");
        this.getView().close();
    }

    private void openFieldSetPage() {
        String name;
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        if ("0".equals(this.getModel().getValue("remarktype"))) {
            map.put("filename", this.getModel().getValue("namerule"));
            map.put("filedMap", this.getFieldMap());
            name = ResManager.loadKDString((String)"\u53d1\u7968\u5907\u6ce8\u8bbe\u7f6e\u5b57\u6bb5\u9009\u62e9", (String)"RemarkSettingPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        } else {
            map.put("filename", this.getModel().getValue("namerule"));
            map.put("filedMap", this.getDetailFieldMap());
            name = ResManager.loadKDString((String)"\u884c\u5907\u6ce8\u8bbe\u7f6e\u5b57\u6bb5\u9009\u62e9", (String)"RemarkSettingPlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        }
        map.put("remark", "isRemarkPage");
        if ((Long)this.getView().getModel().getDataEntity().getPkValue() != 0L) {
            map.put("remarkId", this.getView().getModel().getDataEntity().getPkValue());
        } else {
            map.put("remarkId", 0L);
        }
        map.put("remarkType", this.getModel().getValue("remarktype"));
        ViewUtil.openDialog((AbstractFormPlugin)this, (String)name, map, (String)FIELD_SELECT_MODAL, (String)FILE_NAME_CALLBACK);
    }

    private Map<String, String> getFieldMap() {
        DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)"sim_original_bill").getProperties();
        Map<String, String> fieldMap = properties.stream().filter(property -> !REMARK_BILL_EXCLUDE_FIELD.contains((Object)property.getName()) && property.getDisplayName() != null).collect(Collectors.toMap(IMetadata::getName, v -> v.getDisplayName().getLocaleValue()));
        String tipMsg3 = ResManager.loadKDString((String)"\u7ecf\u529e\u4eba\u8bc1\u4ef6\u7c7b\u578b", (String)"RemarkSettingPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        String tipMsg4 = ResManager.loadKDString((String)"\u7ecf\u529e\u4eba\u8bc1\u4ef6\u53f7\u7801", (String)"RemarkSettingPlugin_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        String tipMsg5 = ResManager.loadKDString((String)"\u7ecf\u529e\u4eba\u56fd\u7c4d\uff08\u5730\u533a\uff09", (String)"RemarkSettingPlugin_5", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        String tipMsg6 = ResManager.loadKDString((String)"\u81ea\u7136\u4eba\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", (String)"RemarkSettingPlugin_6", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        fieldMap.put("operator.certificatetype", tipMsg3);
        fieldMap.put("operator.certificatenumber", tipMsg4);
        fieldMap.put("operator.county", tipMsg5);
        fieldMap.put("operator.taxno", tipMsg6);
        return fieldMap;
    }

    private Map<String, String> getDetailFieldMap() {
        IDataEntityProperty items = (IDataEntityProperty)EntityMetadataCache.getDataEntityType((String)"sim_original_bill").getProperties().get((Object)"sim_original_bill_item");
        DataEntityPropertyCollection properties = ((EntryProp)items).getItemType().getProperties();
        return properties.stream().filter(property -> !REMARK_ITEM_EXCLUDE_FIELD.contains((Object)property.getName()) && property.getDisplayName() != null).collect(Collectors.toMap(IMetadata::getName, v -> v.getDisplayName().getLocaleValue()));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        switch (e.getProperty().getName()) {
            case "separator": {
                this.getModel().setValue("showname", (Object)this.getShowName((String)this.getModel().getValue("namerule")));
                break;
            }
            case "remarktype": {
                this.changeRemarkType(e.getChangeSet()[0].getNewValue());
            }
        }
    }

    private void changeRemarkType(Object remarkType) {
        String nameRule = String.join((CharSequence)",", "billno", "invoiceamount");
        if (RemarkSettingConstant.RemarkType.LINE_REMARK.getValue().equals(remarkType)) {
            nameRule = String.join((CharSequence)",", "goodsname", "num");
        }
        this.getModel().setValue("namerule", (Object)nameRule);
        this.getModel().setValue("showname", (Object)this.getShowName(nameRule));
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if (FILE_NAME_CALLBACK.equals(actionId)) {
            Map returnMap = (Map)event.getReturnData();
            if (CollectionUtils.isEmpty((Map)returnMap)) {
                return;
            }
            String select = (String)returnMap.get("selectKeys");
            String selectedObj = (String)returnMap.get("selected");
            StringBuilder sb = new StringBuilder();
            sb.append("remarksetting").append(RequestContext.get().getOrgId()).append(this.getModel().getValue("remarktype"));
            this.getPageCache().put(sb.toString(), selectedObj);
            this.getModel().setValue("namerule", (Object)select);
            this.getModel().setValue("showname", (Object)this.getShowName(select));
        }
    }

    private String getShowName(String fields) {
        String remarkType = (String)this.getModel().getValue("remarktype");
        String separator = (String)this.getModel().getValue("separator");
        return FieldSelectHelper.getShowFileNameBySelected((String)fields, (String)separator, RemarkSettingConstant.RemarkType.INVOICE_REMARK.getValue().equals(remarkType) ? this.getFieldMap() : this.getDetailFieldMap());
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent event) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)2);
        if ("bdm_operator_info".equals(event.getRefEntityId())) {
            list.add(new QFilter("org", "=", (Object)RequestContext.get().getOrgId()));
        }
        event.setCustomQFilters((List)list);
    }
}

