/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.specialinvoice;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SpecialInvoiceEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(SpecialInvoiceEditPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        this.addBeforeAndAfterF7SelectListener("taxcode");
    }

    private void addBeforeAndAfterF7SelectListener(String ... keys) {
        for (String key : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(key);
            if (null == basedataEdit) continue;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            basedataEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        if ("taxcode".equals(fieldKey)) {
            List<Object> taxCodeList = new ArrayList(8);
            DynamicObjectCollection dynamicObjectCollection = this.getView().getModel().getEntryEntity("entryentity");
            taxCodeList = dynamicObjectCollection.stream().filter(item -> item.getDynamicObject("taxcode") != null).map(item -> item.getString("taxcode.number")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("number", "not in", taxCodeList).and("sumitem", "=", (Object)"0");
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    public void afterF7Select(AfterF7SelectEvent event) {
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if ("btnok".equals(key)) {
            DynamicObject taxCodeObject;
            HashMap<String, String> specialInvoiceMap = new HashMap<String, String>(16);
            DynamicObjectCollection dynamicObjectCollection = this.getView().getModel().getEntryEntity("entryentity");
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                taxCodeObject = dynamicObject.getDynamicObject("taxcode");
                if (taxCodeObject == null) {
                    LOGGER.error("\u5f53\u524d\u7a0e\u6536\u5206\u7c7b\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01");
                    continue;
                }
                this.dealCheckRepeatSpecialInvoiceMethod(specialInvoiceMap, taxCodeObject);
            }
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                taxCodeObject = dynamicObject.getDynamicObject("taxcode");
                QFilter qFilter = new QFilter("number", "=", (Object)taxCodeObject.getString("number")).and("enable", "=", (Object)"1");
                DynamicObject specialInvoiceObject = BusinessDataServiceHelper.loadSingle((String)"bdm_special_invoice_cfg", (String)"id", (QFilter[])qFilter.toArray());
                if (specialInvoiceObject == null) {
                    specialInvoiceObject = BusinessDataServiceHelper.newDynamicObject((String)"bdm_special_invoice_cfg");
                } else {
                    Long pkId = specialInvoiceObject.getLong("id");
                    specialInvoiceObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"bdm_special_invoice_cfg");
                }
                specialInvoiceObject.set("taxcode", (Object)taxCodeObject);
                specialInvoiceObject.set("name", (Object)taxCodeObject.getString("name"));
                specialInvoiceObject.set("number", (Object)taxCodeObject.getString("number"));
                specialInvoiceObject.set("is_special_invoice", (Object)dynamicObject.getString("is_special_invoice"));
                specialInvoiceObject.set("remark", (Object)dynamicObject.getString("remark"));
                specialInvoiceObject.set("enable", (Object)"1");
                specialInvoiceObject.set("status", (Object)"C");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{specialInvoiceObject});
            }
            String tipMsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff01", (String)"SpecialInvoiceEditPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(tipMsg);
            this.getView().close();
        }
    }

    private void dealCheckRepeatSpecialInvoiceMethod(Map<String, String> specialInvoiceMap, DynamicObject taxCodeObject) {
        String name = taxCodeObject.getString("name");
        String number = taxCodeObject.getString("number");
        if (specialInvoiceMap.containsKey(number)) {
            String tipMsg = String.format(ResManager.loadKDString((String)"\u7a0e\u6536\u5206\u7c7b\u7f16\u7801:%s,\u5b58\u5728\u91cd\u590d\u884c\u8bb0\u5f55\u6570\uff01", (String)"SpecialInvoiceEditPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]), number);
            throw new KDBizException(tipMsg);
        }
        specialInvoiceMap.put(number, name);
    }
}

