/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.staticqrcode;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.MetadataUtil;

public class BdmStaticQrCodeSelectFieldPlugin
extends AbstractFormPlugin {
    private static final Log LOG = LogFactory.getLog(BdmStaticQrCodeSelectFieldPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        this.initScanQrCodeFieldMethod();
    }

    private void initScanQrCodeFieldMethod() {
        List fieldKeyList;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && (fieldKeyList = (List)customParams.get("fieldKeyList")) != null) {
            this.initStaticQrCodeFieldEntryMethod(fieldKeyList);
        }
    }

    private void initStaticQrCodeFieldEntryMethod(List<String> fieldKeyList) {
        HashSet<String> fieldSet = new HashSet<String>(8);
        String fieldValues = ImcConfigUtil.getValue((String)"sim_scan_invoice", (String)"sim_scan_invoice_fields");
        if (StringUtils.isBlank((CharSequence)fieldValues)) {
            fieldValues = "buyername;buyertaxno;invoicetype;remark;address;invoicephone;bank;bankaccount;buyerphone;buyeremail;org;applydate;status;buyerproperty;wxid;invoiceid;";
            String[] array = fieldValues.split(";");
            for (int i = 0; i < array.length; ++i) {
                fieldSet.add(array[i]);
            }
        }
        Map metaDataMap = MetadataUtil.getFieldMap((String)"sim_scan_invoice");
        LOG.info("\u5b57\u6bb5\u5c5e\u6027\u6253\u5370:{}", (Object)metaDataMap.toString());
        if (metaDataMap != null && !metaDataMap.isEmpty()) {
            this.getModel().beginInit();
            for (Map.Entry entryObject : metaDataMap.entrySet()) {
                Object fieldKey;
                boolean flag;
                Object isRefId;
                String key = (String)entryObject.getKey();
                Map subMap = (Map)entryObject.getValue();
                if ("id".equals(key) || "modifytime".equals(key) || "createtime".equals(key) || fieldSet.contains(key) || subMap.containsKey("isRefId") && StringUtils.isNotBlank(isRefId = subMap.get("isRefId")) && (flag = Boolean.parseBoolean(isRefId.toString())) || fieldKeyList.contains(fieldKey = subMap.get("fieldKey"))) continue;
                int row = this.getView().getModel().createNewEntryRow("select_field_entryentity");
                this.getModel().setValue("fieldname", subMap.get("fieldName"), row);
                this.getView().setEnable(Boolean.FALSE, row, new String[]{"fieldname"});
                this.getModel().setValue("fieldkey", subMap.get("fieldKey"), row);
                this.getView().setEnable(Boolean.FALSE, row, new String[]{"fieldkey"});
                this.getModel().setValue("fieldrequired", subMap.get("required"), row);
                this.getView().setEnable(Boolean.FALSE, row, new String[]{"fieldrequired"});
                Object fieldType = subMap.get("fieldType");
                this.getModel().setValue("fieldtype", fieldType, row);
                this.getView().setEnable(Boolean.FALSE, row, new String[]{"fieldtype"});
                Object fieldValue = subMap.get("fieldValue");
                this.getModel().setValue("helptext", subMap.get("helpText"), row);
                this.getModel().setValue("bizcontrol", subMap.get("bizControl"));
                if ("checkbox".equals(fieldType) || "radio".equals(fieldType)) {
                    if (StringUtils.isNotBlank(fieldValue)) {
                        Map itemMap = (Map)fieldValue;
                        JSONArray jsonArray = new JSONArray();
                        for (Map.Entry itemEntryObject : itemMap.entrySet()) {
                            JSONObject jsonObject = new JSONObject();
                            jsonObject.put("label", itemEntryObject.getKey());
                            jsonObject.put("value", itemEntryObject.getValue());
                            jsonArray.add((Object)jsonObject);
                        }
                        this.getModel().setValue("fieldvalue", (Object)jsonArray.toJSONString(), row);
                    }
                } else {
                    this.getModel().setValue("fieldvalue", fieldValue, row);
                }
                this.getView().setEnable(Boolean.FALSE, row, new String[]{"fieldvalue"});
            }
            this.getModel().endInit();
            this.getView().updateView("select_field_entryentity");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if ("btnok".equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("select_field_entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            ArrayList<HashMap> returnList = new ArrayList<HashMap>(selectRows.length);
            for (int i = 0; i < selectRows.length; ++i) {
                HashMap paramsMap = Maps.newHashMap();
                paramsMap.put("fieldKey", this.getModel().getValue("fieldkey", selectRows[i]));
                paramsMap.put("fieldValue", this.getModel().getValue("fieldvalue", selectRows[i]));
                paramsMap.put("fieldName", this.getModel().getValue("fieldname", selectRows[i]));
                paramsMap.put("fieldType", this.getModel().getValue("fieldtype", selectRows[i]));
                paramsMap.put("bizControl", this.getModel().getValue("bizcontrol", selectRows[i]));
                paramsMap.put("helpText", this.getModel().getValue("helptext", selectRows[i]));
                returnList.add(paramsMap);
            }
            this.getView().returnDataToParent(returnList);
            this.getView().close();
        }
    }
}

