/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.vehicleinfo;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.imc.bdm.common.constant.TaxRate;
import kd.imc.bdm.common.util.ComboEditUtil;
import kd.imc.bdm.common.util.TaxRateUtil;

public class VehicleInfoAddAndEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(VehicleInfoAddAndEditPlugin.class);
    private static final String ADVCONTOOLBARAP = "advcontoolbarap";

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"goodscode"});
        this.addItemClickListeners(new String[]{ADVCONTOOLBARAP});
        BasedataEdit edit = (BasedataEdit)this.getView().getControl("goodscode");
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        switch (e.getProperty().getName()) {
            case "goodscode": {
                DynamicObject obj = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (StringUtils.isBlank((Object)obj)) {
                    return;
                }
                this.getModel().setValue("taxpremark", (Object)"0");
                this.getModel().setValue("zzstsgl", (Object)"");
                this.getView().setEnable(Boolean.FALSE, new String[]{"zzstsgl"});
                this.setTaxRate(obj);
                if (!StringUtils.isNotBlank((CharSequence)obj.getString("vatspecialmanagement"))) break;
                TaxRateUtil.fillPrivilegeType((String)obj.getString("vatspecialmanagement"), (ComboEdit)((ComboEdit)this.getControl("zzstsgl")));
                break;
            }
            case "taxpremark": {
                String flag = (String)e.getChangeSet()[0].getNewValue();
                if (flag.equals("0")) {
                    this.getModel().setValue("zzstsgl", (Object)"");
                    Object taxRateCode = this.getModel().getValue("goodscode");
                    if (null != taxRateCode) {
                        DynamicObject taxRateObj = (DynamicObject)taxRateCode;
                        this.setTaxRate(taxRateObj);
                    }
                    this.getView().setEnable(Boolean.FALSE, new String[]{"taxpremark"});
                    return;
                }
                this.setZZSTSGL(flag);
                break;
            }
            case "taxrate": {
                String rate1 = (String)e.getChangeSet()[0].getNewValue();
                if (StringUtils.isEmpty((CharSequence)rate1)) {
                    return;
                }
                if (BigDecimal.ZERO.compareTo(new BigDecimal(rate1)) == 0) {
                    if (!"0".equals(this.getModel().getValue("taxpremark"))) break;
                    ComboEdit comboEdit = (ComboEdit)this.getControl("zzstsgl");
                    String tipMsg = ResManager.loadKDString((String)"\u666e\u901a\u96f6\u7a0e\u7387", (String)"GoodsEditPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                    comboEdit.setComboItems(Collections.singletonList(new ComboItem(new LocaleString(tipMsg), tipMsg)));
                    this.getModel().setValue("zzstsgl", (Object)tipMsg);
                    this.getView().setEnable(Boolean.FALSE, new String[]{"zzstsgl"});
                    break;
                }
                String tipMsg = ResManager.loadKDString((String)"\u666e\u901a\u96f6\u7a0e\u7387", (String)"GoodsEditPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                if (!tipMsg.equals(this.getModel().getValue("zzstsgl"))) break;
                this.getModel().setValue("zzstsgl", (Object)"");
                break;
            }
            case "zzstsgl": {
                Object taxcode = this.getModel().getValue("goodscode");
                String en = (String)this.getModel().getValue("taxrate");
                String type = (String)e.getChangeSet()[0].getNewValue();
                this.setRate(taxcode, type, en);
                break;
            }
            case "brandmodel": {
                String tipMsg3 = ResManager.loadKDString((String)"\u5382\u724c\u578b\u53f7", (String)"VehicleInfoSaveOp_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                this.CheckGBKLengthContent(this.getModel().getValue("brandmodel") + "", tipMsg3, 60);
                break;
            }
            case "producingarea": {
                String tipMsg1 = ResManager.loadKDString((String)"\u4ea7\u5730", (String)"VehicleInfoSaveOp_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                this.CheckGBKLengthContent(this.getModel().getValue("producingarea") + "", tipMsg1, 32);
                break;
            }
            case "producingname": {
                String tipMsg2 = ResManager.loadKDString((String)"\u751f\u4ea7\u4f01\u4e1a\u540d\u79f0", (String)"VehicleInfoSaveOp_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                this.CheckGBKLengthContent(this.getModel().getValue("producingname") + "", tipMsg2, 40);
                break;
            }
        }
    }

    private void setTaxRate(DynamicObject obj) {
        String taxRateStr = obj.getBigDecimal("taxrate").stripTrailingZeros().toString();
        if ("0.1".equals(taxRateStr)) {
            taxRateStr = TaxRate.TEN_PERCENT.getRateValue();
        }
        this.getModel().setValue("taxrate", (Object)taxRateStr);
    }

    private void setRate(Object taxcode, String type, String en) {
        if (StringUtils.isBlank((Object)taxcode)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)en)) {
            return;
        }
        if (!StringUtils.isEmpty((CharSequence)type)) {
            this.getModel().setValue("taxrate", (Object)en);
        }
        this.setTaxRateValueByPrivilegetype(type);
        String tipMsg4 = ResManager.loadKDString((String)"\u7b80\u6613\u5f81\u6536", (String)"GoodsEditPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        if (String.valueOf(this.getModel().getValue("zzstsgl")).contains(tipMsg4)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"taxrate"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"taxrate"});
        }
    }

    private boolean setTaxRateValueByPrivilegetype(String s) {
        String tipMsg = ResManager.loadKDString((String)"\u7b80\u6613\u5f81\u6536", (String)"GoodsEditPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        String tipMsg2 = ResManager.loadKDString((String)"\u7b80\u6613\u5f81\u6536\u51cf\u6309", (String)"GoodsEditPlugin_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        String tipMsg3 = ResManager.loadKDString((String)"\u6309", (String)"GoodsEditPlugin_5", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        String tipMsg4 = ResManager.loadKDString((String)"%\u7b80\u6613\u5f81\u6536", (String)"GoodsEditPlugin_6", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        if (s.contains(tipMsg)) {
            this.getModel().setValue("zzstsgl", (Object)s);
            if (s.contains(tipMsg2)) {
                s = "1.5";
            } else {
                s = s.replace(tipMsg3, "");
                s = s.replace(tipMsg4, "");
            }
            String rateValue = new BigDecimal(s).divide(new BigDecimal("100")).toPlainString();
            this.getModel().setValue("taxrate", (Object)rateValue);
            return true;
        }
        return false;
    }

    private void setZZSTSGL(String zzstsgl) {
        if ("1".equals(zzstsgl)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"taxpremark"});
            DynamicObject obj = (DynamicObject)this.getModel().getValue("goodscode");
            if (null == obj || StringUtils.isBlank((CharSequence)obj.getString("vatspecialmanagement"))) {
                ComboEdit comboEdit = (ComboEdit)this.getControl("zzstsgl");
                comboEdit.setComboItems(ComboEditUtil.setDefaultComboItems((ComboEdit)comboEdit));
            } else {
                String zzstsglTax = obj.getString("vatspecialmanagement");
                TaxRateUtil.fillPrivilegeType((String)zzstsglTax, (ComboEdit)((ComboEdit)this.getControl("zzstsgl")));
                this.setJAJZ(zzstsglTax);
            }
        } else {
            String taxRate = (String)this.getModel().getValue("taxrate");
            if (StringUtils.isNotBlank((CharSequence)taxRate) && BigDecimal.ZERO.compareTo(new BigDecimal(taxRate)) == 0) {
                ComboEdit comboEdit = (ComboEdit)this.getControl("zzstsgl");
                String tipMsg = ResManager.loadKDString((String)"\u666e\u901a\u96f6\u7a0e\u7387", (String)"GoodsEditPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                comboEdit.setComboItems(Collections.singletonList(new ComboItem(new LocaleString(tipMsg), tipMsg)));
                this.getModel().setValue("zzstsgl", (Object)tipMsg);
            } else {
                this.getModel().setValue("zzstsgl", (Object)"");
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"zzstsgl"});
        }
    }

    private void setJAJZ(String zzstsgl) {
        String tipMsg = ResManager.loadKDString((String)"\u7b80\u6613\u5f81\u6536", (String)"GoodsEditPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)zzstsgl) && zzstsgl.contains(tipMsg)) {
            String[] arr;
            for (String s : arr = zzstsgl.split("\u3001")) {
                if (this.setTaxRateValueByPrivilegetype(s)) break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("goodscode".equals(key)) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter newFilter = new QFilter("mergecode", "like", (Object)"1090305%");
            newFilter.or("mergecode", "like", (Object)"1090306%");
            newFilter.or("mergecode", "like", (Object)"1090307%");
            newFilter.or("mergecode", "=", (Object)"1090308000000000000");
            newFilter.or("mergecode", "=", (Object)"1090308020000000000");
            newFilter.or("mergecode", "like", (Object)"1090309%");
            newFilter.or("mergecode", "=", (Object)"1090301000000000000");
            newFilter.or("mergecode", "like", (Object)"1090312%");
            newFilter.or("mergecode", "like", (Object)"1090315%");
            newFilter.or("mergecode", "=", (Object)"1090000000000000000");
            newFilter.or("mergecode", "=", (Object)"1000000000000000000");
            newFilter.or("mergecode", "=", (Object)"1090300000000000000");
            formShowParameter.getListFilterParameter().getQFilters().add(newFilter);
            formShowParameter.getTreeFilterParameter().getQFilters().add(newFilter);
            evt.addCustomQFilter(newFilter);
        }
    }

    public void CheckGBKLengthContent(String content, String propertyName, int maxLength) {
        int gbkLength;
        if (null == content || content.length() == 0) {
            return;
        }
        try {
            byte[] bs = content.getBytes("GBK");
            ByteBuffer buf = ByteBuffer.wrap(bs);
            gbkLength = buf.capacity();
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("\u89e3\u7801\u5f02\u5e38", (Throwable)e);
            gbkLength = 0;
        }
        if (gbkLength > maxLength) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e%d\u4e2a\u5b57\u8282,\u4e00\u4e2a\u6c49\u5b57\u5360\u4e24\u4e2a\u5b57\u8282", (String)"VehicleInfoAddAndEditPlugin_9", (String)"imc-bdm-formplugin", (Object[])new Object[0]), propertyName, maxLength));
        }
    }
}

