/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.org.webapi;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.EquipmentType;
import kd.imc.bdm.common.constant.PermissionEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.ThreadPoolsHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.service.CAService;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.InputPermissionUtils;
import kd.imc.bdm.formplugin.equipment.EquipmentListPlugin;
import kd.imc.bdm.formplugin.equipment.control.EquipmentListControl;
import kd.imc.bdm.helper.ThirdOrgHelper;

public class AddEquipmentApiPlugin
implements IBillWebApiPlugin {
    private static Log logger = LogFactory.getLog(AddEquipmentApiPlugin.class);
    private static final ImmutableSet<Integer> integerImmutableSet = ImmutableSet.of((Object)12, (Object)14, (Object)16);

    public ApiResult doCustomService(Map<String, Object> params) {
        DynamicObject permisson;
        DynamicObjectCollection collect;
        String taxNo;
        if (CollectionUtils.isEmpty(params)) {
            return ApiResult.fail((String)ErrorType.EMPTY_PARAM.getName(), (String)ErrorType.EMPTY_PARAM.getCode());
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("\u589e\u52a0\u8bbe\u5907\u6388\u6743\u63a5\u53e3\u4f20\u5165\u53c2\u6570[%s]", SerializationUtils.toJsonString(params)));
        }
        if (StringUtils.isBlank((CharSequence)(taxNo = (String)params.get("taxNo")))) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"AddEquipmentApiPlugin_0", (String)"imc-bdm-webapi", (Object[])new Object[0]), (String)ErrorType.EMPTY_PARAM.getCode());
        }
        String authType = (String)params.get("authType");
        if (StringUtils.isBlank((CharSequence)authType)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u6388\u6743\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"AddEquipmentApiPlugin_1", (String)"imc-bdm-webapi", (Object[])new Object[0]), (String)ErrorType.EMPTY_PARAM.getCode());
        }
        if (!PermissionEnum.ISSUE_INVOICE_SERVICE.getPermissionNo().equals(authType) && !PermissionEnum.COLLECT_INVOICE_SERVICE.getPermissionNo().equals(authType)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u6388\u6743\u7c7b\u578b\u9519\u8bef", (String)"AddEquipmentApiPlugin_2", (String)"imc-bdm-webapi", (Object[])new Object[0]), (String)ErrorType.EMPTY_PARAM.getCode());
        }
        DynamicObject epInfoObj = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)"", (QFilter[])new QFilter("number", "=", (Object)taxNo).toArray());
        if (null == epInfoObj) {
            return ApiResult.fail((String)ErrorType.COLLECT_0537.getName(), (String)ErrorType.COLLECT_0537.getCode());
        }
        DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)String.join((CharSequence)",", "epinfo", "devlist_tag", "longnumber"), (QFilter[])new QFilter("epinfo", "=", epInfoObj.getPkValue()).and("enterprisemainorg", "=", (Object)"1").toArray());
        if (org == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u672a\u521d\u59cb\u5316", (String)"AddEquipmentApiPlugin_3", (String)"imc-bdm-webapi", (Object[])new Object[0]), (String)ErrorType.COLLECT_0537.getCode());
        }
        if (logger.isInfoEnabled()) {
            logger.info("\u5f00\u59cb\u6388\u6743");
        }
        if (CollectionUtils.isEmpty((Collection)(collect = QueryServiceHelper.query((String)"bdm_invoice_permission", (String)"", (QFilter[])new QFilter("epinfo.number", "=", (Object)taxNo).and("authstate", "=", (Object)"1").and("servergroup", "=", (Object)authType).toArray()))) && (permisson = InputPermissionUtils.save((Long)Long.parseLong(org.getPkValue().toString()), (Object)epInfoObj.getPkValue(), (String)authType)) != null) {
            permisson.set("authstate", (Object)"1");
            permisson.set("userfield", (Object)RequestContext.get().getUserId());
            permisson.set("authdate", (Object)new Date());
            ImcSaveServiceHelper.update((DynamicObject)permisson);
        }
        if (PermissionEnum.COLLECT_INVOICE_SERVICE.getPermissionNo().equals(authType)) {
            return this.distributionAllEle(org, epInfoObj, params);
        }
        return this.deviceAuth(org, epInfoObj, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiResult deviceAuth(DynamicObject org, DynamicObject epInfoObj, Map<String, Object> params) {
        List requestEquipmentNos = (List)params.get("equipmentNos");
        if (CollectionUtils.isEmpty((Collection)requestEquipmentNos)) {
            return this.distributionAllEle(org, epInfoObj, params);
        }
        try {
            this.checkRequestEquipmentMap(requestEquipmentNos);
        }
        catch (MsgException e) {
            return ApiResult.fail((String)e.getErrorMsg(), (String)e.getErrorCode());
        }
        try (TXHandle tx = TX.required();){
            if (logger.isInfoEnabled()) {
                logger.info("\u5f00\u59cb\u8fdb\u884c\u7a0e\u76d8\u6388\u6743");
            }
            DynamicObject[] equipments = EquipmentUtil.getEquipmentDynamicObjectsByOrg((DynamicObject)org);
            Map<Object, DynamicObject> equipmentNoMap = Arrays.stream(equipments).collect(Collectors.toMap(k -> k.get("equipmentno"), v -> v, (v1, v2) -> v1));
            EquipmentListControl equipmentListControl = new EquipmentListControl();
            for (Map requestEquipmentMap : requestEquipmentNos) {
                String equipmentNo = (String)requestEquipmentMap.get("equipmentNo");
                DynamicObject equipment = equipmentNoMap.get(equipmentNo);
                if (equipment == null) {
                    DynamicObject taxEquipment = QueryServiceHelper.queryOne((String)"bdm_tax_equipment", (String)"epinfo.number", (QFilter[])new QFilter("equipmentno", "=", (Object)equipmentNo).toArray());
                    if (taxEquipment != null) {
                        ApiResult apiResult = ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u7a0e\u76d8\u5df2\u5173\u8054\u7a0e\u53f7%s", (String)"AddEquipmentApiPlugin_4", (String)"imc-bdm-webapi", (Object[])new Object[0]), taxEquipment.getString("epinfo.number")), (String)ErrorType.EMPTY_PARAM.getCode());
                        return apiResult;
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info(String.format("\u8bbe\u5907\u4e0d\u5b58\u5728\uff0c\u65b0\u589e\u8bbe\u5907\uff0c\u8bbe\u5907\u7f16\u53f7\u4e3a[%s]", equipmentNo));
                    }
                    equipment = this.newEquipment(requestEquipmentMap, org);
                } else {
                    equipment = BusinessDataServiceHelper.loadSingle((Object)equipment.getPkValue(), (String)"bdm_tax_equipment");
                }
                equipment.set("equipmentname", requestEquipmentMap.get("equipmentName"));
                equipment.set("paperpticketquota", requestEquipmentMap.get("paperCommonQuota"));
                equipment.set("paperzticketquota", requestEquipmentMap.get("paperSpecialQuota"));
                equipment.set("electpticketquota", requestEquipmentMap.get("eleCommonQuota"));
                equipment.set("electzticketquota", requestEquipmentMap.get("eleSpecialQuota"));
                equipment.set("drawer", requestEquipmentMap.get("drawer"));
                equipment.set("reviewer", requestEquipmentMap.get("reviewer"));
                equipment.set("payee", requestEquipmentMap.get("payee"));
                ImcSaveServiceHelper.save((DynamicObject)equipment);
                Set devSet = Arrays.stream(org.getString("devlist_tag").split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
                devSet.add(equipment.getPkValue().toString());
                org.set("devlist_tag", (Object)String.join((CharSequence)",", devSet));
                List orgNumbers = (List)requestEquipmentMap.get("orgNumbers");
                if (!"1".equals(equipment.getString("authstatus"))) {
                    if (EquipmentType.isLyServer((String)equipment.getString("equipmenttype"))) continue;
                    MsgResponse msgResponse = EquipmentListPlugin.doEquipmentActiveRequest((DynamicObject)equipment);
                    if (!ErrorType.SUCCESS.getCode().equalsIgnoreCase(msgResponse.getErrorCode())) continue;
                    equipment = BusinessDataServiceHelper.loadSingle((Object)equipment.getPkValue(), (String)"bdm_tax_equipment");
                    equipmentListControl.activeEquipment(equipment);
                    this.distributionDevices(equipment, org, epInfoObj, orgNumbers);
                    continue;
                }
                this.distributionDevices(equipment, org, epInfoObj, orgNumbers);
            }
            ImcSaveServiceHelper.update((DynamicObject)org);
            RequestContext requestContext = RequestContext.get();
            ThreadPoolsHelper.batchApplyCaThreadPool.execute(() -> {
                RequestContext.copyAndSet((RequestContext)requestContext);
                CAService.batchApplyCA(Collections.singletonList(epInfoObj));
            });
        }
        return ApiResult.success((Object)org);
    }

    private ApiResult distributionAllEle(DynamicObject org, DynamicObject epInfoObj, Map<String, Object> params) {
        List orgNumbers = (List)params.get("orgNumbers");
        if (CollectionUtils.isEmpty((Collection)orgNumbers)) {
            return ApiResult.success((Object)"");
        }
        List<String> newOrgNumbers = this.getNewOrgNumbers(orgNumbers);
        DynamicObject[] lowerOrgs = BusinessDataServiceHelper.load((String)"bdm_org", (String)String.join((CharSequence)",", "epinfo", "longnumber", "enterprisemainorg"), (QFilter[])new QFilter("number", "in", newOrgNumbers).toArray());
        if (lowerOrgs.length == 0) {
            return ApiResult.success((Object)"");
        }
        for (DynamicObject lowerOrg : lowerOrgs) {
            DynamicObject orgEpInfo;
            if (!lowerOrg.getString("longnumber").contains(org.getPkValue().toString()) || (orgEpInfo = lowerOrg.getDynamicObject("epinfo")) != null) continue;
            lowerOrg.set("epinfo", epInfoObj.getPkValue());
            if ("1".equals(lowerOrg.getString("enterprisemainorg"))) continue;
            lowerOrg.set("enterprisemainorg", (Object)"0");
        }
        ImcSaveServiceHelper.update((DynamicObject[])lowerOrgs);
        return ApiResult.success((Object)"");
    }

    private List<String> getNewOrgNumbers(List<String> orgNumbers) {
        ArrayList<String> newOrgNumbers = new ArrayList<String>(orgNumbers.size());
        for (String orgNumber : orgNumbers) {
            newOrgNumbers.add(ThirdOrgHelper.getOrgNumberByThirdOrgNumber(orgNumber));
        }
        return newOrgNumbers;
    }

    private void distributionDevices(DynamicObject equipment, DynamicObject org, DynamicObject epInfo, List<String> orgNumbers) {
        if (logger.isInfoEnabled()) {
            logger.info("\u5f00\u59cb\u5c06\u5bf9\u5e94\u8bbe\u5907\u6388\u6743\u7ed9\u7ec4\u7ec7");
        }
        if (CollectionUtils.isEmpty(orgNumbers)) {
            return;
        }
        List<String> newOrgNumbers = this.getNewOrgNumbers(orgNumbers);
        DynamicObject[] lowerOrgs = BusinessDataServiceHelper.load((String)"bdm_org", (String)String.join((CharSequence)",", "devlist_tag", "defaultdev", "epinfo", "longnumber", "enterprisemainorg"), (QFilter[])new QFilter("number", "in", newOrgNumbers).toArray());
        if (lowerOrgs.length == 0) {
            return;
        }
        for (DynamicObject lowerOrg : lowerOrgs) {
            if (!lowerOrg.getString("longnumber").contains(org.getPkValue().toString())) continue;
            DynamicObject orgEpInfo = lowerOrg.getDynamicObject("epinfo");
            if (orgEpInfo == null) {
                lowerOrg.set("epinfo", epInfo.getPkValue());
                if (!"1".equals(lowerOrg.getString("enterprisemainorg"))) {
                    lowerOrg.set("enterprisemainorg", (Object)"0");
                }
            } else if (!epInfo.getPkValue().equals(orgEpInfo.getPkValue())) continue;
            Set devSet = Arrays.stream(lowerOrg.getString("devlist_tag").split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
            devSet.add(equipment.getPkValue().toString());
            lowerOrg.set("devlist_tag", (Object)String.join((CharSequence)",", devSet));
        }
        ImcSaveServiceHelper.update((DynamicObject[])lowerOrgs);
    }

    private void checkRequestEquipmentMap(List<Map<String, Object>> requestEquipmentNos) {
        for (Map<String, Object> requestEquipmentMap : requestEquipmentNos) {
            String equipmentNo = (String)requestEquipmentMap.get("equipmentNo");
            if (StringUtils.isBlank((CharSequence)equipmentNo)) {
                throw new MsgException(ErrorType.EMPTY_PARAM.getCode(), ResManager.loadKDString((String)"\u8bbe\u5907\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"AddEquipmentApiPlugin_5", (String)"imc-bdm-webapi", (Object[])new Object[0]));
            }
            String equipmentType = (String)requestEquipmentMap.get("equipmentType");
            if (StringUtils.isBlank((CharSequence)equipmentType)) {
                throw new MsgException(ErrorType.EMPTY_PARAM.getCode(), String.format(ResManager.loadKDString((String)"\u8bbe\u5907\u7f16\u53f7[%s]\u8bbe\u5907\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"AddEquipmentApiPlugin_6", (String)"imc-bdm-webapi", (Object[])new Object[0]), equipmentNo));
            }
            if (!EquipmentType.EQUIPMENT_MAP.containsKey(equipmentType)) {
                throw new MsgException(ErrorType.FI_PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u8bbe\u5907\u7f16\u53f7[%s]\u8bbe\u5907\u7c7b\u578b\u4e0d\u5b58\u5728", (String)"AddEquipmentApiPlugin_7", (String)"imc-bdm-webapi", (Object[])new Object[0]), equipmentNo));
            }
            if (EquipmentType.isLyServer((String)equipmentType) && equipmentNo.length() != 12) {
                throw new MsgException(ErrorType.FI_PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u8bbe\u5907\u7f16\u53f7\u586b\u5199\u9519\u8bef\uff0c\u8054\u4e91\u6258\u7ba1\u7c7b\u578b\u8bbe\u5907\u7f16\u53f7\u957f\u5ea6\u4e3a12\u4f4d", (String)"AddEquipmentApiPlugin_8", (String)"imc-bdm-webapi", (Object[])new Object[0]));
            }
            if (!integerImmutableSet.contains((Object)equipmentNo.length())) {
                throw new MsgException(ErrorType.FI_PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u8bbe\u5907\u7f16\u53f7[%s]\u957f\u5ea6\u4e0d\u7b26\uff08\u8bbe\u5907\u7f16\u53f7\u957f\u5ea6\u9650\u5236\u4e3a12\uff0c14\uff0c16\u4f4d", (String)"AddEquipmentApiPlugin_9", (String)"imc-bdm-webapi", (Object[])new Object[0]), equipmentNo));
            }
            if ("2".equals(equipmentType) && (equipmentNo.length() != 14 || !equipmentNo.startsWith("44"))) {
                throw new MsgException(ErrorType.FI_PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u8bbe\u5907\u7f16\u53f7\u586b\u5199\u9519\u8bef\uff0c\u91d1\u7a0e\u76d8\u957f\u5ea6\u4e3a14\u4f4d\u4e14\u4ee544\u5f00\u5934", (String)"AddEquipmentApiPlugin_10", (String)"imc-bdm-webapi", (Object[])new Object[0]));
            }
            if (!"1".equals(equipmentType) || equipmentNo.length() == 14 && equipmentNo.startsWith("33")) continue;
            throw new MsgException(ErrorType.FI_PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u8bbe\u5907\u7f16\u53f7\u586b\u5199\u9519\u8bef\uff0c\u7a0e\u63a7\u76d8\u957f\u5ea6\u4e3a14\u4f4d\u4e14\u4ee533\u5f00\u5934", (String)"AddEquipmentApiPlugin_11", (String)"imc-bdm-webapi", (Object[])new Object[0]));
        }
    }

    private DynamicObject newEquipment(Map<String, Object> requestEquipmentMap, DynamicObject org) {
        DynamicObject equipment = BusinessDataServiceHelper.newDynamicObject((String)"bdm_tax_equipment");
        equipment.set("equipmenttype", requestEquipmentMap.get("equipmentType"));
        equipment.set("equipmentno", requestEquipmentMap.get("equipmentNo"));
        equipment.set("epinfo", org.get("epinfo"));
        equipment.set("authstatus", (Object)"0");
        equipment.set("disen", (Object)"1");
        return equipment;
    }
}

