/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.org.webapi;

import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgParam;
import kd.imc.bdm.formplugin.org.webapi.AddorgService;
import org.apache.commons.lang3.StringUtils;

public class AddSkyOrgWebApiPlugin
implements IBillWebApiPlugin {
    private static Log logger = LogFactory.getLog(AddSkyOrgWebApiPlugin.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        if (logger.isInfoEnabled()) {
            logger.info(String.format("\u661f\u7a7a\u589e\u52a0\u7ec4\u7ec7\u63a5\u53e3\u4f20\u5165\u53c2\u6570[%s]", SerializationUtils.toJsonString(params)));
        }
        ApiResult result = new ApiResult();
        result.setSuccess(true);
        result.setErrorCode("0000");
        if (params == null) {
            result.setErrorCode("0001");
            result.setMessage(ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a", (String)"AddSkyOrgWebApiPlugin_0", (String)"imc-bdm-webapi", (Object[])new Object[0]));
            return result;
        }
        String tenantNo = (String)params.get("tenantNo");
        String tenantName = (String)params.get("tenantName");
        String clientId = (String)params.get("clientId");
        String clientSecret = (String)params.get("clientSecret");
        String encryptKey = (String)params.get("encryptKey");
        List orgs = (List)params.get("orgs");
        if (StringUtils.isEmpty((CharSequence)tenantNo)) {
            result.setErrorCode("0001");
            result.setMessage(ResManager.loadKDString((String)"\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"AddSkyOrgWebApiPlugin_1", (String)"imc-bdm-webapi", (Object[])new Object[0]));
            return result;
        }
        AddorgService service = new AddorgService();
        Long tenantOrgId = service.addOrg(tenantNo, tenantName, null, 0L);
        service.addBdmOrg(0L, tenantOrgId, tenantNo, tenantName, null, null);
        if (orgs != null && orgs.size() > 0) {
            for (Object org : orgs) {
                Map orgMap = (Map)org;
                String taxNo = (String)orgMap.get("taxNo");
                String name = (String)orgMap.get("name");
                String orgNo = (String)orgMap.get("orgNo");
                String orgName = (String)orgMap.get("orgName");
                if (StringUtils.isNotBlank((CharSequence)orgName)) {
                    orgName = orgName.replace("_", "");
                }
                String subClientId = (String)orgMap.get("clientId");
                String subClientSecret = (String)orgMap.get("clientSecret");
                String subEncryptKey = (String)orgMap.get("encryptKey");
                if (StringUtils.isEmpty((CharSequence)taxNo)) continue;
                Long taxOrgId = service.addOrg("tax_" + taxNo, name, taxNo, tenantOrgId);
                service.addBdmOrg(tenantOrgId, taxOrgId, "tax_" + taxNo, name, taxNo, name);
                if (StringUtils.isEmpty((CharSequence)orgNo)) continue;
                OrgParam orgParam = service.addOrg(tenantNo, tenantName, orgNo, orgName, null, taxOrgId);
                service.addBdmOrg(taxOrgId, orgParam.getId(), orgParam.getNumber(), orgName, null, null);
                if (!StringUtils.isEmpty((CharSequence)subClientId) && !StringUtils.isEmpty((CharSequence)subClientSecret)) {
                    service.addClient(orgParam.getId(), taxNo, name, subClientId, subClientSecret, subEncryptKey);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)clientId) || StringUtils.isEmpty((CharSequence)clientSecret)) continue;
                service.addClient(orgParam.getId(), taxNo, name, clientId, clientSecret, encryptKey);
            }
        }
        return result;
    }
}

