/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.org.webapi;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.permission.api.IUserService;
import kd.bos.permission.model.UserParam;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AddUserWebApiPlugin
implements IBillWebApiPlugin {
    private static Log logger = LogFactory.getLog(AddUserWebApiPlugin.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        ApiResult result = new ApiResult();
        Boolean success = Boolean.TRUE;
        result.setSuccess(success.booleanValue());
        result.setErrorCode("0000");
        if (params == null) {
            result.setErrorCode("0001");
            result.setMessage(ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a", (String)"AddUserWebApiPlugin_0", (String)"imc-bdm-webapi", (Object[])new Object[0]));
        } else {
            String json = SerializationUtils.toJsonString(params);
            logger.info("\u65b0\u589e\u7528\u6237\u53c2\u6570{}", (Object)json);
            JSONObject jsonObj = JSONObject.parseObject((String)json);
            JSONArray employees = jsonObj.getJSONArray("employees");
            if (CollectionUtils.isEmpty((Collection)employees)) {
                result.setErrorCode("0001");
                result.setMessage(ResManager.loadKDString((String)"employees\u53c2\u6570\u4e3a\u7a7a", (String)"AddUserWebApiPlugin_1", (String)"imc-bdm-webapi", (Object[])new Object[0]));
            } else {
                for (int i = 0; i < employees.size(); ++i) {
                    JSONObject employee = employees.getJSONObject(i);
                    try {
                        JSONArray ouNos;
                        Long defOrg;
                        String email;
                        String name = employee.getString("name");
                        String number = employee.getString("number");
                        if (StringUtils.isEmpty((Object)number)) {
                            result.setErrorCode("0002");
                            result.setMessage(ResManager.loadKDString((String)"\u53c2\u6570number\u4e3a\u7a7a", (String)"AddUserWebApiPlugin_2", (String)"imc-bdm-webapi", (Object[])new Object[0]));
                            return result;
                        }
                        if (StringUtils.isEmpty((Object)name)) {
                            result.setErrorCode("0002");
                            result.setMessage(ResManager.loadKDString((String)"\u53c2\u6570name\u4e3a\u7a7a", (String)"AddUserWebApiPlugin_3", (String)"imc-bdm-webapi", (Object[])new Object[0]));
                            return result;
                        }
                        String phone = employee.getString("phone");
                        Map<String, Object> userInfo = this.getUserId(number, name, phone, email = employee.getString("email"), defOrg = this.getDefaultOrg(ouNos = employee.getJSONArray("ouNos")));
                        if (!CollectionUtils.isEmpty(userInfo)) {
                            Long userId = (Long)userInfo.get("userId");
                            for (int j = 0; j < ouNos.size(); ++j) {
                                JSONObject ou = ouNos.getJSONObject(j);
                                String ouNo = ou.getString("ouNo");
                                Long orgId = this.getOrgId(ouNo);
                                JSONArray roleNos = ou.getJSONArray("roleNos");
                                List<Object> roleList = this.getRoleId(roleNos);
                                if (orgId == null || CollectionUtils.isEmpty(roleList)) continue;
                                this.addUserOrg(userId, roleList, orgId);
                            }
                            if (userInfo != null && !userInfo.isEmpty()) {
                                this.addOpenServiceAuth(userId);
                            }
                            employee.putAll(userInfo);
                        }
                        employee.put("success", (Object)Boolean.TRUE);
                        continue;
                    }
                    catch (KDBizException e) {
                        employee.put("success", (Object)Boolean.FALSE);
                        employee.put("message", (Object)e.getErrorCode().getMessage());
                    }
                }
                result.setData((Object)employees);
            }
        }
        return result;
    }

    private Long getDefaultOrg(JSONArray ouNos) {
        if (ouNos != null) {
            for (int j = 0; j < ouNos.size(); ++j) {
                JSONObject ou = ouNos.getJSONObject(j);
                String ouNo = ou.getString("ouNo");
                Long orgId = this.getOrgId(ouNo);
                if (orgId == null || orgId <= 0L) continue;
                return orgId;
            }
        }
        RequestContext request = RequestContext.get();
        return request.getOrgId();
    }

    private Map<String, Object> getUserId(String number, String name, String phone, String email, Long dept) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        DynamicObject userObject = QueryServiceHelper.queryOne((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{filter});
        Long id = 0L;
        if (userObject != null) {
            logger.info("\u7528\u6237\u5df2\u7ecf\u5b58\u5728number:{},phone:{},email:{}", new Object[]{number, phone, email});
            id = userObject.getLong("id");
        }
        ArrayList<UserParam> paramList = new ArrayList<UserParam>();
        UserParam user = new UserParam();
        user.setId(id.longValue());
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("number", number);
        String username = number;
        if (!StringUtils.isEmpty((Object)phone)) {
            username = phone;
        }
        dataMap.put("name", name);
        dataMap.put("username", username);
        dataMap.put("usertype", "1");
        dataMap.put("phone", phone);
        dataMap.put("email", email);
        dataMap.put("idcard", "");
        dataMap.put("birthday", "1993-8-8");
        dataMap.put("gender", "1");
        dataMap.put("picturefield", "");
        ArrayList posList = new ArrayList(4);
        HashMap<String, Object> entryentity = new HashMap<String, Object>(4);
        entryentity.put("dpt", dept);
        entryentity.put("position", ResManager.loadKDString((String)"\u804c\u5458", (String)"AddUserWebApiPlugin_4", (String)"imc-bdm-webapi", (Object[])new Object[0]));
        entryentity.put("isincharge", Boolean.FALSE);
        entryentity.put("ispartjob", Boolean.FALSE);
        entryentity.put("seq", 1);
        posList.add(entryentity);
        dataMap.put("entryentity", posList);
        user.setDataMap(dataMap);
        paramList.add(user);
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        userService.addOrUpdate(paramList);
        Iterator iterator = paramList.iterator();
        if (iterator.hasNext()) {
            UserParam result1 = (UserParam)iterator.next();
            if (!result1.isSuccess()) {
                throw new KDBizException(new ErrorCode("0001", result1.getMsg()), new Object[0]);
            }
            HashMap<String, Object> userInfo = new HashMap<String, Object>(4);
            userInfo.put("userId", result1.getId());
            userInfo.put("userName", username);
            userInfo.put("name", name);
            return userInfo;
        }
        throw new KDBizException(new ErrorCode("0002", ResManager.loadKDString((String)"\u521b\u5efa\u7528\u6237\u5931\u8d25", (String)"AddUserWebApiPlugin_5", (String)"imc-bdm-webapi", (Object[])new Object[0])), new Object[0]);
    }

    private List<Object> getRoleId(JSONArray roleNumbers) {
        QFilter filter;
        List ids;
        if (roleNumbers != null && !roleNumbers.isEmpty() && !CollectionUtils.isEmpty((Collection)(ids = QueryServiceHelper.queryPrimaryKeys((String)"perm_role", (QFilter[])new QFilter[]{filter = new QFilter("number", "in", (Object)roleNumbers)}, (String)"id", (int)100)))) {
            return ids;
        }
        return null;
    }

    private Long getOrgId(String orgNumbers) {
        if (StringUtils.isEmpty((Object)orgNumbers)) {
            return null;
        }
        QFilter idFilter = new QFilter("number", "=", (Object)orgNumbers);
        DynamicObject orgs = QueryServiceHelper.queryOne((String)"bos_org", (String)"id, number, name", (QFilter[])new QFilter[]{idFilter});
        if (orgs != null) {
            return orgs.getLong("id");
        }
        idFilter = new QFilter("third_org_no", "=", (Object)orgNumbers);
        DynamicObject thirdOrg = QueryServiceHelper.queryOne((String)"bdm_third_org", (String)"id,third_org_no,org_no,orgid", (QFilter[])new QFilter[]{idFilter});
        if (thirdOrg != null) {
            return thirdOrg.getLong("orgid");
        }
        logger.info("\u7ec4\u7ec7\u4e0d\u5b58\u5728number:{}", (Object)orgNumbers);
        return null;
    }

    private void addUserOrg(Long userId, List<Object> roleIds, Long orgId) {
        if (orgId != null && roleIds != null && !roleIds.isEmpty()) {
            String deleteSql = "delete from t_perm_userrole where fuserid=? and forgid=?";
            DB.execute((DBRoute)DBRoute.basedata, (String)deleteSql, (Object[])new Object[]{userId, orgId});
            String[] newFids = DB.genStringIds((String)"t_perm_userrole", (int)roleIds.size());
            String fsource = "2";
            String fisincludesuborg = "0";
            String fdimtype = "bos_org";
            String sql = "insert into t_perm_userrole(fid,forgid,fuserid,froleid,fisincludesuborg,fsource,fdimtype) values (?,?,?,?,?,?,?)";
            ArrayList<Object[]> list = new ArrayList<Object[]>(roleIds.size());
            for (int i = 0; i < roleIds.size(); ++i) {
                Object[] array = new Object[]{newFids[i], orgId, userId, roleIds.get(i), fisincludesuborg, fsource, fdimtype};
                list.add(array);
            }
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, list);
        }
    }

    private void addOpenServiceAuth(Long userId) {
        QFilter filter = new QFilter("appid", "in", (Object)new String[]{"0QHC5B1PZ/Z3", "0QHC=8NRINCF", "0QHC8968SM1T"});
        QFilter status = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection serviceList = QueryServiceHelper.query((String)"open_apiservice_new", (String)"id,number", (QFilter[])new QFilter[]{filter, status});
        if (!CollectionUtils.isEmpty((Collection)serviceList)) {
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"open_apiauthorize");
            ArrayList<DynamicObject> objects = new ArrayList<DynamicObject>(serviceList.size());
            for (DynamicObject value : serviceList) {
                DynamicObjectCollection userCollection;
                Long addUserId;
                Object pk = null;
                String apiNumber = value.getString("number");
                QFilter[] filters = new QFilter[]{new QFilter("api_number", "=", (Object)apiNumber)};
                DynamicObject object = QueryServiceHelper.queryOne((String)"open_apiauthorize", (String)"id,api_number", (QFilter[])filters);
                if (object != null) {
                    pk = object.get("id");
                    object = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"open_apiauthorize");
                } else {
                    object = new DynamicObject((DynamicObjectType)type);
                }
                if ((addUserId = this.getApiUsers(userCollection = object.getDynamicObjectCollection("api_users"), userId)) == null) continue;
                DynamicObject obj = userCollection.addNew();
                obj.set("fbasedataid_id", (Object)addUserId);
                object.set("api_number", (Object)apiNumber);
                object.set("api_users", (Object)userCollection);
                objects.add(object);
            }
            if (!CollectionUtils.isEmpty(objects)) {
                SaveServiceHelper.save((DynamicObject[])objects.toArray(new DynamicObject[0]));
            }
        }
    }

    private Long getApiUsers(DynamicObjectCollection userCollection, Long userId) {
        for (DynamicObject obj : userCollection) {
            Long user = obj.getLong("fbasedataid_id");
            if (user == null || !user.equals(userId)) continue;
            return null;
        }
        return userId;
    }
}

