/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.org.webapi;

import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.formplugin.org.webapi.AddEquipmentApiPlugin;
import kd.imc.bdm.helper.ThirdOrgHelper;
import org.apache.commons.lang3.StringUtils;

public class SwitchOrgWebApiPlugin
implements IBillWebApiPlugin {
    private static Log logger = LogFactory.getLog(AddEquipmentApiPlugin.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        QFilter idFilter;
        DynamicObject[] org;
        ApiResult result = new ApiResult();
        result.setSuccess(true);
        if (params == null) {
            result.setErrorCode("0001");
            result.setMessage(ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a", (String)"SwitchOrgWebApiPlugin_0", (String)"imc-bdm-webapi", (Object[])new Object[0]));
            return result;
        }
        String orgNumber = (String)params.get("orgNumber");
        if (StringUtils.isEmpty((CharSequence)orgNumber)) {
            result.setErrorCode("0001");
            result.setMessage(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"SwitchOrgWebApiPlugin_1", (String)"imc-bdm-webapi", (Object[])new Object[0]));
            return result;
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("\u5207\u6362\u7ec4\u7ec7\u4f20\u5165\u7f16\u7801\uff1a[%s]", orgNumber));
        }
        orgNumber = ThirdOrgHelper.getOrgNumberByThirdOrgNumber(orgNumber);
        if (logger.isInfoEnabled()) {
            logger.info(String.format("\u5207\u6362\u7ec4\u7ec7\u6620\u5c04\u540e\u7f16\u7801\uff1a[%s]", orgNumber));
        }
        if ((org = BusinessDataServiceHelper.load((String)"bos_org", (String)"id, number, name", (QFilter[])new QFilter[]{idFilter = new QFilter("number", "=", (Object)orgNumber)})) == null || org.length < 1) {
            result.setErrorCode("0002");
            result.setMessage(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e3a%s\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"SwitchOrgWebApiPlugin_4", (String)"imc-bdm-webapi", (Object[])new Object[0]), orgNumber));
        } else {
            result.setErrorCode(ErrorType.SUCCESS.getCode());
            long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)org[0].get("id"));
            UserServiceHelper.switchUserDefaultOrg((long)orgId);
        }
        return result;
    }
}

