/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.lqpt;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.bdm.lqpt.model.LqEpConfig;
import kd.imc.bdm.lqpt.service.LqptService;
import kd.imc.bdm.lqpt.utils.SM4Util;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;

public class LqptTestPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(LqptTestPlugin.class);

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        if ("baritemap2".equals(evt.getItemKey())) {
            this.runOne();
        } else if ("clearsxcs".equals(evt.getItemKey())) {
            LqptService lqptService = new LqptService();
            String nsrsbh1 = (String)this.getModel().getValue("nsrsbh");
            LqEpConfig config = lqptService.getLqEpConfig(nsrsbh1);
            if (config.getSydwptbh() != null && "1".equals(config.getSxcsbz())) {
                QFilter filter = new QFilter("nsrsbh", "=", (Object)config.getNsrsbh());
                DeleteServiceHelper.delete((String)"bdm_lqpt_invoiceno", (QFilter[])filter.toArray());
                DeleteServiceHelper.delete((String)"bdm_lqpt_yfm", (QFilter[])filter.toArray());
                DeleteServiceHelper.delete((String)"bdm_lqpt_sxed", (QFilter[])filter.toArray());
                DeleteServiceHelper.delete((String)"bdm_lqpt_sxed_log", (QFilter[])filter.toArray());
                SimpleDateFormat sdf = new SimpleDateFormat("yy");
                CacheHelper.remove((String)(config.getNsrsbh() + '-' + sdf.format(new Date())));
            }
        } else if ("baritemap3".equals(evt.getItemKey())) {
            try {
                String nsrsbh = (String)this.getModel().getValue("taxno");
                String abilityid = (String)this.getModel().getValue("abilityid");
                String serviceId = (String)this.getModel().getValue("serviceId");
                LqptService service = new LqptService();
                LqEpConfig lqEpConfig = service.getLqEpConfig(nsrsbh);
                String body = (String)this.getModel().getValue("body");
                String content = SM4Util.encryptEcb(lqEpConfig.getLqSecret(), body);
                StringEntity httpEntity = new StringEntity(content, "UTF-8");
                HashMap<String, String> headers = new HashMap<String, String>(4);
                headers.put("Content-Type", "text/plain; charset=utf-8");
                headers.put("jrdwptbh", lqEpConfig.getJrdwptbh());
                headers.put("sydwptbh", lqEpConfig.getSydwptbh());
                if (!StringUtils.isEmpty((CharSequence)lqEpConfig.getSxcsbz())) {
                    headers.put("sxcsbz", lqEpConfig.getSxcsbz());
                }
                logger.info(String.format("1\u8bf7\u6c42\u4e50\u4f01\u63a5\u5165\u5355\u4f4d\u5e73\u53f0\u7f16\u53f7[%s]\uff0c\u4f7f\u7528\u5355\u4f4d\u5e73\u53f0\u7f16\u53f7[%s]\uff0c\u6c99\u7bb1\u6d4b\u8bd5\u6807\u5fd7[%s]", lqEpConfig.getJrdwptbh(), lqEpConfig.getSydwptbh(), lqEpConfig.getSxcsbz()));
                logger.info("1\u8bf7\u6c42\u4e50\u4f01\u8bf7\u6c42{}", (Object)body);
                String result = HttpUtil.doPost((String)this.getInterfaceUrl(lqEpConfig.getBaseUrl(), abilityid, serviceId), (String)lqEpConfig.getProxy(), headers, (HttpEntity)httpEntity, (int)lqEpConfig.getConnectTimeout(), (int)lqEpConfig.getSocketTimeout());
                logger.info("1\u8bf7\u6c42\u4e50\u4f01\u54cd\u5e94{}", (Object)result);
                JSONObject resultJson = JSONObject.parseObject((String)result);
                String httpStatusCode = resultJson.getString("httpStatusCode");
                if (!"200".equals(httpStatusCode)) {
                    this.getModel().setValue("result", (Object)result);
                } else {
                    JSONObject responseBody = resultJson.getJSONObject("body");
                    JSONObject Response = responseBody.getJSONObject("Response");
                    String Data = Response.getString("Data");
                    String afterDecrypt = SM4Util.decryptEcb(lqEpConfig.getLqSecret(), Data);
                    this.getModel().setValue("result", (Object)afterDecrypt);
                }
            }
            catch (Exception e) {
                logger.error("\u8bf7\u6c42\u51fa\u9519", (Throwable)e);
                this.getView().showTipNotification(e.getMessage());
            }
        }
    }

    private String getInterfaceUrl(String baseUrl, String ability, String service) {
        if (baseUrl.endsWith("/")) {
            return baseUrl + ability + '/' + service;
        }
        return baseUrl + '/' + ability + '/' + service;
    }

    private void runOne() {
        this.getModel().setValue("result", (Object)"");
        String leqiid = (String)this.getModel().getValue("leqiid");
        String leqisecret = (String)this.getModel().getValue("leqisecret");
        String type = (String)this.getModel().getValue("api_code");
        String param = (String)this.getModel().getValue("param");
        StringBuilder sb = new StringBuilder();
        sb.append("start api_name\uff1a").append(this.getModel().getValue("api_name")).append(",serviceId\uff1a").append(type).append("\n");
        try {
            logger.info("\u52a0\u5bc6\u524d\u53c2\u6570" + param);
            String content = SM4Util.encryptEcb(leqisecret, param);
            logger.info("\u52a0\u5bc6\u540e\u53c2\u6570" + content);
            StringEntity httpEntity = new StringEntity(content, "UTF-8");
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "text/plain; charset=utf-8");
            headers.put("jrdwptbh", leqiid);
            headers.put("sydwptbh", leqiid);
            headers.put("ylbm", (String)this.getModel().getValue("ylbm"));
            headers.put("sxcxbz", "1");
            String reqUrl = this.getModel().getValue("http_url") + type;
            sb.append("request url:").append(reqUrl).append("\n");
            sb.append("request param:").append(param).append("\n");
            sb.append("request param after encrypt:").append(content).append("\n");
            String result = HttpUtil.doPost((String)reqUrl, null, headers, (HttpEntity)httpEntity, (int)15000, (int)15000);
            sb.append("response:").append(result).append("\n");
            try {
                JSONObject resultJson = JSONObject.parseObject((String)result);
                JSONObject responseBody = resultJson.getJSONObject("body");
                JSONObject Response = responseBody.getJSONObject("Response");
                String Data = Response.getString("Data");
                String decodeResult = SM4Util.decryptEcb(leqisecret, Data);
                sb.append("respon after decrypt:").append(decodeResult).append("\n");
                sb.append("finish...").append("\n");
            }
            catch (Exception e) {
                sb.append("errror:").append(e.getMessage()).append('\n');
            }
        }
        catch (Throwable e) {
            sb.append("errror:").append(e.getMessage()).append('\n');
        }
        this.getModel().setValue("result", (Object)sb.toString());
    }
}

