/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.lqpt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.bdm.common.util.DBUtils;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.SearchUtil;
import kd.imc.bdm.common.util.TreeUtils;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class PdmScriptPlugin
extends AbstractFormPlugin {
    private final Log LOGGER = LogFactory.getLog(PdmScriptPlugin.class);
    private static final String TREE_ID = "treeviewap";
    private static final String OUT_PUT = "output";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addEnterListener(TREE_ID);
    }

    public void addEnterListener(String ... keys) {
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        for (String key : keys) {
            TreeView treeView = (TreeView)this.getView().getControl(key);
            Search search = (Search)this.getControl("searchap_" + key);
            if (search != null) {
                search.addEnterListener(event -> {
                    if (event.getText() != null && !"".equals(event.getText())) {
                        SearchUtil.searchMember((String)event.getText().toLowerCase().trim(), (boolean)true, (IFormView)view, (IPageCache)pageCache, (TreeView)treeView, (String)String.format("%s.root", key));
                    } else {
                        pageCache.put(treeView.getKey() + "_resultlist", null);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e", (String)"PdmScriptPlugin_0", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
                    }
                });
            }
            this.addClickListeners(new String[]{"before_" + key, "next_" + key});
        }
    }

    public void afterCreateNewData(EventObject e) {
        List<TreeNode> nodeList = this.queryEntityList();
        this.bind(TREE_ID, nodeList);
    }

    public void bind(String treeName, List<TreeNode> nodeList) {
        TreeView treeView = (TreeView)this.getControl(treeName);
        List roots = TreeUtils.findRoot(nodeList);
        for (TreeNode root : roots) {
            TreeUtils.findChildren((TreeNode)root, nodeList);
            treeView.addNode(root);
        }
        if (roots.size() > 1) {
            TreeNode node = new TreeNode();
            node.setId("-1");
            node.setText("");
            node.setChildren(roots);
            this.setRoot(treeName, node);
        } else {
            this.setRoot(treeName, (TreeNode)roots.get(0));
        }
    }

    public void setRoot(String treeName, TreeNode root) {
        List list = TreeUtils.getNodeList((TreeNode)root);
        HashMap<String, TreeNode> map = new HashMap<String, TreeNode>(8);
        for (TreeNode node : list) {
            map.put(node.getId(), node);
        }
        if (!root.getId().equals("-1")) {
            map.put(root.getId(), root);
        }
        this.getPageCache().put(String.format("%s.nodeMap", treeName), SerializationUtils.toJsonString(map));
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)String.format("%s.root", treeName), (Object)root);
    }

    public void itemClick(ItemClickEvent evt) {
        TreeView treeView = (TreeView)this.getView().getControl(TREE_ID);
        List selectIds = treeView.getTreeState().getSelectedNodeId();
        switch (evt.getItemKey()) {
            case "comment": {
                this.outPutComment(selectIds);
                break;
            }
            case "constant": {
                this.outPutConstant(selectIds);
                break;
            }
            case "execl": {
                this.outPutExcel();
            }
        }
    }

    private void outPutConstant(List<String> selectIds) {
        StringBuilder sb = new StringBuilder();
        for (String entityId : selectIds) {
            try {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
                Map entityMap = mainEntityType.getAllEntities();
                for (Map.Entry entry : entityMap.entrySet()) {
                    EntityType entityType = (EntityType)entry.getValue();
                    DataEntityPropertyCollection pros = entityType.getProperties();
                    for (IDataEntityProperty property : pros) {
                        if (property.getDisplayName() == null || !StringUtils.isNotEmpty((CharSequence)property.getAlias())) continue;
                        sb.append("/***").append(property.getDisplayName().getLocaleValue()).append("   ").append(property.getAlias()).append("***/").append(System.lineSeparator());
                        sb.append("public static final String ").append(property.getName().toUpperCase()).append(" = \"").append(property.getName()).append("\";").append(System.lineSeparator());
                    }
                }
            }
            catch (Exception e) {
                this.LOGGER.error("");
            }
        }
        this.getModel().setValue(OUT_PUT, (Object)sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outPutExcel() {
        TreeView treeView = (TreeView)this.getView().getControl(TREE_ID);
        List selectIds = treeView.getTreeState().getSelectedNodeId();
        XSSFWorkbook wb = new XSSFWorkbook();
        HashMap<String, Integer> sheetRow = new HashMap<String, Integer>(8);
        ArrayList<String> columnList = new ArrayList<String>();
        for (String entityId : selectIds) {
            MainEntityType mainEntityType;
            try {
                mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
            }
            catch (Exception e) {
                continue;
            }
            XSSFSheet sheet = wb.getSheet(mainEntityType.getAppId());
            if (sheet == null) {
                sheet = wb.createSheet(mainEntityType.getAppId());
            }
            Integer rowId = sheetRow.getOrDefault(mainEntityType.getAppId(), 0);
            Map entityMap = mainEntityType.getAllEntities();
            for (Map.Entry entry : entityMap.entrySet()) {
                EntityType entityType = (EntityType)entry.getValue();
                DataEntityPropertyCollection pros = entityType.getProperties();
                if (rowId == 0) {
                    sheet.setColumnWidth(0, 8000);
                    sheet.setColumnWidth(1, 8000);
                    sheet.setColumnWidth(2, 8000);
                    sheet.setColumnWidth(3, 10000);
                    Integer n = rowId;
                    Integer n2 = rowId = Integer.valueOf(rowId + 1);
                    XSSFRow row = sheet.createRow(n.intValue());
                    XSSFCell hSSFCell = row.createCell(0);
                    hSSFCell.setCellValue(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u8868", (String)"PdmScriptPlugin_1", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
                    hSSFCell = row.createCell(1);
                    hSSFCell.setCellValue(ResManager.loadKDString((String)"\u8868\u63cf\u8ff0", (String)"PdmScriptPlugin_2", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
                    hSSFCell = row.createCell(2);
                    hSSFCell.setCellValue(ResManager.loadKDString((String)"\u5b57\u6bb5", (String)"PdmScriptPlugin_3", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
                    hSSFCell = row.createCell(3);
                    hSSFCell.setCellValue(ResManager.loadKDString((String)"\u5b57\u6bb5\u63cf\u8ff0", (String)"PdmScriptPlugin_4", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
                    hSSFCell = row.createCell(4);
                    hSSFCell.setCellValue(ResManager.loadKDString((String)"\u53d6\u503c\u8303\u56f4", (String)"PdmScriptPlugin_5", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
                }
                for (IDataEntityProperty property : pros) {
                    if (!StringUtils.isNotEmpty((CharSequence)property.getAlias()) || columnList.contains(property.getAlias().toLowerCase())) continue;
                    if (StringUtils.isNotEmpty((CharSequence)property.getTableGroup())) {
                        columnList.add(property.getAlias().toLowerCase() + "_" + property.getTableGroup());
                    } else {
                        columnList.add(property.getAlias().toLowerCase());
                    }
                    Integer n = rowId;
                    Integer n3 = rowId = Integer.valueOf(rowId + 1);
                    XSSFRow row = sheet.createRow(n.intValue());
                    XSSFCell hSSFCell = row.createCell(0);
                    hSSFCell.setCellValue(entityType.getAlias());
                    hSSFCell = row.createCell(1);
                    hSSFCell.setCellValue(entityType.getDisplayName().getLocaleValue());
                    hSSFCell = row.createCell(2);
                    hSSFCell.setCellValue(property.getAlias().toLowerCase());
                    if (property.getDisplayName() != null) {
                        hSSFCell = row.createCell(3);
                        hSSFCell.setCellValue(property.getDisplayName().getLocaleValue());
                    }
                    if (!(property instanceof ComboProp)) continue;
                    StringBuilder sb = new StringBuilder();
                    List comboItems = ((ComboProp)property).getComboItems();
                    if (!CollectionUtils.isEmpty((Collection)comboItems)) {
                        for (ValueMapItem item : comboItems) {
                            sb.append(item.getValue()).append('-').append(item.getName().getLocaleValue()).append(',');
                        }
                    }
                    hSSFCell = row.createCell(4);
                    hSSFCell.setCellValue(sb.toString());
                }
                columnList.clear();
            }
            sheetRow.put(mainEntityType.getAppId(), rowId);
        }
        ByteArrayInputStream bais = null;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            wb.write((OutputStream)byteArrayOutputStream);
            bais = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl("DATABASE_" + DateUtils.format((Date)new Date()) + "_.xlsx", (InputStream)bais, 5000);
            this.getView().openUrl(urls);
        }
        catch (Exception e) {
            this.LOGGER.error("\u5bfc\u51fa\u6570\u636e\u5e93\u8868\u5931\u8d25", (Throwable)e);
        }
        finally {
            try {
                wb.close();
            }
            catch (IOException e) {
                this.LOGGER.error("\u5bfc\u51fa\u6570\u636e\u5e93\u8868\u5931\u8d25", (Throwable)e);
            }
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException e) {
                    this.LOGGER.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25");
                }
            }
        }
    }

    private void outPutComment(List<String> selectIds) {
        StringBuilder sb = new StringBuilder();
        for (String entityId : selectIds) {
            try {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
                sb.append("comment on table ").append(mainEntityType.getAlias()).append(" is '").append(mainEntityType.getDisplayName().getLocaleValue()).append("';").append(System.lineSeparator());
                Map entityMap = mainEntityType.getAllEntities();
                for (Map.Entry entry : entityMap.entrySet()) {
                    EntityType entityType = (EntityType)entry.getValue();
                    DataEntityPropertyCollection pros = entityType.getProperties();
                    if (!mainEntityType.getAlias().equals(entityType.getAlias())) {
                        sb.append("comment on table ").append(entityType.getAlias()).append(" is '").append(mainEntityType.getDisplayName().getLocaleValue()).append(entityType.getDisplayName().getLocaleValue()).append("';").append(System.lineSeparator());
                    }
                    for (IDataEntityProperty property : pros) {
                        String table = entityType.getAlias().toLowerCase();
                        if (StringUtils.isNotEmpty((CharSequence)property.getTableGroup())) {
                            table = entityType.getAlias().toLowerCase() + "_" + property.getTableGroup();
                        }
                        if (property.getDisplayName() == null || !StringUtils.isNotEmpty((CharSequence)property.getAlias())) continue;
                        sb.append("comment on column ").append(table).append('.').append(property.getAlias()).append(" is '").append(property.getDisplayName().getLocaleValue()).append("';").append(System.lineSeparator());
                    }
                }
            }
            catch (Exception e) {
                this.LOGGER.error("");
            }
        }
        this.getModel().setValue(OUT_PUT, (Object)sb.toString());
    }

    private List<TreeNode> queryEntityList() {
        ArrayList<TreeNode> listNode = new ArrayList<TreeNode>();
        String sql = "SELECT a.Fnumber,a.Fid,a.Fdata,d.Ftablename,e.Fname Entityname,e.Fnumber Entityid,f.fbizunitid FROM t_Meta_Bizapp         a,      t_Meta_Bizcloud       b,      t_Meta_Entitydesign   c,      t_Meta_Entityinfo     d,      t_Meta_Entitydesign_l e,      T_meta_bizunitrelform f WHERE a.Fbizcloudid = b.Fid  AND b.Fnumber in( 'ISMC','IMC')  AND a.Fid = c.Fbizappid  AND e.Flocaleid = 'zh_CN'  AND c.Fid = e.Fid  AND c.Fid = d.Fentityid  and d.fentityid=f.fformid ORDER BY a.Fnumber, f.fbizunitid, e.Fnumber";
        List columnList = DBUtils.query((String)DBRoute.meta.getRouteKey(), (String)sql);
        ArrayList<String> bizList = new ArrayList<String>(16);
        for (Map map : columnList) {
            String bizid = map.get("FNUMBER").toString();
            String entityname = map.get("ENTITYNAME").toString();
            String entityid = map.get("ENTITYID").toString();
            Object fbizunitid = map.get("FBIZUNITID");
            String bizunitid = null;
            if (fbizunitid != null) {
                bizunitid = fbizunitid.toString();
            }
            if (!bizList.contains(bizid)) {
                TreeNode bizNode = new TreeNode();
                bizNode.setId(bizid);
                bizNode.setText(bizid);
                bizNode.setParentid("");
                listNode.add(bizNode);
                bizList.add(bizid);
                String fdata = map.get("FDATA").toString();
                try {
                    this.parseXml(fdata, bizList, listNode, bizid);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            TreeNode node = new TreeNode();
            node.setId(entityid);
            node.setText(entityid + "_" + entityname);
            HashMap<String, String> data = new HashMap<String, String>(4);
            data.put("id", entityid);
            data.put("name", entityname);
            node.setData(data);
            if (bizList.contains(bizid + bizunitid)) {
                node.setParentid(bizid + bizunitid);
            } else {
                node.setParentid(bizid);
            }
            listNode.add(node);
        }
        return listNode;
    }

    private void parseXml(String xml, List<String> unitList, List<TreeNode> listNode, String parent) {
        String[] packItems;
        int start = xml.indexOf("<AppFunctionPackets>");
        int end = xml.indexOf("</AppFunctionPackets>");
        String pack = xml.substring(start, end);
        for (String item : packItems = pack.split("</AppFunctionPacketElement>")) {
            if (item.indexOf("<Id>") <= 0 || item.indexOf("<Name>") <= 0) continue;
            String name = item.substring(item.indexOf("<Name>") + 6, item.indexOf("</Name>"));
            String id = item.substring(item.indexOf("<Id>") + 4, item.indexOf("</Id>"));
            TreeNode bizNode = new TreeNode();
            bizNode.setId(parent + id);
            bizNode.setText(name);
            bizNode.setParentid(parent);
            listNode.add(bizNode);
            unitList.add(parent + id);
        }
    }
}

