/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.lqpt.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.constant.table.EnterPriseBaseInfoConstant;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InputPermissionUtils;
import kd.imc.bdm.lqpt.formplugin.control.LqptSandboxControl;
import kd.imc.bdm.lqpt.service.SxedService;
import kd.imc.bdm.lqpt.service.TaxpayerService;
import kd.imc.bdm.lqpt.utils.SM4Util;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;

public class LqptSandboxControlPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(LqptSandboxControlPlugin.class);

    public void afterCreateNewData(EventObject e) {
        LqptSandboxControl lqptSandboxControl = new LqptSandboxControl();
        lqptSandboxControl.initSandBoxControlParam(this);
        lqptSandboxControl.initSandBoxVirtualParam(this);
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"advcontoolbarap5", "advcontoolbarap", "advcontoolbarap4", "advcontoolbarap1", "advcontoolbarap2", "advcontoolbarap6", "advcontoolbarap3", "advcontoolbarap7"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String sxcsbz = ImcConfigUtil.getValue((String)"bdm_lqpt", (String)"sxcsbz");
        if (!"1".equals(sxcsbz)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u6c99\u7bb1\u6d4b\u8bd5\u6807\u8bc6\uff0c\u8bf7\u914d\u7f6e\u540e\u518d\u8fdb\u884c\u8c03\u7528\u63a7\u5236\u670d\u52a1", (String)"LqptSandboxControlPlugin_0", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        try {
            switch (evt.getItemKey()) {
                case "virtualinit": {
                    this.virtualEnterpriseInit();
                    break;
                }
                case "init": {
                    this.init();
                    break;
                }
                case "addsxed": {
                    this.addSxed();
                    break;
                }
                case "changestatus": {
                    this.changeInvoiceStatus();
                    break;
                }
                case "change": {
                    this.changeEnterprise();
                    break;
                }
                case "reset": {
                    this.resetEnterprise();
                    break;
                }
                case "input_init": {
                    this.cshcjbm();
                    break;
                }
                case "taxperiodset": {
                    this.taxperiodSet();
                    break;
                }
                case "accountinginit": {
                    this.accountingInit();
                }
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private void init() {
        this.checkParams(false);
        JSONObject requestJson = this.createRequestJson();
        this.checkStringParams(requestJson, "nsrsbh_init");
        requestJson.put("nsrsbh", (Object)requestJson.getString("nsrsbh_init"));
        requestJson.remove((Object)"nsrsbh_init");
        this.checkStringParams(requestJson, "ssjswjgdm_init");
        requestJson.put("ssjswjgDm", (Object)requestJson.getString("ssjswjgdm_init"));
        requestJson.remove((Object)"ssjswjgdm_init");
        this.requestSandbox(requestJson, "LQSX_SWZJ_GT4_QYXXCSH", this.getLeqiIdByTaxNo(requestJson.getString("nsrsbh")));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6210\u529f", (String)"LqptSandboxControlPlugin_1", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
    }

    private void taxperiodSet() {
        JSONObject json = new JSONObject();
        Date skssq = (Date)this.getModel().getValue("skssq");
        if (skssq == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f \u4e0d\u80fd\u4e3a\u7a7a", (String)"LqptSandboxControlPlugin_2", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
        }
        json.put("skssq", (Object)DateUtils.format((Date)skssq, (String)"yyyyMM"));
        this.checkStringParams(json, "sqbz");
        this.requestSandbox(json, "LQSX_SWZJ_GT4_SXFW_SZSKSSQ", "");
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u8bbe\u7f6e\u6210\u529f", (String)"LqptSandboxControlPlugin_3", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
    }

    private void accountingInit() {
        JSONArray hgjksList;
        JSONObject requestJson = new JSONObject();
        this.checkStringParams(requestJson, "kjywrsbh", false);
        this.checkStringParams(requestJson, "bkjnsrsbh", false);
        this.checkStringParams(requestJson, "jkdwrnsrsbh", false);
        JSONObject jsonObject = this.requestSandbox(requestJson, "LQSX_SWZJ_GT4_SXFW_RZXXCSH", "");
        ArrayList<DynamicObject> visualizationList = new ArrayList<DynamicObject>(8);
        JSONArray dkdjList = jsonObject.getJSONArray("dkdjwspzList");
        if (dkdjList != null && dkdjList.size() != 0) {
            logger.info("\u4ee3\u6263\u4ee3\u7f34\u5b8c\u7a0e\u51ed\u8bc1\uff1a" + dkdjList.toJSONString());
            JSONObject dkdj = dkdjList.getJSONObject(0);
            visualizationList.add(this.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "accounting_dkdjwspzh", dkdj.getString("dkdjwspzh")));
            visualizationList.add(this.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "accounting_dkdjwsprq", DateUtils.format((Date)dkdj.getDate("tfrq"), (String)"yyyyMMdd")));
            visualizationList.add(this.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "accounting_dkdj_kjywrsbh", dkdj.getString("kjywrsbh")));
            visualizationList.add(this.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "accounting_dkdj_bkjnsrsbh", dkdj.getString("bkjnsrsbh")));
        }
        if ((hgjksList = jsonObject.getJSONArray("hgjksList")) != null && hgjksList.size() != 0) {
            logger.info("\u6d77\u5173\u7f34\u6b3e\u4e66\uff1a" + hgjksList.toJSONString());
            JSONObject hgjks = hgjksList.getJSONObject(0);
            visualizationList.add(this.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "accounting_jkdwrnsrsbh", hgjks.getString("jkdwrnsrsbh")));
            visualizationList.add(this.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "accounting_hgjkshm", hgjks.getString("hgjkshm")));
            visualizationList.add(this.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "accounting_hgjksrq", DateUtils.format((Date)hgjks.getDate("tfrq"), (String)"yyyyMMdd")));
        }
        ImcConfigUtil.removeCache((String)"bdm_lqpt_sandbox_visualization");
        DeleteServiceHelper.delete((String)"invsm_param_configuration", (QFilter[])new QFilter("config_type", "=", (Object)"bdm_lqpt_sandbox_visualization").and("config_key", "like", (Object)"accounting_%").toArray());
        ImcSaveServiceHelper.save(visualizationList);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5165\u8d26\u4fe1\u606f\u521d\u59cb\u5316\u6210\u529f", (String)"LqptSandboxControlPlugin_4", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
    }

    private JSONObject createEnterpriseJson() {
        JSONObject json = new JSONObject();
        this.checkStringParams(json, "taxno");
        json.put("nsrsbh", (Object)json.getString("taxno"));
        json.remove((Object)"taxno");
        String ssjswjgdm = (String)this.getModel().getValue("ssjswjgdm");
        if (StringUtils.isBlank((CharSequence)ssjswjgdm)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7701\u5e02\u7ea7\u7a0e\u52a1\u673a\u5173\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"LqptSandboxControlPlugin_5", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
        }
        json.put("ssjswjgDm", (Object)ssjswjgdm);
        return json;
    }

    private void changeEnterprise() {
        List qyhyxzdmList;
        JSONObject requestJson = this.createEnterpriseJson();
        this.checkStringParams(requestJson, "fxnsrlx");
        this.checkStringParams(requestJson, "xydj");
        this.checkStringParams(requestJson, "ckqyfldm");
        requestJson.put("ckqyflDm", requestJson.remove((Object)"ckqyfldm"));
        this.checkStringParams(requestJson, "zfjglxdm");
        requestJson.put("zfjglxDm", requestJson.remove((Object)"zfjglxdm"));
        this.checkStringParams(requestJson, "nsrztdm");
        requestJson.put("nsrztDm", requestJson.remove((Object)"nsrztdm"));
        String qyhyxzdms = (String)this.getModel().getValue("qyhyxzdms");
        if (StringUtils.isNotBlank((CharSequence)qyhyxzdms) && CollectionUtils.isNotEmpty((Collection)(qyhyxzdmList = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)qyhyxzdms)))) {
            JSONArray jsonArray = new JSONArray();
            for (String qyhyxzdm : qyhyxzdmList) {
                JSONObject itemJson = new JSONObject();
                itemJson.put("qyhyxzdm", (Object)qyhyxzdm);
                itemJson.put("yxqq", (Object)1633838529000L);
                itemJson.put("yxqz", (Object)4070880000000L);
                jsonArray.add((Object)itemJson);
            }
            requestJson.put("qyhyxzDOList", (Object)jsonArray);
        }
        this.checkStringParams(requestJson, "nsryjjb", false);
        this.checkStringParams(requestJson, "fxnsrbz", false);
        this.checkStringParams(requestJson, "nsrlx", false);
        this.checkStringParams(requestJson, "hydm", false);
        requestJson.put("hyDm", requestJson.remove((Object)"hydm"));
        this.requestSandbox(requestJson, "LQSX_SWZJ_GT4_GXQYXX", this.getLeqiIdByTaxNo(requestJson.getString("nsrsbh")));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d8\u66f4\u4f01\u4e1a\u4fe1\u606f\u6210\u529f", (String)"LqptSandboxControlPlugin_6", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
    }

    private void resetEnterprise() {
        JSONObject requestJson = this.createEnterpriseJson();
        this.requestSandbox(requestJson, "LQSX_SWZJ_GT4_CZQYXX", this.getLeqiIdByTaxNo(requestJson.getString("nsrsbh")));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u7f6e\u6210\u529f", (String)"LqptSandboxControlPlugin_7", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
    }

    private void createParamConfigObj(List<DynamicObject> list, String configKey) {
        Object value = this.getModel().getValue(configKey);
        String str = value instanceof DynamicObject ? ((DynamicObject)value).getPkValue().toString() : (String)value;
        if (StringUtils.isBlank((CharSequence)str)) {
            return;
        }
        list.add(this.buildParamConfigObj("bdm_lqpt_sandbox_control", configKey, str));
    }

    public DynamicObject buildParamConfigObj(String configType, String configKey, String value) {
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"invsm_param_configuration");
        object.set("config_type", (Object)configType);
        object.set("config_key", (Object)configKey);
        object.set("config_value", (Object)value);
        return object;
    }

    private JSONObject createRequestJson() {
        JSONObject json = new JSONObject();
        DynamicObject nsrsbhObj = (DynamicObject)this.getModel().getValue("nsrsbh");
        json.put("nsrsbh", (Object)nsrsbhObj.getString("number"));
        json.put("ssjswjgDm", this.getModel().getValue("ssjswjgdm"));
        return json;
    }

    private void checkParams(boolean checkSsjswjgdm) {
        String ssjswJgdm;
        DynamicObject nsrsbhObj = (DynamicObject)this.getModel().getValue("nsrsbh");
        if (nsrsbhObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u63a5\u5165\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LqptSandboxControlPlugin_8", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
        }
        if (checkSsjswjgdm && StringUtils.isBlank((CharSequence)(ssjswJgdm = (String)this.getModel().getValue("ssjswjgdm")))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7701\u5e02\u7ea7\u7a0e\u52a1\u673a\u5173\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LqptSandboxControlPlugin_9", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
        }
    }

    private void checkStringParams(JSONObject json, String key) {
        this.checkStringParams(json, key, true);
    }

    private void checkStringParams(JSONObject json, String key, boolean isMustInput) {
        String val = (String)this.getModel().getValue(key);
        if (StringUtils.isBlank((CharSequence)val)) {
            if (isMustInput) {
                FieldEdit control = (FieldEdit)this.getControl(key);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LqptSandboxControlPlugin_10", (String)"imc-bdm-lqpt", (Object[])new Object[0]), control.getProperty().getDisplayName().getLocaleValue()));
            }
            json.put(key, (Object)"");
            return;
        }
        json.put(key, (Object)val);
    }

    private void virtualEnterpriseInit() {
        this.checkParams(true);
        DynamicObject virtualorg = (DynamicObject)this.getModel().getValue("virtualorg");
        if (virtualorg == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u865a\u62df\u4f01\u4e1a\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LqptSandboxControlPlugin_11", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
        }
        JSONObject resJson = this.requestSandbox(this.createRequestJson(), "LQSX_SWZJ_GT4_CXXNQYXX", (String)this.getModel().getValue("leqiid"));
        JSONArray lqxndwxxArr = resJson.getJSONArray("lqxndwxx");
        JSONObject lqxndwxx = lqxndwxxArr.getJSONObject(0);
        String xndwLeqiId = lqxndwxx.getString("xndwLqdwid");
        String xndwNsrmc = lqxndwxx.getString("xndwNsrmc");
        String xndwNsrsbh = lqxndwxx.getString("xndwNsrsbh");
        this.getModel().setValue("xndwleqiid", (Object)xndwLeqiId);
        this.getModel().setValue("xndwnsrsbh", (Object)xndwNsrsbh);
        this.getModel().setValue("xndwnsrmc", (Object)xndwNsrmc);
        DynamicObject nsrsbhObj = (DynamicObject)this.getModel().getValue("nsrsbh");
        DynamicObject epBaseInfo = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)"id", (QFilter[])new QFilter("number", "=", (Object)nsrsbhObj.getString("number")).toArray());
        if (epBaseInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u4f01\u4e1a\u4fe1\u606f", (String)"LqptSandboxControlPlugin_12", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
        }
        epBaseInfo = BusinessDataServiceHelper.loadSingle((Object)epBaseInfo.getPkValue(), (String)"bdm_enterprise_baseinfo");
        epBaseInfo.set("enterpriserole", (Object)"1");
        epBaseInfo.set("leqiid", this.getModel().getValue("leqiid"));
        epBaseInfo.set("leqisecret", this.getModel().getValue("leqisecret"));
        epBaseInfo.set("issuechannel", (Object)"2");
        ImcSaveServiceHelper.save((DynamicObject)epBaseInfo);
        TaxpayerService taxpayerService = new TaxpayerService();
        try {
            taxpayerService.init(nsrsbhObj.getString("number"), "1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("virtualorg")), (String)"bdm_org");
        DynamicObject virtualEnterPrise = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)"id", (QFilter[])new QFilter("number", "=", (Object)xndwNsrsbh).toArray());
        virtualEnterPrise = virtualEnterPrise == null ? BusinessDataServiceHelper.newDynamicObject((String)"bdm_enterprise_baseinfo") : BusinessDataServiceHelper.loadSingle((Object)virtualEnterPrise.getPkValue(), (String)"bdm_enterprise_baseinfo");
        virtualEnterPrise.set("name", (Object)xndwNsrmc);
        virtualEnterPrise.set("number", (Object)xndwNsrsbh);
        virtualEnterPrise.set("org", (Object)org);
        virtualEnterPrise.set("org", (Object)org);
        Date now = new Date();
        virtualEnterPrise.set("createtime", (Object)now);
        virtualEnterPrise.set("modifytime", (Object)now);
        virtualEnterPrise.set("authtype", (Object)"5");
        virtualEnterPrise.set("isvoucher", (Object)"2");
        virtualEnterPrise.set("issuechannel", (Object)"2");
        virtualEnterPrise.set("leqiid", (Object)lqxndwxx.getString("xndwLqdwid"));
        virtualEnterPrise.set("enterpriserole", (Object)"2");
        virtualEnterPrise.set("accessepinfo", epBaseInfo.getPkValue());
        ImcSaveServiceHelper.save((DynamicObject)virtualEnterPrise);
        try {
            taxpayerService.init(xndwNsrsbh, "2");
        }
        catch (Exception exception) {
            // empty catch block
        }
        DynamicObject epInfo = BusinessDataServiceHelper.newDynamicObject((String)"bdm_enterprise_info");
        epInfo.set("epinfo", virtualEnterPrise.getPkValue());
        ImcSaveServiceHelper.save((DynamicObject)epInfo);
        org.set("epinfo", virtualEnterPrise.getPkValue());
        org.set("enterprisemainorg", (Object)"1");
        ImcSaveServiceHelper.save((DynamicObject)org);
        InputPermissionUtils.savePermission((Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)org.getPkValue()));
        ArrayList<DynamicObject> visualizationList = new ArrayList<DynamicObject>(8);
        visualizationList.add(this.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "virtual_leqiId", xndwLeqiId));
        visualizationList.add(this.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "virtual_taxno", xndwNsrsbh));
        visualizationList.add(this.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "virtual_taxname", xndwNsrmc));
        visualizationList.add(this.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "virtual_org", org.getPkValue().toString()));
        ImcConfigUtil.removeCache((String)"bdm_lqpt_sandbox_visualization");
        DeleteServiceHelper.delete((String)"invsm_param_configuration", (QFilter[])new QFilter("config_type", "=", (Object)"bdm_lqpt_sandbox_visualization").and("config_key", "like", (Object)"virtual_%").toArray());
        ImcSaveServiceHelper.save(visualizationList);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(8);
        this.createParamConfigObj(list, "control_url");
        this.createParamConfigObj(list, "leqiid");
        this.createParamConfigObj(list, "leqisecret");
        this.createParamConfigObj(list, "nsrsbh");
        this.createParamConfigObj(list, "ssjswjgdm");
        ImcConfigUtil.removeCache((String)"bdm_lqpt_sandbox_control");
        DeleteServiceHelper.delete((String)"invsm_param_configuration", (QFilter[])new QFilter("config_type", "=", (Object)"bdm_lqpt_sandbox_control").toArray());
        ImcSaveServiceHelper.save(list);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6210\u529f", (String)"LqptSandboxControlPlugin_1", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
    }

    private void addSxed() {
        this.checkParams(true);
        JSONObject requestJson = this.createRequestJson();
        BigDecimal ed = (BigDecimal)this.getModel().getValue("ed");
        if (ed == null || ed.compareTo(BigDecimal.ZERO) <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u5e94\u8be5\u5927\u4e8e0\u3002", (String)"LqptSandboxControlPlugin_13", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
        }
        requestJson.put("ed", (Object)ed);
        this.requestSandbox(requestJson, "LQSX_SWZJ_GT4_ZJNSRSXED", this.getLeqiIdByTaxNo((String)this.getModel().getValue("xsfnsrsbh")));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u589e\u52a0\u6388\u4fe1\u989d\u5ea6\u6210\u529f", (String)"LqptSandboxControlPlugin_14", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
        try {
            SxedService sxedService = new SxedService();
            DynamicObject nsrsbhObj = (DynamicObject)this.getModel().getValue("nsrsbh");
            String taxNo = nsrsbhObj.getString("number");
            DynamicObject sxed = sxedService.getDynamicObject(taxNo);
            if (sxed != null) {
                sxedService.querySxed(taxNo, sxed);
                sxedService.afterQuerySxed(taxNo, sxed);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getLeqiIdByTaxNo(String xsfnsrsbh) {
        if (StringUtils.isBlank((CharSequence)xsfnsrsbh)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LqptSandboxControlPlugin_15", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
        }
        DynamicObject ep = BusinessDataServiceHelper.loadSingleFromCache((String)"bdm_enterprise_baseinfo", (String)String.join((CharSequence)",", "enterpriserole", "leqiid", "leqisecret", "accessepinfo"), (QFilter[])new QFilter("issuechannel", "in", (Object)EnterPriseBaseInfoConstant.LQPT_CHANNEL).and("number", "=", (Object)xsfnsrsbh).toArray());
        if (ep == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u53f7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u672a\u914d\u7f6e\u4e50\u4f01\u3002", (String)"LqptSandboxControlPlugin_16", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
        }
        return ep.getString("leqiid");
    }

    private void changeInvoiceStatus() {
        this.checkParams(false);
        JSONObject json = new JSONObject();
        DynamicObject nsrsbhObj = (DynamicObject)this.getModel().getValue("nsrsbh");
        json.put("xsfnsrsbh", (Object)nsrsbhObj.getString("number"));
        this.checkStringParams(json, "gmfnsrsbh");
        this.checkStringParams(json, "fphm");
        String fprzztDm = (String)this.getModel().getValue("fprzztdm");
        if (StringUtils.isBlank((CharSequence)fprzztDm)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u5165\u8d26\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LqptSandboxControlPlugin_17", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
        }
        json.put("fprzztDm", (Object)fprzztDm);
        String fpdkztdm = (String)this.getModel().getValue("fpdkztdm");
        if (StringUtils.isBlank((CharSequence)fpdkztdm)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u62b5\u6263\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LqptSandboxControlPlugin_18", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
        }
        json.put("fpdkztDm", (Object)fpdkztdm);
        this.requestSandbox(json, "LQSX_SWZJ_GT4_FPRZDKZTBG", this.getLeqiIdByTaxNo(json.getString("gmfnsrsbh")));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u7968\u5165\u8d26\u62b5\u6263\u72b6\u6001\u53d8\u66f4\u6210\u529f", (String)"LqptSandboxControlPlugin_19", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
    }

    private void cshcjbm() {
        JSONArray hgjksList;
        JSONArray dkdjList;
        JSONObject json = new JSONObject();
        this.checkStringParams(json, "cshcjbm");
        String virtualLeqiId = ImcConfigUtil.getValue((String)"bdm_lqpt_sandbox_visualization", (String)"virtual_leqiId");
        JSONObject jsonObject = this.requestSandbox(json, "LQSX_SWZJ_GT4_SXFW_YPSJCSH", virtualLeqiId);
        ArrayList<DynamicObject> visualizationList = new ArrayList<DynamicObject>(8);
        JSONArray fpList = jsonObject.getJSONArray("fplist");
        if (fpList != null && fpList.size() > 0) {
            boolean find01 = false;
            boolean find81 = false;
            boolean find10 = false;
            for (int i = 0; i < fpList.size(); ++i) {
                JSONObject fp = fpList.getJSONObject(i);
                logger.info("\u53d1\u7968\u5bf9\u8c61\uff1a" + fp.toJSONString());
                if ("01".equals(fp.getString("fplx"))) {
                    if (find01) continue;
                    visualizationList.add(this.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "rim_fpdm01", fp.getString("zzfpDm")));
                    visualizationList.add(this.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "rim_fphm01", fp.getString("zzfphm")));
                    visualizationList.add(this.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "rim_kprq01", DateUtils.format((Date)fp.getDate("kprq"), (String)"yyyyMMdd")));
                    visualizationList.add(this.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "rim_kpje01", fp.getString("je")));
                    find01 = true;
                } else if ("81".equals(fp.getString("fplx"))) {
                    if (find81) continue;
                    visualizationList.add(this.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "rim_fpdm81", fp.getString("zzfpDm")));
                    visualizationList.add(this.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "rim_fphm81", fp.getString("fphm")));
                    visualizationList.add(this.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "rim_kprq81", DateUtils.format((Date)fp.getDate("kprq"), (String)"yyyyMMdd")));
                    visualizationList.add(this.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "rim_kpje81", fp.getString("je")));
                    find81 = true;
                } else if ("10".equals(fp.getString("fplx"))) {
                    if (find10) continue;
                    visualizationList.add(this.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "rim_fpdm10", fp.getString("zzfpDm")));
                    visualizationList.add(this.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "rim_fphm10", fp.getString("zzfphm")));
                    visualizationList.add(this.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "rim_kprq10", DateUtils.format((Date)fp.getDate("kprq"), (String)"yyyyMMdd")));
                    visualizationList.add(this.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "rim_kpje10", fp.getString("je")));
                    find10 = true;
                }
                if (find01 && find81 && find10) break;
            }
        }
        if ((dkdjList = jsonObject.getJSONArray("dkdjlist")) != null && dkdjList.size() != 0) {
            logger.info("\u4ee3\u6263\u4ee3\u7f34\u5b8c\u7a0e\u51ed\u8bc1\uff1a" + dkdjList.toJSONString());
            JSONObject dkdj = dkdjList.getJSONObject(0);
            visualizationList.add(this.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "rim_dkdjwspzh", dkdj.getString("dkdjwspzh")));
            visualizationList.add(this.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "rim_dkdjwsprq", DateUtils.format((Date)dkdj.getDate("tfrq"), (String)"yyyyMMdd")));
            visualizationList.add(this.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "rim_dkdj_bkjnsrsbh", dkdj.getString("bkjnsrsbh")));
        }
        if ((hgjksList = jsonObject.getJSONArray("hgjkslist")) != null && hgjksList.size() != 0) {
            logger.info("\u6d77\u5173\u7f34\u6b3e\u4e66\uff1a" + hgjksList.toJSONString());
            JSONObject hgjks = hgjksList.getJSONObject(0);
            visualizationList.add(this.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "rim_hgjkshm", hgjks.getString("hgjkshm")));
            visualizationList.add(this.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "rim_hgjksrq", DateUtils.format((Date)hgjks.getDate("tfrq"), (String)"yyyyMMdd")));
        }
        ImcConfigUtil.removeCache((String)"bdm_lqpt_sandbox_visualization");
        DeleteServiceHelper.delete((String)"invsm_param_configuration", (QFilter[])new QFilter("config_type", "=", (Object)"bdm_lqpt_sandbox_visualization").and("config_key", "like", (Object)"rim_%").toArray());
        ImcSaveServiceHelper.save(visualizationList);
        this.requestSandbox(new JSONObject(), "LQSX_SWZJ_GT4_SXFW_CSHSJZLGJCF", virtualLeqiId);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6210\u529f", (String)"LqptSandboxControlPlugin_1", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
    }

    private JSONObject requestSandbox(JSONObject requestJson, String serviceid, String sydwLeqiId) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "text/plain; charset=utf-8");
        String controlUrl = (String)this.getModel().getValue("control_url");
        if (StringUtils.isBlank((CharSequence)controlUrl)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u63a7\u5236\u670d\u52a1\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LqptSandboxControlPlugin_20", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
        }
        String leqiId = (String)this.getModel().getValue("leqiid");
        if (StringUtils.isBlank((CharSequence)leqiId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u63a5\u5165\u5355\u4f4d\u4e50\u4f01id\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LqptSandboxControlPlugin_21", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
        }
        String leqiSecret = (String)this.getModel().getValue("leqisecret");
        if (StringUtils.isBlank((CharSequence)leqiSecret)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u63a5\u5165\u5355\u4f4d\u4e50\u4f01\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LqptSandboxControlPlugin_22", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
        }
        headers.put("jrdwptbh", leqiId);
        if (StringUtils.isNotBlank((CharSequence)sydwLeqiId)) {
            headers.put("sydwptbh", sydwLeqiId);
        } else {
            headers.put("sydwptbh", leqiId);
        }
        headers.put("sxcxbz", "1");
        logger.info(String.format("\u8bf7\u6c42\u5934\u4e3a:%s", SerializationUtils.toJsonString(headers)));
        try {
            String requestStr = requestJson.toJSONString();
            logger.info("\u8bf7\u6c42\u4e50\u4f01\u63a5\u53e3\u539f\u59cb\u53c2\u6570\uff1a" + requestStr);
            String content = SM4Util.encryptEcb(leqiSecret, requestStr);
            logger.info("\u8bf7\u6c42\u4e50\u4f01\u63a5\u53e3\u52a0\u5bc6\u53c2\u6570\uff1a" + content);
            StringEntity httpEntity = new StringEntity(content, "UTF-8");
            String result = HttpUtil.doPost((String)(controlUrl + '/' + serviceid), null, headers, (HttpEntity)httpEntity, (int)15000, (int)15000);
            logger.info("\u4e50\u4f01\u63a5\u53e3\u54cd\u5e94\u539f\u59cb\u7ed3\u679c :" + result);
            JSONObject resultJson = JSONObject.parseObject((String)result);
            String httpStatusCode = resultJson.getString("httpStatusCode");
            if (!"200".equals(httpStatusCode)) {
                throw new KDBizException(resultJson.getString("body"));
            }
            JSONObject responseBody = resultJson.getJSONObject("body");
            JSONObject Response = responseBody.getJSONObject("Response");
            JSONObject error = Response.getJSONObject("Error");
            if (error != null && !error.isEmpty()) {
                throw new KDBizException(error.getString("Message"));
            }
            String Data = Response.getString("Data");
            String decodeResult = SM4Util.decryptEcb(leqiSecret, Data);
            JSONObject dataJsonObject = JSONObject.parseObject((String)decodeResult);
            String returncode = dataJsonObject.getString("returncode");
            logger.info("\u4e50\u4f01\u63a5\u53e3\u54cd\u5e94\u89e3\u5bc6\u7ed3\u679c :" + decodeResult);
            if (!"00".equals(returncode)) {
                throw new KDBizException(dataJsonObject.getString("returnmsg"));
            }
            return dataJsonObject;
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }
}

