/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.lqpt.formplugin.op;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.RandomString;
import kd.imc.bdm.lqpt.formplugin.LqptSandboxControlPlugin;
import kd.imc.bdm.lqpt.utils.SM4Util;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;

public class LqptSandboxTestCaseOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(LqptSandboxControlPlugin.class);
    private static final ImmutableSet<String> not_print_success_log = new ImmutableSet.Builder().add((Object[])new String[]{"CXSSFLBM", "CXJYSSFLBM", "CXHGJKSNCPHGSHLB"}).build();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("accessepinfo");
        e.getFieldKeys().add("leqiid");
        e.getFieldKeys().add("leqisecret");
        e.getFieldKeys().add("items.abilityid");
        e.getFieldKeys().add("items.abilitytype");
        e.getFieldKeys().add("items.caseid");
        e.getFieldKeys().add("items.caseresult");
        e.getFieldKeys().add("items.caseresult_tag");
        e.getFieldKeys().add("subentryentity.methodnumber");
        e.getFieldKeys().add("subentryentity.methodename");
        e.getFieldKeys().add("subentryentity.methodreq");
        e.getFieldKeys().add("subentryentity.methodreq_tag");
        e.getFieldKeys().add("subentryentity.methodresult");
        e.getFieldKeys().add("subentryentity.methodresult_tag");
        e.getFieldKeys().add("subentryentity.cache_response");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] testCaseArr;
        for (DynamicObject testCase : testCaseArr = e.getDataEntities()) {
            this.executeTestCase(testCase);
        }
        ImcSaveServiceHelper.save((DynamicObject[])testCaseArr);
    }

    private void executeTestCase(DynamicObject testCase) {
        Date today = DateUtils.trunc((Date)new Date());
        Map variables = this.getOption().getVariables();
        String selectRows = variables.getOrDefault("selectRows", "");
        if (StringUtils.isBlank((CharSequence)selectRows)) {
            return;
        }
        String selectSubRows = variables.getOrDefault("selectSubRows", "");
        String taxNo = testCase.getDynamicObject("accessepinfo").getString("number");
        DynamicObjectCollection testItems = testCase.getDynamicObjectCollection("items");
        DynamicObject testItem = (DynamicObject)testItems.get(Integer.parseInt(selectRows));
        DynamicObjectCollection subItems = testItem.getDynamicObjectCollection("subentryentity");
        if (CollectionUtils.isEmpty((Collection)subItems)) {
            testItem.set("caseresult", (Object)"empty params");
            return;
        }
        for (int j = 0; j < subItems.size(); ++j) {
            JSONObject request;
            JSONObject requestJson;
            if (StringUtils.isNotBlank((CharSequence)selectSubRows) && !selectSubRows.equals(String.valueOf(j))) continue;
            DynamicObject subItem2 = (DynamicObject)subItems.get(j);
            if (ResManager.loadKDString((String)"\u6210\u529f", (String)"LqptSandboxTestCaseOp_0", (String)"imc-bdm-lqpt", (Object[])new Object[0]).equals(subItem2.getString("methodresult"))) continue;
            String methodreq_tag = subItem2.getString("methodreq_tag");
            if (StringUtils.isBlank((CharSequence)methodreq_tag)) {
                subItem2.set("methodresult", (Object)ResManager.loadKDString((String)"\u5931\u8d25", (String)"LqptSandboxTestCaseOp_1", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
                subItem2.set("methodresult_tag", (Object)"empty params");
                return;
            }
            if (methodreq_tag.startsWith("[")) {
                JSONArray jsonArray = JSONObject.parseArray((String)methodreq_tag);
                requestJson = jsonArray.getJSONObject(0);
                request = jsonArray;
            } else {
                request = requestJson = JSONObject.parseObject((String)methodreq_tag);
            }
            JSONObject saveResponse = requestJson.getJSONObject("saveResponse");
            requestJson.remove((Object)"saveResponse");
            boolean useAccessLeqiId = requestJson.containsKey((Object)"useAccessLeqiId");
            requestJson.remove((Object)"useAccessLeqiId");
            this.replaceJsonVal(requestJson, taxNo, today, testCase, subItems, subItem2);
            if (subItem2.getString("methodresult_tag").contains(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u7528\u4f8b\u8fd4\u56de", (String)"LqptSandboxTestCaseOp_2", (String)"imc-bdm-lqpt", (Object[])new Object[0])) && subItem2.getString("methodresult_tag").contains(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230", (String)"LqptSandboxTestCaseOp_3", (String)"imc-bdm-lqpt", (Object[])new Object[0]))) continue;
            StringBuilder sb = new StringBuilder();
            JSONObject responseJson = this.executeRequest(sb, testCase, testItem, subItem2, SerializationUtils.toJsonString((Object)request), useAccessLeqiId);
            if (responseJson != null) {
                if (saveResponse != null) {
                    Set entries = saveResponse.entrySet();
                    JSONObject paramJson = new JSONObject();
                    for (Map.Entry entry : entries) {
                        String key = (String)entry.getValue();
                        if (!key.contains(".")) {
                            paramJson.put((String)entry.getKey(), (Object)responseJson.getString((String)entry.getValue()));
                            continue;
                        }
                        String[] split = key.split("\\.");
                        paramJson.put((String)entry.getKey(), (Object)responseJson.getJSONObject(split[0]).getString(split[1]));
                    }
                    subItem2.set("cache_response", (Object)paramJson.toJSONString());
                }
                subItem2.set("methodresult", (Object)ResManager.loadKDString((String)"\u6210\u529f", (String)"LqptSandboxTestCaseOp_0", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
            } else {
                subItem2.set("methodresult", (Object)ResManager.loadKDString((String)"\u5931\u8d25", (String)"LqptSandboxTestCaseOp_1", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
            }
            subItem2.set("methodresult_tag", (Object)sb.toString());
        }
        long successSize = subItems.stream().filter(subItem -> ResManager.loadKDString((String)"\u6210\u529f", (String)"LqptSandboxTestCaseOp_0", (String)"imc-bdm-lqpt", (Object[])new Object[0]).equals(subItem.getString("methodresult"))).count();
        if (successSize == (long)subItems.size()) {
            testItem.set("caseresult", (Object)ResManager.loadKDString((String)"\u6210\u529f", (String)"LqptSandboxTestCaseOp_0", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
        } else if (successSize != 0L) {
            testItem.set("caseresult", (Object)ResManager.loadKDString((String)"\u90e8\u5206\u6210\u529f", (String)"LqptSandboxTestCaseOp_4", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
        } else {
            testItem.set("caseresult", (Object)ResManager.loadKDString((String)"\u5931\u8d25", (String)"LqptSandboxTestCaseOp_1", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
        }
    }

    private void replaceJsonVal(JSONObject requestJson, String taxNo, Date today, DynamicObject testCase, DynamicObjectCollection subItems, DynamicObject currentSubItem) {
        Long sleep = requestJson.getLong("sleep");
        if (sleep != null) {
            try {
                Thread.sleep(sleep);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        requestJson.remove((Object)"sleep");
        Map sandboxVisualization = ImcConfigUtil.putCache((String)"bdm_lqpt_sandbox_visualization");
        Set jsonEntries = requestJson.entrySet();
        for (Map.Entry jsonEntry : jsonEntries) {
            Object value = jsonEntry.getValue();
            if (value instanceof String) {
                if ("nsrsbh".equals(value)) {
                    jsonEntry.setValue(taxNo);
                    continue;
                }
                if ("xsfmc".equals(value)) {
                    jsonEntry.setValue(testCase.getDynamicObject("accessepinfo").getString("name"));
                    continue;
                }
                if ("ptbh".equals(value)) {
                    jsonEntry.setValue(testCase.getString("leqiid"));
                    continue;
                }
                if ("uuid".equals(value)) {
                    jsonEntry.setValue(testCase.getString("leqiid") + testCase.getString("leqiid") + RandomString.nextString((int)32, (boolean)false, (boolean)false));
                    continue;
                }
                if ("gmfmc".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("virtual_taxname"), ResManager.loadKDString((String)"\u8377\u5858\u533a\u6709\u7406\u60f3\u9910\u5385", (String)"LqptSandboxTestCaseOp_5", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
                    continue;
                }
                if ("gmfnsrsbh".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("virtual_taxno"), "92430202MA4M6C8D7N");
                    continue;
                }
                if ("rim_fpdm01".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("rim_fpdm01"), "9999240410");
                    continue;
                }
                if ("rim_fphm01".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("rim_fphm01"), "00022081");
                    continue;
                }
                if ("rim_kprq01".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("rim_kprq01"), "20240410");
                    continue;
                }
                if ("rim_kpje01".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("rim_kpje01"), "7547.17");
                    continue;
                }
                if ("rim_fpdm81".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("rim_fpdm81"), "9999240410");
                    continue;
                }
                if ("rim_fphm81".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("rim_fphm81"), "00022081");
                    continue;
                }
                if ("rim_kprq81".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("rim_kprq81"), "20240410");
                    continue;
                }
                if ("rim_kpje81".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("rim_kpje81"), "7547.17");
                    continue;
                }
                if ("rim_fpdm10".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("rim_fpdm10"), "9999240410");
                    continue;
                }
                if ("rim_fphm10".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("rim_fphm10"), "00022081");
                    continue;
                }
                if ("rim_kprq10".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("rim_kprq10"), "20240410");
                    continue;
                }
                if ("rim_kpje10".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("rim_kpje10"), "7547.17");
                    continue;
                }
                if ("rim_hgjkshm".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("rim_hgjkshm"), "425020211008888520-L02");
                    continue;
                }
                if ("rim_hgjksrq".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("rim_hgjksrq"), "20230401");
                    continue;
                }
                if ("rim_dkdjwspzh".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("rim_dkdjwspzh"), "353015220400121173");
                    continue;
                }
                if ("rim_dkdjwsprq".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("rim_dkdjwsprq"), "20180606");
                    continue;
                }
                if ("rim_dkdj_bkjnsrsbh".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("rim_dkdj_bkjnsrsbh"), "410105169954248");
                    continue;
                }
                if ("sim_lzfpsl".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("sim_lzfpsl"), "1");
                    continue;
                }
                if ("sim_lzfpje".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("sim_lzfpje"), "10.00");
                    continue;
                }
                if ("sim_lzfpse".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("sim_lzfpse"), "0.13");
                    continue;
                }
                if ("sim_hzfpsl".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("sim_hzfpsl"), "0");
                    continue;
                }
                if ("sim_hzfpje".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("sim_hzfpje"), "0.00");
                    continue;
                }
                if ("sim_hzfpse".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("sim_hzfpse"), "0.00");
                    continue;
                }
                if ("accounting_dkdjwspzh".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("accounting_dkdjwspzh"), "399996052900001081");
                    continue;
                }
                if ("accounting_dkdjwsprq".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("accounting_dkdjwsprq"), "20240529");
                    continue;
                }
                if ("accounting_dkdj_bkjnsrsbh".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("accounting_dkdj_bkjnsrsbh"), "9145080070864475XF");
                    continue;
                }
                if ("accounting_dkdj_kjywrsbh".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("accounting_dkdj_kjywrsbh"), "9145080070864475XF");
                    continue;
                }
                if ("accounting_hgjkshm".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("accounting_hgjkshm"), "000024052900001261-L02");
                    continue;
                }
                if ("accounting_hgjksrq".equals(value)) {
                    this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("accounting_hgjksrq"), "20240529");
                    continue;
                }
                if (!"accounting_jkdwrnsrsbh".equals(value)) continue;
                this.setReplaceVal(jsonEntry, (String)sandboxVisualization.get("accounting_jkdwrnsrsbh"), "9145080070864475XF");
                continue;
            }
            if (value instanceof JSONObject) {
                this.replaceJsonVal((JSONObject)value, taxNo, today, testCase, subItems, currentSubItem);
                continue;
            }
            if (!(value instanceof JSONArray)) continue;
            JSONArray array = (JSONArray)value;
            for (int i = 0; i < array.size(); ++i) {
                JSONObject itemsJSONObject = array.getJSONObject(i);
                this.replaceJsonVal(itemsJSONObject, taxNo, today, testCase, subItems, currentSubItem);
            }
        }
        String getPreResponse = requestJson.getString("getPreResponse");
        if (StringUtils.isNotBlank((CharSequence)getPreResponse)) {
            DynamicObject findItem = null;
            for (DynamicObject subItem : subItems) {
                if (!getPreResponse.equals(subItem.getString("methodnumber"))) continue;
                findItem = subItem;
                break;
            }
            if (findItem == null) {
                currentSubItem.set("methodresult", (Object)ResManager.loadKDString((String)"\u5931\u8d25", (String)"LqptSandboxTestCaseOp_1", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
                currentSubItem.set("methodresult_tag", (Object)String.format(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230(%1$s)\u5bf9\u5e94\u7684\u7528\u4f8b\u8fd4\u56de\uff0c\u8bf7\u5148\u6267\u884c\u5bf9\u5e94\u7528\u4f8b", (String)"LqptSandboxTestCaseOp_24", (String)"imc-bdm-lqpt", (Object[])new Object[0]), getPreResponse));
            } else if (StringUtils.isNotBlank((CharSequence)findItem.getString("cache_response"))) {
                requestJson.putAll((Map)JSONObject.parseObject((String)findItem.getString("cache_response")));
                currentSubItem.set("methodresult_tag", (Object)"");
            } else {
                currentSubItem.set("methodresult", (Object)ResManager.loadKDString((String)"\u5931\u8d25", (String)"LqptSandboxTestCaseOp_1", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
                currentSubItem.set("methodresult_tag", (Object)String.format(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230(%1$s|%2$s)\u5bf9\u5e94\u7684\u7528\u4f8b\u8fd4\u56de\uff0c\u8bf7\u5148\u6267\u884c\u5bf9\u5e94\u7528\u4f8b", (String)"LqptSandboxTestCaseOp_25", (String)"imc-bdm-lqpt", (Object[])new Object[0]), getPreResponse, findItem.getString("methodename")));
            }
        }
        requestJson.remove((Object)"getPreResponse");
        String dateFormatStr = requestJson.getString("dateFormat");
        if (StringUtils.isNotBlank((CharSequence)dateFormatStr)) {
            boolean getPreMonth = requestJson.containsKey((Object)"getPreMonth");
            requestJson.remove((Object)"getPreMonth");
            boolean getAppointMonth = requestJson.containsKey((Object)"getAppointMonth");
            requestJson.remove((Object)"getAppointMonth");
            String date = (String)sandboxVisualization.get("date");
            JSONObject dateFormatJson = JSONObject.parseObject((String)dateFormatStr);
            Set entries = dateFormatJson.entrySet();
            for (Map.Entry entry : entries) {
                Date formatDate = getPreMonth ? DateUtils.addMonth((Date)today, (int)-1) : (getAppointMonth && StringUtils.isNotBlank((CharSequence)date) ? DateUtils.handleDate((String)date) : today);
                requestJson.put((String)entry.getKey(), (Object)new SimpleDateFormat((String)entry.getValue()).format(formatDate));
            }
        }
        requestJson.remove((Object)"dateFormat");
        String removeKey = requestJson.getString("removeKey");
        if (StringUtils.isNotBlank((CharSequence)removeKey)) {
            String[] split;
            for (String s : split = removeKey.split(",")) {
                requestJson.remove((Object)s);
            }
            requestJson.remove((Object)"removeKey");
        }
    }

    private void setReplaceVal(Map.Entry<String, Object> jsonEntry, String configValue, String defaultVal) {
        if (StringUtils.isBlank((CharSequence)configValue)) {
            jsonEntry.setValue(defaultVal);
        } else {
            jsonEntry.setValue(configValue);
        }
    }

    private JSONObject executeRequest(StringBuilder sb, DynamicObject testCase, DynamicObject testItem, DynamicObject subItem, String requestStr, boolean useAccessLeqiId) {
        String virtualLeqiId;
        String leqiId = testCase.getString("leqiid");
        String leqisecret = testCase.getString("leqisecret");
        String caseId = testItem.getString("caseid");
        String serviceid = subItem.getString("methodnumber");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "text/plain; charset=utf-8");
        headers.put("jrdwptbh", leqiId);
        String abilityType = testItem.getString("abilitytype");
        if ("1".equals(abilityType) && !useAccessLeqiId && StringUtils.isNotBlank((CharSequence)(virtualLeqiId = ImcConfigUtil.getValue((String)"bdm_lqpt_sandbox_visualization", (String)"virtual_leqiId")))) {
            leqiId = virtualLeqiId;
        }
        headers.put("sydwptbh", leqiId);
        if ("1".equals(ImcConfigUtil.getValue((String)"bdm_lqpt", (String)"sandbox_contains_sxcsbz"))) {
            headers.put("sxcsbz", "1");
        }
        try {
            JSONObject resultJson;
            String httpStatusCode;
            String abilityId = testItem.getString("abilityid");
            if (abilityId.contains("_")) {
                abilityId = abilityId.substring(0, abilityId.indexOf(95));
            }
            if (StringUtils.isNotBlank((CharSequence)caseId) && !"1".equals(ImcConfigUtil.getValue((String)"bdm_lqpt", (String)"sandbox_ignore_ylbm"))) {
                headers.put("ylbm", caseId);
            }
            sb.append(ResManager.loadKDString((String)"\u8bf7\u6c42\u5934\u4e3a:", (String)"LqptSandboxTestCaseOp_8", (String)"imc-bdm-lqpt", (Object[])new Object[0])).append(SerializationUtils.toJsonString(headers)).append("\n");
            String msg = String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u6d4b\u8bd5... \u63a5\u53e3\u540d\u79f0\uff1a%1$s,\u63a5\u53e3\u7f16\u7801\uff1a%2$s\n", (String)"LqptSandboxTestCaseOp_10", (String)"imc-bdm-lqpt", (Object[])new Object[0]), subItem.getString("methodename"), caseId);
            sb.append(msg);
            Map map = ImcConfigUtil.getValue((String)"bdm_lqpt");
            String leqiUrl = (String)map.get("baseurl");
            String content = SM4Util.encryptEcb(leqisecret, requestStr);
            StringEntity httpEntity = new StringEntity(content, "UTF-8");
            String reqUrl = leqiUrl + '/' + abilityId + '/' + serviceid;
            sb.append(ResManager.loadKDString((String)"\u8bf7\u6c42\u4e50\u4f01\u63a5\u53e3\u5730\u5740\uff1a", (String)"LqptSandboxTestCaseOp_12", (String)"imc-bdm-lqpt", (Object[])new Object[0])).append(reqUrl).append("\n");
            sb.append(ResManager.loadKDString((String)"\u8bf7\u6c42\u4e50\u4f01\u63a5\u53e3\u539f\u59cb\u53c2\u6570\uff1a", (String)"LqptSandboxTestCaseOp_13", (String)"imc-bdm-lqpt", (Object[])new Object[0])).append(requestStr).append("\n");
            sb.append(ResManager.loadKDString((String)"\u8bf7\u6c42\u4e50\u4f01\u63a5\u53e3\u52a0\u5bc6\u53c2\u6570\uff1a", (String)"LqptSandboxTestCaseOp_14", (String)"imc-bdm-lqpt", (Object[])new Object[0])).append(content).append("\n");
            String result = HttpUtil.doPost((String)reqUrl, null, headers, (HttpEntity)httpEntity, (int)30000, (int)30000);
            if (!not_print_success_log.contains((Object)serviceid)) {
                sb.append(ResManager.loadKDString((String)"\u4e50\u4f01\u63a5\u53e3\u54cd\u5e94\u539f\u59cb\u7ed3\u679c :", (String)"LqptSandboxTestCaseOp_15", (String)"imc-bdm-lqpt", (Object[])new Object[0])).append(result).append("\n");
            }
            if (!"200".equals(httpStatusCode = (resultJson = JSONObject.parseObject((String)result)).getString("httpStatusCode"))) {
                sb.append(ResManager.loadKDString((String)"\u4e50\u4f01\u63a5\u53e3\u54cd\u5e94http\u72b6\u6001\u7801\u4e3a", (String)"LqptSandboxTestCaseOp_16", (String)"imc-bdm-lqpt", (Object[])new Object[0])).append(httpStatusCode).append("\n");
                sb.append(ResManager.loadKDString((String)"\u7ed3\u675f\u6d4b\u8bd5...", (String)"LqptSandboxTestCaseOp_17", (String)"imc-bdm-lqpt", (Object[])new Object[0])).append("\n");
                return null;
            }
            JSONObject responseBody = resultJson.getJSONObject("body");
            JSONObject Response = responseBody.getJSONObject("Response");
            JSONObject error = Response.getJSONObject("Error");
            if (error != null && !error.isEmpty()) {
                sb.append(ResManager.loadKDString((String)"\u4e50\u4f01\u63a5\u53e3\u54cd\u5e94\u72b6\u6001\u7801\u4e3a", (String)"LqptSandboxTestCaseOp_18", (String)"imc-bdm-lqpt", (Object[])new Object[0])).append(error.getString("Code")).append(ResManager.loadKDString((String)"\u54cd\u5e94\u4fe1\u606f\u4e3a", (String)"LqptSandboxTestCaseOp_19", (String)"imc-bdm-lqpt", (Object[])new Object[0])).append(error.getString("Message")).append("\n");
                sb.append(ResManager.loadKDString((String)"\u7ed3\u675f\u6d4b\u8bd5...", (String)"LqptSandboxTestCaseOp_17", (String)"imc-bdm-lqpt", (Object[])new Object[0])).append("\n");
                return null;
            }
            String Data = Response.getString("Data");
            String decodeResult = SM4Util.decryptEcb(leqisecret, Data);
            JSONObject dataJsonObject = JSONObject.parseObject((String)decodeResult);
            String returncode = dataJsonObject.getString("returncode");
            if (!"00".equals(returncode)) {
                sb.append(ResManager.loadKDString((String)"\u4e50\u4f01\u63a5\u53e3\u54cd\u5e94\u72b6\u6001\u7801\u4e3a", (String)"LqptSandboxTestCaseOp_18", (String)"imc-bdm-lqpt", (Object[])new Object[0])).append(returncode).append("\n");
                sb.append(ResManager.loadKDString((String)"\u4e50\u4f01\u63a5\u53e3\u54cd\u5e94\u9519\u8bef\u4fe1\u606f\u4e3a", (String)"LqptSandboxTestCaseOp_20", (String)"imc-bdm-lqpt", (Object[])new Object[0])).append(dataJsonObject.getString("returnmsg")).append("\n");
                sb.append(ResManager.loadKDString((String)"\u4e50\u4f01\u63a5\u53e3\u54cd\u5e94\u89e3\u5bc6\u7ed3\u679c :", (String)"LqptSandboxTestCaseOp_21", (String)"imc-bdm-lqpt", (Object[])new Object[0])).append(decodeResult).append("\n");
                sb.append(ResManager.loadKDString((String)"\u7ed3\u675f\u6d4b\u8bd5...", (String)"LqptSandboxTestCaseOp_17", (String)"imc-bdm-lqpt", (Object[])new Object[0])).append("\n");
                return null;
            }
            if (!not_print_success_log.contains((Object)serviceid)) {
                sb.append(ResManager.loadKDString((String)"\u4e50\u4f01\u63a5\u53e3\u54cd\u5e94\u89e3\u5bc6\u7ed3\u679c :", (String)"LqptSandboxTestCaseOp_21", (String)"imc-bdm-lqpt", (Object[])new Object[0])).append(decodeResult).append("\n");
            } else {
                sb.append(ResManager.loadKDString((String)"\u8c03\u7528\u6210\u529f\u3002", (String)"LqptSandboxTestCaseOp_22", (String)"imc-bdm-lqpt", (Object[])new Object[0])).append("\n");
            }
            if (serviceid.startsWith("CXQDFPSCJG")) {
                this.calcLzfpsh(testItem, dataJsonObject);
            }
            sb.append(ResManager.loadKDString((String)"\u7ed3\u675f\u6d4b\u8bd5...", (String)"LqptSandboxTestCaseOp_17", (String)"imc-bdm-lqpt", (Object[])new Object[0])).append("\n\n");
            return dataJsonObject;
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            sb.append(ResManager.loadKDString((String)"\u51fa\u9519...", (String)"LqptSandboxTestCaseOp_23", (String)"imc-bdm-lqpt", (Object[])new Object[0])).append(e.getMessage()).append("\n\n");
            return null;
        }
    }

    private void calcLzfpsh(DynamicObject testItem, JSONObject returnJson) {
        try {
            JSONArray resultList = returnJson.getJSONArray("resultList");
            JSONObject invoiceResult = resultList.getJSONObject(0);
            String status = invoiceResult.getString("status");
            if (!"00".equals(status)) {
                return;
            }
            DynamicObjectCollection subItems = testItem.getDynamicObjectCollection("subentryentity");
            DynamicObject fpscItem = null;
            for (DynamicObject subItem : subItems) {
                if (!subItem.getString("methodnumber").contains("FPSC")) continue;
                fpscItem = subItem;
                break;
            }
            if (fpscItem == null) {
                return;
            }
            String methodreq_tag = fpscItem.getString("methodreq_tag");
            if (StringUtils.isBlank((CharSequence)methodreq_tag)) {
                return;
            }
            JSONObject invoice = JSONObject.parseArray((String)methodreq_tag).getJSONObject(0);
            String hjje = invoice.getBigDecimal("hjje").setScale(2, 4).toString();
            String hjse = invoice.getBigDecimal("hjse").setScale(2, 4).toString();
            Map sandboxVisualization = ImcConfigUtil.putCache((String)"bdm_lqpt_sandbox_visualization");
            String lzfpsl = (String)sandboxVisualization.get("sim_lzfpsl");
            String lzfpje = (String)sandboxVisualization.get("sim_lzfpje");
            String lzfpse = (String)sandboxVisualization.get("sim_lzfpse");
            if (StringUtils.isBlank((CharSequence)lzfpsl)) {
                lzfpsl = "1";
                lzfpje = hjje;
                lzfpse = hjse;
            } else {
                lzfpsl = String.valueOf(Integer.parseInt(lzfpsl) + 1);
                lzfpje = new BigDecimal(lzfpje).add(new BigDecimal(hjje)).setScale(2, 4).toString();
                lzfpse = new BigDecimal(lzfpse).add(new BigDecimal(hjse)).setScale(2, 4).toString();
            }
            ArrayList<DynamicObject> visualizationList = new ArrayList<DynamicObject>(8);
            LqptSandboxControlPlugin lqptSandboxControlPlugin = new LqptSandboxControlPlugin();
            visualizationList.add(lqptSandboxControlPlugin.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "sim_lzfpsl", lzfpsl));
            visualizationList.add(lqptSandboxControlPlugin.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "sim_lzfpje", lzfpje));
            visualizationList.add(lqptSandboxControlPlugin.buildParamConfigObj("bdm_lqpt_sandbox_visualization", "sim_lzfpse", lzfpse));
            DeleteServiceHelper.delete((String)"invsm_param_configuration", (QFilter[])new QFilter("config_type", "=", (Object)"bdm_lqpt_sandbox_visualization").and("config_key", "like", (Object)"sim_%").toArray());
            ImcSaveServiceHelper.save(visualizationList);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

