/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.lqpt.formplugin.op;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.lqpt.service.SxedService;

public class LqptSxedSyncOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(PropertieUtil.addFieldKey((String)"bdm_lqpt_sxed", (boolean)true));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.dataEntities;
                if (dataEntities.length == 0) {
                    return;
                }
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject sxed = dataEntity.getDataEntity();
                    String cacheKey = "lqpt_sxed_query" + sxed.getString("nsrsbh");
                    if (!StringUtils.isNotBlank((CharSequence)CacheHelper.get((String)cacheKey))) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7a0e\u53f7%s\u5728\u4e00\u5c0f\u65f6\u5185\u5df2\u540c\u6b65\u8fc7\u6388\u4fe1\u989d\u5ea6\uff0c\u6682\u65f6\u65e0\u6cd5\u540c\u6b65\uff0c\u4e50\u4f01\u89c4\u5b9a\u67e5\u8be2\u6388\u4fe1\u989d\u5ea6\u6700\u5c0f\u65f6\u95f4\u95f4\u9694\u4e3a\u4e00\u4e2a\u5c0f\u65f6", (String)"LqptSxedSyncOp_0", (String)"imc-bdm-lqpt", (Object[])new Object[0]), sxed.getString("nsrsbh")));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] sxeds = e.getDataEntities();
        SxedService sxedService = new SxedService();
        for (DynamicObject sxed : sxeds) {
            try {
                String nsrsbh = sxed.getString("nsrsbh");
                sxedService.querySxed(nsrsbh, sxed);
                sxedService.afterQuerySxed(nsrsbh, sxed);
            }
            catch (Exception ex) {
                this.operationResult.addErrorInfo((OperateErrorInfo)new ValidationErrorInfo("", sxed.getPkValue(), 0, 0, ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u4e91", (String)"LqptSxedSyncOp_1", (String)"imc-bdm-lqpt", (Object[])new Object[0]), ex.getMessage(), ErrorLevel.Error));
            }
        }
    }
}

