/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.lqpt.formplugin.op;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.lqpt.service.SxedService;

public class LqptSxedValidTimeAdjustOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(PropertieUtil.addFieldKey((String)"bdm_lqpt_sxed", (boolean)true));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.dataEntities;
                if (dataEntities.length == 0) {
                    return;
                }
                Date date = new Date();
                String yyyyMM = DateUtils.format((Date)date, (String)"yyyyMM");
                String yyyy_MM = DateUtils.format((Date)date, (String)"yyyy-MM");
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject sxed = dataEntity.getDataEntity();
                    String sq = sxed.getString("sq");
                    if (StringUtils.isBlank((CharSequence)sq)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7a0e\u53f7%s\u5f53\u524d\u5c5e\u671f\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u8c03\u6574\u3002", (String)"LqptSxedValidTimeAdjustOp_1", (String)"imc-bdm-lqpt", (Object[])new Object[0]), sxed.getString("nsrsbh")));
                        continue;
                    }
                    if (yyyyMM.equals(sq) || yyyy_MM.equals(sq)) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7a0e\u53f7%s\u5f53\u524d\u65e5\u671f\u4e0d\u5728\u5c5e\u671f\u8303\u56f4\u5185\uff0c\u4e0d\u80fd\u8fdb\u884c\u8c03\u6574\u3002", (String)"LqptSxedValidTimeAdjustOp_0", (String)"imc-bdm-lqpt", (Object[])new Object[0]), sxed.getString("nsrsbh")));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] sxeds = e.getDataEntities();
        SxedService sxedService = new SxedService();
        for (DynamicObject sxed : sxeds) {
            try {
                String message = sxedService.updateSxedTime(sxed.getString("nsrsbh"), false);
                if (!StringUtils.isNotBlank((CharSequence)message)) continue;
                this.operationResult.addErrorInfo((OperateErrorInfo)new ValidationErrorInfo("", sxed.getPkValue(), 0, 0, ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u4e91", (String)"LqptSxedSyncOp_1", (String)"imc-bdm-lqpt", (Object[])new Object[0]), message, ErrorLevel.Error));
            }
            catch (Exception ex) {
                this.operationResult.addErrorInfo((OperateErrorInfo)new ValidationErrorInfo("", sxed.getPkValue(), 0, 0, ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u4e91", (String)"LqptSxedSyncOp_1", (String)"imc-bdm-lqpt", (Object[])new Object[0]), ex.getMessage(), ErrorLevel.Error));
            }
        }
    }
}

