/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.lqpt.schedule;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import org.apache.commons.collections.CollectionUtils;

public class LqptTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(LqptTask.class);

    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        try (DLock lock = DLock.create((String)("bdm-clearLog" + LqptTask.class.getSimpleName()));){
            if (lock.tryLock()) {
                Date deleteDay = DateUtils.addDay((Date)new Date(), (int)this.getApiLogSaveDay());
                this.deleteLog(deleteDay, "bdm_lqpt_log", "create_time");
                this.deleteLog(deleteDay, "bdm_api_log", "createdate");
                this.deleteLog(deleteDay, "sim_bill_process_log", "createdate");
                this.deleteLog(deleteDay, "invsm_botp_callback_log", "createtime");
            }
        }
    }

    private int getApiLogSaveDay() {
        int day = 60;
        try {
            day = Integer.parseInt(ImcConfigUtil.getValue((String)"api_log", (String)"save_day"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0 - day;
    }

    private int getLogSingleDeleteCount() {
        int day = 10000;
        try {
            day = Integer.parseInt(ImcConfigUtil.getValue((String)"api_log", (String)"single_delete_count"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return day;
    }

    private void deleteLog(Date deleteDay, String formId, String createDateKey) {
        try {
            List idList;
            String cacheKey = formId + "imc_bdm_log_delte";
            if (StringUtils.isNotBlank((CharSequence)CacheHelper.get((String)cacheKey))) {
                return;
            }
            int deleteCount = this.getLogSingleDeleteCount();
            this.deleteMatchRedConfirmLog(formId, createDateKey);
            int index = 1;
            QFilter[] qFilters = new QFilter(createDateKey, "<", (Object)deleteDay).toArray();
            while (!CollectionUtils.isEmpty((Collection)(idList = QueryServiceHelper.queryPrimaryKeys((String)formId, (QFilter[])qFilters, (String)"id", (int)deleteCount)))) {
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)formId), (Object[])idList.toArray());
                if (++index <= 100) continue;
                break;
            }
            Date remainDate = DateUtils.addMinute((Date)DateUtils.trunc((Date)DateUtils.addDay((Date)new Date(), (int)1)), (int)-10);
            long remain = (remainDate.getTime() - System.currentTimeMillis()) / 1000L;
            if (remain > 0L) {
                CacheHelper.put((String)cacheKey, (String)cacheKey, (int)Integer.parseInt(String.valueOf(remain)));
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u5220\u9664\u65e5\u5fd7\u8bb0\u5f55\u8868\u5931\u8d25\uff0c\u8868\u540d[%s]", formId));
        }
    }

    private void deleteMatchRedConfirmLog(String formId, String createDateKey) {
        try {
            Date lastDay = DateUtils.addDay((Date)new Date(), (int)-1);
            QFilter filter = new QFilter("requesturl", "=", (Object)"matchRedConfirm").and(createDateKey, "<=", (Object)lastDay);
            DeleteServiceHelper.delete((String)formId, (QFilter[])filter.toArray());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

